/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class Version {
    private String value;
    private int majorVersion;
    private int minorVersion;
    private int serviceNo;
    private String qualifier;

    public Version(String value) {
        this.value = value;
        this.setupVersionNo();
    }

    private void setupVersionNo() {
        if (this.value != null) {
            String[] values = this.split(this.value);
            if (values.length >= 3) {
                this.majorVersion = Integer.parseInt(values[0]);
                this.minorVersion = Integer.parseInt(values[1]);
                this.serviceNo = Integer.parseInt(values[2]);
            }
            this.qualifier = values.length == 4 ? values[3] : "";
        }
    }

    private String[] split(String value) {
        StringTokenizer token = new StringTokenizer(value, ".");
        ArrayList<String> list = new ArrayList<String>();
        while (token.hasMoreTokens()) {
            list.add(token.nextToken());
        }
        String[] arrays = new String[list.size()];
        return list.toArray(arrays);
    }

    public String getValue() {
        return this.value;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public boolean versionUnderEqual(int major, int minor, int serviceNo) {
        if (this.majorVersion != major) {
            return this.majorVersion < major;
        }
        if (this.minorVersion != minor) {
            return this.minorVersion < minor;
        }
        if (this.serviceNo != serviceNo) {
            return this.serviceNo < serviceNo;
        }
        return true;
    }
}

