/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.generate.ddl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import jp.sourceforge.tmdmaker.generate.ddl.DatabaseNotSelectRuntimeException;
import jp.sourceforge.tmdmaker.generate.ddl.Messages;
import jp.sourceforge.tmdmaker.generate.ddl.internal.DdlUtilsConverter;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.generate.Generator;
import jp.sourceforge.tmdmaker.model.generate.GeneratorRuntimeException;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.PlatformFactory;
import org.apache.ddlutils.model.Database;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DdlUtilsDDLGenerator
implements Generator {
    private static Logger logger = LoggerFactory.getLogger(DdlUtilsDDLGenerator.class);

    public void execute(String rootDir, List<AbstractEntityModel> models) {
        if (models.isEmpty()) {
            return;
        }
        Diagram diagram = models.get(0).getDiagram();
        String databaseName = diagram.getDatabaseName();
        if (databaseName == null || databaseName.length() == 0) {
            throw new DatabaseNotSelectRuntimeException();
        }
        DdlUtilsConverter converter = new DdlUtilsConverter(ImplementRule.isForeignKeyEnabled());
        Database database = converter.convert(diagram, models);
        converter.addCommonColumns(database, (List<IAttribute>)diagram.getCommonAttributes());
        Platform platform = PlatformFactory.createNewPlatformInstance((String)databaseName);
        String sql = platform.getCreateModelSql(database, true, true);
        logger.debug(sql);
        this.writeSqlFile(rootDir, "ddl.sql", sql);
    }

    private void writeSqlFile(String rootDir, String fileName, String sql) {
        File file = new File(rootDir, fileName);
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(file);
                out.write(sql.getBytes("UTF-8"));
            }
            catch (FileNotFoundException e) {
                logger.error(Messages.DdlUtilsDDLGenerator_FileNotFound, (Throwable)e);
                throw new GeneratorRuntimeException((Throwable)e);
            }
            catch (IOException e) {
                logger.error(Messages.DdlUtilsDDLGenerator_FileOutputError, (Throwable)e);
                throw new GeneratorRuntimeException((Throwable)e);
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getGeneratorName() {
        return Messages.DdlUtilsDDLGenerator_GeneratorName;
    }

    public String getGroupName() {
        return "DDL";
    }

    public boolean isImplementModelOnly() {
        return true;
    }
}

