/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.editor.draw2d.adjuster;

import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Entity;
import jp.sourceforge.tmdmaker.model.ModelElement;
import jp.sourceforge.tmdmaker.model.SubsetType;
import jp.sourceforge.tmdmaker.ui.editor.draw2d.ConstraintAdjuster;
import jp.sourceforge.tmdmaker.ui.editor.draw2d.ConstraintConverter;
import org.eclipse.draw2d.geometry.Rectangle;

public class SubsetTypeAdjuster
implements ConstraintAdjuster {
    public static final int CHAR_SIZE = 12;
    private AbstractEntityModel superset;
    private SubsetType subsetType;

    public SubsetTypeAdjuster(AbstractEntityModel superset, SubsetType subsetType) {
        this.superset = superset;
        this.subsetType = subsetType;
    }

    @Override
    public void adjust() {
        ConstraintConverter.setConstraint((ModelElement)this.subsetType, this.calculateSubsetTypePosition());
    }

    private Rectangle calculateSubsetTypePosition() {
        int rx = this.superset.calcurateMaxIdentifierRefSize();
        int ax = this.superset.calcurateMaxAttributeNameSize();
        int x = (rx + ax) * 12 / 2;
        int identifierCount = this.superset.getReusedIdentifiers().size();
        if (this.superset instanceof Entity) {
            ++identifierCount;
        }
        int attributeCount = this.superset.getAttributes().size();
        int acount = Math.max(identifierCount, attributeCount);
        int y = 70 + 12 * acount;
        Rectangle rectangle = ConstraintConverter.getTranslatedRectangle((ModelElement)this.superset, x, y);
        return rectangle;
    }
}

