/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.actions;

import java.util.List;
import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.VirtualSuperset;
import jp.sourceforge.tmdmaker.model.VirtualSupersetType;
import jp.sourceforge.tmdmaker.ui.actions.AbstractMultipleSelectionAction;
import jp.sourceforge.tmdmaker.ui.dialogs.VirtualSupersetCreateDialog;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.VirtualSupersetCreateCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.VirtualSupersetEditCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.VirtualSupersetTypeChangeCommand;
import jp.sourceforge.tmdmaker.ui.editor.gef3.editparts.DiagramEditPart;
import jp.sourceforge.tmdmaker.ui.editor.gef3.editparts.node.AbstractEntityModelEditPart;
import jp.sourceforge.tmdmaker.ui.editor.gef3.editparts.node.AbstractModelEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;

public class VirtualSupersetCreateAction
extends AbstractMultipleSelectionAction {
    public static final String ID = "_VS";

    public VirtualSupersetCreateAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.EditVirtualSuperset);
        this.setId(ID);
    }

    public void run() {
        VirtualSupersetCreateDialog dialog;
        Point pos = this.getControlCursorLocation();
        List<AbstractEntityModel> selectedModels = this.getSelectedModelList();
        Diagram diagram = this.getDiagram();
        VirtualSuperset original = null;
        VirtualSupersetType aggregator = null;
        if (!selectedModels.isEmpty() && (original = this.getVirtualSuperset()) != null) {
            selectedModels.remove(original);
        }
        if ((dialog = new VirtualSupersetCreateDialog(this.getControl().getShell(), diagram, original, selectedModels)).open() == 0) {
            CompoundCommand ccommand = null;
            VirtualSuperset edited = dialog.getEditedValue();
            aggregator = dialog.getEditedAggregator();
            List<AbstractEntityModel> selection = dialog.getSelection();
            if (original == null) {
                if (selection.isEmpty()) {
                    return;
                }
                ccommand = new CompoundCommand();
                ccommand.add((Command)new VirtualSupersetCreateCommand(edited, selection, pos.x, pos.y));
                ccommand.add((Command)new VirtualSupersetTypeChangeCommand(edited, aggregator.isApplyAttribute()));
            } else {
                ccommand = new VirtualSupersetEditCommand(original, edited, selection, aggregator.isApplyAttribute());
            }
            this.execute((Command)ccommand);
        }
    }

    private Control getControl() {
        return ((AbstractEditPart)this.getSelectedObjects().get(0)).getViewer().getControl();
    }

    private Point getControlCursorLocation() {
        Control control = this.getControl();
        Point pos = control.getDisplay().getCursorLocation();
        pos = control.toControl(pos);
        pos.x -= 200;
        pos.y -= 100;
        return pos;
    }

    private Diagram getDiagram() {
        for (Object o : this.getSelectedObjects()) {
            if (o instanceof DiagramEditPart) {
                return (Diagram)((DiagramEditPart)o).getModel();
            }
            if (!(o instanceof AbstractModelEditPart)) continue;
            return (Diagram)((AbstractModelEditPart)o).getParent().getModel();
        }
        return null;
    }

    private VirtualSuperset getVirtualSuperset() {
        List<AbstractEntityModel> list = this.getSelectedModelList();
        for (AbstractEntityModel o : list) {
            if (!(o instanceof VirtualSuperset)) continue;
            return (VirtualSuperset)o;
        }
        for (AbstractEntityModel o : list) {
            VirtualSupersetType type = o.findVirtualSupersetType();
            if (type == null) continue;
            return type.getSuperset();
        }
        return null;
    }

    @Override
    protected boolean calculateEnabled() {
        if (!this.getSelectedObjects().isEmpty() && this.hasEntityModel()) {
            return true;
        }
        return this.isDiagramSelected();
    }

    private boolean hasEntityModel() {
        for (Object o : this.getSelectedObjects()) {
            if (!(o instanceof AbstractEntityModelEditPart)) continue;
            return true;
        }
        return false;
    }

    private boolean isDiagramSelected() {
        return this.getSelectedObjects().size() == 1 && this.getSelectedObjects().get(0) instanceof DiagramEditPart;
    }
}

