/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker;

import java.io.File;
import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.TMDEditor;
import jp.sourceforge.tmdmaker.ui.preferences.IPreferenceListener;
import jp.sourceforge.tmdmaker.ui.preferences.appearance.AppearancePreferenceListener;
import jp.sourceforge.tmdmaker.ui.preferences.rule.RulePreferenceListener;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class TMDPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "tmdmaker";
    public static final String IMPORTER_PLUGIN_ID = "tmdmaker.importers";
    private static TMDPlugin plugin;
    private IPropertyChangeListener[] listeners = new IPropertyChangeListener[]{new AppearancePreferenceListener(), new RulePreferenceListener()};

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        IPreferenceStore store = plugin.getPreferenceStore();
        IPropertyChangeListener[] iPropertyChangeListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyChangeListener listener = iPropertyChangeListenerArray[n2];
            if (listener instanceof IPreferenceListener) {
                ((IPreferenceListener)listener).preferenceStart(store);
            }
            store.addPropertyChangeListener(listener);
            ++n2;
        }
        this.update();
    }

    public void stop(BundleContext context) throws Exception {
        IPreferenceStore store = plugin.getPreferenceStore();
        IPropertyChangeListener[] iPropertyChangeListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyChangeListener listener = iPropertyChangeListenerArray[n2];
            store.removePropertyChangeListener(listener);
            ++n2;
        }
        super.stop(context);
        plugin = null;
    }

    public static TMDPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return TMDPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static void log(Throwable t) {
        Status status = new Status(4, PLUGIN_ID, 4, t.getMessage(), t);
        TMDPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void log(String message) {
        Status status = new Status(4, PLUGIN_ID, 4, message, null);
        TMDPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void showMessageDialog(String message) {
        MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 34);
        messageBox.setText(Messages.TMDPlugin_InformationTitle);
        messageBox.setMessage(message);
        messageBox.open();
    }

    public static void showErrorDialog(String message) {
        Status status = new Status(4, PLUGIN_ID, message);
        TMDPlugin.log(message);
        ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.TMDPlugin_ErrorTitle, (String)message, (IStatus)status);
    }

    public static void showErrorDialog(Throwable t) {
        TMDPlugin.showErrorDialog(Messages.TMDPlugin_ErrorMessage, t);
    }

    public static void showErrorDialog(String message, Throwable t) {
        Status status = new Status(4, PLUGIN_ID, 0, t.getMessage(), t);
        TMDPlugin.log(t);
        ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.TMDPlugin_ErrorTitle, (String)message, (IStatus)status);
    }

    public static Image getImage(String path) {
        ImageRegistry images = TMDPlugin.getDefault().getImageRegistry();
        Image image = images.get(path);
        if (image == null) {
            image = TMDPlugin.getImageDescriptor(path).createImage();
            images.put(path, image);
        }
        return image;
    }

    public void update() {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = w.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference ref = iEditorReferenceArray[n6];
                    IEditorPart part = ref.getEditor(false);
                    if (part instanceof TMDEditor) {
                        ((TMDEditor)part).updateVisuals();
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static void refreshGenerateResource(String path) throws Exception {
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(new File(path).toURI());
        if (files != null) {
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile f = iFileArray[n2];
                f.refreshLocal(2, null);
                ++n2;
            }
        }
    }

    public static void refreshGenerateResources(String path) throws Exception {
        IContainer[] container = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(new File(path).toURI());
        if (container != null) {
            IContainer[] iContainerArray = container;
            int n = container.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer c = iContainerArray[n2];
                c.refreshLocal(2, null);
                ++n2;
            }
        }
    }

    public static IFile getEditFile(IWorkbenchPart part) {
        return ((IFileEditorInput)((IEditorPart)part).getEditorInput()).getFile();
    }
}

