<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @copyright  2013 NPO CCC-TIES <info@cccties.org>
 * @author Codia <system.info@codia.co.jp>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
**/

// wowzaサーバーとの疎通確認
function get_response_wowza(){
    global $CFG;
    $url = 'http://' . $CFG->mplayer_streamer_wowza . ':1935';
    return check_http_response($url);
}

// OMサーバーとの疎通確認
// ログイン成功した場合に疎通可能とする
function get_response_openmeetings(){
    global $CFG;
    if(!file_exists($CFG->dirroot.'/mod/openmeetings/lib/nusoap.php')){
        return false;
    }
    require_once($CFG->dirroot.'/mod/openmeetings/lib/nusoap.php');

    $client_userService = new nusoap_client("http://".$CFG->openmeetings_red5host.":".$CFG->openmeetings_red5port."/".$CFG->openmeetings_webappname."/services/UserService?wsdl", "wsdl");
    $client_userService->setUseCurl(true);
    $err = $client_userService->getError();
    if ($err) {
        return false;
    }  

    $result = $client_userService->call('getSession');
    if (!$client_userService->fault) {
        $err = $client_userService->getError();
        if (!$err) {
            $params = array(
                'SID' => $result["return"]["session_id"],
                'username' => $CFG->openmeetings_openmeetingsAdminUser,
                'userpass' => $CFG->openmeetings_openmeetingsAdminUserPass
            );

            $result = $client_userService->call('loginUser',$params);
            if ($client_userService->fault) {
            } else {
                $err = $client_userService->getError();
                if ($err) {
                } else {
                    $returnValue = $result["return"];	
                }
            }
        }
    }   
    if ($returnValue>0){
        return true;
    } else {
        return false;
    }
}

// 配布サイトとの疎通確認
function get_response_download(){
    $url = get_downloadsite_url();
    return check_http_response($url);
}

// 各サーバーとの疎通確認を行う
function get_response(){
    $info = array();
    $targets = array('wowza', 'openmeetings');
    // ディレクトリが存在するものだけチェックする
    foreach($targets as $target){
        $path = get_module_path($target);
        $function_name = 'get_response_' . $target;
        if($path != null && !file_exists(dirname(__FILE__) . $path )){
            $info[$target] = get_string('response_not_install', 'local_ties');
        }elseif(!function_exists($function_name)){
            $info[$target] = get_string('response_false', 'local_ties');
        }else{
            $info[$target] = ($function_name()) ? get_string('response_success', 'local_ties'): get_string('response_false', 'local_ties');
        }
    }

    return $info;
}

// サーバー情報を取得
// 未使用
function get_version(){

    $info = array();
    $targets = array('mysql', 'php', 'apache', 'ip', 'os');
    foreach($targets as $target){
        $function_name = 'get_info_' . $target;
        if(!function_exists($function_name)){
            continue;
        }
        $info[$target] = $function_name();

    }

    return $info;
    
}

// IPの取得
function get_info_ip(){
    return getenv('SERVER_ADDR');
}

// OSの取得
function get_info_os(){
    return php_uname();
}

// apacheの情報取得
function get_info_apache(){
    return apache_get_version();
}

// PHPのバージョンの情報取得
function get_info_php(){
    return phpversion();
}

// MySQLの情報取得
function get_info_mysql(){
    global $DB;
    $ver =  $DB->get_server_info();
    return $ver['version'];
}

// 各モジュールのパスを取得
function get_module_path($name){
    $modules = array(
        'ties'             => '/',
        'tiesskin'         => '/../../theme/ties',
        'mplayer'          => '/../../mod/mplayer',
        'openmeetings'     => '/../../mod/openmeetings',
        'shibboleth_ties'  => '/../../auth/shibboleth_ties',
        );

    return $modules[$name];
}

// TIESモジュールがインストールされているが、管理対象でないモジュールがあるか確認
// ToDO:モジュール一覧をどこかでまとめる
function check_modules() {
    global $DB;
    // 対象のモジュールのディレクトリを指定する
    // installer.phpの有無をチェック
    $modules = array('ties', 'tiesskin', 'mplayer', 'openmeetings', 'shibboleth_ties',);

    $basedir = dirname(__FILE__);

    $manage_modules = array();
    foreach($modules as $modulename){
        $path = get_module_path($modulename);
        if(!file_exists($basedir. $path . '/installer.php') || !file_exists($basedir. $path . '/version.php')){
            continue;
        }

        // 対象のモジュールのDB上の値をチェックする
        // 管理対象でないものを通知する
        $module_result = $DB->get_records_select("local_ties_modules", "name = ?", array($modulename));
        if(empty($module_result)) {
            array_push($manage_modules, array('name' => $modulename , 'path' => $basedir . $path));
        }

    }

    return $manage_modules;
}

// 対象のモジュールを管理対象にする
function manage_module($name, $path) {
    global $DB;

    $module = $DB->get_records_select("local_ties_modules", "name = ?", array($name));
    if(!empty($module)){
        return false;
    }

    require $path . '/version.php';

    $version = '';
    if(!empty($module->version)){
        $version = $module->version;
    }else if(!empty($plugin->version)){
        $version = $plugin->version;
    }

    $dispversion = '';
    if(!empty($module->dispversion)){
        $dispversion = $module->dispversion;
    }else if(!empty($plugin->dispversion)){
        $dispversion = $plugin->dispversion;
    }

    $module_info           = new stdClass();
    $module_info->name     = $name;
    $module_info->version  = $version;
    $module_info->dispversion  = $dispversion;
    $DB->insert_record('local_ties_modules', $module_info);

    return;
}


/**
 * モジュールの更新を行うメソッドです
 *
 * @param boolean $force (true:同日中の更新の有無にかかわらず強制的に更新確認する)
 * @return boolean (true:成功,false:失敗)
 */
function update_modules($force = false){
    global $DB;
    // 同日に更新の確認をしていないかチェック
    if(!$force){
        if(check_today_update()){
            return true;
        }
    }

    // トランザクション開始
    $transaction = $DB->start_delegated_transaction();

    update_updatedate();

    // モジュールの情報を取得する
    $json =  get_module_info();
    if($json === false){
        return false;
    }

    $response = json_decode($json);

    // 取得した情報でモジュールの情報を更新する
    if(!set_modules_data($response)){
        return false;
    }

    // トランザクション終了
    $DB->commit_delegated_transaction($transaction);

    return true;

}

/**
 * 同日に更新確認をしているか判定
 *
 * @return boolean (true:更新確認あり,false:更新確認なし)
 */
function check_today_update(){
    global $DB;

    // 日付を取得
    $today = date("Ymd");

    // 更新日を取得
    $modules = $DB->get_records_select("local_ties_modules_update", 'updatedate = ' . $today);

    // 今日は更新している場合false
    if(count($modules) > 0 ){
        return true;
    }

    return false;
}

/**
 * モジュールの情報を取得
 *
 * @param string $type (all:配布しているすべてのモジュール,installed:インストールしているすべてのモジュール,except:インストールしていないモジュール)
 * @return object 取得したモジュールの情報
 */
function get_module_info($type = "installed"){

    // APIから取得するデータを指定
    $posts_param['type'] = 'get_module_info';

    // モジュールの指定
    if($type === "installed" || $type === "except"){
        $modules = array();
        foreach(get_install_modules_list() as $module){
            $modules[] = $module->name;
        }

        $posts_param['modules'] = $modules;
    }

    // インストールしていないモジュールの指定
    if($type === "except"){
        $posts_param['except_flg'] = true;
    }

    // データの取得
    $json = get_contents($posts_param);

    if($json === false){
        return false;
    }

    return $json;
}

// DLリンクのベースURLを取得する
/**
 * ダウンロードリンクのベースのURLを取得する
 *
 * @return object URL
 */
function get_downloadpage_url(){

    // APIから取得するデータを指定
    $posts_param['type'] = 'get_download_url';

    // データの取得
    $json = get_contents($posts_param);

    if($json === false){
        return false;
    }

    return json_decode($json);
}

/*
 * 配布サイトと連携するためのAPIのURL取得
 * @return string URL
 */
function get_downloadsite_url() {
    global $CFG;
    return $CFG->downloadurl."/ties/version.php";
}

/**
 * APIを通してデータを取得
 *
 * @param  array $posts_param (POSTする配列)
 * @param  array $get_param (GETする配列)
 * @return json 取得したデータ
 */
function get_contents($posts_param = array(), $get_param = array()){
    global $CFG;

    // APIのURL設定
    // ToDo:APIのファイル名を変更すること
    $url = get_downloadsite_url();
    
    if(!check_http_response($url)){
        return false;
    }

    // GET値の生成
    $params = '';
    foreach($get_param as $key => $val){
        if($params){
            $params .= '&';
        }
        $params .= $key . '=' . $val;
    }

    // POST値の生成
    if(!empty($posts_param)){
        // そのまま送ると受け取り側で&amp;が変換されずキー名に代入されるため、
        // 応急処置的にjsonで送る
        $posts_param = array('http' => array(
                    'method' => 'POST',
                    'header' => implode("\r\n",array('Content-Type: application/x-www-form-urlencoded')),
                    'content' => http_build_query(
                        array('param' => json_encode($posts_param))
                        )
                    )
                );
        // ToDo:posts_paramが空はまずい？できればコードを統一したい
        $json = file_get_contents($url . '?' . $params, false, stream_context_create($posts_param));
    }else{
        $json = file_get_contents($url . '?' . $params, false);
    }

    if ($json == false) {
        return false;
    }

    return $json;
}

/**
 * インストールしているモジュールの一覧取得
 *
 * @return array (DBから取得したモジュール一覧)
 */
function get_install_modules_list(){
    global $DB;
    $modules = $DB->get_records_select("local_ties_modules", '');
    return $modules;
}

/**
 * 配布しているモジュールの一覧を取得
 *
 * @return object (配布しているモジュールの一覧)
 */
function get_download_modules_list(){
    $json = get_module_info('except');
    $modules = json_decode($json);

    return $modules;
}

/**
 * 取得したモジュールの情報をDBに保存
 *
 * @param object $response (取得したモジュールの情報)
 * return boolean (true:成功,false:失敗)
 */
function set_modules_data($response){
    global $DB;

    // ダウンロードリンクを取得
    $downloadurl = get_downloadpage_url();

    if(!is_object($downloadurl)){
        return false;
    }

    $url = $downloadurl->url;

    // 一度すべてのインストールモジュールのリンクとバージョンと更新フラグを初期化する。
    // データが受け取らなかった場合、前回の値を引き継ぐため。
    $updateModuleInfo = array();
    $updateModuleInfo = $DB->get_records("local_ties_modules");
    foreach($updateModuleInfo as $module){
        $module->update_flg = 0;
        $module->link = null;
        $module->latestversion = null;
        $DB->update_record("local_ties_modules", $module);
    }

    foreach($response as $moduleInfo){
        $updateModuleInfo = array();
        $updateModuleInfo = $DB->get_records_select("local_ties_modules", "name = ?", array($moduleInfo->module_name));
        $updateModuleInfo = reset($updateModuleInfo);
        if(!$updateModuleInfo){
            continue;
        }

        // インストールバージョンより新しいバージョンの場合フラグを立てる
        if($updateModuleInfo->version  < $moduleInfo->latestversion){
            $updateModuleInfo->update_flg = 1;
        }else{
            $updateModuleInfo->update_flg = 0;
        }

        $updateModuleInfo->link = $url . $moduleInfo->link;
        $updateModuleInfo->latestversion = $moduleInfo->latestversion;

        $DB->update_record("local_ties_modules", $updateModuleInfo);
    }

    return true;

}

/**
 * モジュールの確認日を登録
 *
 */
function update_updatedate(){
    global $DB;
    $date = date('Ymd');

    $modules = $DB->get_records_select("local_ties_modules_update", 'updatedate = ' . $date);
    if(count($modules) === 0 ){
        $update = new stdClass();
        $update->updatedate = $date;
        $DB->insert_record('local_ties_modules_update', $update);
    }

}

/**
 * 更新されているモジュールの有無を判定
 *
 * @return booleadn (true:一つでも更新がある)
 */
function check_exist_updatemodule(){
    global $DB;
    $modules = get_install_modules_list();
    $modules = $DB->get_records_select("local_ties_modules", 'update_flg = 1');

    if(count($modules) > 0 ){
        return true;
    }
    return false;
}


/**
 * プロトコルを除去し、スラッシュをクォートする 
 * @param  string $url (対象のURL)
 * @return booleadn (true:一つでも更新がある)
 */
function trim_url($url){
    $parse_url = parse_url($url);
    $url = $parse_url['host'] . $parse_url['path'];
    $url = preg_quote($url, '/');

    return $url;
}

/**
 * プロトコルを除去し、スラッシュをクォートする 
 * @param  string $url (対象のURL)
 * @return booleadn (true:一つでも更新がある)
 */
function check_http_response($url){
    $status = get_http_header($url) ;
    if((int)$status['Status-Code'] < 400){
        return true;
    }else{
        return false;
    }
}

//-------------------------------------------------------------------------
// array get_http_header( string URI )
// URIがHTTPプロトコルだった場合、そのURIにHEADリクエストを行います。
// 返り値にはHTTP-Version、Status-Code、Reason-Phraseが必ず含まれ、それ以外
// にサーバが返した情報（index: value）が含まれます。
// Status-Codeが9xxの場合、それはホストが存在しない場合などHTTPリクエストが
// 正常に行われなかったことを意味します。
//-------------------------------------------------------------------------
function get_http_header( $target ) {

    // URIから各情報を取得
    $info = parse_url( $target );

    $scheme = $info['scheme'];
    $host = $info['host'];
    if(array_key_exists('port', $info)){
        $port = $info['port'];
    }else{
        $port = null;
    }
    $path = $info['path'];
    // ポートが空の時はデフォルトの80にします。
    if( ! $port ) {
        $port = 80;
    }

    // リクエストフィールドを制作。
    $msg_req = "HEAD " . $path . " HTTP/1.0\r\n";
    $msg_req .= "Host: $host\r\n";
    $msg_req .=
        "User-Agent: H2C/1.0\r\n";
    $msg_req .= "\r\n";

    // スキームがHTTPの時のみ実行
    if ( $scheme == 'http' ) {

        $status = array();

        // 指定ホストに接続。
        if ( $handle = @fsockopen( $host, $port, $errno, $errstr, 1 ) ) {

            fputs ( $handle, $msg_req );

            if ( socket_set_timeout( $handle, 3 ) ) { 

                $line = 0;
                while( ! feof( $handle) ) {

                    // 1行めはステータスライン
                    if( $line == 0 ) {
                        $temp_stat =
                            explode( ' ', fgets( $handle, 4096 ) );
                        $status['HTTP-Version'] =
                            array_shift( $temp_stat );
                        $status['Status-Code'] = array_shift( $temp_stat );
                        $status['Reason-Phrase'] =
                            implode( ' ', $temp_stat );

                    // 2行目以降はコロンで分割してそれぞれ代入
                    } else {
                        $temp_stat =
                            explode( ':', fgets( $handle, 4096 ) );
                        $name = array_shift( $temp_stat );
                        // 通常:の後に1文字半角スペースがあるので除去
                        $status[ $name ] =
                            substr( implode( ':', $temp_stat ), 1);
                    }
                    $line++;
                }

            } else {
                    $status['HTTP-Version'] = '---';
                    $status['Status-Code'] = '902';
                    $status['Reason-Phrase'] = "No Response";
            }

            fclose ( $handle );

        } else {
            $status['HTTP-Version'] = '---';
            $status['Status-Code'] = '901';
            $status['Reason-Phrase'] = "Unable To Connect";
        }


    } else {
        $status['HTTP-Version'] = '---';
        $status['Status-Code'] = '903';
        $status['Reason-Phrase'] = "Not HTTP Request";
    }
    return $status;

}
