/* ************************************************************ plugin.c *** *
 * TEImage˴ؤؿ إåե
 *
 * Copyright (C) 1998-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <03/04/28 23:19:34 sugaya>
 * ************************************************************************* */
#include <dirent.h>
#include <unistd.h>
#include <dlfcn.h>
#include "teoeyes.h"
#include "draw.h"
#include "operation.h"
#include "plugin.h"
#include "plugin_info.h"

/* ************************************************************************* */
static guint	hash_func			(gpointer	key);
gint		hash_comp	 		(gpointer	arg1,
						 gpointer	arg2);
static gboolean	plugin_add_hash 		(PluginInfo	*p);
static GList*	plugin_ls_plugin 		(gchar		*dir);
static gint	plugin_exec_func 		(gpointer	data,
						 guint		action,
						 GtkWidget	*widget);

/* ϥåơ֥ѥϥåͷ׻ؿ ************************************ */
static guint
hash_func (gpointer	key) {
  gchar		*skey = (gchar *) key;
  gint		n;
  guint		result = 0;

  if (key) return 0;

  for (n = 0; n < strlen (skey); n++) {
    result = (result << 4) + (result ^ (guint) skey[n]);
  }
  return result;
}

/* ϥåơ֥ѥӴؿ ****************************************** */
gint
hash_comp (gpointer	arg1,
	   gpointer	arg2) {
  return !strcmp ((gchar *) arg1, (gchar *) arg2);
}

/* ץ饰ϥåơ֥Ͽ ********************************** */
static gboolean
plugin_add_hash (PluginInfo	*p) {
  gchar	*key;
  
  /* ϥåơ֥ */
  if (!plugin_table) {
    plugin_table = g_hash_table_new ((GHashFunc) hash_func,
				     (GCompareFunc) hash_comp);
  }
  /* ϥå奭 */
  key = g_strconcat ("<plugin>", ((GtkIconItemFactoryEntry *) p)->path, NULL);
  
  /* ϥåơ֥ؤϿ */
  if (g_hash_table_lookup (plugin_table, key)) {
    g_free (key);
    return FALSE;
  }
  g_hash_table_insert (plugin_table, key, p);
  
  return TRUE;
}

/* ץ饰ꥹȤγ ************************************************** */
static GList*
plugin_ls_plugin (gchar	*dir) {
  DIR           *dp;
  struct dirent *entry;
  GList		*files = NULL;
  gchar		*ext;

  g_return_val_if_fail (dir && *dir, NULL);

  if (!(dp = opendir (dir))) return NULL;

  while ((entry = readdir (dp))) {
    if (g_dir_is_current_dir (entry->d_name) || 
	g_dir_is_parent_dir  (entry->d_name)) continue;    
    if ((ext = (gchar *) strrchr (entry->d_name, '.')) == NULL) continue;
    if (strcmp (ext, ".tpi") != 0) continue;

    files = g_list_append (files, g_strdup (entry->d_name));
  }
  closedir (dp);
 
  return files;
}

/* ץ饰¹Դؿ ****************************************************** */
static gint
plugin_exec_func (gpointer	data,
		  guint		action,
		  GtkWidget	*widget) {
  PluginInfo	*p;
  TEImage	*ti;
  gchar		*key = (gchar *) widget->name;
  GdkPixbuf	*tmp, *dst;

  /* ץ饰θ */
  if (!plugin_table) return 0;
  p = g_hash_table_lookup (plugin_table, key);

  /* Хåå */
  do_backup (image_list);
  
  /* ץ饰ؿμ¹ */
  tmp = gdk_pixbuf_copy (ti_get_pixbuf (image_list));
  dst = gdk_pixbuf_copy (ti_get_pixbuf (image_list));
  (p->plugin_func) (tmp, dst);

  /* ̤ȿ */
  ti = ti_get_image (image_list);
  gdk_pixbuf_copy_area (dst,
			0, 0,
			gdk_pixbuf_get_width  (dst),
			gdk_pixbuf_get_height (dst),
			ti->pixbuf,
			0, 0);
  /*  */
  draw_image (image_list,
	      ti_get_current_width  (image_list),
	      ti_get_current_height (image_list));

  gdk_pixbuf_unref (tmp);
  gdk_pixbuf_unref (dst);

  return 1;
}

/* ץ饰ѤΥ˥塼 **************************************** */
void
plugin_menu_new (GtkMenuItem	*menu1,
		 GtkMenuItem	*menu2) {
  GtkIconItemFactory		*item_factory[2];
  GtkIconItemFactoryEntry	*entry;
  GtkIconItemFactoryEntry	*plugin_items;
  PluginInfo			*p;
  GList				*p_list = NULL;
  GList				*list, *p_list_ptr, *us_list;
  gchar				*plugin_path;	
  void				*handle;
  gint				plugin_nums = 0;

  /* ץ饰˥塼 */
  plugin_items = g_new (GtkIconItemFactoryEntry, 1);

  /* TEAROFFƥ */
  plugin_items[plugin_nums].path		= "/Tearoff";
  plugin_items[plugin_nums].accelerator		= NULL;
  plugin_items[plugin_nums].callback		= 0;
  plugin_items[plugin_nums].callback_action	= 0;
  plugin_items[plugin_nums].item_type		= "<Tearoff>";
  plugin_items[plugin_nums].extra_data		= NULL;
  plugin_nums++;

  /* ץ饰򥵡ƥ˥塼ɲ */
  list = tc->plugin_dirs;
  while (list) {
    p_list_ptr = p_list = plugin_ls_plugin ((gchar *) list->data);
    while (p_list_ptr) {
      /* ץ饰ѥ */
      plugin_path = g_strconcat ((gchar *) list->data,
				 G_DIR_SEPARATOR_S,
				 (gchar *) p_list_ptr->data, NULL);
      /* ץ饰ɤ߹ */
      handle = dlopen (plugin_path, RTLD_LAZY);
      if (!handle) {
	g_printerr (_("TeoEyes Plugin %s cannot be loaded !\n"), plugin_path);
	g_free (plugin_path);
	p_list_ptr = g_list_next (p_list_ptr);
	continue;
      }
      /* ϥɥꥹȤ */
      handle_list = g_list_append (handle_list, handle);

      /* ץ饰γ */
      p = dlsym (handle, "plugin_info");
      if (!p) {
	g_printerr (_("Plugin Information in %s is not found !\n"),
		    plugin_path);
	g_free (plugin_path);	  
	p_list_ptr = g_list_next (p_list_ptr);
	continue;
      }
      entry = (GtkIconItemFactoryEntry *) p;

      us_list = tc->unuse_plugin_list;
      while (us_list) {
	if (strcmp (entry->path, (char *) us_list->data) == 0) {
	  p->active = 0;
	  break;
	}
	us_list = g_list_next (us_list);
      }
      if (plugin_nums != 0 && plugin_add_hash (p)) {
	/* ˥塼ƥκ */
	plugin_items = (GtkIconItemFactoryEntry *)
	  realloc (plugin_items,
		   sizeof (GtkIconItemFactoryEntry) * (plugin_nums + 1));

	plugin_items[plugin_nums].path		  = entry->path;
	plugin_items[plugin_nums].accelerator	  = entry->accelerator;
	plugin_items[plugin_nums].callback
	  = (GtkIconItemFactoryCallback) plugin_exec_func;
	plugin_items[plugin_nums].callback_action = entry->callback_action;
	plugin_items[plugin_nums].item_type	  = entry->item_type;
	plugin_items[plugin_nums].extra_data	  = entry->extra_data;
	plugin_nums++;
      }
      p_list_ptr = g_list_next (p_list_ptr);
      g_free (plugin_path);
    }
    list = g_list_next (list);
    g_list_foreach (p_list, (GFunc) g_free, NULL);
  }
  /* ֥˥塼 */
  item_factory[0] = 
    gtk_icon_item_factory_new (GTK_TYPE_MENU, "<plugin>", NULL);
  item_factory[1] = 
    gtk_icon_item_factory_new (GTK_TYPE_MENU, "<plugin>", NULL);
  gtk_icon_item_factory_set_translate_func 
    (item_factory[0], (GtkTranslateFunc) gettext, NULL, NULL);
  gtk_icon_item_factory_set_translate_func
    (item_factory[1], (GtkTranslateFunc) gettext, NULL, NULL);
  gtk_icon_item_factory_create_items (item_factory[0],
				      plugin_nums, plugin_items, NULL);
  gtk_icon_item_factory_create_items (item_factory[1],
				      plugin_nums, plugin_items, NULL);
  gtk_menu_item_set_submenu (menu1,
			     gtk_icon_item_factory_get_widget (item_factory[0],
							       "<plugin>"));
  gtk_menu_item_set_submenu (menu2,
			     gtk_icon_item_factory_get_widget (item_factory[1],
							       "<plugin>"));
  /* ˥塼󥢥ƥֲ */
  if (plugin_nums != 1) {
    GList	*itemlist1, *itemlist2;

    itemlist1 = gtk_container_children (GTK_CONTAINER (menu1->submenu));
    itemlist2 = gtk_container_children (GTK_CONTAINER (menu2->submenu));
    while (itemlist1) {
      p = g_hash_table_lookup (plugin_table,
			       (GTK_WIDGET (itemlist1->data))->name);
      if (p) {
	if (!p->active) {
	  gtk_widget_set_sensitive (GTK_WIDGET (itemlist1->data), FALSE);
	  gtk_widget_set_sensitive (GTK_WIDGET (itemlist2->data), FALSE);
	}
	plugin_list = g_list_append (plugin_list, p);
      }
      itemlist1 = g_list_next (itemlist1);
      itemlist2 = g_list_next (itemlist2);
    }
  }
}

/* ***************************************************** End of plugin.c *** */
