/* ************************************************************** main.c *** *
 * ᥤؿ
 *
 * Copyright (C) 2001-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <03/04/28 22:24:49 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"
#include "callback.h"
#include "getargs.h"
#include "image_io.h"
#include "image_window.h"
#include "init.h"
#include "option.h"
#include "property.h"

/* ꤵ줿طʲȤ褷λ **************************** */
static void
set_wallpaper (GList	*list,
	       gint	align) {
  /* ɻ */
  set_as_wallpaper (ti_get_file_path (list), align-1);

  /* β */
  teoeyes_free_option (to);
  config_free_file (tc);
  g_list_foreach (list, (GFunc) teoeyes_image_free, NULL); 

  /* λ */
  exit (1);
}

/* ꤵ줿եƥɤ ************************************** */
static void
load_all_images (GList	*list) {
  GtkWidget		*progress_window;
  GtkWidget		*progress_bar;    
  GtkWidget		*vbox;
  GtkWidget		*align;
  GtkAdjustment		*adj;
  GList			*tmplist;  
  gint			count;
  gint			max;
  gint			w, h;

  count = 0;
  max = g_list_length (list);

  /* ץ쥹Сɽ */
  {
    progress_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_policy (GTK_WINDOW (progress_window), FALSE, FALSE, TRUE);
    gtk_window_set_title (GTK_WINDOW (progress_window),
			  _("Now loading images..."));
    gtk_container_set_border_width (GTK_CONTAINER (progress_window), 0);

    vbox = gtk_vbox_new (FALSE, 5);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), 0);
    gtk_container_add (GTK_CONTAINER (progress_window), vbox);
    gtk_widget_show (vbox);

    align = gtk_alignment_new (0.5, 0.5, 0, 0);
    gtk_box_pack_start (GTK_BOX (vbox), align, FALSE, FALSE, 1);
    gtk_widget_show (align);

    adj = (GtkAdjustment *) gtk_adjustment_new (0, 1, (float) max, 0, 0, 0);
    progress_bar = gtk_progress_bar_new_with_adjustment (adj);
    gtk_progress_set_format_string (GTK_PROGRESS (progress_bar), "%p%%");
    gtk_progress_set_show_text (GTK_PROGRESS (progress_bar), 1);
    gtk_container_add (GTK_CONTAINER (align), progress_bar);
    gtk_widget_show (progress_bar);

    gdk_window_get_size (GDK_ROOT_PARENT (), &w, &h);
    w = w / 2 - 100;
    h = h / 2;
    gtk_widget_set_usize (progress_window, 200, -1);
    gtk_widget_set_uposition (progress_window, w, h);
    gtk_widget_show (progress_window);
  }    
  /* Υ */
  while (list) {
    count++;
    gtk_progress_bar_update (GTK_PROGRESS_BAR (progress_bar),
			     (float) count / max);
    while (gtk_events_pending ()) gtk_main_iteration ();

    if (!teoeyes_image_load (ti_get_image (list), 0, to->min, to->max)) {
      tmplist		= list->prev;
      tmplist->next	= NULL;
      while (list) list = g_list_remove (list, (gpointer) (list->data));
      break;
    }
    list = g_list_next (list);
  }
  gtk_widget_hide    (progress_window);
  gtk_widget_destroy (progress_window);
}

/* ɥΥȥ (-gץ) ************************* */
static void
set_geometry (GtkWidget	*window,
	      TEOption	*to) {
  int	rx, ry, rw, rh, rd;
    
  if (to->geometry->width  != UNDEF_VAL && to->geometry->height != UNDEF_VAL) {
    gtk_widget_set_size_request (window,
				 to->geometry->width, to->geometry->height);
  }
  if (to->geometry->x != UNDEF_VAL && to->geometry->y != UNDEF_VAL) {
    gdk_window_get_geometry (GDK_ROOT_PARENT (), &rx, &ry, &rw, &rh, &rd);
    to->geometry->x = (to->geometry->xsign > 0) ?
      to->geometry->x :
      rw - ((to->geometry->width == UNDEF_VAL) ? 
	    ti_get_width (image_list) :
	    to->geometry->width) - to->geometry->x;
    to->geometry->y = (to->geometry->ysign > 0) ?
      to->geometry->y :
      rh - ((to->geometry->height == UNDEF_VAL) ?
	    ti_get_height (image_list) :
	    to->geometry->height) - to->geometry->y;
    gtk_widget_set_uposition (window, to->geometry->x,  to->geometry->y);
  }
}

/* ************************************************************************* */
int
main (int	argc,
      char	**argv) {
  
  /*  */
  {
    teoeyes_init (argc, argv);

    /* եɤ߹ */
    tc = teoeyes_init_config ();
    if (!tc) exit (1);
    /* ץ */
    to = teoeyes_init_option ();
    /* ν */
    loader_init (tc->loader_dirs);
  }
  /* Υå */
  if (!getargs (argc, argv, &to, &tc)) usage ();

  /* ɤ߹ */
  teoeyes_image_load (ti_get_image (image_list), to->frame, to->min, to->max);

  /* طʤؤ (-rootץ) */
  if (to->wallpaper) set_wallpaper (image_list, to->wallpaper);

  /* ƥɤ߹ (-lץ) */
  if (to->load_all && g_list_next (image_list)) {
    load_all_images (image_list->next);
  }
  /* ɥ */
  image_window = image_window_new (_("TeoEyes"),
				   ti_get_width  (image_list),
				   ti_get_height (image_list));
  
  /* ɥΥȥ (-g ץ) */
  if (to->geometry) set_geometry (image_window, to);

  /* ɥɽ */
  gtk_widget_show (image_window);

  /* ᥤ롼 */
  gtk_main ();

  return 0;
}

/* ******************************************************* End of main.c *** */
