/* ******************************************************* list_viewer.c *** *
 * ꥹȥӥ塼
 *
 * Copyright (C) 1998-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <03/05/14 23:26:33 sugaya>
 * ************************************************************************* */
#include <teo.h>
#include "teoeyes.h"
#include "callback.h"
#include "image_io.h"
#include "image_window.h"
#include "list_viewer.h"

#include "stock_close.icon"
#include "stock_trash.icon"
#include "stock_blue_arrow_first.icon"
#include "stock_blue_arrow_left.icon"
#include "stock_blue_arrow_right.icon"
#include "stock_blue_arrow_last.icon"

#define	ICON_WIDTH	160
#define	ICON_HEIGHT	120

/* ץȥ ******************************************************** */
static void		cb_destroy		(GtkWidget	*widget,
						 gpointer	data);
static void		cb_mouse_press 		(GtkWidget	*widget,
						 GdkEventButton	*event,
						 gpointer	data);
static void		cb_remove_image		(GtkWidget	*widget,
						 gpointer	data);
static void		lv_add_image 		(GtkWidget	*window,
						 GtkWidget	*box);
static void		lv_remove_image		(void);
static GtkWidget*	lv_icon_new 		(GList		*list,
						 gint		frame,
						 gboolean	for_teo);
static GtkWidget*	lv_icon_box_new 	(GList		*list,
						 GtkWidget	*parent,
						 gint		frame,
						 gboolean	can_expand,
						 gboolean	for_teo);
static GtkWidget* 	lv_component_toolbar_new(void);

/* ************************************************************************* *
 * Хåؿ
 *
 * cb_destroy
 * cb_mouse_press
 * cb_remove_image
 * ************************************************************************* */

/* ꥹȥӥ塼Ĥ ********************************************** */
static void
cb_destroy (GtkWidget	*widget,
	    gpointer	data) {
  gtk_widget_destroy (list_viewer);
  list_viewer = NULL;
}

/* ޥåΥ٥ ********************************************** */
static void
cb_mouse_press (GtkWidget	*widget,
		GdkEventButton	*event,
		gpointer	data) {
  GtkWidget	*ebox = NULL;
  GtkWidget	*icon_box;
  gchar		*label;  
  gchar		*filename;
  gint		frame;
  
  /*  */
  {
    /* 򤵤Ƥ̾ */
    label = (gchar *) G_GET_PARAMETER (list_viewer, "selected_filename");

    /*  */
    if (label) {
      ebox = G_GET_WIDGET (list_viewer, label);
      if (ebox) {
	icon_box = G_GET_WIDGET (ebox, "icon_box");
	if (icon_box) {
	  gtk_frame_set_shadow_type (GTK_FRAME (icon_box), GTK_SHADOW_NONE);
	}
	G_SET_PARAMETER (list_viewer, "selected_filename", NULL);
      }
    }    
    /*  */
    if (widget != ebox) {
      icon_box = G_GET_WIDGET (widget, "icon_box");
      if (icon_box) {
	gtk_frame_set_shadow_type(GTK_FRAME (icon_box),GTK_SHADOW_ETCHED_OUT);
      }
      /* 򤵤줿̾Ͽ */
      label = (gchar *) G_GET_PARAMETER (widget, "filename");
      G_SET_PARAMETER (list_viewer, "selected_filename", label);
    }
  }
  /* ֥륯åΥ٥ */
  if (event->type == GDK_2BUTTON_PRESS) {
    switch (event->button) {
    case MOUSE_BUTTON_LEFT:  /* ɽ */
      label = (gchar *) G_GET_PARAMETER (widget, "filename");
      if (label) {
	filename   = strrchr (label, ';') + 1;
	frame      = (gint) G_GET_PARAMETER (widget, "frame");
	image_list = ti_get_list_from_path (image_list, filename);
	if (image_list) {
	  if (ti_get_external (image_list)) {
	    teoeyes_image_load (ti_get_image (image_list),
				frame, to->min, to->max);
	  }
	  gtk_widget_set_size_request (get_widget (image_window, "canvas"),
				       ti_get_width  (image_list),
				       ti_get_height (image_list));
	}
      }
      break;
    case MOUSE_BUTTON_RIGHT:	/* ե졼Ÿؤ */
      if ((gint) G_GET_PARAMETER (widget, "can_expand")) {
	if (!(gint) G_GET_PARAMETER (widget, "expanded")) {
	  gtk_widget_show (G_GET_WIDGET (widget, "group_box"));
	  G_SET_PARAMETER (widget, "expanded", TRUE);
	} else {
	  gtk_widget_hide (G_GET_WIDGET (widget, "group_box"));
	  G_SET_PARAMETER (widget, "expanded", FALSE);
	}
      }
      break;
    }
  }
}

/* ************************************************************************* */
static void
cb_remove_image (GtkWidget	*widget,
		 gpointer	data) {
  lv_remove_image ();
}

/* ************************************************************************* *
 * ؿ
 *
 * lv_add_image
 * lv_remove_image
 * ************************************************************************* */

/* ͥɲ ******************************************************** */
static void
lv_add_image (GtkWidget	*window,
	      GtkWidget	*box) {
  TeoeyesImageModule*	module = NULL;  
  TEOFILE		*teofp;
  GList			*list;
  GtkWidget		*icon_box;
  GtkWidget		*group_box;
  gint			n, nframes;

  list = g_list_first (image_list);
  while (list) {
    /* ⥸塼γ */
    if (ti_get_external (list)) {
      module = select_module_from_file (ti_get_file_path (list));
    }
    if (module && strcmp (module->info->name, "TEO") == 0) {
      if (ti_get_fp (list)) {
	nframes = ti_get_nframes (list);
      } else {
	teofp = TeoOpenFile (ti_get_file_path (list));
	nframes = TeoFrame (teofp);
	TeoCloseFile (teofp);
      }
      icon_box = lv_icon_box_new (list, window, 0,
				  (nframes > 1) ? TRUE : FALSE, TRUE);
      gtk_box_pack_start (GTK_BOX (box), icon_box, FALSE, FALSE, 5);
      gtk_widget_show (icon_box);
      
      if (nframes > 1) {
	group_box = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (box), group_box, FALSE, FALSE, 0);
	G_SET_WIDGET (G_GET_WIDGET (icon_box, "ebox"), "group_box", group_box);
	for (n = 1; n < nframes; n++) {
	  icon_box = lv_icon_box_new (list, window, n, FALSE, TRUE);
	  gtk_box_pack_start (GTK_BOX (group_box), icon_box, FALSE, FALSE, 5);
	  gtk_widget_show (icon_box);	  
	}
      }
    } else {
      icon_box = lv_icon_box_new (list, window, 0, FALSE, FALSE);
      gtk_box_pack_start (GTK_BOX (box), icon_box, FALSE, FALSE, 5);
      gtk_widget_show (icon_box);
    }
    list = g_list_next (list);
    module = NULL;
  }
}

/* ************************************************************************* */
static void
lv_remove_image (void) {
  GList		*this = NULL;
  GList		*prev = NULL;
  GList		*next = NULL;
  gchar		*filename;

  /* 򤵤Ƥ̾ */
  filename = (gchar *) G_GET_PARAMETER (list_viewer, "selected_filename");
  if (!filename) return;

  /* ꥹȤγ */
  filename = strrchr (filename, ';') + 1;  
  this = ti_get_list_from_path (image_list, filename);
  if (!this) return;
  prev = g_list_previous (this);
  next = g_list_next     (this);

  /* ˲ʤϺʤ */
  if (!prev && !next) return;

  /* ߤΥꥹȤκ */
  if (prev) prev->next = next;
  if (next) next->prev = prev;

  /* ǡβ */
  teoeyes_image_free (this->data);

  /* ɽ */
  if (this == image_list) {
    image_list = (next) ? next : prev;
    if (!ti_get_pixbuf (image_list)) {
      teoeyes_image_load (ti_get_image (image_list), 0, to->min, to->max);
    }
    /* ɥѹ */
    gtk_widget_set_usize (get_widget (image_window, "canvas"),
			  ti_get_width  (image_list),
			  ti_get_height (image_list));
  }
  /* ͥι */
  list_viewer_refresh_list (list_viewer);

  /*  */
  gtk_object_set_data (GTK_OBJECT (list_viewer), "selected_filename", NULL);
}

/* ************************************************************************* *
 * ꥹȥӥ塼ؿ
 *
 * lv_icon_new
 * lv_icon_box_new
 * lv_component_toolbar_new
 * list_viewer_new
 * ************************************************************************* */

/* ͥ ******************************************************** */
static GtkWidget*
lv_icon_new (GList	*list,
	     gint	frame,
	     gboolean	for_teo) {
  TEImage	*ti;
  GdkPixbuf	*pbuf, *spbuf;
  GtkWidget	*icon;
  gint		ow, oh, sw, sh;

  /* ꥸʥǡγ */
  ti = teoeyes_image_new (ti_get_file_path (list), ti_get_external (list));
  if (for_teo) {
    ti->frame	   = frame;
    ti->min	   = to->min;
    ti->max        = to->max;
    ti->user_data2 = FALSE;
  }
  pbuf = (ti_get_external (list)) ? 
    teoeyes_image_open (ti) : ti_get_pixbuf (list);

  /* ꥸʥǡ礭 */  
  ow = gdk_pixbuf_get_width  (pbuf);
  oh = gdk_pixbuf_get_height (pbuf);

  /* ͥǡ礭 */  
  if (ow <= ICON_WIDTH && oh <= ICON_HEIGHT) {
    sw = ow;
    sh = oh;
  } else if (ow > ICON_WIDTH && oh > ICON_HEIGHT) {
    if (ow > oh) {
      sw = ICON_WIDTH;
      sh = sw * oh / ow;
    } else {
      sh = ICON_HEIGHT;
      sw = sh * ow / oh;
    }
  } else if (ow > ICON_WIDTH) {
    sw = ICON_WIDTH;
    sh = sw * oh / ow;
  } else if (oh > ICON_HEIGHT) {
    sh = ICON_HEIGHT;
    sw = sh * ow / oh;    
  }
  /* ͥǡ */    
  spbuf = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, sw, sh);
  gdk_pixbuf_composite_color (pbuf, spbuf, 0, 0, sw, sh, 0, 0,
			      (double) sw / ow, (double) sh / oh,
			      GDK_INTERP_TILES,
			      255, 0, 0, 16, 0xaaaaaa, 0x555555);
  icon = gtk_image_new_from_pixbuf (spbuf);

  teoeyes_image_free (ti);
  gdk_pixbuf_unref   (spbuf);
  
  return icon;
}

/* ܥå ************************************************** */
static GtkWidget*
lv_icon_box_new (GList		*list,
		 GtkWidget	*parent,
		 gint		frame,
		 gboolean	can_expand,
		 gboolean	for_teo) {
  GtkWidget	*icon_box;
  GtkWidget	*ebox;
  GtkWidget	*icon;
  gchar		label[MAX_STRING_LNG_LINE];

  /* ܥå */
  icon_box = gtk_frame_new (NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (icon_box), GTK_SHADOW_NONE);
  gtk_container_set_border_width (GTK_CONTAINER (icon_box), 2);
  {
    /* ٥ȥܥå */
    ebox = gtk_event_box_new ();
    gtk_widget_set_events (ebox, GDK_BUTTON_PRESS_MASK);
    g_signal_connect (G_OBJECT (ebox), "button_press_event",
		      G_CALLBACK (cb_mouse_press), NULL);
    gtk_container_add (GTK_CONTAINER (icon_box), ebox);
    gtk_widget_show (ebox);
    {
      /* ٥ȥܥå˾ղ */
      if (ti_get_external (list)) {
	sprintf (label, "%d;%s", frame, ti_get_file_path (list));
      } else {
	sprintf (label, "%d;%s", frame, ti_get_filename (list));
      }      
      G_SET_WIDGET (parent,   g_strdup (label),	ebox);
      G_SET_WIDGET (icon_box, "ebox",		ebox);
      G_SET_WIDGET (ebox,     "icon_box",	icon_box);
      G_SET_PARAMETER (ebox,  "filename",	g_strdup (label));      
      G_SET_PARAMETER (ebox,  "can_expand",	can_expand);
      G_SET_PARAMETER (ebox,  "expanded",	FALSE);
      G_SET_PARAMETER (ebox,  "frame",		frame);
    }
    /* ɲ */
    icon = lv_icon_new (list, frame, for_teo);
    gtk_container_add (GTK_CONTAINER (ebox), icon);
    gtk_widget_show (icon);
    G_SET_WIDGET (parent, "icon", icon);
  }
  return icon_box;
}

/* ġСݡͥȤ ****************************************** */
static GtkWidget*
lv_component_toolbar_new (void) {
  GtkWidget	*handlebox;
  GtkWidget	*toolbar;
  GtkWidget	*icon;
  GdkPixbuf	*pixbuf;
  
  /* ϥɥܥå */
  handlebox = gtk_handle_box_new ();

  /* ġС */
  toolbar = gtk_toolbar_new ();
  gtk_container_add (GTK_CONTAINER (handlebox), toolbar);
  G_SET_WIDGET (handlebox, "toolbar", toolbar);
  {
    /* Ĥץܥ */
    pixbuf = gdk_pixbuf_new_from_inline (-1, stock_close, FALSE, NULL);
    icon = gtk_image_new_from_pixbuf (pixbuf);
    gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				GTK_TOOLBAR_CHILD_BUTTON,
				NULL,				  
				_("Close"), 
				_("Close Image List Viewer"),
				_("Close Image List Viewer"),
				icon,
				G_CALLBACK (cb_destroy),
				NULL);
    gdk_pixbuf_unref (pixbuf);
    G_SET_WIDGET (handlebox, "icon1", icon);

    /* ֤Ȣץܥ */
    pixbuf = gdk_pixbuf_new_from_inline (-1, stock_trash, FALSE, NULL);
    icon = gtk_image_new_from_pixbuf (pixbuf);
    gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				GTK_TOOLBAR_CHILD_BUTTON,
				NULL,				  
				_("Trash"), 
				_("Delete a selected image from the list"),
				_("Delete a selected image from the list"),
				icon,
				G_CALLBACK (cb_remove_image),
				NULL);    
    gdk_pixbuf_unref (pixbuf);
    G_SET_WIDGET (handlebox, "icon2", icon);

    /* Ƭץܥ */
    pixbuf = gdk_pixbuf_new_from_inline (-1, stock_blue_arrow_first,
					 FALSE, NULL);
    icon = gtk_image_new_from_pixbuf (pixbuf);
    gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				GTK_TOOLBAR_CHILD_BUTTON,
				NULL,				  
				_("First Image"), 
				_("Show the first image in the list"),
				_("Show the first image in the list"),
				icon,
				G_CALLBACK (cb_top_image),
				NULL);
    gdk_pixbuf_unref (pixbuf);
    G_SET_WIDGET (handlebox, "icon3", icon);

    /* ץܥ */
    pixbuf = gdk_pixbuf_new_from_inline (-1, stock_blue_arrow_left,
					 FALSE, NULL);
    icon = gtk_image_new_from_pixbuf (pixbuf);
    gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				GTK_TOOLBAR_CHILD_BUTTON,
				NULL,				  
				_("Previous Image"), 
				_("Show the previous image in the list"),
				_("Show the previous image in the list"),
				icon,
				G_CALLBACK (cb_previous_image),
				NULL);
    gdk_pixbuf_unref (pixbuf);
    G_SET_WIDGET (handlebox, "icon4", icon);

    /* ּץܥ */
    pixbuf = gdk_pixbuf_new_from_inline (-1, stock_blue_arrow_right,
					 FALSE, NULL);
    icon = gtk_image_new_from_pixbuf (pixbuf);
    gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				GTK_TOOLBAR_CHILD_BUTTON,
				NULL,				  
				_("Next Image"), 
				_("Show the next image in the list"),
				_("Show the next image in the list"),
				icon,
				G_CALLBACK (cb_next_image),
				NULL);
    gdk_pixbuf_unref (pixbuf);
    G_SET_WIDGET (handlebox, "icon5", icon);

    /* ץܥ */
    pixbuf = gdk_pixbuf_new_from_inline (-1, stock_blue_arrow_last,
					 FALSE, NULL);
    icon = gtk_image_new_from_pixbuf (pixbuf);
    gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				GTK_TOOLBAR_CHILD_BUTTON,
				NULL,				  
				_("Last Image"), 
				_("Show the last image in the list"),
				_("Show the last image in the list"),
				icon,
				G_CALLBACK (cb_bottom_image),
				NULL);
    gdk_pixbuf_unref (pixbuf);
    G_SET_WIDGET (handlebox, "icon6", icon);
  }
  return handlebox;
}

/* ꥹȥӥ塼 ************************************************ */
GtkWidget*
list_viewer_new (void) {
  GtkWidget	*window;
  GtkWidget	*box;
  GtkWidget	*handlebox;
  GtkWidget	*separator;
  GtkWidget	*scrolled_window;

  /* ɥ */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_wmclass (GTK_WINDOW (window), "teoeyes", "Teo Image Viewer");
  gtk_window_set_title (GTK_WINDOW (window), _("Teoeyes Image List Viewer"));
  gtk_window_set_resizable (GTK_WINDOW (window), TRUE);
  gtk_window_set_icon (GTK_WINDOW (window), te_icon);
  g_signal_connect (G_OBJECT (window),
		    "destroy", G_CALLBACK (cb_destroy), NULL);
  g_signal_connect (G_OBJECT (window),
		    "delete_event", G_CALLBACK (cb_destroy), NULL);

  /* ľܥå */
  box = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), box);
  gtk_widget_show (box);
  G_SET_WIDGET (window, "box1", box);
  {
    /* ġСݡͥȤ */
    handlebox = lv_component_toolbar_new ();
    gtk_box_pack_start (GTK_BOX (box), handlebox, FALSE, FALSE, 0);
    gtk_widget_show_all (handlebox);
    G_SET_WIDGET (window, "handlebox", handlebox);
    
    /* ѥ졼 */
    separator = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (box), separator, FALSE, FALSE, 3);
    gtk_widget_show (separator);
    G_SET_WIDGET (window, "separator", separator);
  
    /* 륦ɥ */
    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    G_SET_WIDGET (window, "scrolled_window", scrolled_window);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				    GTK_POLICY_ALWAYS, GTK_POLICY_NEVER);
    gtk_box_pack_start (GTK_BOX (box), scrolled_window, TRUE, TRUE, 0);
    gtk_widget_show (scrolled_window);    
    {
      /* ʿܥå */
      box = gtk_hbox_new (FALSE, 0);
      G_SET_WIDGET (window, "box", box);
      gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW
					     (scrolled_window), box);
      gtk_widget_show (box);
      
      /* ͥɲ */
      lv_add_image (window, box);

      /* 򤵤줿Ͽ (Ϥ̤) */
      G_SET_PARAMETER (window, "selected_image", NULL);
    }	
  }
  return window;
}

/* ͥι ******************************************************** */
void
list_viewer_refresh_list (GtkWidget	*window) {
  GtkWidget	*box;
  GtkWidget	*scrolled_window;

  box = G_GET_WIDGET (window, "box");
  scrolled_window = G_GET_WIDGET (window, "scrolled_window");
  gtk_widget_hide (box);
  gtk_widget_destroy (box);
  
  box = gtk_hbox_new (FALSE, 0);
  G_SET_WIDGET (window, "box", box);

  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW
					 (scrolled_window), box);
  gtk_widget_show (box);

  lv_add_image (window, box);					  
}

/* ************************************************ End of list_viewer.c *** */
