/* ************************************************* image_window_menu.h *** *
 * ɥΥ˥塼
 *
 * Copyright (C) 2002-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <03/04/30 10:11:44 sugaya>
 * ************************************************************************* */
#ifndef	__IMAGE_WIMDOW_MENU_H__
#define	__IMAGE_WINDOW_MENU_H__

#include "callback.h"

#include "teoeyes_icon.icon"
#include "stock_new.icon"
#include "stock_open.icon"
#include "stock_save.icon"
#include "stock_save_as.icon"
#include "stock_print.icon"
#include "stock_quit.icon"
#include "stock_loope.icon"
#include "stock_blue_arrow_top.icon"
#include "stock_blue_arrow_up.icon"
#include "stock_blue_arrow_down.icon"
#include "stock_blue_arrow_bottom.icon"
#include "stock_green_arrow_top.icon"
#include "stock_green_arrow_up.icon"
#include "stock_green_arrow_down.icon"
#include "stock_green_arrow_bottom.icon"
#include "stock_red_arrow_top.icon"
#include "stock_red_arrow_up.icon"
#include "stock_red_arrow_down.icon"
#include "stock_red_arrow_bottom.icon"
#include "stock_size_double.icon"
#include "stock_size_half.icon"
#include "stock_size_down.icon"
#include "stock_size_up.icon"
#include "stock_draw.icon"
#include "stock_edit.icon"
#include "stock_undo.icon"
#include "stock_reset.icon"
#include "stock_grayscale.icon"
#include "stock_reverse.icon"
#include "stock_normalize.icon"
#include "stock_hflip.icon"
#include "stock_vflip.icon"
#include "stock_plugin.icon"
#include "stock_window.icon"
#include "stock_list.icon"
#include "stock_editor.icon"
#include "stock_explorer.icon"
#include "stock_player.icon"
#include "stock_assistant.icon"
#include "stock_prof.icon"
#include "stock_info.icon"
#include "stock_help.icon"
#include "stock_about.icon"

/* ************************************************************************* */
static GtkIconItemFactoryEntry menu_items[] = {
  /* ե˥塼 */
  {N_("/_File"),		NULL,	0, 	0,	"<Branch>",	NULL},
  {N_("/_File/tearoff"),	NULL,	0,	0,	"<Tearoff>",	NULL},
  {N_("/_File/New"),	"<Control>N",
   cb_new,	0,	"<ImageItem>",	stock_new},  
  {N_("/_File/Open"),	"<Control>O",
   cb_open,	0,	"<ImageItem>",	stock_open},
  {N_("/_File/Save"),	"<Control>S",
   cb_save, 	0,	"<ImageItem>",	stock_save},
  {N_("/_File/Save as"),"<Control><Alt>S",
   cb_save_as,	0,	"<ImageItem>",	stock_save_as},
  {N_("/_File/separator"),	NULL,	0,	0,	"<Separator>",	NULL},
  {N_("/_File/Print"),	"<Control>P",
   cb_print,	0,	"<ImageItem>",	stock_print},
  {N_("/_File/separator"),	NULL,	0,	0,	"<Separator>",	NULL},
  {N_("/_File/Quit"),	"<Control>Q",
   cb_quit, 0, "<ImageItem>", stock_quit},
  
  /* ɽ˥塼 */
  {N_("/_View"),		NULL,	0,	0,	"<Branch>",	NULL},
  {N_("/_View/tearoff"),	NULL,	0,	0,	"<Tearoff>",	NULL},

  {N_("/_View/Image"),		NULL,	0,	0,	"<Branch>",	NULL},
  {N_("/_View/Image/tearoff"),	NULL,	0, 	0,	"<Tearoff>",	NULL},
  
  {N_("/_View/Image/Top Image"),	"<Shift><Alt>T",
   cb_top_image,	0,	"<ImageItem>",	stock_blue_arrow_top},  
  {N_("/_View/Image/Previous Image"),	"<Shift><Alt>P",
   cb_previous_image,	0,	"<ImageItem>",	stock_blue_arrow_up},  
  {N_("/_View/Image/Next Image"),	"<Shift><Alt>N",
   cb_next_image,	0,	"<ImageItem>",	stock_blue_arrow_down},  
  {N_("/_View/Image/Bottom Image"), 	"<Shift><Alt>B",
   cb_bottom_image,	0,	"<ImageItem>",	stock_blue_arrow_bottom},  
  
  {N_("/_View/Frame"),		NULL,	0,	0,	"<Branch>",	NULL},
  {N_("/_View/Frame/tearoff"),	NULL,	0, 	0,	"<Tearoff>",	NULL},
  
  {N_("/_View/Frame/Top Frame"),	"<Shift><Control>T",
   cb_top_frame,	0,	"<ImageItem>",	stock_green_arrow_top},  
  {N_("/_View/Frame/Previous Frame"),	"<Shift><Control>P",
   cb_previous_frame,	0,	"<ImageItem>",	stock_green_arrow_up},  
  {N_("/_View/Frame/Next Frame"),	"<Shift><Control>N",
   cb_next_frame,	0,	"<ImageItem>",	stock_green_arrow_down},  
  {N_("/_View/Frame/Bottom Frame"),	"<Shift><Control>B",
   cb_bottom_frame,	0,	"<ImageItem>",	stock_green_arrow_bottom},  

  {N_("/_View/Plane"),		NULL,	0,	0,	"<Branch>",	NULL},
  {N_("/_View/Plane/tearoff"),	NULL,	0,	0,	"<Tearoff>",	NULL},
  {N_("/_View/Plane/Show Plane"),	"<Control>V",
   cb_plane_mode,	0,	"<CheckItem>",	NULL},
  {N_("/_View/Plane/Top Plane"),	"<Shift>T",
   cb_top_plane, 	0,	"<ImageItem>",	stock_red_arrow_top},
  {N_("/_View/Plane/Previous Plane"),	"<Shift>P",
   cb_previous_plane, 	0,	"<ImageItem>",	stock_red_arrow_up},
  {N_("/_View/Plane/Next Plane"),	"<Shift>N",
   cb_next_plane, 	0,	"<ImageItem>",	stock_red_arrow_down},  
  {N_("/_View/Plane/Bottom Plane"),	"<Shift>B",
   cb_bottom_plane, 	0,	"<ImageItem>",	stock_red_arrow_bottom},

  {N_("/_View/Size"),		NULL,	0,	0,	"<Branch>",	NULL},
  {N_("/_View/Size/tearoff"),	NULL,	0,	0,	"<Tearoff>",	NULL},
  {N_("/_View/Size/Double Size"),	"<Control>period",
   cb_size_double,	0,	"<ImageItem>",	stock_size_double},  
  {N_("/_View/Size/Half Size"),		"<Control>comma",
   cb_size_half,	0,	"<ImageItem>",	stock_size_half},  
  {N_("/_View/Size/Scale Up 10\\%"),	"period",
   cb_size_up,		0,	"<ImageItem>",	stock_size_up},  
  {N_("/_View/Size/Scale down 10\\%"),	"comma",
   cb_size_down,	0,	"<ImageItem>",	stock_size_down},  

  {N_("/_View/separator"),	NULL,	0,	0,	"<Separator>",	NULL},
  {N_("/_View/Show Menubar"),	"<Control>M",
   cb_show_menubar,	0,	"<CheckItem>",		NULL},
  {N_("/_View/separator"),	NULL,	0,	0,	"<Separator>",	NULL},

  {N_("/_View/Image _Information"),	"<Control>I",
   cb_show_image_info,	0, 	"<ImageItem>",	stock_info},
  {N_("/_View/separator"),	NULL,	0,	0,	"<Separator>",	NULL},
  
  {N_("/_View/Set Image as _Wallpaper"),	NULL,
   0,	0,	"<iBranch>",					stock_draw},
  {N_("/_View/Set Image as _Wallpaper/_Centered"),	NULL,
   cb_wallpaper_centered,	0,	"<Item>",	NULL},
  {N_("/_View/Set Image as _Wallpaper/_Tiled"),		NULL,
   cb_wallpaper_tiled,		0,	"<Item>",	NULL},
  {N_("/_View/Set Image as _Wallpaper/_Scaled"),	NULL,
   cb_wallpaper_scaled,		0,	"<Item>",	NULL},
  {N_("/_View/Set Image as _Wallpaper/Str_etched"),	NULL,	
   cb_wallpaper_stretched,	0,	"<Item>",	NULL},

  /* Խ˥塼 */
  {N_("/_Edit"),		NULL,	0,	0,	"<Branch>",	NULL},
  {N_("/_Edit/tearoff"),	NULL,	0,	0,	"<Tearoff>",	NULL},
  {N_("/_Edit/Undo"),		"<Alt>U",
   cb_undo,	0,		"<ImageItem>",	stock_undo},   
  {N_("/_Edit/separator"),	NULL,	0,	0,	"<Separator>",	NULL},
  {N_("/_Edit/Original"),		"<Alt>O",
   cb_original, 	0,	"<ImageItem>",	stock_reset},
  {N_("/_Edit/Grayscale"),		"<Alt>G",
   cb_grayscale, 	0,	"<ImageItem>",	stock_grayscale},
  {N_("/_Edit/Reverse"),		"<Alt>R",
   cb_reverse, 		0,		"<ImageItem>",	stock_reverse},
  {N_("/_Edit/Normalize"),		"<Alt>N",
   cb_normalize,	0,	"<ImageItem>",	stock_normalize},
  {N_("/_Edit/Flip Horizontal"),	"<Alt>H",
   cb_flip_horizontal, 	0,	"<ImageItem>",	stock_hflip},
  {N_("/_Edit/Flip Vertical"),		"<Alt>V",
   cb_flip_vertical, 	0,	"<ImageItem>",	stock_vflip},
  
  /* ץ饰˥塼 */
  {N_("/Plugin"),		NULL,	0,	0,	"<Item>",	NULL},

  /* ɥ˥塼 */
  {N_("/_Window"),		NULL,	0,	0,	"<Branch>",	NULL},
  {N_("/_Window/tearoff"),	NULL,	0,	0,	"<Tearoff>",	NULL},
  
  {N_("/_Window/Image List Viewer"),	"<Control>L",
   cb_show_lv, 	0,	"<ImageItem>",	stock_list},  
  {N_("/_Window/Image Editor"),		"<Control>E",
   cb_show_editor, 	0,	"<ImageItem>",	stock_editor},  
  {N_("/_Window/Image Explorer"),	"<Control>B",
   cb_show_ixp, 	0,	"<ImageItem>",	stock_explorer},  
  {N_("/_Window/Image Player"),		"<Control>C",
   cb_show_player, 	0,	"<ImageItem>",	stock_player},  
  {N_("/_Window/separator"),	NULL,	0,	0,	"<Separator>",	NULL},
  {N_("/_Window/Assistant"),		"<Alt>A",
   cb_show_assistant, 	0,	"<ImageItem>",	stock_assistant},

  /* ˥塼 */
  {N_("/_Property"),		NULL,	0,	0,	"<Branch>",	NULL},
  {N_("/_Property/tearoff"),	NULL,	0,	0,	"<Tearoff>",	NULL},
  {N_("/_Property/_Property"),		"<Control>F",
   cb_show_config,	0,	"<ImageItem>",	stock_prof},

  /* إץ˥塼 */
  {N_("/_Help"),		NULL,	0,	0,	"<LastBranch>",	NULL},
  {N_("/_Help/tearoff"),	NULL,	0,	0,	"<Tearoff>",	NULL},
  
  {N_("/_Help/About Teoeyes"),		"<Control>A",
   cb_show_about,	0,	"<ImageItem>",	stock_about},
  {N_("/_Help/Help"),			"<Control>H",
   cb_show_help, 	0,	"<ImageItem>",	stock_help}  
  
};

/* ************************************************************************* */
static GtkIconItemFactoryEntry popup_menu_items[] = {
  {N_("/Tearoff"),	NULL,	0,	0,	"<Tearoff>",	NULL},

  {N_("/Teoeyes"),	NULL,	0,	0,	"<iTitle>",	teoeyes_icon},

  {N_("/separator"),	NULL,	0,	0,	"<Separator>",	NULL},

  /* ե˥塼 */
  {N_("/_File"),	NULL,	0, 	0,	"<iBranch>",	stock_open},
  {N_("/_File/tearoff"),NULL,	0,	0,	"<Tearoff>",	NULL},
  {N_("/_File/New"),	"<Control>N",
   cb_new,	0,	"<ImageItem>",	stock_new},  
  {N_("/_File/Open"),	"<Control>O",
   cb_open,	0,	"<ImageItem>",	stock_open},
  {N_("/_File/Save"),	"<Control>S",
   cb_save, 	0,	"<ImageItem>",	stock_save},
  {N_("/_File/Save as"),"<Control><Alt>S",
   cb_save_as,	0,"<ImageItem>",	stock_save_as},
  {N_("/_File/separator"),NULL,	0,	0,	"<Separator>",	NULL},
  {N_("/_File/Print"),	"<Control>P",
   cb_print,	0,	"<ImageItem>",	stock_print},
  
  /* ɽ˥塼 */
  {N_("/_View"),	NULL,	0,	0,	"<iBranch>",	stock_loope},
  {N_("/_View/tearoff"),NULL,	0,	0,	"<Tearoff>",	NULL},

  {N_("/_View/Image"),		NULL,	0,	0,	"<Branch>",	NULL},
  {N_("/_View/Image/tearoff"),	NULL,	0, 	0,	"<Tearoff>",	NULL},
  
  {N_("/_View/Image/Top Image"),	"<Shift><Alt>T",
   cb_top_image,	0,	"<ImageItem>",	stock_blue_arrow_top},  
  {N_("/_View/Image/Previous Image"),	"<Shift><Alt>P",
   cb_previous_image,	0,	"<ImageItem>",	stock_blue_arrow_up},  
  {N_("/_View/Image/Next Image"),	"<Shift><Alt>N",
   cb_next_image,	0,	"<ImageItem>",	stock_blue_arrow_down},  
  {N_("/_View/Image/Bottom Image"), 	"<Shift><Alt>B",
   cb_bottom_image,	0,	"<ImageItem>",	stock_blue_arrow_bottom},  
  
  {N_("/_View/Frame"),		NULL,	0,	0,	"<Branch>",	NULL},
  {N_("/_View/Frame/tearoff"),	NULL,	0, 	0,	"<Tearoff>",	NULL},
  
  {N_("/_View/Frame/Top Frame"),	"<Shift><Control>T",
   cb_top_frame,	0,	"<ImageItem>",	stock_green_arrow_top},  
  {N_("/_View/Frame/Previous Frame"),	"<Shift><Control>P",
   cb_previous_frame,	0,	"<ImageItem>",	stock_green_arrow_up},  
  {N_("/_View/Frame/Next Frame"),	"<Shift><Control>N",
   cb_next_frame,	0,	"<ImageItem>",	stock_green_arrow_down},  
  {N_("/_View/Frame/Bottom Frame"),	"<Shift><Control>B",
   cb_bottom_frame,	0,	"<ImageItem>",	stock_green_arrow_bottom},  

  {N_("/_View/Plane"),		NULL,	0,	0,	"<Branch>",	NULL},
  {N_("/_View/Plane/tearoff"),	NULL,	0,	0,	"<Tearoff>",	NULL},
  {N_("/_View/Plane/Show Plane"),	"<Control>V",
   cb_plane_mode,	0,	"<CheckItem>",	NULL},
  {N_("/_View/Plane/Top Plane"),	"<Shift>T",
   cb_top_plane, 	0,	"<ImageItem>",	stock_red_arrow_top},
  {N_("/_View/Plane/Previous Plane"),	"<Shift>P",
   cb_previous_plane, 	0,	"<ImageItem>",	stock_red_arrow_up},
  {N_("/_View/Plane/Next Plane"),	"<Shift>N",
   cb_next_plane, 	0,	"<ImageItem>",	stock_red_arrow_down},  
  {N_("/_View/Plane/Bottom Plane"),	"<Shift>B",
   cb_bottom_plane, 	0,	"<ImageItem>",	stock_red_arrow_bottom},

  {N_("/_View/Size"),		NULL,	0,	0,	"<Branch>",	NULL},
  {N_("/_View/Size/tearoff"),	NULL,	0,	0,	"<Tearoff>",	NULL},
  {N_("/_View/Size/Double Size"),	"<Control>period",
   cb_size_double,	0,	"<ImageItem>",	stock_size_double},  
  {N_("/_View/Size/Half Size"),		"<Control>comma",
   cb_size_half,	0,	"<ImageItem>",	stock_size_half},  
  {N_("/_View/Size/Scale Up 10\\%"),	"period",
   cb_size_up,		0,	"<ImageItem>",	stock_size_up},  
  {N_("/_View/Size/Scale down 10\\%"),	"comma",
   cb_size_down,	0,	"<ImageItem>",	stock_size_down},  

  {N_("/_View/separator"),	NULL,	0,	0,	"<Separator>",	NULL},
  {N_("/_View/Show Menubar"),	"<Control>M",
   cb_show_menubar,	0,	"<CheckItem>",		NULL},
  {N_("/_View/separator"),	NULL,	0,	0,	"<Separator>",	NULL},
  
  {N_("/_View/Set Image as _Wallpaper"),	NULL,
   0,	0,	"<iBranch>",		stock_draw},
  {N_("/_View/Set Image as _Wallpaper/_Centered"),	NULL,
   cb_wallpaper_centered,	0,	"<Item>",	NULL},
  {N_("/_View/Set Image as _Wallpaper/_Tiled"),		NULL,
   cb_wallpaper_tiled,		0,	"<Item>",	NULL},
  {N_("/_View/Set Image as _Wallpaper/_Scaled"),	NULL,	
   cb_wallpaper_scaled,		0,	"<Item>",	NULL},
  {N_("/_View/Set Image as _Wallpaper/Str_etched"),	NULL,	
   cb_wallpaper_stretched,	0,	"<Item>",	NULL},

  /* Խ˥塼 */
  {N_("/_Edit"),	NULL,	0,	0,	"<iBranch>",	stock_edit},
  {N_("/_Edit/tearoff"),NULL,	0,	0,	"<Tearoff>",	NULL},
  {N_("/_Edit/Undo"),		"<Alt>U",
   cb_undo,	0,	"<ImageItem>",	stock_undo},   
  {N_("/_Edit/separator"),	NULL,	0,	0,	"<Separator>",	NULL},
  {N_("/_Edit/Original"),		"<Alt>O",
   cb_original, 	0,	"<ImageItem>",	stock_reset},
  {N_("/_Edit/Grayscale"),		"<Alt>G",
   cb_grayscale, 	0,	"<ImageItem>",	stock_grayscale},
  {N_("/_Edit/Reverse"),		"<Alt>R",
   cb_reverse,	 	0,	"<ImageItem>",	stock_reverse},
  {N_("/_Edit/Normalize"),		"<Alt>N",
   cb_normalize,	0,	"<ImageItem>",	stock_normalize},
  {N_("/_Edit/Flip Horizontal"),	"<Alt>H",
   cb_flip_horizontal, 	0,	"<ImageItem>",	stock_hflip},
  {N_("/_Edit/Flip Vertical"),		"<Alt>V",
   cb_flip_vertical, 	0,	"<ImageItem>",	stock_vflip},

  /* ץ饰˥塼 */
  {N_("/Plugin"),	NULL,	0,	0,	"<ImageItem>",	stock_plugin},

  /* ɥ˥塼 */
  {N_("/_Window"),	NULL,	0,	0,	"<iBranch>",	stock_window},
  {N_("/_Window/tearoff"),NULL,	0,	0,	"<Tearoff>",	NULL},
  
  {N_("/_Window/Image List Viewer"),	"<Control>L",
   cb_show_lv, 	0,	"<ImageItem>",	stock_list},  
  {N_("/_Window/Image Editor"),		"<Control>E",
   cb_show_editor, 	0,	"<ImageItem>",	stock_editor},  
  {N_("/_Window/Image Explorer"),	"<Control>B",
   cb_show_ixp, 	0,	"<ImageItem>",	stock_explorer},  
  {N_("/_Window/Image Player"),		"<Control>C",
   cb_show_player, 	0,	"<ImageItem>",	stock_player},  
  {N_("/_Window/separator"),	NULL,	0,	0,	"<Separator>",	NULL},
  {N_("/_Window/Assistant"),		"<Alt>A",
   cb_show_assistant, 	0,	"<ImageItem>",	stock_assistant},

  {N_("/separator"),	NULL,	0,	0,	"<Separator>",	NULL},
  
  /*  */
  {N_("/Image _Information"),	"<Control>I",
   cb_show_image_info, 	0, 	"<ImageItem>",	stock_info},

  {N_("/separator"),	NULL,	0,	0,	"<Separator>",	NULL},
   
  /* ˥塼 */
  {N_("/_Property"),	"<Control>F",
   cb_show_config,	0,	"<ImageItem>",	stock_prof},

  {N_("/_About Teoeyes"),	"<Control>A",
   cb_show_about, 	0,	"<ImageItem>",	stock_about},
   
  /* إץ˥塼 */
  {N_("/_Help"),	"<Control>H",
   cb_show_help, 	0,	"<ImageItem>",	stock_help},

  {N_("/separator"),	NULL,	0,	0,	"<Separator>",	NULL},

  {N_("/_Quit"),	"<Control>Q",
   cb_quit, 0, "<ImageItem>", stock_quit}
};

#endif	/* __IMAGE_WINDOW_MENU_H__ */

/* ****************************************** End of image_window_menu.h *** */
