/* ********************************************************** image_io.h *** *
 * ϴؿ ءե
 *
 * Copyright (C) 2002-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <03/04/17 09:52:15 sugaya>
 * ************************************************************************* */
#ifndef	__IMAGE_IO_H__
#define	__IMAGE_IO_H__

#include "image_loader.h"

/* ************************************************************************* */
TeoeyesImageModule*
select_module_from_file 			(const gchar	*filename);
TeoeyesImageModule*
select_module_from_extension 			(const gchar	*extension);
void		loader_init 			(GList		*loader_path);
void		loader_close			(GList		*loader);
gboolean	check_image_supported		(const gchar	*filename);
GdkPixbuf*	teoeyes_image_open 		(TEImage	*ti);
gboolean	teoeyes_image_load 		(TEImage	*ti,
						 gint		frame,
						 gdouble	min,
						 gdouble	max);
void		teoeyes_image_set 		(TEImage	*ti,
						 gint		frame,
						 gdouble	min,
						 gdouble	max);
gboolean	teoeyes_image_save		(const gchar	*filename,
						 TEImage	*teimg);

#endif	/* __IMAGE_IO_H__ */

/* *************************************************** End of image_io.h *** */
