/* ************************************************************** draw.c *** *
 * ؿ
 *
 * Copyright (C) 2001-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <03/05/02 23:22:56 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"
#include "draw.h"
#include "image_window.h"

/*  ************************************************************** */
void
draw_image (GList	*list,
	    gint	width,
	    gint	height) {
  GtkWidget	*canvas;
  GdkWindow	*window;
  GdkPixbuf	*background, *plane = NULL;
  GdkPixmap	*pixmap;
  GdkBitmap	*mask;

  /* Хγ */
  canvas = G_GET_WIDGET (image_window, "canvas");
  window = canvas->window;

  /* ץ졼ɽ⡼ */
  if (ti_get_channel (list) != -1) {
    plane = ti_get_nth_plane (list, ti_get_channel (list));
  }
  /* Хå */
  gdk_window_set_back_pixmap (window, NULL, FALSE);
  background = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, width, height);

  /*  */
  gdk_pixbuf_composite_color ((plane) ? plane : ti_get_pixbuf (list),
			      background,
			      0, 0,
			      width, height,
			      0, 0,
			      (gdouble) width  / ti_get_width  (list),
			      (gdouble) height / ti_get_height (list),
			      GDK_INTERP_TILES,
			      255,
			      0, 0,
			      16, 0xaaaaaa, 0x555555);
  /* ɥؤ */

  /* ԥåޥåפ */
  gdk_pixbuf_render_pixmap_and_mask (background, &pixmap, &mask, 255);

  /* ɥؤ */
  gdk_window_set_back_pixmap (window, pixmap, FALSE);
  gdk_window_clear (window);
  gdk_window_shape_combine_mask (window, mask, 0, 0);
  gdk_flush ();

  gdk_pixbuf_unref (background);
  gdk_pixmap_unref (pixmap);
  if (mask)  gdk_bitmap_unref (mask);
  if (plane) gdk_pixbuf_unref (plane);
}

/* ΰȤ ******************************************************** */
void
draw_scope (GtkWidget	*widget,
	    gint	x,
	    gint	y,
	    gint	scale) {
  GdkWindow		*window;
  GdkGC			*white_gc, *black_gc;
  static GdkColormap	*cmap = NULL;
  static GdkColor	white, black;
  gint			offset;
  gint			width;

  if (!cmap) {
    cmap = gdk_colormap_get_system ();
    white.pixel = 0;
    white.red   = 255 << 8;
    white.green = 255 << 8;
    white.blue  = 255 << 8;
    black.pixel = 0;
    black.red   = 0;
    black.green = 0;
    black.blue  = 0;
    gdk_color_alloc (cmap, &white);
    gdk_color_alloc (cmap, &black);    
  }
  window = widget->window;
  gdk_window_clear_area (window, 0, 0, 
			 widget->allocation.width, widget->allocation.height);
  white_gc = gdk_gc_new (window);
  black_gc = gdk_gc_new (window);
  gdk_gc_set_foreground (white_gc, &white);
  gdk_gc_set_foreground (black_gc, &black);  

  offset = LOOPE_WINDOW_SIZE / (scale * 2);
  width  = LOOPE_WINDOW_SIZE / scale;
  gdk_draw_rectangle (window, white_gc, FALSE,
		      x - (offset+1), y - (offset+1), width + 4, width + 4);
  gdk_draw_rectangle (window, black_gc, FALSE,
		      x - offset, y - offset, width + 2, width + 2);
  gdk_flush ();
  gdk_gc_destroy (white_gc);
  gdk_gc_destroy (black_gc);
}

/* 롼ڲ ******************************************************** */
void
draw_loope_image (GtkWidget	*widget,
		  GList		*list,
		  gint		x,
		  gint		y,
		  gint		lx,
		  gint		ly,
		  gint		scale) {
  GdkWindow	*window;
  GdkPixbuf	*pixbuf, *background;
  guchar	*src_ptr, *dst_ptr;
  static gint	pre_x, pre_y;
  gint		pos, row, col, ox, oy, w, h, ow, oh, plane, rowstride;
  
  /* ΰ֡礭γ */
  if (x == -1) x = pre_x;
  if (y == -1) y = pre_y;
  pre_x     = x;
  pre_y     = y;
  w = h     = LOOPE_WINDOW_SIZE / scale;
  ox	    = x + 1 - w / 2;
  oy	    = y + 1 - h / 2;
  ow	    = ti_get_width  (list);
  oh	    = ti_get_height (list);
  rowstride = gdk_pixbuf_get_rowstride (ti_get_pixbuf (list));

  /* ǡؤΥݥ */
  src_ptr = gdk_pixbuf_get_pixels (ti_get_pixbuf (list));

  /* ץ졼γ */
  plane = 3 + ti_get_has_alpha (list);

  /* ǡΰ */
  pixbuf  = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, w, h);
  dst_ptr = gdk_pixbuf_get_pixels (pixbuf);
  
  /* ǡ */
  for (row = oy; row < oy + h; row++) {
    for (col = ox; col < ox + w; col++) {
      if (row < 0 || row >= oh || col < 0 || col >= ow) {
	*dst_ptr++ = 0;
	*dst_ptr++ = 0;
	*dst_ptr++ = 0;
      } else {
	pos = row * rowstride + col * plane;
	*dst_ptr++ = *(src_ptr + pos);
	*dst_ptr++ = *(src_ptr + pos + 1);
	*dst_ptr++ = *(src_ptr + pos + 2);
      }
    }
  }
  /*  */
  background = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8,
			       LOOPE_WINDOW_SIZE, LOOPE_WINDOW_SIZE);
  /* Хγ */
  window = widget->window;
  gdk_window_set_back_pixmap (window, NULL, FALSE);
  gdk_pixbuf_composite_color (pixbuf, background,
			      0, 0,
			      LOOPE_WINDOW_SIZE, LOOPE_WINDOW_SIZE,
			      0, 0,
			      (gdouble) LOOPE_WINDOW_SIZE / w,
			      (gdouble) LOOPE_WINDOW_SIZE / h,
			      GDK_INTERP_TILES,
			      255,
			      0, 0,
			      8, 0xaaaaaa, 0x555555);
  gdk_pixbuf_render_to_drawable (background,
				 window,
				 widget->style->fg_gc[GTK_STATE_NORMAL],
				 0, 0,
				 0, 0,
				 LOOPE_WINDOW_SIZE, LOOPE_WINDOW_SIZE,
				 GDK_RGB_DITHER_NORMAL,
				 0, 0);
  gdk_draw_rectangle (window,
		      widget->style->white_gc, FALSE, lx, ly, scale, scale);
  gdk_draw_rectangle (window, widget->style->black_gc,
		      FALSE, lx + 1, ly + 1, scale - 2, scale - 2);
  
  gdk_pixbuf_unref (pixbuf);
  gdk_pixbuf_unref (background);  
}

/* ******************************************************* End of draw.c *** */
