/* *********************************************************** browser.c *** *
 * ץ
 *
 * Copyright (C) 1998-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <03/03/15 00:30:49 sugaya>
 * ************************************************************************* */
#include <dirent.h>
#include "teoeyes.h"
#include "image_io.h"
#include "message.h"
#include "open.h"

#include "gnome-image-list.h"
#include "gtkdirtreeview.h"
#include "gtkiconitemfactory.h"

#define	DIR_TREE_WIDTH		180
#define	DIR_TREE_HEIGHT		400
#define	LIST_WINDOW_WIDTH	620
#define	LIST_WINDOW_HEIGHT	400
#define	PROGRESSBAR_WIDTH	100

enum {
  COLUMN_TERMINATOR = -1,
  COLUMN_FILENAME,
  COLUMN_FILESIZE,
  COLUMN_IMAGESIZE,
  COLUMN_UPDATETIME,
  N_COLUMN
};

enum {
  IXP_VIEW_MODE_ICON,
  IXP_VIEW_MODE_DETAIL
};

/* ************************************************************************* */
static void	  ixp_destroy			(GtkWidget	*widget,
						 gpointer	data);
static void	  ixp_close 			(GtkWidget	*widget,
						 gpointer	data);
static void	  ixp_reload 			(GtkWidget	*widget,
						 gpointer	data);
static void	  ixp_clean 			(GtkWidget	*widget,
						 gpointer	data);
static void	  ixp_switch_view_mode 		(GtkWidget	*widget,
						 gpointer	data);
static void	  ixp_show_hidden	 	(GtkWidget	*widget,
						 gpointer	data);
static void	  ixp_go_home 			(GtkWidget	*widget,
						 gpointer	data);
static gboolean	  ixp_tree_select 		(GtkWidget	*widget,
						 GdkEventButton	*event,
						 gpointer	data);
static gboolean	  ixp_combo_set_dir 		(GtkWidget	*widget,
						 GdkEventKey	*key,
						 gpointer	data);
static void	  ixp_combo_changed		(GtkWidget	*widget,
						 GtkWidget	*child,
						 gpointer	data);

static gint	  compare_by_spell 		(gconstpointer	data1,
						 gconstpointer	data2);
static GList*	  ls_image 			(const gchar	*dir);
static gchar*	  ixp_create_icon 		(const gchar	*filename);
static void	  ixp_add_icon 			(GnomeImageList	*gil,
						 const gchar	*filename,
						 const gchar	*label);
static void	  ixp_combo_set_popdown_item 	(TEBrowser	*ixp,
						 GtkCombo	*combo,
						 GList	*item);
static void	  ixp_file_list_add 		(GtkListStore	*store,
						 const gchar	*filename,
						 const gchar	*label);
static gboolean	  ixp_file_list_button_press 	(GtkWidget	*widget,
						 GdkEvent	*event,
						 gpointer	data);

static GtkWidget* ixp_component_menu_new	(TEBrowser	*ixp);
static GtkWidget* ixp_component_toolbar_new 	(TEBrowser	*ixp);
static GtkWidget* ixp_component_combo_new 	(TEBrowser	*ixp);
static GtkWidget* ixp_component_file_list_new 	(TEBrowser	*ixp);

#include "browser_menu.h"

static gboolean	  combo_callback_flag = TRUE;

/* ************************************************************************* *
 * ץ Хåؿ
 * ************************************************************************* */

/* ************************************************************************* *
 * GtkWindowΥХåؿ
 *
 * ixp_destroy
 * ************************************************************************* */

/* ץΥ ******************************************** */
static void
ixp_destroy (GtkWidget	*widget,
	     gpointer	data) {
  gtk_widget_hide (widget);
}

/* ************************************************************************* *
 * ˥塼ȥġС˶̤ΥХåؿ
 *
 * ixp_close
 * ixp_reload
 * ixp_clean
 * ixp_switch_view_mode
 * ************************************************************************* */

/* ץΥ ******************************************** */
static void
ixp_close (GtkWidget	*widget,
	   gpointer	data) {
  gtk_widget_hide (explorer->window);
}

/* ************************************************************************* */
static void
ixp_reload (GtkWidget	*widget,
	    gpointer	data) {
  ixp_scan_dir (explorer,
		gtk_dir_tree_view_get_selected_path (GTK_DIR_TREE_VIEW
						     (explorer->dir_tree)));
}

/* ƥݥեκ ************************************************ */
static void
ixp_clean (GtkWidget	*widget,
	   gpointer	data) {
  gchar	*icon_dir;
  gchar	*msg;

  icon_dir = tc->thumbnail_dir;
  msg = g_strconcat (_("Are you sure you want to remove"), " ",
		     icon_dir, NULL);
  if (confirm_box_show (image_window, _("Confirm"), msg) == FALSE) {
    g_free (msg);
    return;
  }
  g_dir_remove (icon_dir);
  g_free (msg);
}

/* ɽ⡼ɤؤ ****************************************************** */
static void
ixp_switch_view_mode (GtkWidget	*widget,
		      gpointer	data) {
  gint	mode = (gint) data;

  switch (mode) {
  case IXP_VIEW_MODE_ICON:
    if (!GTK_WIDGET_VISIBLE (explorer->icon_window)) {
      gtk_widget_hide (explorer->file_window);            
      gtk_widget_show_all (explorer->icon_window);
    }
    break;
  case IXP_VIEW_MODE_DETAIL:
    if (!GTK_WIDGET_VISIBLE (explorer->file_window)) {
      gtk_widget_hide (explorer->icon_window);            
      gtk_widget_show_all (explorer->file_window);
    }
    break;
  }
}

/* ************************************************************************* *
 * ˥塼ΥХåؿ
 *
 * ixp_show_hidden
 * ************************************************************************* */

/* ǥ쥯ȥɽ/ɽ ******************************************* */
static void
ixp_show_hidden (GtkWidget	*widget,
		 gpointer	data) {
  gboolean	show_hidden;

  show_hidden =
    gtk_dir_tree_view_get_show_hidden (GTK_DIR_TREE_VIEW (explorer->dir_tree));
  gtk_dir_tree_view_set_show_hidden (GTK_DIR_TREE_VIEW
				     (explorer->dir_tree), !show_hidden);
  gtk_dir_tree_view_refresh_tree (GTK_DIR_TREE_VIEW (explorer->dir_tree));
}

/* ************************************************************************* *
 * ġСΥХåؿ
 *
 * ixp_go_home
 * ************************************************************************* */

/* ۡǥ쥯ȥذư ************************************************ */
static void
ixp_go_home (GtkWidget	*widget,
	     gpointer	data) {
  TEBrowser	*ixp;
  const gchar	*home;

  ixp  = (TEBrowser *) data;
  home = g_get_home_dir ();

  gtk_dir_tree_view_set_dir (GTK_DIR_TREE_VIEW (ixp->dir_tree), home);
  ixp_scan_dir (ixp, home);
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (ixp->dir_combo)->entry), home);
  ixp_combo_list_add (ixp, ixp->dir_combo, home);
}

/* ************************************************************************* *
 * ǥ쥯ȥĥ꡼˴ؤ륳Хåؿ
 *
 * ixp_tree_select
 * ************************************************************************* */

/* ǥ쥯ȥĥ꡼ǥǥ쥯ȥ꤬򤵤줿Ȥν ****************** */
static gboolean
ixp_tree_select (GtkWidget	*widget,
		 GdkEventButton	*event,
		 gpointer	data) {
  TEBrowser	*ixp;
  GtkWidget	*entry;
  gchar		*path, *utf8_path;

  ixp   = (TEBrowser *) data;
  
  path = gtk_dir_tree_view_get_selected_path (GTK_DIR_TREE_VIEW (widget));
  if (!path || (path && strcmp (path, ixp->selected_dir) == 0)) return FALSE;

  entry = GTK_COMBO (ixp->dir_combo)->entry;
  ixp_scan_dir (ixp, path);
  utf8_path = g_locale_to_utf8 (path, -1, NULL, NULL, NULL);
  gtk_entry_set_text (GTK_ENTRY (entry), utf8_path);
  ixp_combo_list_add (ixp, ixp->dir_combo, utf8_path);

  g_free (utf8_path);

  return FALSE;
}

/* ************************************************************************* *
 * ܥåȤ˴ؤ륳Хåؿ
 *
 * ixp_combo_set_dir
 * ixp_combo_changed
 * ************************************************************************* */

/* ************************************************************************* */
static gboolean
ixp_combo_set_dir (GtkWidget	*widget,
		   GdkEventKey	*key,
		   gpointer	data) {
  TEBrowser	*ixp;
  gchar		*dir;

  if (key->keyval != GDK_Return && key->keyval != GDK_KP_Enter) return FALSE;

  ixp = (TEBrowser *) data;
  dir = g_strdup (gtk_entry_get_text (GTK_ENTRY (widget)));

  if (dir && g_dir_is (dir)) {
    if (dir[strlen (dir)-1] != '/') {
      dir = (gchar *) g_realloc (dir, sizeof (gchar) * (strlen (dir) + 2));
      sprintf (dir, "%s%s", dir, G_DIR_SEPARATOR_S);
    }
    gtk_dir_tree_view_set_dir (GTK_DIR_TREE_VIEW (ixp->dir_tree), dir);
    ixp_scan_dir (ixp, dir);
    ixp_combo_list_add (ixp, ixp->dir_combo, dir);
    
    g_free (dir);
  }
  return FALSE;
}

/* ************************************************************************* */
static void
ixp_combo_changed (GtkWidget	*widget,
		   GtkWidget	*child,
		   gpointer	data) {
  TEBrowser	*ixp;
  GtkCombo	*combo;
  gchar		*dir;

  ixp   = (TEBrowser *) data;
  combo = GTK_COMBO (ixp->dir_combo);
  dir   = g_locale_from_utf8 (gtk_entry_get_text (GTK_ENTRY (combo->entry)),
			      -1, NULL, NULL, NULL);
  
  if (dir && strcmp (dir, ixp->selected_dir) != 0) {
    gtk_signal_handler_block (GTK_OBJECT (combo->list), combo->list_change_id);
    if (combo_callback_flag) {
      gtk_dir_tree_view_set_dir (GTK_DIR_TREE_VIEW (ixp->dir_tree), dir);
      ixp_scan_dir (ixp, dir);
    }
    gtk_signal_handler_unblock(GTK_OBJECT (combo->list),combo->list_change_id);
  }
  g_free (dir);
}

/* ************************************************************************* *
 * ꥹȤ˴ؤ륳Хåؿ
 *
 * ixp_drag_data_get
 * ixp_select_icon
 * ************************************************************************* */

/* ************************************************************************* */
static void
ixp_drag_data_get (GtkWidget		*widget,
		   GdkDragContext	*context,
		   GtkSelectionData	*selection_data,
		   guint		info,
		   guint		time,
		   gpointer		data) {
  GList	*selection = NULL;
  gchar	*url, *filename;
  gchar	*src_ptr, *dst_ptr;
  gchar	header[] = "file:\r\n\0";
  gint	n;

  selection = gnome_image_list_get_selection (GNOME_IMAGE_LIST (widget));
  if (!selection) return;
  filename = (gchar *)
    gnome_image_list_get_icon_data (GNOME_IMAGE_LIST (widget),
				    (gint) selection->data);
  url = g_new (gchar, strlen (filename) + 8);
  src_ptr = filename;
  dst_ptr = url;

  for (n = 0; n < 5; n++) *dst_ptr++ = header[n];
  for (n = 0; n < strlen (filename); n++) *dst_ptr++ = *src_ptr++;
  for (n = 5; n < 8; n++) *dst_ptr++ = header[n];

  gtk_selection_data_set (selection_data, selection_data->target, 8,
			  (gchar *) url, strlen (url) + 1);
  g_free (url);
}

/* ************************************************************************* */
static void
ixp_select_icon (GtkWidget	*widget,
		 gint		num,
		 GdkEventButton	*event) {
  gchar	*filename;
  
  if (event->type == GDK_2BUTTON_PRESS) {
    filename = (gchar *) 
      gnome_image_list_get_icon_data (GNOME_IMAGE_LIST (widget), num);
    if (event->state == 4) {
      teoeyes_open_image_on_new_window (filename);
    } else {
      teoeyes_open_image_on_same_window (filename);
    }
  }
}

/* ************************************************************************* *
 * ؿ
 *
 * compare_by_spell
 * ls_image
 * ixp_create_icon
 * ixp_add_icon
 * ixp_scan_dir
 * ixp_combo_list_add
 * ixp_combo_set_popdown_item
 * ixp_file_list_add
 * ************************************************************************* */

/* ̾ǥ ************************************************************ */
static gint
compare_by_spell (gconstpointer	data1,
		  gconstpointer	data2) {
  const gchar	*str1 = data1;
  const gchar	*str2 = data2;

  return strcmp (str1, str2);
}

/* ǥ쥯ȥβꥹȤ **************************************** */
static GList*
ls_image (const gchar	*dir) {
  DIR		*dp;
  struct dirent	*entry;
  GList		*files = NULL;
  gchar		*path;
  
  g_return_val_if_fail (dir && *dir, NULL);

  if (!(dp = opendir (dir))) return NULL;

  while ((entry = readdir (dp))) {
    if (g_dir_is_current_dir (entry->d_name) || 
	g_dir_is_parent_dir  (entry->d_name)) continue;
    path = g_build_filename (dir, entry->d_name, NULL);
#if 0
    if (g_dir_is (path)) {
      g_free (path);
      continue;
    }
    if (check_image_supported (path)) {
      files = g_list_append (files, g_strdup (entry->d_name));
    }
#else
    if (path && !g_dir_is (path) && check_image_supported (path)) {
      files = g_list_append (files, g_strdup (entry->d_name));
    }
#endif
    g_free (path);
  }
  closedir (dp);

  if (files) files = g_list_sort (files, compare_by_spell);
  
  return files;
}

/* ͥκ **************************************************** */
static gchar*
ixp_create_icon (const gchar	*filename) {
  TEImage	*ti;
  GdkPixbuf	*pbuf1, *pbuf2;
  gint		w, h, row, col;
  gchar		*png_name, *icon_name, *dir;
  gchar		*ptr, *ext, *src_data, *dst_data, *src_ptr, *dst_ptr;
  guint64	data1, data2;

  
  ptr = png_name = g_strdup (filename);
  ext = strrchr (png_name, '.');

  while (ptr < ext) *ptr++;
  *ptr++ = '.';
  *ptr++ = 'p';
  *ptr++ = 'n';
  *ptr++ = 'g';
  *ptr++ = '\0';

  icon_name = g_build_filename (tc->thumbnail_dir, png_name, NULL);
  g_free (png_name);

  if (g_file_exist (icon_name)) {
    data1 = g_file_get_moddate (filename);
    data2 = g_file_get_moddate (icon_name);
    if (data1 < data2) {
      pbuf1 = gdk_pixbuf_new_from_file (icon_name, NULL);
      if (gdk_pixbuf_get_width  (pbuf1) == tc->thumbnail_width ||
	  gdk_pixbuf_get_height (pbuf1) == tc->thumbnail_height) {
	gdk_pixbuf_unref (pbuf1);
	return icon_name;
      } else {
	gdk_pixbuf_unref (pbuf1);
      }
    }
  }
  ti 			 = g_new (TEImage, 1);
  ti->filename 		 = (gchar *) filename;
  ti->frame    		 = 0;
  ti->min      		 = -1;
  ti->max      		 = -1;
  ti->user_data1 	 = (gpointer) 1;
  ti->fp	 	 = NULL;
  ti->original_data_list = NULL;
  ti->pixbuf_list	 = NULL;
  pbuf1 		 = teoeyes_image_open (ti);
  g_free (ti);
  
  if (!pbuf1) {
    g_free (icon_name);
    return NULL;
  }
  w = gdk_pixbuf_get_width  (pbuf1);
  h = gdk_pixbuf_get_height (pbuf1);
  if (w > tc->thumbnail_width || h > tc->thumbnail_height) {
    h = (tc->thumbnail_width * h) / w;
    w = tc->thumbnail_width;
    if (h == 0) h = 2;
    if (h > tc->thumbnail_height) {
      w = (tc->thumbnail_height * gdk_pixbuf_get_width (pbuf1))
	/ gdk_pixbuf_get_height (pbuf1);
      h = tc->thumbnail_height;
      if (w == 0) w = 2;
    }
  }
  src_data = g_new (gchar, w * h * 3);
  if (!src_data) {
    gdk_pixbuf_unref (pbuf1);    
    g_free (icon_name);
    return NULL;
  }
  pbuf2 = gdk_pixbuf_new_from_data (src_data, GDK_COLORSPACE_RGB, FALSE, 8,
				    w, h, w * 3, gdk_pixbuf_free_buffer, NULL);
  if (!pbuf2) {
    gdk_pixbuf_unref (pbuf1);    
    g_free (icon_name);
    return NULL;
  }
  gdk_pixbuf_composite_color (pbuf1, pbuf2,
			      0, 0, w, h, 0, 0,
			      (double) w / gdk_pixbuf_get_width (pbuf1),
			      (double) h / gdk_pixbuf_get_height(pbuf1),
			      GDK_INTERP_TILES,
			      255, 0, 0, 16, 0xaaaaaa, 0x555555);
  gdk_pixbuf_unref (pbuf1);

  dst_data = g_new (gchar, tc->thumbnail_width * tc->thumbnail_height * 3);
  if (!dst_data) {
    gdk_pixbuf_unref (pbuf2);    
    g_free (icon_name);
    return NULL;
  }
  src_ptr = gdk_pixbuf_get_pixels (pbuf2);
  dst_ptr = dst_data;

  for (row = 0; row < tc->thumbnail_height; row++) {
    for (col = 0; col < tc->thumbnail_width; col++) {
      if (row >= (tc->thumbnail_height / 2 - gdk_pixbuf_get_height (pbuf2) / 2)
	  &&
	  row < (tc->thumbnail_height / 2 - gdk_pixbuf_get_height (pbuf2) / 2
		 + gdk_pixbuf_get_height (pbuf2)) &&
	  col >= (tc->thumbnail_width / 2 - gdk_pixbuf_get_width (pbuf2) / 2)
	  &&
	  col < (tc->thumbnail_width / 2 - gdk_pixbuf_get_width (pbuf2) / 2
		 + gdk_pixbuf_get_width (pbuf2))) {
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;
      } else {
	*dst_ptr++ = 255;
	*dst_ptr++ = 255;
	*dst_ptr++ = 255;
      }
    }
  }
  pbuf1 = gdk_pixbuf_new_from_data (dst_data, GDK_COLORSPACE_RGB, FALSE, 8,
				    tc->thumbnail_width,
				    tc->thumbnail_height,
				    tc->thumbnail_width * 3,
				    gdk_pixbuf_free_buffer, NULL);
  if (!pbuf1) {
    gdk_pixbuf_unref (pbuf2);
    g_free (icon_name);
    g_free (dst_data);
    return NULL;
  }
  ext = strrchr (icon_name, '/');
  if (ext) {
    dir = g_new (gchar, 
		 strlen (icon_name) - strlen (ext) + 1);
    src_ptr = icon_name;
    dst_ptr = dir;
    while (src_ptr < ext) *dst_ptr++ = *src_ptr++;
    *dst_ptr = '\0';
    if (!g_file_exist (dir)) g_dir_mkdirs (dir);
    g_free (dir);
  }
  gdk_pixbuf_save (pbuf1, icon_name, "jpeg", NULL, NULL);
  
  gdk_pixbuf_unref (pbuf1);
  gdk_pixbuf_unref (pbuf2);
  
  return icon_name;
}

/* ͥɲ **************************************************** */
static void
ixp_add_icon (GnomeImageList	*gil,
	      const gchar	*filename,
	      const gchar	*label) {
  gchar			*icon_name = NULL;
  gchar			*utf8_label;	
  gint			n;
  
  icon_name = ixp_create_icon (filename);
  if (icon_name) {
    utf8_label = g_locale_to_utf8 (label, -1, NULL, NULL, NULL);
    n = gnome_image_list_append (gil, icon_name, utf8_label);
    gnome_image_list_set_icon_data (gil, n, (gpointer) g_strdup (filename));
    g_free (utf8_label);
    g_free (icon_name);
  }
}

/* ͥ ************************************************ */
void
ixp_scan_dir (TEBrowser		*ixp,
	      const gchar	*dir) {
  GtkListStore	*store;  
  GList		*ilist = NULL;
  GList		*list;
  gchar		*label, *path, *file;
  int		n, inums;

  if (ixp->selected_dir) g_free (ixp->selected_dir);
  ixp->selected_dir = g_strdup (dir);
  
  gnome_image_list_freeze (GNOME_IMAGE_LIST (ixp->iconlist));
  gnome_image_list_clear  (GNOME_IMAGE_LIST (ixp->iconlist));

  store = GTK_LIST_STORE (gtk_tree_view_get_model
			  (GTK_TREE_VIEW (ixp->filelist)));
  gtk_list_store_clear (store);  
  
  ilist = ls_image (dir);

  if (ilist) {
    n     = 1;
    inums = g_list_length (ilist);
    list  = ilist;

    while (list) {
      file = g_locale_to_utf8 ((gchar *) list->data, -1, NULL, NULL, NULL); 
      label = g_new (gchar,
		     strlen (_("Now Loading")) + file + 2);
      sprintf (label, "%s %s", _("Now Loading"), file);
      gtk_label_set (GTK_LABEL (ixp->state_label), label);

      gtk_progress_bar_update (GTK_PROGRESS_BAR (ixp->progressbar),
			       (1.0 * n) / inums);
      while (gtk_events_pending ()) gtk_main_iteration ();
      path = g_strconcat (dir, G_DIR_SEPARATOR_S, (gchar *) list->data, NULL);
      ixp_add_icon (GNOME_IMAGE_LIST (ixp->iconlist),
		    path, (gchar *) list->data);
      ixp_file_list_add (store, path, (gchar *) list->data);
      g_free (file);
      g_free (label);
      g_free (path);
      list = list->next;
      n++;
    }
    gtk_progress_bar_update (GTK_PROGRESS_BAR (ixp->progressbar), 0.0);
    while (gtk_events_pending ()) gtk_main_iteration ();
    gtk_label_set (GTK_LABEL (ixp->state_label), "");
    g_list_foreach (ilist, (GFunc) g_free, NULL); 
  }
  gnome_image_list_thaw (GNOME_IMAGE_LIST (ixp->iconlist));  
}

/* ܥåȤ˿ǥ쥯ȥ̾ɲ ************************** */
void
ixp_combo_list_add (TEBrowser	*ixp,
		    GtkWidget	*combo,
		    const gchar	*dir) {
  GList		*list;
  gboolean	flg = TRUE;

  list = g_list_first (ixp->combo_list);
  while (list) {
    if (strcmp (dir, (gchar *) list->data) == 0) {
      flg = FALSE;
      break;
    }
    list = g_list_next (list);
  }
  if (flg) {
    combo_callback_flag = FALSE;
    ixp->combo_list = g_list_prepend (ixp->combo_list, g_strdup (dir));
    if (g_list_length (g_list_first (ixp->combo_list)) > COMBO_LIST_MAX) {
      ixp->combo_list = g_list_remove (ixp->combo_list,
				       g_list_last (ixp->combo_list)->data);
    }
    ixp_combo_set_popdown_item (ixp, GTK_COMBO (combo), ixp->combo_list);
    combo_callback_flag = TRUE;    
  }
}

/* ܥåȤ˿ǥ쥯ȥ̾ɲ ************************** */
static void
ixp_combo_set_popdown_item (TEBrowser	*ixp,
			    GtkCombo	*combo,
			    GList	*item) {
  GList		*list;
  GtkWidget	*li;

  gtk_list_clear_items (GTK_LIST (combo->list), 0, -1);
  list = item;
  while (list) {
    li = gtk_list_item_new_with_label ((gchar *) list->data);
    gtk_widget_show (li);
    gtk_container_add (GTK_CONTAINER (combo->list), li);
    list = g_list_next (list);
  }
}

/* ************************************************************************* */
static void
ixp_file_list_add (GtkListStore	*store,
		   const gchar	*filename,
		   const gchar	*label) {
  TEImage	*ti;
  GdkPixbuf	*pbuf;
  GtkTreeIter	iter;
  gchar		isize[1049];

  ti 			 = g_new (TEImage, 1);
  ti->filename 	    	 = (gchar *) filename;
  ti->frame    	    	 = 0;
  ti->min      	    	 = -1,
  ti->max      	    	 = -1;
  ti->user_data1    	 = (gpointer) 1;
  ti->fp       	    	 = NULL;
  ti->original_data_list = NULL;
  ti->pixbuf_list   	 = NULL;
  pbuf 			 = teoeyes_image_open (ti);
  g_free (ti);

  if (pbuf) {
    sprintf (isize, "%dx%d",
	     gdk_pixbuf_get_width (pbuf), gdk_pixbuf_get_height (pbuf));
  
    gtk_list_store_append (store, &iter);
    gtk_list_store_set (store, &iter,
			COLUMN_FILENAME,  g_locale_to_utf8 (label, -1,
							    NULL, NULL, NULL),
			COLUMN_FILESIZE,  g_file_get_size_string (filename),
			COLUMN_IMAGESIZE, g_strdup (isize),
			COLUMN_UPDATETIME,g_file_get_moddate_string (filename),
			COLUMN_TERMINATOR);
    gdk_pixbuf_unref (pbuf);
  }
}

/* ************************************************************************* */
static gboolean
ixp_file_list_button_press (GtkWidget	*widget,
			    GdkEvent	*event,
			    gpointer	data) {
  GtkTreeView		*treeview = GTK_TREE_VIEW (widget);
  GtkTreeSelection	*selection;
  GtkTreeModel		*model;
  GtkTreeIter		iter;
  gint			success;
  gchar			*path, *filename, *path_utf8;
  
  if (event->type == GDK_2BUTTON_PRESS) {
    selection = gtk_tree_view_get_selection (treeview);
    if (!selection) return FALSE;
    success = gtk_tree_selection_get_selected (selection, &model, &iter);
    if (success) {
      gtk_tree_model_get (model, &iter, 0, &filename, -1);
      path_utf8 = g_build_filename (((TEBrowser *) data)->selected_dir, 
			       filename, NULL);
      path = g_locale_from_utf8 (path_utf8, -1, NULL, NULL, NULL); 
      teoeyes_open_image_on_same_window (path);
      g_free (path);
      g_free (path_utf8);
      g_free (filename);
    }
  }
  return FALSE;
}

/* ************************************************************************* *
 * ץؿ
 *
 * ixp_component_menu_new
 * ixp_component_toolbar_new
 * ixp_component_combo_new
 * ixp_component_file_list_new 
 * ixp_new
 * ************************************************************************* */

/* ˥塼С ****************************************************** */
static GtkWidget*
ixp_component_menu_new (TEBrowser	*ixp) {
  GtkIconItemFactory	*item_factory;
  GtkAccelGroup		*accel_group;
  GtkWidget		*handlebox;
  GtkWidget		*frame;
  GtkWidget		*menubar;
  gint			nmenu_items;

  /* ϥɥܥå */
  handlebox = gtk_handle_box_new ();
  {
    /* ե졼 */
    frame = gtk_frame_new (NULL);
    gtk_container_add (GTK_CONTAINER (handlebox), frame);
    G_SET_WIDGET (ixp->window, "menu:frame", frame);

    /* ˥塼 */
    nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);    
    accel_group = gtk_accel_group_new ();
    item_factory
      = gtk_icon_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", accel_group);
    gtk_window_add_accel_group (GTK_WINDOW (ixp->window), accel_group);
    
    gtk_icon_item_factory_set_translate_func 
      (item_factory, (GtkTranslateFunc) gettext, NULL, NULL);
    gtk_icon_item_factory_create_items (item_factory,
					nmenu_items, menu_items, NULL);
    menubar = gtk_icon_item_factory_get_widget (item_factory, "<main>");
    gtk_container_add (GTK_CONTAINER (frame), menubar);
    G_SET_WIDGET (ixp->window, "menu:menubar", menubar);
  }
  return handlebox;
}

/* ġС ******************************************************** */
static GtkWidget*
ixp_component_toolbar_new (TEBrowser	*ixp) {
  GtkWidget	*handlebox;
  GtkWidget	*toolbar;
  GtkWidget	*icon;
  GdkPixbuf	*pixbuf;

  /* ϥɥܥå */
  handlebox = gtk_handle_box_new ();
  {
    /* ġС */
    toolbar = gtk_toolbar_new ();
    gtk_container_add (GTK_CONTAINER (handlebox), toolbar);
    G_SET_WIDGET (ixp->window, "toolbar:toolbar", toolbar);
    {
      /* TeoEyesεưܥ */
      pixbuf = gdk_pixbuf_new_from_inline (-1, stock_new, FALSE, NULL);      
      icon = gtk_image_new_from_pixbuf (pixbuf);
      gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				  GTK_TOOLBAR_CHILD_BUTTON,
				  NULL,
				  _("New"), 
				  _("Run TeoEyes"),
				  _("Run TeoEyes"),
				  icon,
				  G_CALLBACK (cb_new),
				  NULL);
      G_SET_WIDGET (ixp->window, "toolbar:icon1", icon);
      gdk_pixbuf_unref (pixbuf);

      /* ֳץܥ */
      pixbuf = gdk_pixbuf_new_from_inline (-1, stock_open, FALSE, NULL);
      icon = gtk_image_new_from_pixbuf (pixbuf);
      gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				  GTK_TOOLBAR_CHILD_BUTTON,
				  NULL,
				  _("Open"), 
				  _("Open a new file"),
				  _("Open a new file"),
				  icon,
				  G_CALLBACK (cb_open),
				  NULL);
      G_SET_WIDGET (ixp->window, "toolbar:icon2", icon);
      gdk_pixbuf_unref (pixbuf);
#if 0
      /* ¸ץܥ */
      pixbuf = gdk_pixbuf_new_from_inline (-1, stock_save, FALSE, NULL);      
      icon = gtk_image_new_from_pixbuf (pixbuf);
      gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				  GTK_TOOLBAR_CHILD_BUTTON,
				  NULL,				  
				  _("Save"), 
				  _("Save to the original file"),
				  _("Save to the original file"),
				  icon,
				  NULL,
				  NULL);
      /* ̾¸ץܥ */
      pixbuf = gdk_pixbuf_new_from_inline (-1, stock_save_as, FALSE, NULL);
      icon = gtk_image_new_from_pixbuf (pixbuf);
      gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				  GTK_TOOLBAR_CHILD_BUTTON,
				  NULL,
				  _("SaveAs"),
				  _("Save to a new file"),
				  _("Save to a new file"),
				  icon,
				  NULL,
				  NULL);
#endif
      /* ѥ졼 */
      gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

      /* ֥饦Ĥܥ */
      pixbuf = gdk_pixbuf_new_from_inline (-1, stock_close, FALSE, NULL);
      icon = gtk_image_new_from_pixbuf (pixbuf);
      gtk_widget_set_usize (icon, 48, -1);
      gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				  GTK_TOOLBAR_CHILD_BUTTON,
				  NULL,
				  _("Close"),
				  _("Close the Image Explorer"),
				  _("Close the Image Explorer"),
				  icon,
				  G_CALLBACK (ixp_close),
				  ixp->window);
      G_SET_WIDGET (ixp->window, "toolbar:icon3", icon);
      gdk_pixbuf_unref (pixbuf);

      /* ֽλץܥ */
      pixbuf = gdk_pixbuf_new_from_inline (-1, stock_quit, FALSE, NULL);      
      icon = gtk_image_new_from_pixbuf (pixbuf);
      gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				  GTK_TOOLBAR_CHILD_BUTTON,
				  NULL,				  
				  _("Exit"), 
				  _("Exit TeoEyes"),
				  _("Exit TeoEyes"),
				  icon,
				  G_CALLBACK (cb_quit),
				  NULL);
      G_SET_WIDGET (ixp->window, "toolbar:icon4", icon);
      gdk_pixbuf_unref (pixbuf);

      /* ѥ졼 */
      gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

      /* ۡذưܥ */
      pixbuf = gdk_pixbuf_new_from_inline (-1, stock_home, FALSE, NULL);
      icon = gtk_image_new_from_pixbuf (pixbuf);
      gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				  GTK_TOOLBAR_CHILD_BUTTON,
				  NULL,				  
				  _("Home"), 
				  _("Go to home folder"),
				  _("Go to home folder"),
				  icon,
				  G_CALLBACK (ixp_go_home),
				  ixp);
      G_SET_WIDGET (ixp->window, "toolbar:icon5", icon);
      gdk_pixbuf_unref (pixbuf);

      /* ѥ졼 */
      gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
      
      /* ץܥ */
      pixbuf = gdk_pixbuf_new_from_inline (-1, stock_prof, FALSE, NULL);
      icon = gtk_image_new_from_pixbuf (pixbuf);
      gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				  GTK_TOOLBAR_CHILD_BUTTON,
				  NULL,
				  _("Property"), 
				  _("Configure TeoEyes property"),
				  _("Configure TeoEyes property"),
				  icon,
				  G_CALLBACK (cb_show_config),
				  NULL);
      G_SET_WIDGET (ixp->window, "toolbar:icon6", icon);
      gdk_pixbuf_unref (pixbuf);

      /* ѥ졼 */
      gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

      /* ǥ쥯ȥΥ */
      pixbuf = gdk_pixbuf_new_from_inline (-1, stock_reload, FALSE, NULL);
      icon = gtk_image_new_from_pixbuf (pixbuf);
      gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				  GTK_TOOLBAR_CHILD_BUTTON,
				  NULL,
				  _("Reload"),
				  _("Reload the current folder"),
				  _("Reload the current folder"),
				  icon,
				  G_CALLBACK (ixp_reload),
				  NULL);
      G_SET_WIDGET (ixp->window, "toolbar:icon7", icon);
      gdk_pixbuf_unref (pixbuf);

      /* ֥꡼ץܥ */
      pixbuf = gdk_pixbuf_new_from_inline (-1, stock_clean, FALSE, NULL);
      icon = gtk_image_new_from_pixbuf (pixbuf);
      gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				  GTK_TOOLBAR_CHILD_BUTTON,
				  NULL,
				  _("Clean"), 
				  _("Clean up the thumbnail files"),
				  _("Clean up the thumbnail files"),
				  icon,
				  G_CALLBACK (ixp_clean),
				  NULL);
      G_SET_WIDGET (ixp->window, "toolbar:icon8", icon);
      gdk_pixbuf_unref (pixbuf);

      /* ѥ졼 */
      gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

      /* ɽڤؤܥ (ɽ) */
      pixbuf = gdk_pixbuf_new_from_inline (-1, stock_iconlist, FALSE, NULL);
      icon = gtk_image_new_from_pixbuf (pixbuf);
      gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				  GTK_TOOLBAR_CHILD_BUTTON,
				  NULL,			       
				  _("IconList"), 
				  _("Switch view to the icon list"),
				  _("Switch view to the icon list"),
				  icon,
				  G_CALLBACK (ixp_switch_view_mode),
				  (gpointer) IXP_VIEW_MODE_ICON);
      G_SET_WIDGET (ixp->window, "toolbar:icon9", icon);
      gdk_pixbuf_unref (pixbuf);

      /* ɽڤؤܥ (ꥹɽ) */
      pixbuf = gdk_pixbuf_new_from_inline (-1, stock_filelist, FALSE, NULL);
      icon = gtk_image_new_from_pixbuf (pixbuf);
      gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				  GTK_TOOLBAR_CHILD_BUTTON,
				  NULL,
				  _("FileList"), 
				  _("Switch view to the file list"),
				  _("Switch view to the file list"),
				  icon,
				  G_CALLBACK (ixp_switch_view_mode),
				  (gpointer) IXP_VIEW_MODE_DETAIL);
      G_SET_WIDGET (ixp->window, "toolbar:icon10", icon);
      gdk_pixbuf_unref (pixbuf);
    }
  }
  return handlebox;
}

/* ܥȥ **************************************************** */
static GtkWidget*
ixp_component_combo_new (TEBrowser	*ixp) {
  GtkWidget	*handlebox;
  GtkWidget	*box;
  GtkWidget	*label;

  /* ϥɥܥå */
  handlebox = gtk_handle_box_new ();
  gtk_container_border_width (GTK_CONTAINER (handlebox), 3);
  {
    /* ʿBOX */
    box = gtk_hbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (handlebox), box);
    G_SET_WIDGET (ixp->window, "combo:box", box);    
    {
      /* ٥ */
      label = gtk_label_new (_("Current Dir:"));
      gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 1);
      G_SET_WIDGET (ixp->window, "combo:label", label);    

      /* ǥ쥯ȥꥳ */
      ixp->dir_combo = gtk_combo_new ();
      gtk_box_pack_start (GTK_BOX (box), ixp->dir_combo, TRUE, TRUE, 1);
      gtk_combo_disable_activate (GTK_COMBO (ixp->dir_combo));
      g_signal_connect (G_OBJECT (GTK_COMBO (ixp->dir_combo)->entry),
			"key_press_event",
			G_CALLBACK (ixp_combo_set_dir), ixp);
      g_signal_connect (G_OBJECT (GTK_COMBO (ixp->dir_combo)->list), 
			"select_child",
			G_CALLBACK (ixp_combo_changed), ixp);
      G_SET_WIDGET    (ixp->window, "combo:combo", ixp->dir_combo);
      G_SET_PARAMETER (ixp->window, "combo_entry", 
		       GTK_COMBO (ixp->dir_combo)->entry);
    }
  }
  return handlebox;
}

/* ************************************************************************* */
static GtkWidget*
ixp_component_file_list_new (TEBrowser	*ixp) {
  GtkWidget		*treeview;
  GtkListStore		*store;
  GtkTreeModel		*model;
  GtkCellRenderer	*renderer;
  GtkTreeViewColumn	*column;
  
  store = gtk_list_store_new (N_COLUMN,
			      G_TYPE_STRING,
			      G_TYPE_STRING,
			      G_TYPE_STRING,
			      G_TYPE_STRING);
  model = GTK_TREE_MODEL (store);
  treeview = gtk_tree_view_new_with_model (model);
  g_signal_connect (G_OBJECT (treeview), "button_press_event",
		    G_CALLBACK (ixp_file_list_button_press), ixp);
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (treeview), TRUE);
  
  /* ե̾ */
  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes (_("FileName"),
						     renderer,
						     "text",
						     COLUMN_FILENAME,
						     NULL);
  gtk_tree_view_column_set_resizable (GTK_TREE_VIEW_COLUMN (column), TRUE);
  gtk_tree_view_column_set_sort_column_id (column, COLUMN_FILENAME);
  gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

  /* ե륵 */
  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes (_("FileSize"),
						     renderer,
						     "text",
						     COLUMN_FILESIZE,
						     NULL);
  gtk_tree_view_column_set_resizable (GTK_TREE_VIEW_COLUMN (column), TRUE);
  gtk_tree_view_column_set_sort_column_id (column, COLUMN_FILESIZE);
  gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

  /*  */
  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes (_("ImageSize"),
						     renderer,
						     "text",
						     COLUMN_IMAGESIZE,
						     NULL);
  gtk_tree_view_column_set_resizable (GTK_TREE_VIEW_COLUMN (column), TRUE);
  gtk_tree_view_column_set_sort_column_id (column, COLUMN_IMAGESIZE);
  gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);
  
  /*  */
  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes (_("UpdateTime"),
						     renderer,
						     "text",
						     COLUMN_UPDATETIME,
						     NULL);
  gtk_tree_view_column_set_resizable (GTK_TREE_VIEW_COLUMN (column), TRUE);
  gtk_tree_view_column_set_sort_column_id (column, COLUMN_UPDATETIME);
  gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);
  
  return treeview;
}

/* ץ ************************************************ */
TEBrowser*
ixp_new (void) {
  TEBrowser	*ixp;
  GtkWidget	*vbox;
  GtkWidget	*hbox;
  GtkWidget	*paned;
  GtkWidget	*scrolled_window;
  GtkWidget	*widget;
  gchar		*folder, *ofolder, *lfolder, *lofolder, *dfolder;

  /* TEBrowser¤Τΰ */ 
  ixp = g_new (TEBrowser, 1);
  ixp->combo_list   = NULL;
  ixp->mode	    = BROWSER_MODE_ICON;
  ixp->sort_type    = BROWSER_SORT_BY_NAME;
  ixp->selected_dir = NULL;
  
  /* ɥ */
  ixp->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_wmclass (GTK_WINDOW (ixp->window),
			  "teoeyes", "Teo Image Viewer");
  gtk_widget_realize (ixp->window);
  gtk_window_set_title (GTK_WINDOW (ixp->window), _("TeoEyes Image Explorer"));
  gtk_container_set_border_width (GTK_CONTAINER (ixp->window), 2);
  gtk_window_set_resizable (GTK_WINDOW (ixp->window), TRUE);
  gtk_window_set_icon (GTK_WINDOW (ixp->window), te_icon);
  gdk_window_set_icon_name (ixp->window->window,
			    _("TeoEyes Image Explorer"));
  g_signal_connect (G_OBJECT (ixp->window), "destroy",
		    G_CALLBACK (ixp_destroy), NULL);
  g_signal_connect (G_OBJECT (ixp->window), "delete_event",
		    G_CALLBACK (ixp_destroy), NULL);

  /* ľѥåܥå */
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (ixp->window), vbox);
  G_SET_WIDGET (ixp->window, "vbox1", vbox);
  {
    /* ˥塼 */
    widget = ixp_component_menu_new (ixp);
    gtk_widget_show_all (widget);
    gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, TRUE, 0);
    G_SET_WIDGET (ixp->window, "menu", widget);

    /* ġС */
    widget = ixp_component_toolbar_new (ixp);
    gtk_widget_show_all (widget);    
    gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 0);
    G_SET_WIDGET (ixp->window, "toolbar", widget);

    /* ǥ쥯ȥꥳܤ */
    widget = ixp_component_combo_new (ixp);
    gtk_widget_show_all (widget);    
    gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 0);
    G_SET_WIDGET (ixp->window, "combo", widget);

    /* ѥ󥦥ɥ */
    paned = gtk_hpaned_new ();
    gtk_widget_show (paned);
    gtk_box_pack_start (GTK_BOX (vbox), paned, TRUE, TRUE, 0);
    G_SET_WIDGET (ixp->window, "paned", paned);
    {
      scrolled_window = gtk_scrolled_window_new (NULL, NULL);
      gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW
					   (scrolled_window),
					   GTK_SHADOW_ETCHED_IN);
      gtk_container_add (GTK_CONTAINER (paned), scrolled_window);
      G_SET_WIDGET (ixp->window, "scrolled_window", scrolled_window);
      {
	/* ǥ쥯ȥĥ꡼ */
	if (tc->folder_icon) {
	  folder   
	    = g_build_filename (tc->folder_icon, "folder.png", NULL);
	  ofolder
	    = g_build_filename (tc->folder_icon, "folder_open.png", NULL);
	  lfolder
	    = g_build_filename (tc->folder_icon, "folder_link.png", NULL);
	  lofolder
	    = g_build_filename (tc->folder_icon, "folder_link_open.png", NULL);
	  dfolder
	    = g_build_filename (tc->folder_icon, "folder_dennied.png", NULL);
	  ixp->dir_tree 
	    = gtk_dir_tree_view_new_from_file (G_DIR_SEPARATOR_S,
					       FALSE,
					       folder, ofolder,
					       lfolder, lofolder, dfolder);
	  g_free (folder);
	  g_free (ofolder);
	  g_free (lfolder);
	  g_free (lofolder);
	  g_free (dfolder);
	} else {
	  ixp->dir_tree = gtk_dir_tree_view_new (G_DIR_SEPARATOR_S, FALSE);
	}
	gtk_dir_tree_view_set_headers_visible (GTK_DIR_TREE_VIEW
					       (ixp->dir_tree), FALSE);
	g_signal_connect (G_OBJECT (ixp->dir_tree), "button_release_event",
			  G_CALLBACK (ixp_tree_select), ixp);
	gtk_widget_set_size_request (ixp->dir_tree,
				     DIR_TREE_WIDTH, DIR_TREE_HEIGHT);
	gtk_container_add (GTK_CONTAINER (scrolled_window), ixp->dir_tree);
	G_SET_WIDGET (ixp->window, "dir_tree", ixp->dir_tree);
      }
      gtk_widget_show_all (scrolled_window);      
      widget = gtk_vbox_new (FALSE, 0);
      gtk_widget_show (widget);            
      gtk_container_add (GTK_CONTAINER (paned), widget);
      G_SET_WIDGET (ixp->window, "vbox2", widget);
      {
	/* ꥹȤǼ륦ɥ */
	ixp->icon_window = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW
					     (ixp->icon_window),
					     GTK_SHADOW_ETCHED_IN);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (ixp->icon_window),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_widget_set_size_request (ixp->icon_window,
				     LIST_WINDOW_WIDTH, LIST_WINDOW_HEIGHT);
	gtk_box_pack_start (GTK_BOX (widget),
			    ixp->icon_window, TRUE, TRUE, 0);
	G_SET_WIDGET (ixp->window, "icon_window", ixp->icon_window);	
	{
	  /* ꥹȤ */
	  ixp->iconlist = gnome_image_list_new (tc->thumbnail_width, NULL,
					       GNOME_IMAGE_LIST_STATIC_TEXT);
	  g_signal_connect (G_OBJECT (ixp->iconlist), "drag_data_get",
			    G_CALLBACK (ixp_drag_data_get), ixp);
	  g_signal_connect (G_OBJECT (ixp->iconlist), "select_icon",
			    G_CALLBACK (ixp_select_icon), NULL);
	  gtk_container_add (GTK_CONTAINER (ixp->icon_window), ixp->iconlist);
	  G_SET_WIDGET (ixp->window, "iconlist", ixp->iconlist);
	}
	/* եꥹȤǼ륦ɥ */
	ixp->file_window = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW
					     (ixp->file_window),
					     GTK_SHADOW_ETCHED_IN);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (ixp->file_window),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_widget_set_size_request (ixp->file_window,
				     LIST_WINDOW_WIDTH, LIST_WINDOW_HEIGHT);
	gtk_box_pack_start (GTK_BOX (widget),
			    ixp->file_window, TRUE, TRUE, 0);
	G_SET_WIDGET (ixp->window, "file_window", ixp->file_window);
	{
	  /* եꥹȤ */
	  ixp->filelist = ixp_component_file_list_new (ixp);
	  gtk_container_add (GTK_CONTAINER (ixp->file_window), ixp->filelist);
	  G_SET_WIDGET (ixp->window, "filelist", ixp->filelist);
	}
      }
    }
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
    G_SET_WIDGET (ixp->window, "hbox1", hbox);
    {
      ixp->progressbar = gtk_progress_bar_new ();
      gtk_widget_set_size_request (ixp->progressbar, PROGRESSBAR_WIDTH, -1);
      gtk_box_pack_start (GTK_BOX (hbox), ixp->progressbar, FALSE, FALSE, 0);
      G_SET_WIDGET (ixp->window, "progressbar", ixp->progressbar);

      widget = gtk_frame_new (NULL);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      gtk_frame_set_shadow_type (GTK_FRAME (widget), GTK_SHADOW_IN);
      G_SET_WIDGET (ixp->window, "frame", widget);
      {
	/* ٥ */
	ixp->state_label = gtk_label_new ("");
	gtk_misc_set_alignment (GTK_MISC (ixp->state_label), 0.0, 0.5);
	gtk_container_add (GTK_CONTAINER (widget), ixp->state_label);
	G_SET_WIDGET (ixp->window, "state_label", ixp->state_label);
      }
    }
    gtk_widget_show_all (hbox);
  }
  return ixp;
}

/* ************************************************************************* */
void
ixp_widget_destroy (TEBrowser	*ixp) {
  gtk_widget_destroy (ixp->window);
  g_list_foreach (g_list_first (ixp->combo_list), (GFunc) g_free, NULL);
  g_free (ixp);
}

/* **************************************************** End of browser.c *** */
