/* ************************************************************ binary.c *** *
 * Teoeyes Plugin Collection (Ͳ)
 *
 * Copyright (C) 2001-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-12-09 12:38:09 sugaya>
 * ************************************************************************* */
#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <gnome.h>
#include "teoeyesplugin.h"

#define	MIN_VAL			0
#define	MAX_VAL			255
#define	STEP_SIZE		1
#define	PAGE_SIZE		5
/* ץ쥹СѤ1ѹƤ */
#define	USE_PROGRESS_BAR	0

/* ************************************************************************* *
   ץ饰ؿ
 * ************************************************************************* */
void
exec_binary (GdkPixbuf	*src,
	     GdkPixbuf	*dst,
	     double	param1,
	     double	param2,
	     double	param3) {
  int		row, col, has_alpha_src, has_alpha_dst;
  guchar	r, g, b, y, val, th;

  has_alpha_src = gdk_pixbuf_get_has_alpha (src);
  has_alpha_dst = gdk_pixbuf_get_has_alpha (dst);
  th	  = (guchar) param1;

  for (row = 0; row < gdk_pixbuf_get_height (src); row++) {
    for (col = 0; col < gdk_pixbuf_get_width (src); col++) {
      r = gdk_pixbuf_get_pixel (src, col, row, 0);
      g = gdk_pixbuf_get_pixel (src, col, row, 1);
      b = gdk_pixbuf_get_pixel (src, col, row, 2);
      y = (guchar) (0.299 * r + 0.587 * g + 0.114 * b);
      val = (y > th) ? 255 : 0;
      gdk_pixbuf_put_pixel (dst, col, row, 0, val);
      gdk_pixbuf_put_pixel (dst, col, row, 1, val);
      gdk_pixbuf_put_pixel (dst, col, row, 2, val);
      if (has_alpha_dst) {
	if (has_alpha_src) {
	  gdk_pixbuf_put_pixel (dst, col, row, 3, val);
	} else {
	  gdk_pixbuf_put_pixel (dst, col, row, 3, 255);
	}
      }
#if USE_PROGRESS_BAR /* ץ쥹СѤ1ѹƤ */
      plugin_progressbar_update ((double) (row - gdk_pixbuf_get_heigth (src))/
				 (gdk_pixbuf_get_height (src)));
#endif
    }
  }
#if USE_PROGRESS_BAR 
  plugin_progressbar_update (0.0);
#endif
}

/* ************************************************************************* *
   ץ饰¹Ѵؿ
 * ************************************************************************* */
void
plugin_binary (GdkPixbuf	*src,
	       GdkPixbuf	*dst) {
  /* ץ饰ɽ */
  plugin_dialog_new (_("Binary Plugin"),	/* ȥ */
		     exec_binary,		/* ץ饰ؿ */
		     src,			/* ϲǡ */
		     dst,			/* ϲǡ */
		     _("Threshold"),			/* ѥ᡼٥ */
		     MIN_VAL,			/* ѥ᡼Ǿ */
		     MAX_VAL,			/* ѥ᡼ */
		     STEP_SIZE,			/* ѥ᡼1 */	
		     PAGE_SIZE,			/* ѥ᡼2 */	
		     NON_USE_PROGRESSBAR,	/* ץ쥹Сλ */
		     ACTION_INTERACTIVE);	/* ץӥ塼̤ιˡ */

  gtk_main ();
}

/* ************************************************************************* *
   ץ饰
 * ************************************************************************* */
PluginInfo plugin_info = {  
  {N_("/Binarize by threshold"),
   NULL,
   0,
   0,
   "<Item>",
   NULL
  },
  N_("Binary Plugin"),
  N_("Yasuyuki Sugaya"),
  "2.0",
  N_("This plugin binarizes the image\n according to the threshold."),
  1,
  plugin_binary
};

/* ***************************************************** End of binary.c *** */
