/* ************************************************************ io-pnm.c *** *
 * PNM⥸塼
 *
 * Copyright (C) 2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <03/03/24 22:48:43 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "image_loader.h"
#include "format_pnm.icon"

/* ************************************************************************* */
static ImageFormatPattern signature[] = {
  {"P1", NULL, 100},
  {"P2", NULL, 100},
  {"P3", NULL, 100},
  {"P4", NULL, 100},
  {"P5", NULL, 100},
  {"P6", NULL, 100},
  {NULL, NULL, 0}
};
static gchar *mime_types[] = {
  "image/x-portable-anymap",
  "image/x-portable-bitmap",
  "image/x-portable-graymap",
  "image/x-portable-pixmap",
  NULL
};
static gchar *extensions[] = {
  "pnm",
  "pbm",
  "pgm",
  "ppm",
  NULL
};

/* ************************************************************************* */
static void
free_buffer (guchar	*pixels,
	     gpointer	data) {
  g_free (pixels);
}

/* ץ졼ĥǡǡǡ ********** */
static GdkPixbuf*
gdk_pixbuf_remove_alpha (const GdkPixbuf	*src) {
  GdkPixbuf	*dst;
  unsigned char	*data, *src_ptr, *dst_ptr;
  int		size, n;

  size = gdk_pixbuf_get_width (src) * gdk_pixbuf_get_height(src) * 3;
  src_ptr = gdk_pixbuf_get_pixels (src);
  dst_ptr = data = (unsigned char *)
    malloc (sizeof (unsigned char) * size);
			
  for (n = size/3; n > 0; n--) {
    *dst_ptr++ = *src_ptr++;
    *dst_ptr++ = *src_ptr++;
    *dst_ptr++ = *src_ptr++;
    src_ptr++;
  }
  dst = gdk_pixbuf_new_from_data (data, GDK_COLORSPACE_RGB, FALSE, 8,
				  gdk_pixbuf_get_width (src),
				  gdk_pixbuf_get_height(src),
				  gdk_pixbuf_get_width (src) * 3,
				  free_buffer, NULL);
  return dst;
}

/* ************************************************************************* */
GdkPixbuf*
load_pnm (const gchar	*filename,
	   gpointer	data) {
  return gdk_pixbuf_new_from_file (filename, NULL);
}

/* ************************************************************************* */
static gboolean
_save_pbm (const gchar	*filename,
	   guchar	*data,
	   gint		width,
	   gint		height) {
  FILE		*fp;
  guchar	*ptr;
  guchar	Y, r, g, b, val; 
  int		n, m, bitshift;

  fp = fopen (filename, "w");
  if (!fp) return FALSE;

  fprintf (fp, "P4\n");
  fprintf (fp, "# Created by teoeyes PNM loader Version 1.0\n");
  fprintf (fp, "\n%d %d\n", width, height);

  ptr = data;
  for (n = 0; n < height; n++) {
    bitshift = 7;
    val	     = 0;
    for (m = 0; m < width; m++) {
      r = *ptr++;
      g = *ptr++;
      b = *ptr++;
      Y = (guchar) (0.299 * r + 0.587 * g + 0.114 * b);
      if (Y > 128) val += 1 << bitshift;
      bitshift--;
      if (bitshift == -1) {
	putc (val, fp);
	bitshift = 7;
	val	 = 0;     
      }
    }
    if (bitshift != 7) putc (val, fp); 
  }
  fclose (fp);

  return TRUE;
}

/* ************************************************************************* */
static gboolean
_save_pgm (const gchar	*filename,
	   guchar	*data,
	   gint		width,
	   gint		height) {
  FILE		*fp;
  guchar	*ptr;
  guchar	Y[1], r, g, b; 
  int		n;

  fp = fopen (filename, "w");
  if (!fp) return FALSE;

  fprintf (fp, "P5\n");
  fprintf (fp, "# Created by teoeyes PNM loader Version 1.0\n");
  fprintf (fp, "%d %d\n255\n", width, height);
  for (ptr = data, n = width * height; n > 0; n--) {
    r = *ptr++;
    g = *ptr++;
    b = *ptr++;
    Y[0] = (guchar) (0.299 * r + 0.587 * g + 0.114 * b); 
    fwrite (Y, sizeof (char), 1, fp);
  }
  fclose (fp);

  return TRUE;
}

/* ************************************************************************* */
static gboolean
_save_ppm (const gchar	*filename,
	   guchar	*data,
	   gint		width,
	   gint		height) {
  FILE	*fp;

  fp = fopen (filename, "w");
  if (!fp) return FALSE;

  fprintf (fp, "P6\n");
  fprintf (fp, "# Created by teoeyes PNM loader Version 1.0\n");
  fprintf (fp, "%d %d\n255\n", width, height);
  fwrite (data, sizeof (char), width * height * 3, fp);

  fclose (fp);

  return TRUE;
}

/* ************************************************************************* */
gboolean
save_pnm (const gchar	*filename,
	   gpointer	data) {
  GdkPixbuf	*src = (GdkPixbuf *) data;
  GdkPixbuf	*dst = NULL;
  gchar		*ext, *pixels;
  gboolean	result;

  /* ץ졼 */
  if (gdk_pixbuf_get_has_alpha (src)) {
    dst = gdk_pixbuf_remove_alpha (src);
    pixels = gdk_pixbuf_get_pixels (dst);
  } else {
    pixels = gdk_pixbuf_get_pixels (src);
  }
  ext = strrchr (filename, '.');
  if (!ext) {
    result = _save_ppm (filename, pixels, 
			gdk_pixbuf_get_width(src), gdk_pixbuf_get_height(src));
  } else {
    if (strcmp (ext, ".pbm") == 0) {
      result 
	= _save_pbm (filename, pixels,
		     gdk_pixbuf_get_width(src), gdk_pixbuf_get_height(src));
    } else if (strcmp (ext, ".pgm") == 0) {
      result 
	= _save_pgm (filename, pixels,
		     gdk_pixbuf_get_width(src), gdk_pixbuf_get_height(src));
    } else {
      result 
	= _save_ppm (filename, pixels,
		     gdk_pixbuf_get_width(src), gdk_pixbuf_get_height(src));
    } 
  }
  if (dst) gdk_pixbuf_unref (dst);

  return result;
}

/* ************************************************************************* */
void
load_info (TeoeyesImageModule	*module) {
  module->info = (ImageFormat *) g_malloc (sizeof (ImageFormat));
  module->info->signature	= signature;
  module->info->name		= "PNM";
  module->info->description	= "The PNM/PBM/PGM/PPM image format family";
  module->info->mime_types	= mime_types;
  module->info->extensions	= extensions;
  module->info->flags		= IMAGE_FORMAT_WRITABLE;
  module->icon = gdk_pixbuf_new_from_inline (-1, format_pnm, FALSE, NULL);
};

/* ************************************************************************* */
TeoeyesImageModule module = {
  "PNM",
  NULL,
  NULL,
  load_pnm,
  save_pnm,
  load_info
};

/* **************************************************** End of io-pnm.c *** */
