﻿<%-----------------------------------------------------------------------------
 * @(#)servletHack.jsp  1.00  2007/09/19
 * ----------------------------------------------------------------------------
 * description : 
 *    サーブレットの中身を表示する。
 * ----------------------------------------------------------------------------
 * Copyright (c) 2007 Tatooine Project. All Rights Reserved.
 *---------------------------------------------------------------------------%>

<%@ page contentType="text/html; charset=utf-8" session="true" %>

<%@ page import="java.util.Enumeration" %>
<%@ page import="java.util.Date" %>
<%@ page import="java.net.URLDecoder" %>
<%@ page import="java.io.BufferedReader" %>
<%@ page import="java.util.regex.Pattern" %>
<%!
	private String sanitize(String string) {
		string = string.replaceAll("&", "&amp;");
		string = string.replaceAll("<", "&lt;");
		string = string.replaceAll(">", "&gt;");
		string = string.replaceAll("\"", "&quot;");
		string = string.replaceAll("'", "&#39;");
		return string;
	}
%>
<% 
	if (request.getCharacterEncoding() == null) {
		request.setCharacterEncoding("utf-8");
	}
%>
<!DOCTYPE html PUBLIC 
		"-//W3C//DTD XHTML 1.0 Strict//EN" 
		"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<meta http-equiv="content-style-type" content="text/css" />
<meta http-equiv="content-script-type" content="text/javascript" />
<meta name="author" content="toru noda" />
<title>Servlet Hack</title>
<style type="text/css">
table {
	margin: 20px;
	width: 500px;
	border: 1px solid #cccccc;
	border-collapse: collapse;
}
th {
	text-align: center;
	color: #000000;
	background-color: #09aa04;
	border: 1px solid #cccccc;
	padding: 5px 10px;
}
td {s
	text-align: left;
	border: 1px solid #cccccc;
	padding: 5px 10px;
	white-space:nowrap;
}
</style>
</head>
<body>
	<h1>Servlet Hack</h1>
	<hr />
	<h2>HttpServletRequest</h2>
	<h3>Request Headers</h3>
	<table>
		<thead>
			<tr>
				<th>name</th>
				<th>value</th>
			</tr>
		</thead>
		<tbody>
		<%
			Enumeration headers = request.getHeaderNames();
			while (headers.hasMoreElements()) {
				String name = (String) headers.nextElement();
		%>
			<tr>
				<td><%= name %></td>
				<td><%= request.getHeader(name) %></td>
			</tr>
		<%
			}
		%>
		</tbody>
	</table>
	<h3>Request Parameters</h3>
	<table>
		<thead>
			<tr>
				<th>name</th>
				<th>value</th>
			</tr>
		</thead>
		<tbody>
		<%
			Enumeration params = request.getParameterNames();
			while (params.hasMoreElements()) {
				String name = (String) params.nextElement();
		%>
			<tr>
				<td><%= name %></td>
				<td><%= sanitize(request.getParameter(name)) %></td>
			</tr>
		<%
			}
		%>
	</tbody>
	</table>
	<h3>Request Attributes</h3>
	<table>
		<thead>
			<tr>
				<th>name</th>
				<th>value</th>
			</tr>
		</thead>
		<tbody>
		<%
			Enumeration attrs = request.getAttributeNames();
			while (attrs.hasMoreElements()) {
				String name = (String) attrs.nextElement();
		%>
			<tr>
				<td><%= name %></td>
				<td><%= request.getAttribute(name) %></td>
			</tr>
		<%
			}
		%>
		</tbody>
	</table>
	<h3>Cookies</h3>
	<table>
		<thead>
			<tr>
				<th>name</th>
				<th>value</th>
				<th>version</th>
				<th>domain</th>
				<th>path</th>
				<th>maxAge</th>
				<th>secure</th>
				<th>comment</th>
			</tr>
		</thead>
		<tbody>
		<%
			Cookie[] cookies = request.getCookies();
			if (cookies != null) {
				for (int i = 0; i < cookies.length; i++) {
					if (cookies[i] != null) {
		%>
			<tr>
				<td><%= cookies[i].getName() %></td>
				<td><%= cookies[i].getValue() %></td>
				<td><%= cookies[i].getVersion() %></td>
				<td><%= cookies[i].getDomain() %></td>
				<td><%= cookies[i].getPath() %></td>
				<td><%= cookies[i].getMaxAge() %></td>
				<td><%= cookies[i].getSecure() %></td>
				<td><%= cookies[i].getComment() %></td>
			</tr>
		<%
					}
				}
			}
		%>
		</tbody>
	</table>
	<h3>Misc</h3>
	<table>
		<thead>
			<tr>
				<th>getter</th>
				<th>value</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>getCharacterEncoding()</td>
				<td><%= request.getCharacterEncoding() %></td>
			</tr>
			<tr>
				<td>getScheme()</td>
				<td><%= request.getScheme() %></td>
			</tr>
			<tr>
				<td>getProtocol()</td>
				<td><%= request.getProtocol() %></td>
			</tr>
			<tr>
				<td>getMethod()</td>
				<td><%= request.getMethod() %></td>
			</tr>
			<tr>
				<td>getServerName()</td>
				<td><%= request.getServerName() %></td>
			</tr>
			<tr>
				<td>getServerPort()</td>
				<td><%= request.getServerPort() %></td>
			</tr>
			<tr>
				<td>getRequestURI()</td>
				<td><%= request.getRequestURI() %></td>
			</tr>
			<tr>
				<td>getRequestURL()</td>
				<td><%= request.getRequestURL() %></td>
			</tr>
			<tr>
				<td>getServletPath()</td>
				<td><%= request.getServletPath() %></td>
			</tr>
			<tr>
				<td>getContextPath()</td>
				<td><%= request.getContextPath() %></td>
			</tr>
			<tr>
				<td>getAuthType()</td>
				<td><%= request.getAuthType() %></td>
			</tr>
			<tr>
				<td>getContentLength()</td>
				<td><%= request.getContentLength() %></td>
			</tr>
			<tr>
				<td>getContentType()</td>
				<td><%= request.getContentType() %></td>
			</tr>
			<tr>
				<td>getRequestedSessionId()</td>
				<td><%= request.getRequestedSessionId() %></td>
			</tr>
			<tr>
				<td>isSecure()</td>
				<td><%= request.isSecure() %></td>
			</tr>
			<tr>
				<td>getPathTranslated()</td>
				<td><%= request.getPathTranslated() %></td>
			</tr>
			<tr>
				<td>getQueryString()</td>
				<td><%= request.getQueryString() %></td>
			</tr>
			<tr>
				<td>getRemoteUser()</td>
				<td><%= request.getRemoteUser() %></td>
			</tr>
			<tr>
				<td>getUserPrincipal()</td>
				<td><%= request.getUserPrincipal() %></td>
			</tr>
			<tr>
				<td>getRemoteAddr()</td>
				<td><%= request.getRemoteAddr() %></td>
			</tr>
			<tr>
				<td>getRemoteHost()</td>
				<td><%= request.getRemoteHost() %></td>
			</tr>
			<tr>
				<td>getRemotePort()</td>
				<td><%= request.getRemotePort() %></td>
			</tr>
			<tr>
				<td>getLocalName()</td>
				<td><%= request.getLocalName() %></td>
			</tr>
			<tr>
				<td>getLocalAddr()</td>
				<td><%= request.getLocalAddr() %></td>
			</tr>
			<tr>
				<td>getLocalPort()</td>
				<td><%= request.getLocalPort() %></td>
			</tr>
			<tr>
				<td>getPathInfo()</td>
				<td><%= request.getPathInfo() %></td>
			</tr>
			<tr>
				<td>isRequestedSessionIdValid()</td>
				<td><%= request.isRequestedSessionIdValid() %></td>
			</tr>
			<tr>
				<td>isRequestedSessionIdFromCookie()</td>
				<td><%= request.isRequestedSessionIdFromCookie() %></td>
			</tr>
			<tr>
				<td>isRequestedSessionIdFromURL()</td>
				<td><%= request.isRequestedSessionIdFromURL() %></td>
			</tr>
			<tr>
				<td>getLocale()</td>
				<td><%= request.getLocale() %></td>
			</tr>
		</tbody>
	</table>
	<hr />
	<h2>HttpSession</h2>
	<h3>Session Attributes</h3>
	<table>
		<thead>
			<tr>
				<th>name</th>
				<th>value</th>
			</tr>
		</thead>
		<tbody>
		<%
			Enumeration sesAttrs = session.getAttributeNames();
			while (sesAttrs.hasMoreElements()) {
				String name = (String) sesAttrs.nextElement();
		%>
			<tr>
				<td><%= name %></td>
				<td><%= request.getAttribute(name) %></td>
			</tr>
		<%
			}
		%>
		</tbody>
	</table>
	<h3>Misc</h3>
	<table>
		<thead>
			<tr>
				<th>getter</th>
				<th>value</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>getId()</td><td><%= session.getId() %></td>
			</tr>
			<tr>
				<td>getCreationTime()</td>
				<td><%= new Date(session.getCreationTime()) %></td>
			</tr>
			<tr>
				<td>getLastAccessedTime()</td>
				<td><%= new Date(session.getLastAccessedTime()) %></td>
			</tr>
			<tr>
				<td>getMaxInactiveInterval()</td>
				<td><%= session.getMaxInactiveInterval() %></td>
			</tr>
			<tr>
				<td>isNew()</td>
				<td><%= session.isNew() %></td>
			</tr>
		</tbody>
	</table>
	<hr />
	<h2>ServletContext</h2>
	<h3>Application Attributes</h3>
	<table>
		<thead>
			<tr>
				<th>name</th>
				<th>value</th>
			</tr>
		</thead>
		<tbody>
		<%
			Enumeration appAttrs = application.getAttributeNames();
			while (appAttrs.hasMoreElements()) {
			
				String name = (String) appAttrs.nextElement();
				out.println("<tr>");
				
				if (name.equals("org.apache.catalina.jsp_classpath")) {
				
					out.println("<td>" + name + "</td>");
					out.println("<td>");
					Pattern p = Pattern.compile("[;]+");
					String[] result = p.split((String) application.getAttribute(name));
					for (int i = 0; i < result.length; i++) {
						out.println(result[i] + "<br />");
					}
					out.println("</td>");
				}
				else if (name.equals("org.apache.catalina.WELCOME_FILES")) {
				
					out.println("<td>" + name + "</td>");
					out.println("<td>");
					String[] welcomeFiles = (String[]) application.getAttribute(name);
					for (int i = 0; i < welcomeFiles.length; i++) {
						out.println(welcomeFiles[i] + "<br />");
					}
					out.println("</td>");
				}
				else {
					out.println("<td>" + name + "</td>");
					out.println("<td>" + application.getAttribute(name) + "</td>");
				}
				out.println("</tr>");
			}
		%>
		</tbody>
	</table>
	<h3>Init Parameters</h3>
	<table>
		<thead>
			<tr>
				<th>name</th>
				<th>value</th>
			</tr>
		</thead>
		<tbody>
		<%
			Enumeration appInitParams = application.getInitParameterNames();
			while (appInitParams.hasMoreElements()) {
				String name = (String) appInitParams.nextElement();
		%>
			<tr>
				<td><%= name %></td>
				<td><%= application.getInitParameter(name) %></td>
			</tr>
		<%
			}
		%>
		</tbody>
	</table>
	<h3>Misc</h3>
	<table>
		<thead>
			<tr>
				<th>getter</th>
				<th>value</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>getMajorVersion()</td>
				<td><%= application.getMajorVersion() %></td>
			</tr>
			<tr>
				<td>getMinorVersion()</td>
				<td><%= application.getMinorVersion() %></td>
			</tr>
			<tr>
				<td>getRealPath("/")</td>
				<td><%= application.getRealPath("/") %></td>
			</tr>
			<tr>
				<td>getServerInfo()</td>
				<td><%= application.getServerInfo() %></td>
			</tr>
			<tr>
				<td>getServletContextName()</td>
				<td><%= application.getServletContextName() %></td>
			</tr>
		</tbody>
	</table>
	<hr />
	<h2>ServletConfig</h2>
	<h3>Init Parameters</h3>
	<table>
		<thead>
			<tr>
				<th>name</th>
				<th>value</th>
			</tr>
		</thead>
		<tbody>
		<%
			Enumeration initParams = config.getInitParameterNames();
			while (initParams.hasMoreElements()) {
				String name = (String) initParams.nextElement();
		%>
			<tr>
				<td><%= name %></td>
				<td><%= config.getInitParameter(name) %></td>
			</tr>
		<%
			}
		%>
		</tbody>
	</table>
	<h3>Misc</h3>
	<table>
		<thead>
			<tr>
				<th>getter</th>
				<th>value</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>getServletName()</td>
				<td><%= config.getServletName() %></td>
			</tr>
		</tbody>
	</table>
	<hr />
	<div align="right">
		<p>Copyright &copy; 2007 Tatooine Project.</p>
	</div>
</body>
</html>
