/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.ui.swing;

import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import net.jankenpoi.i18n.I18n;
import net.jankenpoi.sudokuki.preferences.UserPreferences;
import net.jankenpoi.sudokuki.ui.L10nComponent;
import net.jankenpoi.sudokuki.ui.swing.LocaleListenerImpl;
import net.jankenpoi.sudokuki.ui.swing.StockIcons;
import net.jankenpoi.sudokuki.ui.swing.SwingView;

public class NumbersMenu
extends JMenu
implements L10nComponent {
    private final SwingView view;
    private final JRadioButtonMenuItem itemStandardNumbers = new JRadioButtonMenuItem();
    private final JRadioButtonMenuItem itemChineseNumbers = new JRadioButtonMenuItem();
    private final JRadioButtonMenuItem itemArabicNumbers = new JRadioButtonMenuItem();
    private final Action actionStandardNumbers;
    private final Action actionChineseNumbers;
    private final Action actionArabicNumbers;
    private LocaleListenerImpl localeListener;

    public NumbersMenu(SwingView swingView) {
        this.view = swingView;
        this.actionStandardNumbers = new AbstractAction(I18n.gtxt("Standard"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NumbersMenu.this.setNumbersMode(0);
            }
        };
        this.actionChineseNumbers = new AbstractAction(I18n.gtxt("Chinese"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NumbersMenu.this.setNumbersMode(1);
            }
        };
        this.actionArabicNumbers = new AbstractAction(I18n.gtxt("Arabic"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NumbersMenu.this.setNumbersMode(2);
            }
        };
        this.addItems();
        this.setIcon(StockIcons.ICON_FONT);
        this.setL10nMessages(null, I18n.gtxt("DETECTED_LANGUAGE"));
        this.localeListener = new LocaleListenerImpl(this);
        I18n.addLocaleListener(this.localeListener);
        this.setEnabled(true);
    }

    @Override
    public void setL10nMessages(Locale locale, String string) {
        this.setText(I18n.gtxt("Numbers"));
        this.itemStandardNumbers.setText(I18n.gtxt("Standard"));
        this.itemChineseNumbers.setText(I18n.gtxt("Chinese"));
        this.itemArabicNumbers.setText(I18n.gtxt("Arabic"));
    }

    private void addItems() {
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = UserPreferences.getInstance().getInteger("NumbersMode", 0);
        this.itemStandardNumbers.setAction(this.actionStandardNumbers);
        buttonGroup.add(this.itemStandardNumbers);
        this.itemStandardNumbers.setSelected(n == 0);
        this.add(this.itemStandardNumbers);
        this.itemChineseNumbers.setAction(this.actionChineseNumbers);
        buttonGroup.add(this.itemChineseNumbers);
        this.itemChineseNumbers.setSelected(n == 1);
        this.add(this.itemChineseNumbers);
        this.itemArabicNumbers.setAction(this.actionArabicNumbers);
        buttonGroup.add(this.itemArabicNumbers);
        this.itemArabicNumbers.setSelected(n == 2);
        this.add(this.itemArabicNumbers);
    }

    private void setNumbersMode(int n) {
        UserPreferences.getInstance().set("numbersMode", n);
        this.view.getController().notifyGridChanged();
    }
}

