/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.ui.swing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.jankenpoi.i18n.I18n;

public class NewVersionFoundDialog
extends JDialog {
    private Frame parent;

    public NewVersionFoundDialog(Frame frame) {
        super(frame, true);
        this.parent = frame;
        this.initComponents();
        this.setTitle(I18n.gtxt("Update recommended"));
        this.pack();
    }

    private void initComponents() {
        URI uRI = null;
        try {
            uRI = new URI("http://sourceforge.net/projects/sudokuki/files/sudokuki");
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        JPanel jPanel = this.makeInfoPanel(uRI);
        Dimension dimension = this.parent.getPreferredSize();
        Dimension dimension2 = new Dimension();
        dimension2.setSize(dimension.getHeight() * 1.75, dimension.getWidth() * 1.25);
        this.add(jPanel);
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }

    protected JPanel makeInfoPanel(final URI uRI) {
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel(false);
        String string = "<html><table border=\"0\"><tr></tr><tr>" + I18n.gtxt("A new version of Sudokuki is available!<br/>") + "</tr>" + "<tr>" + I18n.gtxt("Please download and install the latest package<br/>from the following website:<br/>") + "</tr>" + "<tr>" + "</tr>" + "<tr>" + "</tr>" + "</table>" + "</html>";
        JLabel jLabel = new JLabel(string);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(false);
        JButton jButton = new JButton();
        jButton.setText("<HTML><FONT color=\"#000099\"><U>" + I18n.gtxt("Download Sudokuki") + "</U></FONT></HTML>");
        jButton.setHorizontalAlignment(0);
        jButton.setBorderPainted(false);
        jButton.setOpaque(false);
        jButton.setBackground(Color.WHITE);
        jButton.setToolTipText(uRI.toString());
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewVersionFoundDialog.this.open(uRI);
            }
        });
        jButton.setCursor(new Cursor(12));
        jPanel3.add(jButton);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private void open(URI uRI) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(uRI);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

