/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.ui.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import net.jankenpoi.i18n.I18n;
import net.jankenpoi.i18n.LocaleListener;
import net.jankenpoi.sudokuki.ui.L10nComponent;
import net.jankenpoi.sudokuki.ui.swing.LocaleListenerImpl;
import net.jankenpoi.sudokuki.ui.swing.StockIcons;
import net.jankenpoi.sudokuki.ui.swing.ToolBar;

public class LanguageDialog
extends JDialog
implements L10nComponent {
    private HashMap<String, JRadioButton> itemsMap = new HashMap();
    private LocaleListener localeListener;
    private JPanel panel = new JPanel();
    private JPanel btnPanel = new JPanel();
    private JButton okBtn = new JButton(I18n.gtxt("Ok"));
    private final HashMap<String, Icon> icons = new HashMap();

    public LanguageDialog(JFrame jFrame, ToolBar toolBar) {
        super((Frame)jFrame, true);
        this.setTitle(I18n.gtxt("Language"));
        this.initComponents();
        this.setResizable(false);
        this.pack();
        this.panel.requestFocus();
        Point point = toolBar.getLocationOnScreen();
        this.setSize(jFrame.getWidth() * 2 / 3, jFrame.getHeight() * 2 / 3);
        this.setLocation(point.x + toolBar.getWidth() / 2 - this.getWidth() / 2, point.y + toolBar.getHeight());
        this.localeListener = new LocaleListenerImpl(this);
        I18n.addLocaleListener(this.localeListener);
    }

    private void initComponents() {
        Container container = this.getContentPane();
        BoxLayout boxLayout = new BoxLayout(container, 1);
        container.setLayout(boxLayout);
        GridLayout gridLayout = new GridLayout(0, 1);
        this.panel.setLayout(gridLayout);
        this.icons.put("ar", StockIcons.ICON_FLAG_AR);
        this.icons.put("de", StockIcons.ICON_FLAG_DE);
        this.icons.put("el", StockIcons.ICON_FLAG_EL);
        this.icons.put("eo", StockIcons.ICON_FLAG_EO);
        this.icons.put("en", StockIcons.ICON_FLAG_EN);
        this.icons.put("es", StockIcons.ICON_FLAG_ES);
        this.icons.put("fr", StockIcons.ICON_FLAG_FR);
        this.icons.put("hu", StockIcons.ICON_FLAG_HU);
        this.icons.put("ja", StockIcons.ICON_FLAG_JA);
        this.icons.put("lv", StockIcons.ICON_FLAG_LV);
        this.icons.put("nl", StockIcons.ICON_FLAG_NL);
        this.icons.put("pl", StockIcons.ICON_FLAG_PL);
        this.icons.put("pt", StockIcons.ICON_FLAG_PT);
        this.icons.put("pt_BR", StockIcons.ICON_FLAG_BR);
        this.icons.put("ru", StockIcons.ICON_FLAG_RU);
        this.icons.put("ta", StockIcons.ICON_FLAG_TA);
        this.icons.put("tr", StockIcons.ICON_FLAG_TR);
        this.icons.put("zh", StockIcons.ICON_FLAG_ZH);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.addItem("ar", "\u0627\u0644\u0639\u0631\u0628\u064a\u0629", buttonGroup);
        this.addItem("de", "Deutsch", buttonGroup);
        this.addItem("el", "E\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac", buttonGroup);
        this.addItem("en", "English", buttonGroup);
        this.addItem("eo", "Esperanto", buttonGroup);
        this.addItem("es", "Espa\u00f1ol", buttonGroup);
        this.addItem("fr", "Fran\u00e7ais", buttonGroup);
        this.addItem("hu", "Magyar", buttonGroup);
        this.addItem("ja", "\u65e5\u672c\u8a9e", buttonGroup);
        this.addItem("lv", "Latvie\u0161u", buttonGroup);
        this.addItem("nl", "Nederlands", buttonGroup);
        this.addItem("pl", "Polski", buttonGroup);
        this.addItem("pt", "Portugu\u00eas", buttonGroup);
        this.addItem("pt_BR", "Portugu\u00eas (Brasil)", buttonGroup);
        this.addItem("ru", "\u0420\u0443\u0441\u0441\u043a\u0438\u0439", buttonGroup);
        this.addItem("ta", "\u0ba4\u0bae\u0bbf\u0bb4\u0bcd (\u0b87\u0ba8\u0bcd\u0ba4\u0bbf\u0baf\u0bbe)", buttonGroup);
        this.addItem("tr", "T\u00fcrk\u00e7e", buttonGroup);
        this.addItem("zh", "\u4e2d\u6587", buttonGroup);
        JScrollPane jScrollPane = new JScrollPane();
        JPanel jPanel = new JPanel();
        jPanel.add(this.panel);
        jPanel.setBackground(Color.WHITE);
        this.panel.setBackground(Color.WHITE);
        jScrollPane.getViewport().add(jPanel);
        container.add(jScrollPane);
        FlowLayout flowLayout = new FlowLayout(1);
        this.btnPanel.setLayout(flowLayout);
        this.okBtn.setHorizontalTextPosition(0);
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.okButtonClicked();
            }

            private void okButtonClicked() {
                LanguageDialog.this.dispose();
            }
        });
        this.btnPanel.add(this.okBtn);
        container.add(this.btnPanel);
    }

    @Override
    public void setL10nMessages(Locale locale, String string) {
        this.setTitle(I18n.gtxt("Language"));
        this.okBtn.setText(I18n.gtxt("Ok"));
    }

    private void addItem(final String string, String string2, ButtonGroup buttonGroup) {
        JRadioButton jRadioButton = new JRadioButton(string2, this.icons.get(string));
        this.itemsMap.put(string, jRadioButton);
        if (string.equals(string)) {
            jRadioButton.setSelected(true);
        }
        jRadioButton.setAction(new AbstractAction(string2, this.icons.get(string)){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                I18n.reset(string);
            }
        });
        jRadioButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    LanguageDialog.this.dispose();
                }
            }
        });
        buttonGroup.add(jRadioButton);
        this.panel.add(jRadioButton);
    }
}

