/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.ui.swing;

import java.util.Locale;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import net.jankenpoi.i18n.I18n;
import net.jankenpoi.i18n.LocaleListener;
import net.jankenpoi.sudokuki.ui.L10nComponent;
import net.jankenpoi.sudokuki.ui.swing.ActionsRepository;
import net.jankenpoi.sudokuki.ui.swing.CheatMenu;
import net.jankenpoi.sudokuki.ui.swing.ClearAllMovesAction;
import net.jankenpoi.sudokuki.ui.swing.CustomGridAction;
import net.jankenpoi.sudokuki.ui.swing.EraseAllMemosAction;
import net.jankenpoi.sudokuki.ui.swing.LanguageMenu;
import net.jankenpoi.sudokuki.ui.swing.LevelMenu;
import net.jankenpoi.sudokuki.ui.swing.LocaleListenerImpl;
import net.jankenpoi.sudokuki.ui.swing.NumbersMenu;
import net.jankenpoi.sudokuki.ui.swing.PlayCustomGridAction;
import net.jankenpoi.sudokuki.ui.swing.StockIcons;
import net.jankenpoi.sudokuki.ui.swing.SwingView;

public class EditMenu
extends JMenu
implements L10nComponent {
    private final JMenuItem itemClearAllMoves = new JMenuItem();
    private final JMenuItem itemEraseAllMemos = new JMenuItem();
    private final JMenuItem itemCustomGrid = new JMenuItem();
    private final JMenuItem itemPlayCustomGrid = new JMenuItem();
    private final Action actionClearAllMoves;
    private final Action actionEraseAllMemos;
    private final Action actionCustomGrid;
    private final Action actionPlayCustomGrid;
    private final LocaleListener localeListener;
    private LevelMenu levelMenu;
    private CheatMenu cheatMenu;

    @Override
    public void setL10nMessages(Locale locale, String string) {
        this.setText(I18n.gtxt("Edit"));
        this.itemClearAllMoves.setText(I18n.gtxt("Clear moves"));
        this.actionClearAllMoves.putValue("ShortDescription", I18n.gtxt("Clear all moves"));
        this.itemEraseAllMemos.setText(I18n.gtxt("Hide memos..."));
        this.actionEraseAllMemos.putValue("ShortDescription", I18n.gtxt("Hide all memos..."));
        this.itemCustomGrid.setText(I18n.gtxt("Custom grid"));
        this.actionCustomGrid.putValue("ShortDescription", I18n.gtxt("Compose a custom grid..."));
        this.itemPlayCustomGrid.setText(I18n.gtxt("Play grid"));
        this.actionPlayCustomGrid.putValue("ShortDescription", I18n.gtxt("Play with current grid..."));
    }

    EditMenu(ActionsRepository actionsRepository, JFrame jFrame, SwingView swingView) {
        this.setMnemonic(69);
        this.getAccessibleContext().setAccessibleDescription("Edit menu");
        this.actionClearAllMoves = new ClearAllMovesAction("Clear all moves", StockIcons.ICON_CLEAR, "Clear all my moves", new Integer(88), swingView);
        actionsRepository.put("ClearAllMoves", this.actionClearAllMoves);
        this.actionEraseAllMemos = new EraseAllMemosAction("Erase all memos", StockIcons.ICON_CLEAR_ALL_MEMOS, "Erase all memos...", new Integer(88), swingView);
        actionsRepository.put("EraseAllMemos", this.actionEraseAllMemos);
        this.actionCustomGrid = new CustomGridAction("Custom grid", StockIcons.ICON_EDIT, "Compose a custom grid...", new Integer(71), swingView);
        actionsRepository.put("CustomGrid", this.actionCustomGrid);
        this.actionPlayCustomGrid = new PlayCustomGridAction("Play custom grid", StockIcons.ICON_PLAY, "Play with current grid...", new Integer(72), swingView);
        actionsRepository.put("PlayCustomGrid", this.actionPlayCustomGrid);
        this.addItems(actionsRepository, jFrame, swingView);
        this.setL10nMessages(null, I18n.gtxt("DETECTED_LANGUAGE"));
        this.localeListener = new LocaleListenerImpl(this);
        I18n.addLocaleListener(this.localeListener);
    }

    private void addItems(ActionsRepository actionsRepository, JFrame jFrame, SwingView swingView) {
        this.itemClearAllMoves.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.itemClearAllMoves.setAction(this.actionClearAllMoves);
        this.actionClearAllMoves.setEnabled(false);
        this.add(this.itemClearAllMoves);
        this.itemEraseAllMemos.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.itemEraseAllMemos.setAction(this.actionEraseAllMemos);
        this.actionEraseAllMemos.setEnabled(false);
        this.add(this.itemEraseAllMemos);
        this.addSeparator();
        this.levelMenu = new LevelMenu();
        this.add(this.levelMenu);
        this.add(new NumbersMenu(swingView));
        this.add(new LanguageMenu());
        this.addSeparator();
        this.cheatMenu = new CheatMenu(actionsRepository, jFrame, swingView);
        this.add(this.cheatMenu);
        this.addSeparator();
        this.itemCustomGrid.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.itemCustomGrid.setAction(this.actionCustomGrid);
        this.itemCustomGrid.setEnabled(true);
        this.add(this.itemCustomGrid);
        this.itemPlayCustomGrid.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.itemPlayCustomGrid.setAction(this.actionPlayCustomGrid);
        this.itemPlayCustomGrid.setEnabled(false);
        this.add(this.itemPlayCustomGrid);
    }

    public CheatMenu getCheatMenu() {
        return this.cheatMenu;
    }

    public LevelMenu getLevelMenu() {
        return this.levelMenu;
    }
}

