/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.ui.swing;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import net.jankenpoi.i18n.I18n;
import net.jankenpoi.sudokuki.ui.swing.CheckUpdateAction;

public class CheckUpdateDialog
extends JDialog {
    private static final String VERSION_FILE_DOWNLOAD_WEB_SITE = "http://sourceforge.net/projects/sudokuki/files/sudokuki/1.2/LATEST/download";
    private JFrame parent;
    final CheckUpdateAction checkUpdateAction;
    private int result = -1;
    private final SwingWorker<String, Void> worker = new SwingWorker<String, Void>(){

        @Override
        protected String doInBackground() throws Exception {
            String string = this.getHttpLatestVersionString();
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            CheckUpdateDialog.this.result = -1;
            try {
                String string = (String)this.get();
                if (string.equals("Sudokuki 1.2.4")) {
                    CheckUpdateDialog.this.result = 0;
                } else if (string.startsWith("Sudokuki")) {
                    CheckUpdateDialog.this.checkUpdateAction.notifyNewVersionFound();
                    CheckUpdateDialog.this.result = 1;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (CancellationException cancellationException) {
                CheckUpdateDialog.this.result = -2;
            }
            finally {
                CheckUpdateDialog.this.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getHttpLatestVersionString() {
            String[] stringArray;
            Object object;
            String string = null;
            BufferedReader bufferedReader = null;
            try {
                object = new URL(CheckUpdateDialog.VERSION_FILE_DOWNLOAD_WEB_SITE);
                stringArray = ((URL)object).openConnection();
                stringArray.setDoInput(true);
                stringArray.setUseCaches(false);
                bufferedReader = new BufferedReader(new InputStreamReader(stringArray.getInputStream()));
                string = bufferedReader.readLine();
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            object = "";
            if (string != null && (stringArray = string.split(" is the latest version.")).length >= 1) {
                object = stringArray[0];
            }
            return object;
        }
    };

    public CheckUpdateDialog(JFrame jFrame, CheckUpdateAction checkUpdateAction) {
        super((Frame)jFrame, true);
        this.checkUpdateAction = checkUpdateAction;
        this.parent = jFrame;
        this.initComponents();
        this.setResizable(false);
        this.worker.execute();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        GridLayout gridLayout = new GridLayout(3, 1);
        container.setLayout(gridLayout);
        JLabel jLabel = new JLabel("<html><table border=\"0\"><tr><td align=\"center\">" + I18n.gtxt("Checking for available updates") + ".</td>" + "</tr><html>");
        JLabel jLabel2 = new JLabel("<html><table border=\"0\"><tr><td align=\"center\">" + I18n.gtxt("Please wait...") + "</td>" + "</tr><html>");
        JButton jButton = new JButton(I18n.gtxt("Cancel"));
        jButton.setHorizontalTextPosition(0);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CheckUpdateDialog.this.cancelButtonClicked();
            }
        });
        container.add(jLabel);
        container.add(jLabel2);
        FlowLayout flowLayout = new FlowLayout(1);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(flowLayout);
        jPanel.add(jButton);
        container.add(jPanel);
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }

    private void cancelButtonClicked() {
        this.worker.cancel(true);
    }

    int getResult() {
        return this.result;
    }
}

