/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.ui.swing;

import java.util.Locale;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import net.jankenpoi.i18n.I18n;
import net.jankenpoi.i18n.LocaleListener;
import net.jankenpoi.sudokuki.ui.L10nComponent;
import net.jankenpoi.sudokuki.ui.swing.ActionsRepository;
import net.jankenpoi.sudokuki.ui.swing.LocaleListenerImpl;
import net.jankenpoi.sudokuki.ui.swing.NewGridAction;
import net.jankenpoi.sudokuki.ui.swing.OpenGridAction;
import net.jankenpoi.sudokuki.ui.swing.PrintAction;
import net.jankenpoi.sudokuki.ui.swing.PrintMultiAction;
import net.jankenpoi.sudokuki.ui.swing.QuitAction;
import net.jankenpoi.sudokuki.ui.swing.SaveAsAction;
import net.jankenpoi.sudokuki.ui.swing.StockIcons;
import net.jankenpoi.sudokuki.ui.swing.SwingGrid;
import net.jankenpoi.sudokuki.ui.swing.SwingView;

public class FileMenu
extends JMenu
implements L10nComponent {
    private final JMenuItem itemNew = new JMenuItem();
    private final JMenuItem itemOpen = new JMenuItem();
    private final JMenuItem itemSaveAs = new JMenuItem();
    private final JMenuItem itemPrint = new JMenuItem();
    private final JMenuItem itemPrintMulti = new JMenuItem();
    private final JMenuItem itemQuit = new JMenuItem();
    private final Action actionNew;
    private final Action actionOpen;
    private final Action actionSaveAs;
    private final Action actionQuit = new QuitAction();
    private final Action actionPrint;
    private final Action actionPrintMulti;
    private final LocaleListener localeListener;

    @Override
    public void setL10nMessages(Locale locale, String string) {
        this.setText(I18n._("File"));
        this.itemNew.setText(I18n._("New"));
        this.actionNew.putValue("SmallIcon", StockIcons.ICON_NEW);
        this.actionNew.putValue("ShortDescription", I18n._("New"));
        this.actionNew.putValue("MnemonicKey", new Integer(78));
        this.itemOpen.setText(I18n._("Open"));
        this.actionOpen.putValue("SmallIcon", StockIcons.ICON_OPEN);
        this.actionOpen.putValue("ShortDescription", I18n._("Open"));
        this.actionOpen.putValue("MnemonicKey", new Integer(79));
        this.itemSaveAs.setText(I18n._("Save as"));
        this.actionSaveAs.putValue("SmallIcon", StockIcons.ICON_SAVE_AS);
        this.actionSaveAs.putValue("ShortDescription", I18n._("Save as"));
        this.actionSaveAs.putValue("MnemonicKey", new Integer(83));
        this.itemPrint.setText(I18n._("Print"));
        this.actionPrint.putValue("SmallIcon", StockIcons.ICON_PRINT);
        this.actionPrint.putValue("ShortDescription", I18n._("Print the grid"));
        this.actionPrint.putValue("MnemonicKey", new Integer(80));
        this.itemPrintMulti.setText(I18n._("Print x 4..."));
        this.actionPrintMulti.putValue("SmallIcon", StockIcons.ICON_PRINTER_INFO);
        this.actionPrintMulti.putValue("ShortDescription", I18n._("Print four grids"));
        this.itemQuit.setText(I18n._("Quit"));
        this.actionQuit.putValue("SmallIcon", StockIcons.ICON_QUIT);
        this.actionQuit.putValue("ShortDescription", I18n._("Quit the application"));
        this.actionQuit.putValue("MnemonicKey", new Integer(81));
    }

    FileMenu(JFrame jFrame, ActionsRepository actionsRepository, SwingGrid swingGrid, SwingView swingView) {
        this.setMnemonic(70);
        this.getAccessibleContext().setAccessibleDescription("File menu");
        this.actionNew = new NewGridAction(jFrame, swingView, actionsRepository);
        actionsRepository.put("NewGrid", this.actionNew);
        this.actionOpen = new OpenGridAction(jFrame, swingView);
        actionsRepository.put("OpenGrid", this.actionOpen);
        this.actionSaveAs = new SaveAsAction(jFrame, swingView);
        actionsRepository.put("SaveAs", this.actionSaveAs);
        this.actionPrint = new PrintAction(swingGrid);
        actionsRepository.put("Print", this.actionPrint);
        this.actionPrintMulti = new PrintMultiAction(jFrame, swingView);
        actionsRepository.put("PrintMulti", this.actionPrintMulti);
        this.addItems();
        this.setL10nMessages(null, I18n._("DETECTED_LANGUAGE"));
        this.localeListener = new LocaleListenerImpl(this);
        I18n.addLocaleListener(this.localeListener);
    }

    private void addItems() {
        this.itemNew.setAction(this.actionNew);
        this.itemNew.setIcon(StockIcons.ICON_NEW);
        this.itemNew.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.add(this.itemNew);
        this.itemPrint.setAction(this.actionPrint);
        this.add(this.itemPrint);
        this.itemPrintMulti.setAction(this.actionPrintMulti);
        this.add(this.itemPrintMulti);
        this.addSeparator();
        this.itemOpen.setAction(this.actionOpen);
        this.itemOpen.setIcon(StockIcons.ICON_OPEN);
        this.itemOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.add(this.itemOpen);
        this.itemSaveAs.setAction(this.actionSaveAs);
        this.itemSaveAs.setIcon(StockIcons.ICON_SAVE_AS);
        this.itemSaveAs.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.itemSaveAs.setMnemonic(83);
        this.add(this.itemSaveAs);
        this.addSeparator();
        this.itemQuit.setAction(this.actionQuit);
        this.itemQuit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.add(this.itemQuit);
    }
}

