/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.jankenpoi.i18n.I18n;
import net.jankenpoi.sudokuki.model.GridChangedEvent;
import net.jankenpoi.sudokuki.model.GridModel;
import net.jankenpoi.sudokuki.ui.swing.ActionsRepository;
import net.jankenpoi.sudokuki.ui.swing.CheatMenu;
import net.jankenpoi.sudokuki.ui.swing.Images;
import net.jankenpoi.sudokuki.ui.swing.LevelMenu;
import net.jankenpoi.sudokuki.ui.swing.MenuBar;
import net.jankenpoi.sudokuki.ui.swing.SwingGrid;
import net.jankenpoi.sudokuki.ui.swing.ToolBar;
import net.jankenpoi.sudokuki.view.GridView;

public class SwingView
extends GridView {
    private SwingGrid grid;
    private JFrame frame;
    private ActionsRepository actions;
    private CheatMenu cheatMenu;
    private LevelMenu levelMenu;

    public SwingView(GridModel gridModel) {
        super(gridModel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingView.this.frame = new JFrame("Sudokuki");
                SwingView.this.frame.setLayout(new BorderLayout());
                SwingView.this.grid = new SwingGrid(SwingView.this, SwingView.this.frame);
                SwingView.this.frame.setDefaultCloseOperation(3);
                SwingView.this.frame.setResizable(true);
                SwingView.this.frame.setIconImage(Images.ICON_APPLICATION.getImage());
                MenuBar menuBar = new MenuBar(SwingView.this.frame, SwingView.this.grid, SwingView.this);
                SwingView.this.levelMenu = menuBar.getLevelMenu();
                SwingView.this.cheatMenu = menuBar.getCheatMenu();
                SwingView.this.frame.setJMenuBar(menuBar);
                ToolBar toolBar = new ToolBar(SwingView.this.frame, menuBar.getActions());
                SwingView.this.frame.getContentPane().add((Component)toolBar, "First");
                SwingView.this.frame.getContentPane().add((Component)SwingView.this.grid, "Center");
                SwingView.this.actions = menuBar.getActions();
                SwingView.this.frame.pack();
                SwingView.this.frame.setLocationRelativeTo(null);
                SwingView.this.grid.requestFocusInWindow();
                SwingView.this.grid.setFocusTraversalKeysEnabled(false);
            }
        });
    }

    @Override
    public void display() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingView.this.frame.setVisible(true);
                SwingView.this.frame.setSize(SwingView.this.frame.getPreferredSize());
            }
        });
    }

    @Override
    public void gridChanged(final GridChangedEvent gridChangedEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingView.this.grid.repaint();
                GridModel gridModel = (GridModel)gridChangedEvent.getSource();
                SwingView.this.refreshSaveAsAction(gridModel);
                SwingView.this.refreshPrintGridAction(gridModel);
                SwingView.this.refreshClearAllMovesAction(gridModel);
                SwingView.this.refreshClearAllMemosAction(gridModel);
                SwingView.this.refreshLevelMenu(gridModel);
                SwingView.this.refreshSolutionMenu(gridModel);
                SwingView.this.refreshResolveAction(gridModel);
                SwingView.this.refreshCustomGridAction(gridModel);
                SwingView.this.refreshPlayCustomGridAction(gridModel);
            }
        });
    }

    @Override
    public void gridComplete() {
        JOptionPane.showMessageDialog(this.frame, "<html><table border=\"0\"><tr><td align=\"center\"><b>" + I18n._("Congratulations!") + "</b></td>" + "</tr>" + "<tr>" + "</tr>" + "<tr>" + "<td align=\"center\">" + I18n._("Grid complete!") + "</td>" + "</tr>" + "</table>" + "</html>", "Sudokuki", -1);
    }

    @Override
    public void gridResolved() {
        JOptionPane.showMessageDialog(this.frame, "<html><table border=\"0\"><tr>" + I18n._("Grid resolved with success.") + "</tr>" + "</html>", "Sudokuki", -1);
    }

    private void refreshSaveAsAction(GridModel gridModel) {
        if (this.actions == null) {
            return;
        }
        Action action = this.actions.get("SaveAs");
        action.setEnabled(!gridModel.getCustomGridMode());
    }

    private void refreshPrintGridAction(GridModel gridModel) {
        if (this.actions == null) {
            return;
        }
        Action action = this.actions.get("Print");
        action.setEnabled(!gridModel.getCustomGridMode());
    }

    private void refreshClearAllMemosAction(GridModel gridModel) {
        if (this.actions == null) {
            return;
        }
        Action action = this.actions.get("EraseAllMemos");
        action.setEnabled(gridModel.areSomeMemosSet());
    }

    private void refreshClearAllMovesAction(GridModel gridModel) {
        if (this.actions == null) {
            return;
        }
        Action action = this.actions.get("ClearAllMoves");
        action.setEnabled(!gridModel.isGridComplete() && gridModel.areSomeCellsFilled());
    }

    private void refreshLevelMenu(GridModel gridModel) {
        this.levelMenu.setEnabled(!gridModel.getCustomGridMode());
    }

    private void refreshSolutionMenu(GridModel gridModel) {
        this.cheatMenu.setEnabled(!gridModel.getCustomGridMode() && gridModel.areSomeCellsEmpty());
    }

    protected void refreshResolveAction(GridModel gridModel) {
        if (this.actions == null) {
            return;
        }
        Action action = this.actions.get("ResolveGrid");
        action.setEnabled(!gridModel.getCustomGridMode() && gridModel.areSomeCellsEmpty());
    }

    private void refreshCustomGridAction(GridModel gridModel) {
        if (this.actions == null) {
            return;
        }
        Action action = this.actions.get("CustomGrid");
        action.setEnabled(!gridModel.isGridComplete() && !gridModel.getCustomGridMode() && !gridModel.isGridFull());
    }

    private void refreshPlayCustomGridAction(GridModel gridModel) {
        if (this.actions == null) {
            return;
        }
        Action action = this.actions.get("PlayCustomGrid");
        action.setEnabled(gridModel.getCustomGridMode() && gridModel.getGridValidity().isGridValid());
    }

    @Override
    public void close() {
    }
}

