/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.ui.swing;

import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import net.jankenpoi.i18n.I18n;
import net.jankenpoi.i18n.LocaleListener;
import net.jankenpoi.sudokuki.preferences.UserPreferences;
import net.jankenpoi.sudokuki.ui.L10nComponent;
import net.jankenpoi.sudokuki.ui.swing.LocaleListenerImpl;
import net.jankenpoi.sudokuki.ui.swing.StockIcons;

public class LevelMenu
extends JMenu
implements L10nComponent {
    private final Action actionLevel1;
    private final Action actionLevel2;
    private final Action actionLevel3;
    private final Action actionLevel4;
    private final Action actionLevel5;
    private final JRadioButtonMenuItem itemLevel1 = new JRadioButtonMenuItem();
    private final JRadioButtonMenuItem itemLevel2 = new JRadioButtonMenuItem();
    private final JRadioButtonMenuItem itemLevel3 = new JRadioButtonMenuItem();
    private final JRadioButtonMenuItem itemLevel4 = new JRadioButtonMenuItem();
    private final JRadioButtonMenuItem itemLevel5 = new JRadioButtonMenuItem();
    private final LocaleListener localeListener;

    public LevelMenu() {
        this.actionLevel1 = new AbstractAction(I18n._("Level 1"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LevelMenu.this.setLevelRatingBounds(0, 5700);
            }
        };
        this.actionLevel2 = new AbstractAction(I18n._("Level 2"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LevelMenu.this.setLevelRatingBounds(5700, 6700);
            }
        };
        this.actionLevel3 = new AbstractAction(I18n._("Level 3"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LevelMenu.this.setLevelRatingBounds(6700, 11000);
            }
        };
        this.actionLevel4 = new AbstractAction(I18n._("Level 4"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LevelMenu.this.setLevelRatingBounds(11000, 15000);
            }
        };
        this.actionLevel5 = new AbstractAction(I18n._("Level 5"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LevelMenu.this.setLevelRatingBounds(15000, Integer.MAX_VALUE);
            }
        };
        this.addItems();
        this.setIcon(StockIcons.ICON_PLUS);
        this.setL10nMessages(null, I18n._("DETECTED_LANGUAGE"));
        this.localeListener = new LocaleListenerImpl(this);
        I18n.addLocaleListener(this.localeListener);
        this.setEnabled(true);
    }

    @Override
    public void setL10nMessages(Locale locale, String string) {
        this.setText(I18n._("Level"));
        this.itemLevel1.setText(I18n._("Level 1"));
        this.itemLevel2.setText(I18n._("Level 2"));
        this.itemLevel3.setText(I18n._("Level 3"));
        this.itemLevel4.setText(I18n._("Level 4"));
        this.itemLevel5.setText(I18n._("Level 5"));
    }

    private void addItems() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.itemLevel1);
        this.itemLevel1.setAction(this.actionLevel1);
        this.itemLevel1.setSelected(true);
        this.add(this.itemLevel1);
        this.itemLevel2.setAction(this.actionLevel2);
        buttonGroup.add(this.itemLevel2);
        this.add(this.itemLevel2);
        this.itemLevel3.setAction(this.actionLevel3);
        buttonGroup.add(this.itemLevel3);
        this.add(this.itemLevel3);
        this.itemLevel4.setAction(this.actionLevel4);
        buttonGroup.add(this.itemLevel4);
        this.add(this.itemLevel4);
        this.itemLevel5.setAction(this.actionLevel5);
        buttonGroup.add(this.itemLevel5);
        this.add(this.itemLevel5);
    }

    private void setLevelRatingBounds(int n, int n2) {
        UserPreferences.getInstance().set("minRating", n);
        UserPreferences.getInstance().set("maxRating", n2);
    }
}

