/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.solver;

public class GridShadow {
    public static final int MASK_FOR_CURRENT_VALUE = 15;
    public static final int MASK_POSSIBLE_VALUES = 8176;
    public static final int FLAG_POSSIBLE_VALUE_1 = 16;
    public static final int FLAG_POSSIBLE_VALUE_2 = 32;
    public static final int FLAG_POSSIBLE_VALUE_3 = 64;
    public static final int FLAG_POSSIBLE_VALUE_4 = 128;
    public static final int FLAG_POSSIBLE_VALUE_5 = 256;
    public static final int FLAG_POSSIBLE_VALUE_6 = 512;
    public static final int FLAG_POSSIBLE_VALUE_7 = 1024;
    public static final int FLAG_POSSIBLE_VALUE_8 = 2048;
    public static final int FLAG_POSSIBLE_VALUE_9 = 4096;
    public static final int MASK_SCREENED_VALUES = 0x1FF00000;
    public static final int FLAG_SCREENED_VALUE_1 = 0x100000;
    public static final int FLAG_SCREENED_VALUE_2 = 0x200000;
    public static final int FLAG_SCREENED_VALUE_3 = 0x400000;
    public static final int FLAG_SCREENED_VALUE_4 = 0x800000;
    public static final int FLAG_SCREENED_VALUE_5 = 0x1000000;
    public static final int FLAG_SCREENED_VALUE_6 = 0x2000000;
    public static final int FLAG_SCREENED_VALUE_7 = 0x4000000;
    public static final int FLAG_SCREENED_VALUE_8 = 0x8000000;
    public static final int FLAG_SCREENED_VALUE_9 = 0x10000000;
    public static final int FLAG_CELL_READ_ONLY = 8192;
    private final int[] cellFlags;
    private final int offset;

    public GridShadow(int[] nArray, int n, boolean bl) {
        this.cellFlags = nArray;
        this.offset = n;
        if (bl) {
            this.initAllFlags();
        }
    }

    public int[] popFirstCellWithMinPossValues() {
        int n = -1;
        int n2 = -1;
        int n3 = 9;
        boolean bl = false;
        boolean bl2 = true;
        block0: for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.isCellFilled(i, j)) continue;
                bl2 = false;
                int n4 = this.getNumberOfPossibleValues(i, j);
                if (n4 == 0) {
                    bl = true;
                    break block0;
                }
                if (n4 >= n3) continue;
                n = i;
                n2 = j;
                if (n4 == 1) break block0;
                n3 = n4;
            }
        }
        if (bl2) {
            return new int[]{10, 10};
        }
        if (bl) {
            return new int[]{11, 11};
        }
        return new int[]{n, n2};
    }

    public byte popFirstValueForCell(int n, int n2) {
        if (this.isCellFilled(n, n2)) {
            return 0;
        }
        for (byte by = 1; by <= 9; by = (byte)(by + 1)) {
            if (!this.isCellValuePossible(n, n2, by) || this.isCellValueScreened(n, n2, by)) continue;
            return by;
        }
        return 0;
    }

    public boolean setCellValueAt(int n, int n2, byte by) {
        int n3;
        int n4 = this.offset + 9 * n + n2;
        this.cellFlags[n4] = this.cellFlags[n4] & 0xFFFFFFF0;
        int n5 = this.offset + 9 * n + n2;
        this.cellFlags[n5] = this.cellFlags[n5] | (0x2000 | by);
        for (n3 = 0; n3 < 9; ++n3) {
            if (n3 == n2 || this.isCellFilled(n, n3) || !this.isCellValuePossible(n, n3, by)) continue;
            this.unsetCellValuePossible(n, n3, by);
            this.setCellValueScreened(n, n3, by);
            if (this.getNumberOfPossibleValues(n, n3) != 0) continue;
            return true;
        }
        for (n3 = 0; n3 < 9; ++n3) {
            if (n3 == n || this.isCellFilled(n3, n2) || !this.isCellValuePossible(n3, n2, by)) continue;
            this.unsetCellValuePossible(n3, n2, by);
            this.setCellValueScreened(n3, n2, by);
            if (this.getNumberOfPossibleValues(n3, n2) != 0) continue;
            return true;
        }
        n3 = 3 * (n2 / 3);
        int n6 = 3 * (n / 3);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n7 = n6 + j;
                int n8 = n3 + i;
                if (this.isCellFilled(n7, n8) || !this.isCellValuePossible(n7, n8, by)) continue;
                this.unsetCellValuePossible(n7, n8, by);
                this.setCellValueScreened(n7, n8, by);
                if (this.getNumberOfPossibleValues(n7, n8) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public void setCellReadOnly(int n, int n2) {
        int n3 = this.offset + 9 * n + n2;
        this.cellFlags[n3] = this.cellFlags[n3] | 0x2000;
    }

    public void setCellValueScreened(int n, int n2, byte by) {
        int n3 = this.offset + 9 * n + n2;
        this.cellFlags[n3] = this.cellFlags[n3] | this.getScreenedValuesFlag(by);
    }

    private boolean isCellValueScreened(int n, int n2, byte by) {
        return (this.cellFlags[this.offset + 9 * n + n2] & this.getScreenedValuesFlag(by)) != 0;
    }

    boolean isCellFilled(int n, int n2) {
        return (this.cellFlags[this.offset + 9 * n + n2] & 0x2000) != 0;
    }

    byte getValueAt(int n, int n2) {
        byte by = (byte)(this.cellFlags[this.offset + 9 * n + n2] & 0xF);
        return by;
    }

    int getNumberOfPossibleValues(int n, int n2) {
        if (this.isCellFilled(n, n2)) {
            return 0;
        }
        int n3 = 0;
        for (byte by = 1; by <= 9; by = (byte)(by + 1)) {
            if (!this.isCellValuePossible(n, n2, by) || this.isCellValueScreened(n, n2, by)) continue;
            ++n3;
        }
        return n3;
    }

    boolean isCellValuePossible(int n, int n2, byte by) {
        return (this.cellFlags[this.offset + 9 * n + n2] & this.getPossibleValuesFlag(by)) != 0;
    }

    void unsetCellValuePossible(int n, int n2, byte by) {
        if (this.isCellValuePossible(n, n2, by)) {
            // empty if block
        }
        int n3 = this.offset + 9 * n + n2;
        this.cellFlags[n3] = this.cellFlags[n3] & ~this.getPossibleValuesFlag(by);
    }

    private void initAllFlags() {
        byte by;
        int n;
        int n2;
        int n3;
        for (n3 = 0; n3 < 9; ++n3) {
            for (n2 = 0; n2 < 9; ++n2) {
                if (this.isCellFilled(n3, n2)) continue;
                this.cellFlags[this.offset + 9 * n3 + n2] = 8176;
            }
        }
        for (n3 = 0; n3 < 9; n3 += 3) {
            for (n2 = 0; n2 < 9; n2 += 3) {
                int n4;
                int n5;
                int n6;
                n = 0;
                for (by = 0; by < 3; ++by) {
                    for (n6 = 0; n6 < 3; ++n6) {
                        n5 = n2 + n6;
                        n4 = n3 + by;
                        if (!this.isCellFilled(n5, n4)) continue;
                        byte by2 = this.getValueAt(n5, n4);
                        n |= 0x1FF00000 & ~this.getScreenedValuesFlag(by2) | this.getPossibleValuesFlag(by2);
                    }
                }
                for (by = 0; by < 3; ++by) {
                    for (n6 = 0; n6 < 3; ++n6) {
                        n5 = n2 + n6;
                        n4 = n3 + by;
                        if (this.isCellFilled(n5, n4)) continue;
                        int n7 = this.offset + 9 * n5 + n4;
                        this.cellFlags[n7] = this.cellFlags[n7] & ~n;
                    }
                }
            }
        }
        for (n3 = 0; n3 < 9; ++n3) {
            n2 = 0;
            for (n = 0; n < 9; ++n) {
                if (!this.isCellFilled(n3, n)) continue;
                by = this.getValueAt(n3, n);
                n2 |= 0x1FF00000 & ~this.getScreenedValuesFlag(by) | this.getPossibleValuesFlag(by);
            }
            for (n = 0; n < 9; ++n) {
                if (this.isCellFilled(n3, n)) continue;
                int n8 = this.offset + 9 * n3 + n;
                this.cellFlags[n8] = this.cellFlags[n8] & ~n2;
            }
        }
        for (n3 = 0; n3 < 9; ++n3) {
            n2 = 0;
            for (n = 0; n < 9; ++n) {
                if (!this.isCellFilled(n, n3)) continue;
                by = this.getValueAt(n, n3);
                n2 |= 0x1FF00000 & ~this.getScreenedValuesFlag(by) | this.getPossibleValuesFlag(by);
            }
            for (n = 0; n < 9; ++n) {
                if (this.isCellFilled(n, n3)) continue;
                int n9 = this.offset + 9 * n + n3;
                this.cellFlags[n9] = this.cellFlags[n9] & ~n2;
            }
        }
        for (n3 = 0; n3 < 9; ++n3) {
            for (n2 = 0; n2 < 9; ++n2) {
                if (this.isCellFilled(n3, n2)) continue;
                n = 0;
                for (by = 1; by <= 9; by = (byte)(by + 1)) {
                    if (!this.isCellValuePossible(n3, n2, by)) continue;
                    ++n;
                }
                int n10 = this.offset + 9 * n3 + n2;
                this.cellFlags[n10] = this.cellFlags[n10] | n;
            }
        }
    }

    private int getPossibleValuesFlag(byte by) {
        switch (by) {
            case 1: {
                return 16;
            }
            case 2: {
                return 32;
            }
            case 3: {
                return 64;
            }
            case 4: {
                return 128;
            }
            case 5: {
                return 256;
            }
            case 6: {
                return 512;
            }
            case 7: {
                return 1024;
            }
            case 8: {
                return 2048;
            }
            case 9: {
                return 4096;
            }
        }
        throw new IllegalArgumentException("getPossibleValuesFlag() value " + by + " is illegal");
    }

    private int getScreenedValuesFlag(byte by) {
        switch (by) {
            case 1: {
                return 0x100000;
            }
            case 2: {
                return 0x200000;
            }
            case 3: {
                return 0x400000;
            }
            case 4: {
                return 0x800000;
            }
            case 5: {
                return 0x1000000;
            }
            case 6: {
                return 0x2000000;
            }
            case 7: {
                return 0x4000000;
            }
            case 8: {
                return 0x8000000;
            }
            case 9: {
                return 0x10000000;
            }
        }
        throw new IllegalArgumentException("getScreenedValuesFlag() value " + by + " is illegal");
    }

    public void debugDump() {
    }
}

