#line 2 "mate_parser.c"
/* Include this before everything else, for various large-file definitions */
#include "config.h"

#line 6 "mate_parser.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 0
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE Mate_restart(yyin ,yyscanner )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via Mate_restart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

void Mate_restart (FILE *input_file ,yyscan_t yyscanner );
void Mate__switch_to_buffer (YY_BUFFER_STATE new_buffer ,yyscan_t yyscanner );
YY_BUFFER_STATE Mate__create_buffer (FILE *file,int size ,yyscan_t yyscanner );
void Mate__delete_buffer (YY_BUFFER_STATE b ,yyscan_t yyscanner );
void Mate__flush_buffer (YY_BUFFER_STATE b ,yyscan_t yyscanner );
void Mate_push_buffer_state (YY_BUFFER_STATE new_buffer ,yyscan_t yyscanner );
void Mate_pop_buffer_state (yyscan_t yyscanner );

static void Mate_ensure_buffer_stack (yyscan_t yyscanner );
static void Mate__load_buffer_state (yyscan_t yyscanner );
static void Mate__init_buffer (YY_BUFFER_STATE b,FILE *file ,yyscan_t yyscanner );

#define YY_FLUSH_BUFFER Mate__flush_buffer(YY_CURRENT_BUFFER ,yyscanner)

YY_BUFFER_STATE Mate__scan_buffer (char *base,yy_size_t size ,yyscan_t yyscanner );
YY_BUFFER_STATE Mate__scan_string (yyconst char *yy_str ,yyscan_t yyscanner );
YY_BUFFER_STATE Mate__scan_bytes (yyconst char *bytes,yy_size_t len ,yyscan_t yyscanner );

void *Mate_alloc (yy_size_t ,yyscan_t yyscanner );
void *Mate_realloc (void *,yy_size_t ,yyscan_t yyscanner );
void Mate_free (void * ,yyscan_t yyscanner );

#define yy_new_buffer Mate__create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        Mate_ensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            Mate__create_buffer(yyin,YY_BUF_SIZE ,yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        Mate_ensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            Mate__create_buffer(yyin,YY_BUF_SIZE ,yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define Mate_wrap(yyscanner) (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

typedef int yy_state_type;

#define yytext_ptr yytext_r

static yy_state_type yy_get_previous_state (yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  ,yyscan_t yyscanner);
static int yy_get_next_buffer (yyscan_t yyscanner );
#if defined(__GNUC__) && __GNUC__ >= 3
__attribute__((__noreturn__))
#endif
static void yy_fatal_error (yyconst char msg[] ,yyscan_t yyscanner );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
	yyleng = (size_t) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yyg->yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 69
#define YY_END_OF_BUFFER 70
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[320] =
    {   0,
        0,    0,    0,    0,   67,   67,    0,    0,    0,    0,
       70,   69,    2,    1,   65,   66,   69,   52,   53,   56,
       58,   60,   63,   57,   69,   69,   69,   69,   69,   69,
       69,   69,   69,   69,   69,   69,   69,   69,   69,   69,
       64,   64,   64,   64,   54,   59,   55,   67,    2,    1,
       68,    4,    7,    2,    7,    2,    0,    6,    0,    0,
       60,   63,    0,   63,   63,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   21,    0,    0,
        0,    0,    0,    0,    0,    0,   64,   64,   64,   64,

       67,    2,    4,    8,    0,    0,    5,   61,   60,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   11,   10,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    9,    0,    0,    0,
        0,    0,    0,    0,    0,    0,   64,   64,    0,    0,
       61,   60,    0,    0,    0,    0,    0,    0,   47,    0,
        0,    0,    0,    0,    0,    0,   43,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   23,    0,   34,    0,   64,   34,
        0,    0,   61,    0,    0,    0,    0,   49,    0,    0,

        0,   15,    0,   24,   35,    0,    0,    0,    0,    0,
        0,   50,    0,   16,   13,    0,    0,    0,    0,   36,
        0,    0,    0,   22,    0,    0,   35,    0,    0,    0,
       61,   40,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   18,    0,    0,   20,   30,    0,    0,
       41,    0,    0,    0,   14,    0,    0,    0,   62,    0,
        0,    0,   51,    0,    0,    0,   42,    0,    0,   19,
        0,   46,    0,   37,   31,   17,    0,    0,    0,    0,
        3,   62,    0,   39,    0,    0,    0,   48,    0,    0,
       29,    0,   25,    0,    0,   62,   33,    0,    0,    0,

       32,    0,   26,   12,   38,    0,    0,   27,    0,    0,
        0,   28,    0,    0,    0,    0,   45,   44,    0
    } ;

static yyconst YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    4,    5,    6,    4,    1,    1,    1,    7,
        8,    9,    1,   10,   11,   12,   13,   14,   14,   14,
       14,   14,   14,   14,   14,   14,   14,   15,   16,    4,
        4,    4,    1,    1,   17,   18,   19,   20,   21,   22,
       23,   11,   24,   11,   11,   25,   26,   27,   28,   29,
       11,   30,   31,   32,   33,   11,   11,   11,   11,   11,
        1,    1,    1,    4,   11,    1,   34,   35,   36,   37,

       38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
       48,   49,   44,   50,   51,   52,   53,   54,   55,   56,
       57,   44,   58,   59,   60,    4,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst YY_CHAR yy_meta[61] =
    {   0,
        1,    1,    1,    1,    2,    1,    1,    1,    1,    1,
        3,    4,    5,    6,    7,    1,    6,    6,    6,    6,
        6,    6,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    6,    6,    6,    6,    6,    6,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    1,    1,    1
    } ;

static yyconst flex_uint16_t yy_base[330] =
    {   0,
        0,    2,    5,    0,   64,   68,   73,  133,   82,   84,
      504,  505,  501,  505,  505,  505,  460,  505,  505,  505,
       59,   80,  486,  505,   84,   64,   54,   65,   69,   80,
      452,   65,  112,   72,  451,  451,   74,  459,   76,   79,
      180,  206,  481,  129,  505,  505,  505,    0,  493,    0,
      505,    0,  505,  492,  480,  490,  444,  505,  487,  475,
      133,  473,  451,  471,  470,  448,  115,  441,  117,  431,
      434,  432,  441,   69,  132,  433,  124,  115,  432,  425,
      424,  420,  434,  424,  419,  424,  437,  505,  411,  414,
      418,  118,  417,  128,  130,  137,  449,  148,  188,  196,

        0,  461,    0,  505,  426,  458,  505,  161,  446,  148,
      417,  406,  151,  172,  421,  418,  406,  404,  411,  402,
      158,  413,  404,  403,  505,  416,  409,  408,  393,  406,
      405,  391,  405,  405,  389,  393,  405,  384,  397,  389,
      378,  382,  382,  388,  209,  382,  181,  216,  383,  413,
      222,  234,  202,  390,  387,  384,  199,  389,  505,  389,
      364,  370,  385,  218,  371,  379,  505,  366,  383,  364,
      384,  367,  359,  372,  368,  370,  369,  358,  355,  356,
      367,  368,  369,  348,  505,  363,  505,  347,  238,  382,
      343,  243,  246,  381,  342,  361,  342,  505,  346,  340,

      342,  505,  354,  351,  505,  352,  353,  346,  341,  330,
      344,  505,  338,  505,  505,  329,  340,  343,  338,  505,
      323,  338,   77,  505,  321,  222,  357,  334,  356,  250,
      355,  505,  318,  325,  314,  328,  330,  311,  310,  315,
      310,  321,  312,  505,  304,  310,  505,  505,  318,  316,
      505,  315,  306,  313,  505,  302,  301,  310,  333,  334,
      307,  310,  505,  314,  291,  299,  505,  302,  301,  505,
      300,  505,  299,  505,  505,  505,  298,  297,  284,  267,
      505,  299,  268,  505,  238,  223,  225,  505,  234,  222,
      505,  218,  505,  222,  215,  505,  505,  213,  223,  216,

      505,  197,  505,  505,  505,  190,  167,  505,  151,  154,
      138,  505,  129,  142,  140,   89,  505,  505,  505,  276,
      283,  290,  297,  301,  303,  308,  315,  320,  326
    } ;

static yyconst flex_int16_t yy_def[330] =
    {   0,
      320,  320,  319,    3,  321,  321,  322,  322,  323,  323,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  324,  325,  319,  324,   25,   25,   25,   25,   25,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      326,  326,  326,  326,  319,  319,  319,  327,  327,  327,
      319,  328,  319,  319,  319,  319,  319,  319,  329,  319,
       25,  325,   25,  325,  325,   25,   25,  319,   25,  319,
      319,  319,  319,  319,   25,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  326,   42,   42,  326,

      327,  327,  328,  319,  319,  329,  319,  319,   61,   25,
      319,  319,   25,   25,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  326,  326,  319,  319,
      319,   61,   25,  319,  319,  319,   25,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  326,  326,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,

      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  326,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,

      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,    0,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319
    } ;

static yyconst flex_uint16_t yy_nxt[566] =
    {   0,
      319,   13,   14,   13,   14,   12,   13,   14,   15,   16,
       17,   18,   19,   12,   20,   12,   12,   21,   22,   23,
       24,   25,   26,   27,   28,   29,   30,   31,   32,   33,
       34,   35,   36,   37,   38,   39,   40,   12,   41,   41,
       41,   41,   41,   42,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   44,   43,   43,   43,
       43,   43,   45,   46,   47,   49,   50,   58,   51,   49,
       50,   59,   51,   12,   13,   14,   12,   12,   12,   12,
       12,   12,   12,   54,   14,   54,   14,   12,   12,   63,
       55,   60,   55,   61,   62,  319,   75,   67,   62,   63,

       63,   79,   69,   68,   63,   85,   70,   89,   95,   86,
       90,   80,   71,   75,   72,   63,   93,  119,  253,   66,
      120,   76,   73,   91,   74,  318,  254,   94,   96,   77,
       12,   12,   12,   12,   13,   14,   12,   12,   12,   12,
       12,   12,   12,  319,   60,   81,  109,   12,   12,   82,
       63,  113,   63,   83,  125,  114,  121,  123,  100,   84,
      139,  142,  145,  126,   98,  111,  140,   63,   63,  145,
      146,  124,  150,  317,  151,  143,  121,  144,  100,  316,
      315,   98,  145,   63,  314,  153,   63,  313,  164,  145,
       12,   12,   12,   98,   62,  319,   98,   98,   98,   98,

       98,   98,  312,  156,   98,  157,  311,   63,  164,  310,
      319,  189,  147,   98,   98,   98,   98,   98,   98,   98,
       62,   98,   99,   98,   98,   98,   98,   98,  148,  187,
      319,  189,  147,  150,   63,  193,  190,   63,  205,   99,
       98,   98,   98,   98,   98,  194,  187,  152,  148,  309,
      195,  199,  319,  190,  229,  205,  230,  150,  227,  231,
      256,  229,  308,  260,  307,  306,  305,  304,  303,  302,
      257,  301,  300,  299,  298,  227,   12,   12,   12,   12,
       12,   12,   12,   48,   48,   48,   48,   48,   48,   48,
       52,   52,   52,   52,   52,   52,   52,   53,   53,   53,

       53,   53,   53,   53,   63,  297,   63,   63,   64,   64,
       97,   97,  296,   97,   97,  101,  295,  101,  101,  101,
      101,  101,  103,  103,  103,  103,  106,  106,  106,  106,
      106,  106,  106,  294,  293,  292,  291,  290,  289,  288,
      287,  286,  285,  284,  283,  229,  282,  281,  280,  279,
      278,  277,  276,  275,  274,  273,  272,  271,  270,  269,
      268,  267,  266,  265,  264,  263,  262,  261,  231,  259,
      258,  319,  255,  252,  251,  250,  249,  248,  247,  246,
      245,  244,  243,  242,  241,  240,  239,  238,  237,  236,
      235,  234,  233,  232,  231,  228,  319,  226,  225,  224,

      223,  222,  221,  220,  219,  218,  217,  216,  215,  214,
      213,  212,  211,  210,  209,  208,  207,  206,  204,  203,
      202,  201,  200,  198,  197,  196,  192,  191,  188,  186,
      185,  184,  183,  182,  181,  180,  179,  178,  177,  176,
      175,  174,  173,  172,  171,  170,  169,  168,  167,  166,
      165,  163,  162,  161,  160,  159,  158,  155,  154,  152,
      107,  149,  102,  319,  141,  138,  137,  136,  135,  134,
      133,  132,  131,  130,  129,  128,  127,  122,  118,  117,
      116,  115,  112,  110,   65,   65,   63,   65,  108,  107,
      105,   56,  104,   56,  102,  319,   92,   88,   87,   78,

       65,   57,   56,  319,   11,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319
    } ;

static yyconst flex_int16_t yy_chk[566] =
    {   0,
        0,    1,    1,    2,    2,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    5,    5,   21,    5,    6,
        6,   21,    6,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    9,    9,   10,   10,    7,    7,   27,
        9,   22,   10,   22,   22,   25,   30,   26,   25,   26,

       28,   32,   28,   27,   29,   34,   28,   37,   40,   34,
       37,   32,   28,   30,   28,   30,   39,   74,  223,   25,
       74,   30,   29,   37,   29,  316,  223,   39,   40,   30,
        7,    7,    7,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,   44,   61,   33,   61,    8,    8,   33,
       67,   69,   69,   33,   78,   69,   75,   77,   44,   33,
       92,   94,   95,   78,   98,   67,   92,   75,   61,   96,
       96,   77,  108,  315,  108,   94,   75,   94,   44,  314,
      313,   98,   95,  110,  311,  110,  113,  310,  121,   96,
        8,    8,    8,   41,   41,  147,   41,   41,   41,   41,

       41,   41,  309,  113,   99,  114,  307,  114,  121,  306,
      100,  147,   99,   41,   41,   41,   41,   41,   41,   42,
       42,   99,   42,   42,   42,   42,   42,   42,  100,  145,
      148,  147,   99,  151,  157,  151,  148,  153,  164,   42,
       42,   42,   42,   42,   42,  152,  145,  152,  100,  302,
      153,  157,  189,  148,  192,  164,  192,  193,  189,  193,
      226,  230,  300,  230,  299,  298,  295,  294,  292,  290,
      226,  289,  287,  286,  285,  189,  320,  320,  320,  320,
      320,  320,  320,  321,  321,  321,  321,  321,  321,  321,
      322,  322,  322,  322,  322,  322,  322,  323,  323,  323,

      323,  323,  323,  323,  324,  283,  324,  324,  325,  325,
      326,  326,  282,  326,  326,  327,  280,  327,  327,  327,
      327,  327,  328,  328,  328,  328,  329,  329,  329,  329,
      329,  329,  329,  279,  278,  277,  273,  271,  269,  268,
      266,  265,  264,  262,  261,  260,  259,  258,  257,  256,
      254,  253,  252,  250,  249,  246,  245,  243,  242,  241,
      240,  239,  238,  237,  236,  235,  234,  233,  231,  229,
      228,  227,  225,  222,  221,  219,  218,  217,  216,  213,
      211,  210,  209,  208,  207,  206,  204,  203,  201,  200,
      199,  197,  196,  195,  194,  191,  190,  188,  186,  184,

      183,  182,  181,  180,  179,  178,  177,  176,  175,  174,
      173,  172,  171,  170,  169,  168,  166,  165,  163,  162,
      161,  160,  158,  156,  155,  154,  150,  149,  146,  144,
      143,  142,  141,  140,  139,  138,  137,  136,  135,  134,
      133,  132,  131,  130,  129,  128,  127,  126,  124,  123,
      122,  120,  119,  118,  117,  116,  115,  112,  111,  109,
      106,  105,  102,   97,   93,   91,   90,   89,   87,   86,
       85,   84,   83,   82,   81,   80,   79,   76,   73,   72,
       71,   70,   68,   66,   65,   64,   63,   62,   60,   59,
       57,   56,   55,   54,   49,   43,   38,   36,   35,   31,

       23,   17,   13,   11,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      319,  319,  319,  319,  319
    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "mate_parser.l"

/*
 * We want a reentrant scanner.
 */
/*
 * We don't use input, so don't generate code for it.
 */
#define YY_NO_INPUT 1
/*
 * We don't use unput, so don't generate code for it.
 */
/*
 * We don't read interactively from the terminal.
 */
/*
 * We want to stop processing when we get to the end of the input.
 */
/*
 * The type for the state we keep for a scanner.
 */
/*
 * We have to override the memory allocators so that we don't get
 * "unused argument" warnings from the yyscanner argument (which
 * we don't use, as we have a global memory allocator).
 *
 * We provide, as macros, our own versions of the routines generated by Flex,
 * which just call malloc()/realloc()/free() (as the Flex versions do),
 * discarding the extra argument.
 */
/*
 * Prefix scanner routines with "Mate_" rather than "yy", so this scanner
 * can coexist with other scanners.
 */
#line 56 "mate_parser.l"

	/* mate_parser.l
	* lexical analyzer for MATE configuration files
	*
	* Copyright 2004, Luis E. Garcia Ontanon <luis@ontanon.org>
	*
	* Wireshark - Network traffic analyzer
	* By Gerald Combs <gerald@wireshark.org>
	* Copyright 1998 Gerald Combs
	*
	* This program is free software; you can redistribute it and/or
	* modify it under the terms of the GNU General Public License
	* as published by the Free Software Foundation; either version 2
	* of the License, or (at your option) any later version.
	*
	* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU General Public License
	* along with this program; if not, write to the Free Software
	* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
	*/

#include "mate.h"
#include "mate_grammar.h"

#include <wsutil/file_util.h>

#ifdef _WIN32
/* disable Windows VC compiler warning "signed/unsigned mismatch" associated  */
/* with YY_INPUT code generated by flex versions such as 2.5.35.              */
#pragma warning (disable:4018)
#endif

	void MateParser(void*,int, gchar*, mate_config* matecfg);
#if (GLIB_MAJOR_VERSION > 2 || (GLIB_MAJOR_VERSION == 2 && GLIB_MINOR_VERSION >= 16))
	void *MateParserAlloc(void *(*)(gsize));
#else
	void *MateParserAlloc(void *(*)(gulong));
#endif
	void MateParserFree( void*, void(*)(void*) );
	void MateParseTrace(FILE*,char*);

#define MAX_INCLUDE_DEPTH 10
typedef struct {
	mate_config* mc;

	mate_config_frame* current_frame;

	void* pParser;

	YY_BUFFER_STATE include_stack[MAX_INCLUDE_DEPTH];
	int include_stack_ptr;
} Mate_scanner_state_t;

#define MATE_PARSE(token_type) MateParser(yyextra->pParser, (token_type), g_strdup(yytext), yyextra->mc);

/*
 * Flex (v 2.5.35) uses this symbol to "exclude" unistd.h
 */
#ifdef _WIN32
#define YY_NO_UNISTD_H
#endif

static void free_config_frame(mate_config_frame *frame) {
	g_free(frame->filename);
	g_free(frame);
}

#define YY_USER_INIT BEGIN OUTSIDE;

/*
 * Sleazy hack to suppress compiler warnings in yy_fatal_error().
 */
#define YY_EXIT_FAILURE ((void)yyscanner, 2)

/*
 * Macros for the allocators, to discard the extra argument.
 */
#define Mate_alloc(size, yyscanner)		(void *)malloc(size)
#define Mate_realloc(ptr, size, yyscanner)	(void *)realloc((char *)(ptr), (size))
#define Mate_free(ptr, yyscanner)		free((char *)ptr)


#line 798 "mate_parser.c"

#define INITIAL 0
#define OUTSIDE 1
#define QUOTED 2
#define INCLUDING 3
#define COMMENT 4

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#define YY_EXTRA_TYPE Mate_scanner_state_t *

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    int yy_n_chars;
    yy_size_t yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    }; /* end struct yyguts_t */

static int yy_init_globals (yyscan_t yyscanner );

int Mate_lex_init (yyscan_t* scanner);

int Mate_lex_init_extra (YY_EXTRA_TYPE user_defined,yyscan_t* scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int Mate_lex_destroy (yyscan_t yyscanner );

int Mate_get_debug (yyscan_t yyscanner );

void Mate_set_debug (int debug_flag ,yyscan_t yyscanner );

YY_EXTRA_TYPE Mate_get_extra (yyscan_t yyscanner );

void Mate_set_extra (YY_EXTRA_TYPE user_defined ,yyscan_t yyscanner );

FILE *Mate_get_in (yyscan_t yyscanner );

void Mate_set_in  (FILE * _in_str ,yyscan_t yyscanner );

FILE *Mate_get_out (yyscan_t yyscanner );

void Mate_set_out  (FILE * _out_str ,yyscan_t yyscanner );

yy_size_t Mate_get_leng (yyscan_t yyscanner );

char *Mate_get_text (yyscan_t yyscanner );

int Mate_get_lineno (yyscan_t yyscanner );

void Mate_set_lineno (int _line_number ,yyscan_t yyscanner );

int Mate_get_column  (yyscan_t yyscanner );

void Mate_set_column (int _column_no ,yyscan_t yyscanner );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int Mate_wrap (yyscan_t yyscanner );
#else
extern int Mate_wrap (yyscan_t yyscanner );
#endif
#endif

#ifndef YY_NO_UNPUT
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int ,yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * ,yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (yyscan_t yyscanner );
#else
static int input (yyscan_t yyscanner );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int Mate_lex (yyscan_t yyscanner);

#define YY_DECL int Mate_lex (yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			Mate_ensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				Mate__create_buffer(yyin,YY_BUF_SIZE ,yyscanner);
		}

		Mate__load_buffer_state(yyscanner );
		}

	{
#line 221 "mate_parser.l"


#line 1062 "mate_parser.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yyg->yy_start;
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				yyg->yy_last_accepting_state = yy_current_state;
				yyg->yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 320 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 319 );
		yy_cp = yyg->yy_last_accepting_cpos;
		yy_current_state = yyg->yy_last_accepting_state;

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yyg->yy_hold_char;
			yy_cp = yyg->yy_last_accepting_cpos;
			yy_current_state = yyg->yy_last_accepting_state;
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 223 "mate_parser.l"
yyextra->current_frame->linenum++;
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 224 "mate_parser.l"
;
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 226 "mate_parser.l"
BEGIN INCLUDING;
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 228 "mate_parser.l"
{
	if ( yyextra->include_stack_ptr >= MAX_INCLUDE_DEPTH )
		g_error("dtd_preparse: include files nested too deeply");

	yyextra->include_stack[yyextra->include_stack_ptr++] = YY_CURRENT_BUFFER;
	yyin = ws_fopen( yytext, "r" );

	if (!yyin) {
		Mate__delete_buffer(YY_CURRENT_BUFFER, yyscanner);

		/* coverity[negative_sink] */
		Mate__switch_to_buffer(yyextra->include_stack[--yyextra->include_stack_ptr], yyscanner);

		if (errno)
			g_string_append_printf(yyextra->mc->config_error, "Mate parser: Could not open file: '%s': %s", yytext, g_strerror(errno) );

	} else {

		yyextra->current_frame = (mate_config_frame *)g_malloc(sizeof(mate_config_frame));
		yyextra->current_frame->filename = g_strdup(yytext);
		yyextra->current_frame->linenum = 1;

		g_ptr_array_add(yyextra->mc->config_stack,yyextra->current_frame);

		Mate__switch_to_buffer(Mate__create_buffer(yyin, YY_BUF_SIZE, yyscanner), yyscanner);
	}

	BEGIN OUTSIDE;
}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(OUTSIDE):
case YY_STATE_EOF(QUOTED):
case YY_STATE_EOF(INCLUDING):
case YY_STATE_EOF(COMMENT):
#line 258 "mate_parser.l"
{
	/* coverity[check_after_sink] */
	if ( --yyextra->include_stack_ptr < 0 ) {
		yyterminate();
	} else {
		Mate__delete_buffer(YY_CURRENT_BUFFER, yyscanner);
		Mate__switch_to_buffer(yyextra->include_stack[yyextra->include_stack_ptr], yyscanner);

		free_config_frame(yyextra->current_frame);
		yyextra->current_frame = (mate_config_frame *)g_ptr_array_remove_index(yyextra->mc->config_stack,yyextra->mc->config_stack->len-1);
	}
}
	YY_BREAK
case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 271 "mate_parser.l"
;
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 273 "mate_parser.l"
BEGIN COMMENT;
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 274 "mate_parser.l"
;
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 275 "mate_parser.l"
BEGIN OUTSIDE;
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 277 "mate_parser.l"
MATE_PARSE(TOKEN_PDU_KW);
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 278 "mate_parser.l"
MATE_PARSE(TOKEN_GOP_KW);
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 279 "mate_parser.l"
MATE_PARSE(TOKEN_GOG_KW);
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 280 "mate_parser.l"
MATE_PARSE(TOKEN_TRANSFORM_KW);
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 281 "mate_parser.l"
MATE_PARSE(TOKEN_MATCH_KW);
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 282 "mate_parser.l"
MATE_PARSE(TOKEN_STRICT_KW);
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 283 "mate_parser.l"
MATE_PARSE(TOKEN_EVERY_KW);
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 284 "mate_parser.l"
MATE_PARSE(TOKEN_LOOSE_KW);
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 285 "mate_parser.l"
MATE_PARSE(TOKEN_REPLACE_KW);
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 286 "mate_parser.l"
MATE_PARSE(TOKEN_INSERT_KW);
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 287 "mate_parser.l"
MATE_PARSE(TOKEN_GOP_TREE_KW);
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 288 "mate_parser.l"
MATE_PARSE(TOKEN_MEMBER_KW);
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 289 "mate_parser.l"
MATE_PARSE(TOKEN_ON_KW);
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 290 "mate_parser.l"
MATE_PARSE(TOKEN_START_KW);
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 291 "mate_parser.l"
MATE_PARSE(TOKEN_STOP_KW);
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 292 "mate_parser.l"
MATE_PARSE(TOKEN_EXTRA_KW);
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 293 "mate_parser.l"
MATE_PARSE(TOKEN_SHOW_TREE_KW);
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 294 "mate_parser.l"
MATE_PARSE(TOKEN_SHOW_TIMES_KW);
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 295 "mate_parser.l"
MATE_PARSE(TOKEN_EXPIRATION_KW);
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 296 "mate_parser.l"
MATE_PARSE(TOKEN_IDLE_TIMEOUT_KW);
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 297 "mate_parser.l"
MATE_PARSE(TOKEN_LIFETIME_KW);
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 298 "mate_parser.l"
MATE_PARSE(TOKEN_NO_TREE_KW);
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 299 "mate_parser.l"
MATE_PARSE(TOKEN_PDU_TREE_KW);
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 300 "mate_parser.l"
MATE_PARSE(TOKEN_FRAME_TREE_KW);
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 301 "mate_parser.l"
MATE_PARSE(TOKEN_BASIC_TREE_KW);
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 302 "mate_parser.l"
MATE_PARSE(TOKEN_TRUE_KW);
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 303 "mate_parser.l"
MATE_PARSE(TOKEN_FALSE_KW);
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 304 "mate_parser.l"
MATE_PARSE(TOKEN_PROTO_KW);
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 305 "mate_parser.l"
MATE_PARSE(TOKEN_PAYLOAD_KW);
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 306 "mate_parser.l"
MATE_PARSE(TOKEN_TRANSPORT_KW);
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 307 "mate_parser.l"
MATE_PARSE(TOKEN_CRITERIA_KW);
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 308 "mate_parser.l"
MATE_PARSE(TOKEN_ACCEPT_KW);
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 309 "mate_parser.l"
MATE_PARSE(TOKEN_REJECT_KW);
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 310 "mate_parser.l"
MATE_PARSE(TOKEN_EXTRACT_KW);
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 311 "mate_parser.l"
MATE_PARSE(TOKEN_FROM_KW);
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 312 "mate_parser.l"
MATE_PARSE(TOKEN_DROP_UNASSIGNED_KW);
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 313 "mate_parser.l"
MATE_PARSE(TOKEN_DISCARD_PDU_DATA_KW);
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 314 "mate_parser.l"
MATE_PARSE(TOKEN_LAST_PDU_KW);
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 315 "mate_parser.l"
MATE_PARSE(TOKEN_DONE_KW);
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 316 "mate_parser.l"
MATE_PARSE(TOKEN_FILENAME_KW);
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 317 "mate_parser.l"
MATE_PARSE(TOKEN_DEBUG_KW);
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 318 "mate_parser.l"
MATE_PARSE(TOKEN_LEVEL_KW);
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 319 "mate_parser.l"
MATE_PARSE(TOKEN_DEFAULT_KW);
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 321 "mate_parser.l"
MATE_PARSE(TOKEN_OPEN_PARENS);
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 322 "mate_parser.l"
MATE_PARSE(TOKEN_CLOSE_PARENS);
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 323 "mate_parser.l"
MATE_PARSE(TOKEN_OPEN_BRACE);
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 324 "mate_parser.l"
MATE_PARSE(TOKEN_CLOSE_BRACE);
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 325 "mate_parser.l"
MATE_PARSE(TOKEN_COMMA);
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 326 "mate_parser.l"
MATE_PARSE(TOKEN_SEMICOLON);
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 327 "mate_parser.l"
MATE_PARSE(TOKEN_SLASH);
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 328 "mate_parser.l"
MATE_PARSE(TOKEN_PIPE);
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 330 "mate_parser.l"
MATE_PARSE(TOKEN_INTEGER);
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 331 "mate_parser.l"
MATE_PARSE(TOKEN_FLOATING);
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 332 "mate_parser.l"
MATE_PARSE(TOKEN_DOTED_IP);
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 333 "mate_parser.l"
MATE_PARSE(TOKEN_COLONIZED);
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 334 "mate_parser.l"
MATE_PARSE(TOKEN_NAME);
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 335 "mate_parser.l"
MATE_PARSE(TOKEN_AVP_OPERATOR);
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 338 "mate_parser.l"
BEGIN QUOTED;
	YY_BREAK
case 67:
/* rule 67 can match eol */
YY_RULE_SETUP
#line 339 "mate_parser.l"
MATE_PARSE(TOKEN_QUOTED);
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 340 "mate_parser.l"
BEGIN OUTSIDE;
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 342 "mate_parser.l"
ECHO;
	YY_BREAK
#line 1510 "mate_parser.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * Mate_lex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yyg->yy_last_accepting_cpos;
				yy_current_state = yyg->yy_last_accepting_state;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( Mate_wrap(yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of Mate_lex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = yyg->yytext_ptr;
	yy_size_t number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (yy_size_t) (yyg->yy_c_buf_p - yyg->yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			yy_size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) (yyg->yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				yy_size_t new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					Mate_realloc((void *) b->yy_ch_buf,b->yy_buf_size + 2 ,yyscanner );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			Mate_restart(yyin  ,yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((int) (yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) Mate_realloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size ,yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_current_state = yyg->yy_start;

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yyg->yy_last_accepting_state = yy_current_state;
			yyg->yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 320 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
{
	int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */
	char *yy_cp = yyg->yy_c_buf_p;

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yyg->yy_last_accepting_state = yy_current_state;
		yyg->yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 320 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 319);

	(void)yyg;
	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			yy_size_t offset = yyg->yy_c_buf_p - yyg->yytext_ptr;
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					Mate_restart(yyin ,yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( Mate_wrap(yyscanner ) )
						return EOF;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void Mate_restart  (FILE * input_file , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        Mate_ensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            Mate__create_buffer(yyin,YY_BUF_SIZE ,yyscanner);
	}

	Mate__init_buffer(YY_CURRENT_BUFFER,input_file ,yyscanner);
	Mate__load_buffer_state(yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
    void Mate__switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		Mate_pop_buffer_state();
	 *		Mate_push_buffer_state(new_buffer);
     */
	Mate_ensure_buffer_stack (yyscanner);
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	Mate__load_buffer_state(yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (Mate_wrap()) processing, but the only time this flag
	 * is looked at is after Mate_wrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

static void Mate__load_buffer_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE Mate__create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) Mate_alloc(sizeof( struct yy_buffer_state ) ,yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in Mate__create_buffer()" );

	b->yy_buf_size = (yy_size_t)size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) Mate_alloc(b->yy_buf_size + 2 ,yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in Mate__create_buffer()" );

	b->yy_is_our_buffer = 1;

	Mate__init_buffer(b,file ,yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with Mate__create_buffer()
 * @param yyscanner The scanner object.
 */
    void Mate__delete_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		Mate_free((void *) b->yy_ch_buf ,yyscanner );

	Mate_free((void *) b ,yyscanner );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a Mate_restart() or at EOF.
 */
    static void Mate__init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	Mate__flush_buffer(b ,yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then Mate__init_buffer was _probably_
     * called from Mate_restart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
    void Mate__flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		Mate__load_buffer_state(yyscanner );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */
void Mate_push_buffer_state (YY_BUFFER_STATE new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (new_buffer == NULL)
		return;

	Mate_ensure_buffer_stack(yyscanner);

	/* This block is copied from Mate__switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		yyg->yy_buffer_stack_top++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from Mate__switch_to_buffer. */
	Mate__load_buffer_state(yyscanner );
	yyg->yy_did_buffer_switch_on_eof = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */
void Mate_pop_buffer_state (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (!YY_CURRENT_BUFFER)
		return;

	Mate__delete_buffer(YY_CURRENT_BUFFER ,yyscanner);
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if (yyg->yy_buffer_stack_top > 0)
		--yyg->yy_buffer_stack_top;

	if (YY_CURRENT_BUFFER) {
		Mate__load_buffer_state(yyscanner );
		yyg->yy_did_buffer_switch_on_eof = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void Mate_ensure_buffer_stack (yyscan_t yyscanner)
{
	yy_size_t num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		yyg->yy_buffer_stack = (struct yy_buffer_state**)Mate_alloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in Mate_ensure_buffer_stack()" );
								  
		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)Mate_realloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in Mate_ensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE Mate__scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) Mate_alloc(sizeof( struct yy_buffer_state ) ,yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in Mate__scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	Mate__switch_to_buffer(b ,yyscanner );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to Mate_lex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       Mate__scan_bytes() instead.
 */
YY_BUFFER_STATE Mate__scan_string (yyconst char * yystr , yyscan_t yyscanner)
{
    
	return Mate__scan_bytes(yystr,strlen(yystr) ,yyscanner);
}

/** Setup the input buffer state to scan the given bytes. The next call to Mate_lex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE Mate__scan_bytes  (yyconst char * yybytes, yy_size_t  _yybytes_len , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	yy_size_t i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) Mate_alloc(n ,yyscanner );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in Mate__scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = Mate__scan_buffer(buf,n ,yyscanner);
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in Mate__scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;
	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */
YY_EXTRA_TYPE Mate_get_extra  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyextra;
}

/** Get the current line number.
 * @param yyscanner The scanner object.
 */
int Mate_get_lineno  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    
        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yylineno;
}

/** Get the current column number.
 * @param yyscanner The scanner object.
 */
int Mate_get_column  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    
        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yycolumn;
}

/** Get the input stream.
 * @param yyscanner The scanner object.
 */
FILE *Mate_get_in  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyin;
}

/** Get the output stream.
 * @param yyscanner The scanner object.
 */
FILE *Mate_get_out  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyout;
}

/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */
yy_size_t Mate_get_leng  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyleng;
}

/** Get the current token.
 * @param yyscanner The scanner object.
 */

char *Mate_get_text  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yytext;
}

/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void Mate_set_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/** Set the current line number.
 * @param _line_number line number
 * @param yyscanner The scanner object.
 */
void Mate_set_lineno (int  _line_number , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* lineno is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "Mate_set_lineno called with no buffer" );
    
    yylineno = _line_number;
}

/** Set the current column.
 * @param _column_no column number
 * @param yyscanner The scanner object.
 */
void Mate_set_column (int  _column_no , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* column is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "Mate_set_column called with no buffer" );
    
    yycolumn = _column_no;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see Mate__switch_to_buffer
 */
void Mate_set_in (FILE *  _in_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyin = _in_str ;
}

void Mate_set_out (FILE *  _out_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyout = _out_str ;
}

int Mate_get_debug  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yy_flex_debug;
}

void Mate_set_debug (int  _bdebug , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yy_flex_debug = _bdebug ;
}

/* Accessor methods for yylval and yylloc */

/* User-visible API */

/* Mate_lex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */

int Mate_lex_init(yyscan_t* ptr_yy_globals)

{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) Mate_alloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* Mate_lex_init_extra has the same functionality as Mate_lex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to Mate_alloc in
 * the yyextra field.
 */

int Mate_lex_init_extra(YY_EXTRA_TYPE yy_user_defined,yyscan_t* ptr_yy_globals )

{
    struct yyguts_t dummy_yyguts;

    Mate_set_extra (yy_user_defined, &dummy_yyguts);

    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }
	
    *ptr_yy_globals = (yyscan_t) Mate_alloc ( sizeof( struct yyguts_t ), &dummy_yyguts );
	
    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }
    
    /* By setting to 0xAA, we expose bugs in
    yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));
    
    Mate_set_extra (yy_user_defined, *ptr_yy_globals);
    
    return yy_init_globals ( *ptr_yy_globals );
}

static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from Mate_lex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = 0;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = (char *) 0;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = (FILE *) 0;
    yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * Mate_lex_init()
     */
    return 0;
}

/* Mate_lex_destroy is for both reentrant and non-reentrant scanners. */
int Mate_lex_destroy  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		Mate__delete_buffer(YY_CURRENT_BUFFER ,yyscanner );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		Mate_pop_buffer_state(yyscanner);
	}

	/* Destroy the stack itself. */
	Mate_free(yyg->yy_buffer_stack ,yyscanner);
	yyg->yy_buffer_stack = NULL;

    /* Destroy the start condition stack. */
        Mate_free(yyg->yy_start_stack ,yyscanner );
        yyg->yy_start_stack = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * Mate_lex() is called, initialization will occur. */
    yy_init_globals( yyscanner);

    /* Destroy the main struct (reentrant only). */
    Mate_free ( yyscanner , yyscanner );
    yyscanner = NULL;
    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;

	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s , yyscan_t yyscanner)
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

#define YYTABLES_NAME "yytables"

#line 342 "mate_parser.l"



extern gboolean mate_load_config(const gchar* filename, mate_config* mc) {
	FILE *in;
	yyscan_t scanner;
	Mate_scanner_state_t state;
	volatile gboolean status = TRUE;

	in = ws_fopen(filename,"r");

	if (!in) {
		g_string_append_printf(mc->config_error,"Mate parser: Could not open file: '%s', error: %s", filename, g_strerror(errno) );
		return FALSE;
	}

	if (Mate_lex_init(&scanner) != 0) {
		g_string_append_printf(mc->config_error, "Mate parse: Could not initialize scanner: %s", g_strerror(errno));
		fclose(in);
		return FALSE;
	}

	Mate_set_in(in, scanner);

	mc->config_stack = g_ptr_array_new();

	state.mc = mc;

	state.current_frame = (mate_config_frame *)g_malloc(sizeof(mate_config_frame));
	state.current_frame->filename = g_strdup(filename);
	state.current_frame->linenum = 1;

	g_ptr_array_add(mc->config_stack,state.current_frame);

	state.pParser = MateParserAlloc(g_malloc);

	state.include_stack_ptr = 0;

	/* Associate the state with the scanner */
	Mate_set_extra(&state, scanner);

	/* MateParserTrace(stdout,""); */

	TRY {
		Mate_lex(scanner);

		/* Inform parser that end of input has reached. */
		MateParser(state.pParser, 0, NULL, mc);

		MateParserFree(state.pParser, g_free);
	} CATCH(MateConfigError) {
		status = FALSE;
	} CATCH_ALL {
		status = FALSE;
		g_string_append_printf(mc->config_error,"An unexpected error occurred");
	}
	ENDTRY;

	Mate_lex_destroy(scanner);
	fclose(in);

	g_ptr_array_foreach(mc->config_stack, (GFunc)free_config_frame, NULL);
	g_ptr_array_free(mc->config_stack, FALSE);

	return status;
}

