Object.defineProperty(exports, "__esModule", { value: true });
























var _react = require("react");var _react2 = _interopRequireDefault(_react);
var _classnames = require("classnames");var _classnames2 = _interopRequireDefault(_classnames);function _interopRequireDefault(obj) {return obj && obj.__esModule ? obj : { default: obj };}function _extends() {_extends = Object.assign || function (target) {for (var i = 1; i < arguments.length; i++) {var source = arguments[i];for (var key in source) {if (Object.prototype.hasOwnProperty.call(source, key)) {target[key] = source[key];}}}return target;};return _extends.apply(this, arguments);}

const MAX_UNEXPANDED_ALL_NOTES = 7;

const NoteRow = /*#__PURE__*/(0, _react.memo)(({ id, title, body, date, onClick, onKeyDown, onContextMenu, parentItemType, parentTitle }) => {
  return /*#__PURE__*/(
    _react2.default.createElement("div", {
      tabIndex: -1,
      className: (0, _classnames2.default)('note-row', { 'standalone-note-row': !parentItemType }),
      onClick: () => onClick(id),
      onContextMenu: (event) => onContextMenu(id, event),
      onKeyDown: onKeyDown }, /*#__PURE__*/

    _react2.default.createElement("div", { className: "inner" },
    parentItemType ? /*#__PURE__*/
    _react2.default.createElement("div", { className: "parent-line" }, /*#__PURE__*/
    _react2.default.createElement("img", { className: "parent-item-type", src: Zotero.ItemTypes.getImageSrc(parentItemType) }), /*#__PURE__*/
    _react2.default.createElement("span", { className: "parent-title" }, parentTitle)) :

    null, /*#__PURE__*/

    _react2.default.createElement("div", { className: "title-line" }, /*#__PURE__*/
    _react2.default.createElement("div", { className: "title" }, title)), /*#__PURE__*/

    _react2.default.createElement("div", { className: "body-line" }, /*#__PURE__*/
    _react2.default.createElement("div", { className: "date" }, date), /*#__PURE__*/
    _react2.default.createElement("div", { className: "body" }, body)))));




});

const NotesList = /*#__PURE__*/(0, _react.forwardRef)(({ onClick, onContextMenu, onAddChildButtonDown, onAddStandaloneButtonDown }, ref) => {
  const [notes, setNotes] = (0, _react.useState)([]);
  const [expanded, setExpanded] = (0, _react.useState)(false);
  const [numVisible, setNumVisible] = (0, _react.useState)(0);
  const [hasParent, setHasParent] = (0, _react.useState)(true);

  const _setExpanded = (value) => {
    setExpanded(value);
    if (value) {
      setNumVisible(numVisible + 1000);
    } else
    {
      setNumVisible(0);
    }
  };

  (0, _react.useImperativeHandle)(ref, () => ({
    setNotes,
    setHasParent,
    setExpanded: _setExpanded }));


  function handleClickMore() {
    _setExpanded(true);
  }

  function handleButtonKeydown(event) {
    if (event.key === 'Tab' && !event.shiftKey) {
      let node = event.target.parentElement.parentElement.querySelector('[tabindex="-1"]');
      if (node) {
        node.focus();
        event.preventDefault();
      }
    } else
    if (event.key === 'Tab' && event.shiftKey) {
      let prevSection = event.target.parentElement.parentElement.previousElementSibling;
      if (prevSection) {
        let node = prevSection.querySelector('[tabindex="-1"]:last-child');
        if (node) {
          node.focus();
          event.preventDefault();
        }
      }
    }
  }

  function handleRowKeyDown(event) {
    if (['Enter', 'Space'].includes(event.key)) {
      // Focus the previous row, because "more-row" will disappear
      if (event.target.classList.contains('more-row')) {
        let node = event.target.previousElementSibling;
        if (node) {
          node.focus();
          event.preventDefault();
        }
      }
      event.target.click();
    } else
    if (event.key === 'ArrowUp') {
      let node = event.target.previousElementSibling;
      if (node) {
        node.focus();
        event.preventDefault();
      }
    } else
    if (event.key === 'ArrowDown') {
      let node = event.target.nextElementSibling;
      if (node) {
        node.focus();
        event.preventDefault();
      }
    }
  }

  let childNotes = notes.filter((x) => x.isCurrentChild);
  let allNotes = notes.filter((x) => !x.isCurrentChild);
  let visibleNotes = allNotes.slice(0, expanded ? numVisible : MAX_UNEXPANDED_ALL_NOTES);
  return /*#__PURE__*/(
    _react2.default.createElement("div", { className: "notes-list" },
    hasParent && /*#__PURE__*/_react2.default.createElement("section", null, /*#__PURE__*/
    _react2.default.createElement("div", { className: "header-row" }, /*#__PURE__*/
    _react2.default.createElement("h2", null, Zotero.getString('pane.context.itemNotes')), /*#__PURE__*/
    _react2.default.createElement("button", { onMouseDown: onAddChildButtonDown, onClick: onAddChildButtonDown, onKeyDown: handleButtonKeydown }, "+")),

    !childNotes.length && /*#__PURE__*/_react2.default.createElement("div", { className: "empty-row" }, Zotero.getString('pane.context.noNotes')),
    childNotes.map((note) => /*#__PURE__*/_react2.default.createElement(NoteRow, _extends({ key: note.id }, note, {
      onClick: onClick, onKeyDown: handleRowKeyDown, onContextMenu: onContextMenu })))), /*#__PURE__*/

    _react2.default.createElement("section", null, /*#__PURE__*/
    _react2.default.createElement("div", { className: "header-row" }, /*#__PURE__*/
    _react2.default.createElement("h2", null, Zotero.getString('pane.context.allNotes')), /*#__PURE__*/
    _react2.default.createElement("button", { onMouseDown: onAddStandaloneButtonDown, onClick: onAddStandaloneButtonDown, onKeyDown: handleButtonKeydown }, "+")),

    !allNotes.length && /*#__PURE__*/_react2.default.createElement("div", { className: "empty-row" }, Zotero.getString('pane.context.noNotes')),
    visibleNotes.map((note) => /*#__PURE__*/_react2.default.createElement(NoteRow, _extends({ key: note.id }, note, {
      onClick: onClick, onKeyDown: handleRowKeyDown, onContextMenu: onContextMenu }))),
    allNotes.length > visibleNotes.length && /*#__PURE__*/
    _react2.default.createElement("div", { className: "more-row", tabIndex: -1, onClick: handleClickMore, onKeyDown: handleRowKeyDown },
    Zotero.getString('general.numMore', Zotero.Utilities.numberFormat(
    [allNotes.length - visibleNotes.length], 0))))));





});exports.default =

NotesList;