/*
    ***** BEGIN LICENSE BLOCK *****

    Copyright © 2020 Corporation for Digital Scholarship
                     Vienna, Virginia, USA
                     https://digitalscholar.org

    This file is part of Zotero.

    Zotero is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Zotero is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with Zotero.  If not, see <http://www.gnu.org/licenses/>.

    ***** END LICENSE BLOCK *****
*/

'use strict';

var _react = require("react");var _react2 = _interopRequireDefault(_react);
var _reactDom = require("react-dom");var _reactDom2 = _interopRequireDefault(_reactDom);
var _propTypes = require("prop-types");var _propTypes2 = _interopRequireDefault(_propTypes);
var _classnames = require("classnames");var _classnames2 = _interopRequireDefault(_classnames);function _interopRequireDefault(obj) {return obj && obj.__esModule ? obj : { default: obj };}

function CreateParent({ loading, item, toggleAccept }) {
  // When the input has/does not have characters toggle the accept button on the dialog
  const handleInput = (e) => {
    if (e.target.value.trim() !== '') {
      toggleAccept(true);
    } else
    {
      toggleAccept(false);
    }
  };

  return /*#__PURE__*/(
    _react2.default.createElement("div", { className: "create-parent-container" }, /*#__PURE__*/
    _react2.default.createElement("span", { className: "title" },
    item.attachmentFilename), /*#__PURE__*/

    _react2.default.createElement("div", { className: "body" }, /*#__PURE__*/
    _react2.default.createElement("input", {
      id: "parent-item-identifier",
      placeholder: Zotero.getString('createParent.prompt'),
      size: "50",
      disabled: loading,
      onChange: handleInput }), /*#__PURE__*/

    _react2.default.createElement("div", {
      mode: "undetermined",
      className: (0, _classnames2.default)('downloadProgress', { hidden: !loading }) }, /*#__PURE__*/

    _react2.default.createElement("div", { className: "progress-bar" })))));




}


CreateParent.propTypes = {
  loading: _propTypes2.default.bool,
  item: _propTypes2.default.object,
  toggleAccept: _propTypes2.default.func };


Zotero.CreateParent = /*#__PURE__*/(0, _react.memo)(CreateParent);


Zotero.CreateParent.destroy = (domEl) => {
  _reactDom2.default.unmountComponentAtNode(domEl);
};


Zotero.CreateParent.render = (domEl, props) => {
  _reactDom2.default.render( /*#__PURE__*/_react2.default.createElement(CreateParent, props), domEl);
};