/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.patch;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchFileStream;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchTarget;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchTargetInfo;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.patch.ISvnPatchContext;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnDiffHunk;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnHunkInfo;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnPatch;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnPropertiesPatch;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnPropertiesPatchTarget;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnTargetContent;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnWcPatchContext;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.ISvnPatchHandler;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnPatchTarget
extends SvnTargetContent {
    private static final int MAX_FUZZ = 2;
    private File absPath;
    private File relPath;
    private File patchedAbsPath;
    private File rejectAbsPath;
    private File moveTargetAbsPath;
    private boolean filtered;
    private boolean skipped;
    private boolean hasTextChanges;
    private boolean added;
    private boolean deleted;
    private boolean hasPropChanges;
    private Map<String, SvnPropertiesPatchTarget> propTargets = new HashMap<String, SvnPropertiesPatchTarget>();
    private boolean special;
    private boolean symlink;
    private boolean replaced;
    private boolean locallyDeleted;
    private boolean obstructed;
    private SVNNodeKind kindOnDisk;
    private SVNNodeKind dbKind;
    private SvnDiffCallback.OperationKind operation;
    private boolean gitSymlinkFormat;
    private File originalContentFile;
    private boolean hasLocalModifications;
    private boolean hadRejects;
    private boolean hadPropRejects;
    private boolean hadAlreadyApplied;
    private boolean executable;
    private File canonPathFromPatchfile;
    private String eolStr;
    private SVNPatchFileStream stream;
    private SVNPatchFileStream patchedStream;
    private SVNPatchFileStream rejectStream;

    public boolean isFiltered() {
        return this.filtered;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public boolean hasTextChanges() {
        return this.hasTextChanges;
    }

    public boolean isAdded() {
        return this.added;
    }

    public File getAbsPath() {
        return this.absPath;
    }

    public File getMoveTargetAbsPath() {
        return this.moveTargetAbsPath;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean hasPropChanges() {
        return this.hasPropChanges;
    }

    public void setSpecial(boolean special) {
        this.special = special;
    }

    public Map<String, SvnPropertiesPatchTarget> getPropTargets() {
        return this.propTargets;
    }

    @Override
    public String getEolStr() {
        return this.eolStr;
    }

    public File getRejectAbsPath() {
        return this.rejectAbsPath;
    }

    public void setRejectAbsPath(File rejectAbsPath) {
        this.rejectAbsPath = rejectAbsPath;
    }

    public SVNPatchFileStream getStream() {
        return this.stream;
    }

    public SVNPatchFileStream getPatchedStream() {
        return this.patchedStream;
    }

    public void setPatchedStream(SVNPatchFileStream patchedStream) {
        this.patchedStream = patchedStream;
    }

    public SVNPatchFileStream getRejectStream() {
        return this.rejectStream;
    }

    public void setRejectStream(SVNPatchFileStream rejectStream) {
        this.rejectStream = rejectStream;
    }

    @Deprecated
    public static SvnPatchTarget applyPatch(SvnPatch patch, File workingCopyDirectory, int stripCount, SVNWCContext context, boolean ignoreWhitespace, boolean removeTempFiles, ISvnPatchHandler patchHandler) throws SVNException, IOException {
        SvnWcPatchContext patchContext = new SvnWcPatchContext(context);
        return SvnPatchTarget.applyPatch(patch, workingCopyDirectory, stripCount, new ArrayList<SVNPatchTargetInfo>(), patchContext, ignoreWhitespace, removeTempFiles, patchHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static SvnPatchTarget applyPatch(SvnPatch patch, File workingCopyDirectory, int stripCount, List<SVNPatchTargetInfo> targetInfos, ISvnPatchContext patchContext, boolean ignoreWhitespace, boolean removeTempFiles, ISvnPatchHandler patchHandler) throws SVNException, IOException {
        Object propTarget;
        SvnHunkInfo hunkInfo;
        SvnPatchTarget target;
        block47: {
            block48: {
                block49: {
                    boolean bl;
                    InputStream binaryDiffResultStream;
                    boolean bl2;
                    block46: {
                        boolean filtered;
                        target = SvnPatchTarget.initPatchTarget(patch, workingCopyDirectory, stripCount, removeTempFiles, targetInfos, patchContext);
                        if (target.isSkipped()) {
                            return target;
                        }
                        if (patchHandler != null && (filtered = patchHandler.singlePatch(target.getCanonPathFromPatchfile(), target.getPatchedAbsPath(), target.getRejectAbsPath()))) {
                            target.setFiltered(true);
                            return target;
                        }
                        List<SvnDiffHunk> hunks = patch.getHunks();
                        if (hunks.size() <= 0) break block46;
                        for (SvnDiffHunk svnDiffHunk : hunks) {
                            int fuzz = 0;
                            while ((hunkInfo = target.getHunkInfo(svnDiffHunk, target, fuzz, ignoreWhitespace, false)).isRejected() && ++fuzz <= 2 && !hunkInfo.isAlreadyApplied()) {
                            }
                            target.addHunkInfo(hunkInfo);
                        }
                        for (SvnHunkInfo svnHunkInfo : target.getHunkInfos()) {
                            if (svnHunkInfo.isAlreadyApplied()) {
                                target.setHadAlreadyApplied(true);
                                continue;
                            }
                            if (svnHunkInfo.isRejected()) {
                                SvnPatchTarget.rejectHunk(target, svnHunkInfo.getHunk(), null);
                                continue;
                            }
                            SvnPatchTarget.applyHunk(target, target, svnHunkInfo, null);
                        }
                        if (target.getKindOnDisk() == SVNNodeKind.FILE) {
                            SvnPatchTarget.copyLinesToTarget(target, 0);
                            if (!target.isEof()) {
                                target.setSkipped(true);
                            }
                        }
                        break block47;
                    }
                    if (patch.getBinaryPatch() == null) break block48;
                    Object originalFileInputStream = target.getOriginalContentFile() != null ? new BufferedInputStream(new FileInputStream(target.getOriginalContentFile())) : SVNFileUtil.DUMMY_IN;
                    InputStream binaryDiffOriginalStream = null;
                    try {
                        binaryDiffOriginalStream = patch.getBinaryPatch().getBinaryDiffOriginalStream();
                        bl2 = SvnPatchTarget.areStreamsSame((InputStream)originalFileInputStream, binaryDiffOriginalStream);
                    }
                    finally {
                        SVNFileUtil.closeFile(binaryDiffOriginalStream);
                        SVNFileUtil.closeFile((InputStream)originalFileInputStream);
                    }
                    if (bl2) {
                        target.setHasTextChanges(true);
                    } else {
                        originalFileInputStream = target.getOriginalContentFile() != null ? new BufferedInputStream(new FileInputStream(target.getOriginalContentFile())) : SVNFileUtil.DUMMY_IN;
                        try {
                            binaryDiffResultStream = patch.getBinaryPatch().getBinaryDiffResultStream();
                            bl = SvnPatchTarget.areStreamsSame((InputStream)originalFileInputStream, binaryDiffResultStream);
                            if (bl) {
                                target.setHadAlreadyApplied(true);
                            }
                        }
                        finally {
                            SVNFileUtil.closeFile(binaryDiffOriginalStream);
                            SVNFileUtil.closeFile((InputStream)originalFileInputStream);
                        }
                    }
                    if (!bl) break block49;
                    binaryDiffResultStream = null;
                    FileOutputStream fileOutputStream = null;
                    try {
                        binaryDiffResultStream = patch.getBinaryPatch().getBinaryDiffResultStream();
                        fileOutputStream = new FileOutputStream(target.getPatchedAbsPath());
                        SvnPatchTarget.copyStream(binaryDiffResultStream, fileOutputStream);
                        fileOutputStream.flush();
                    }
                    catch (Throwable throwable) {
                        SVNFileUtil.closeFile(binaryDiffResultStream);
                        SVNFileUtil.closeFile(fileOutputStream);
                        throw throwable;
                    }
                    SVNFileUtil.closeFile(binaryDiffResultStream);
                    SVNFileUtil.closeFile(fileOutputStream);
                    break block47;
                }
                target.setSkipped(true);
                break block47;
            }
            if (target.getMoveTargetAbsPath() != null && target.getKindOnDisk() == SVNNodeKind.FILE) {
                SvnPatchTarget.copyLinesToTarget(target, 0);
                if (!target.isEof()) {
                    target.setSkipped(true);
                }
            }
        }
        if (target.hadRejects() || target.isLocallyDeleted()) {
            target.setDeleted(false);
        }
        if (target.isAdded() && !target.isLocallyDeleted() && target.getDbKind() != SVNNodeKind.NONE) {
            target.setAdded(false);
        }
        target.setSpecial(target.isSymlink());
        for (Map.Entry entry : patch.getPropPatches().entrySet()) {
            String propName = (String)entry.getKey();
            SvnPropertiesPatch propPatch = (SvnPropertiesPatch)entry.getValue();
            if ("svn:special".equals(propName)) {
                target.setSpecial(propPatch.getOperation() != SvnDiffCallback.OperationKind.Deleted);
            }
            Map<String, SvnPropertiesPatchTarget> propTargets = target.getPropTargets();
            SvnPropertiesPatchTarget propTarget2 = propTargets.get(propName);
            List<SvnDiffHunk> propPatchHunks = propPatch.getHunks();
            for (SvnDiffHunk hunk : propPatchHunks) {
                SvnHunkInfo hunkInfo3;
                int fuzz = 0;
                while ((hunkInfo3 = target.getHunkInfo(hunk, propTarget2, fuzz, ignoreWhitespace, true)).isRejected() && ++fuzz <= 2 && !hunkInfo3.isAlreadyApplied()) {
                }
                propTarget2.addHunkInfo(hunkInfo3);
            }
        }
        if (patch.getNewExecutableBit() != null && patch.getNewExecutableBit() != patch.getOldExecutableBit() && target.getPropTargets().get("svn:executable") != null && patch.getPropPatches().get("svn:executable") == null) {
            void var11_20;
            propTarget = target.getPropTargets().get("svn:executable");
            if (patch.getNewExecutableBit() == Boolean.TRUE) {
                SvnDiffHunk svnDiffHunk = SvnPatchTarget.createAddsSingleLine(patch, SVNPropertyValue.getPropertyAsString(SVNProperty.getValueOfBooleanProperty("svn:executable")), patchContext, workingCopyDirectory);
            } else {
                SvnDiffHunk svnDiffHunk = SvnPatchTarget.createDeletesSingleLine(patch, SVNPropertyValue.getPropertyAsString(SVNProperty.getValueOfBooleanProperty("svn:executable")), patchContext, workingCopyDirectory);
            }
            hunkInfo = target.getHunkInfo((SvnDiffHunk)var11_20, (SvnTargetContent)propTarget, 0, ignoreWhitespace, true);
            ((SvnTargetContent)propTarget).addHunkInfo(hunkInfo);
        }
        if (patch.getNewSymlinkBit() != null && patch.getNewSymlinkBit() != patch.getOldSymlinkBit() && target.getPropTargets().get("svn:special") != null && patch.getPropPatches().get("svn:special") == null) {
            void var11_23;
            propTarget = target.getPropTargets().get("svn:special");
            if (patch.getNewSymlinkBit() == Boolean.TRUE) {
                SvnDiffHunk svnDiffHunk = SvnPatchTarget.createAddsSingleLine(patch, SVNPropertyValue.getPropertyAsString(SVNProperty.getValueOfBooleanProperty("svn:special")), patchContext, workingCopyDirectory);
                target.setSpecial(true);
            } else {
                SvnDiffHunk svnDiffHunk = SvnPatchTarget.createDeletesSingleLine(patch, SVNPropertyValue.getPropertyAsString(SVNProperty.getValueOfBooleanProperty("svn:special")), patchContext, workingCopyDirectory);
                target.setSpecial(false);
            }
            hunkInfo = target.getHunkInfo((SvnDiffHunk)var11_23, (SvnTargetContent)propTarget, 0, ignoreWhitespace, true);
            ((SvnTargetContent)propTarget).addHunkInfo(hunkInfo);
        }
        if (target.isDeleted() || !target.isAdded() && (target.isLocallyDeleted() || target.getDbKind() == SVNNodeKind.NONE)) {
            for (Map.Entry<String, SvnPropertiesPatchTarget> entry : target.getPropTargets().entrySet()) {
                SvnPropertiesPatchTarget propTarget3 = entry.getValue();
                if (propTarget3.getOperation() == SvnDiffCallback.OperationKind.Deleted) continue;
                for (SvnHunkInfo hunkInfo4 : propTarget3.getHunkInfos()) {
                    if (hunkInfo4.isAlreadyApplied() || hunkInfo4.isRejected()) continue;
                    hunkInfo4.setRejected(true);
                    propTarget3.setSkipped(true);
                    if (target.isDeleted() || target.isAdded()) continue;
                    target.setSkipped(true);
                }
            }
        }
        TreeMap<String, SvnPropertiesPatchTarget> propTargets = new TreeMap<String, SvnPropertiesPatchTarget>(target.getPropTargets());
        for (Map.Entry entry : propTargets.entrySet()) {
            SvnPropertiesPatchTarget propTarget4 = (SvnPropertiesPatchTarget)entry.getValue();
            boolean appliedOne = false;
            List<SvnHunkInfo> hunkInfos = propTarget4.getHunkInfos();
            for (SvnHunkInfo hunkInfo5 : hunkInfos) {
                if (hunkInfo5.isAlreadyApplied()) {
                    target.setHadAlreadyApplied(true);
                    continue;
                }
                if (hunkInfo5.isRejected()) {
                    SvnPatchTarget.rejectHunk(target, hunkInfo5.getHunk(), propTarget4.getName());
                    continue;
                }
                SvnPatchTarget.applyHunk(target, propTarget4, hunkInfo5, propTarget4.getName());
                appliedOne = true;
            }
            if (!appliedOne) {
                propTarget4.setSkipped(true);
            }
            if (!appliedOne || !propTarget4.isExisted()) continue;
            SvnPatchTarget.copyLinesToTarget(propTarget4, 0);
            if (propTarget4.isEof()) continue;
            propTarget4.setSkipped(true);
        }
        if (!target.isSymlink()) {
            if (target.getKindOnDisk() == SVNNodeKind.FILE) {
                target.getStream().close();
            }
            target.getPatchedStream().close();
        }
        return target;
    }

    private static void copyStream(InputStream sourceStream, FileOutputStream targetStream) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        while ((bytesRead = sourceStream.read(buffer)) >= 0) {
            targetStream.write(buffer, 0, bytesRead);
        }
    }

    private static boolean areStreamsSame(InputStream stream1, InputStream stream2) throws IOException {
        int bufferLength = 8192;
        byte[] buffer1 = new byte[8192];
        byte[] buffer2 = new byte[8192];
        block0: while (true) {
            int bytesRead1 = SvnPatch.readFully(stream1, buffer1, 0, 8192);
            int bytesRead2 = SvnPatch.readFully(stream2, buffer2, 0, 8192);
            if (bytesRead1 < 0) {
                return bytesRead2 < 0;
            }
            if (bytesRead1 != bytesRead2) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= bytesRead1) continue block0;
                if (buffer1[i] != buffer2[i]) {
                    return false;
                }
                ++i;
            }
            break;
        }
    }

    private static void rejectHunk(SvnPatchTarget target, SvnDiffHunk hunk, String propName) throws SVNException {
        try {
            String atat;
            String textAtat = "@@";
            String propAtat = "##";
            if (propName != null) {
                String propHeader = "Property: " + propName + "\n";
                target.getRejectStream().write(propHeader);
                atat = propAtat;
            } else {
                atat = textAtat;
            }
            String hunkHeader = String.format("%s -%s,%s +%s,%s %s\n", atat, hunk.getDirectedOriginalStart(), hunk.getDirectedOriginalLength(), hunk.getDirectedModifiedStart(), hunk.getDirectedModifiedLength(), atat);
            target.getRejectStream().write(hunkHeader);
            boolean[] eof = new boolean[1];
            String[] eolStr = new String[1];
            do {
                String hunkLine = hunk.readLineDiffText(eolStr, eof);
                if (eof[0]) continue;
                if (hunkLine.length() >= 1) {
                    target.getRejectStream().write(hunkLine);
                }
                if (eolStr[0] == null) continue;
                target.getRejectStream().write(eolStr[0]);
            } while (!eof[0]);
            if (propName != null) {
                target.setHadPropRejects(true);
            } else {
                target.setHadRejects(true);
            }
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
    }

    private static void applyHunk(SvnPatchTarget target, SvnTargetContent targetContent, SvnHunkInfo hunkInfo, String propName) throws SVNException {
        if (target.getKindOnDisk() == SVNNodeKind.FILE || propName != null) {
            SvnPatchTarget.copyLinesToTarget(targetContent, hunkInfo.getMatchedLine() + hunkInfo.getFuzz());
            int line = targetContent.getCurrentLine() + hunkInfo.getHunk().getDirectedOriginalLength() - 2 * hunkInfo.getFuzz();
            targetContent.seekToLine(line);
            if (targetContent.getCurrentLine() != line && !targetContent.isEof()) {
                hunkInfo.setRejected(true);
                SvnPatchTarget.rejectHunk(target, hunkInfo.getHunk(), propName);
                return;
            }
        }
        int linesRead = 0;
        hunkInfo.getHunk().resetModifiedText();
        boolean[] eof = new boolean[1];
        do {
            String[] eolStr = new String[1];
            String hunkLine = hunkInfo.getHunk().readLineModifiedText(eolStr, eof);
            if (++linesRead <= hunkInfo.getFuzz() || linesRead > hunkInfo.getHunk().getDirectedModifiedLength() - hunkInfo.getFuzz()) continue;
            if (hunkLine.length() >= 1) {
                targetContent.getWriteCallback().write(target.getWriteBaton(), hunkLine);
            }
            if (eolStr[0] == null) continue;
            if (targetContent.getEolStyle() != SVNWCContext.SVNEolStyle.None) {
                eolStr[0] = targetContent.getEolStr();
            }
            targetContent.getWriteCallback().write(target.getWriteBaton(), eolStr[0]);
        } while (!eof[0]);
        if (propName != null) {
            target.setHasPropChanges(true);
        } else {
            target.setHasTextChanges(true);
        }
    }

    private SvnHunkInfo getHunkInfo(SvnDiffHunk hunk, SvnTargetContent targetContent, int fuzz, boolean ignoreWhitespace, boolean isPropHunk) throws SVNException {
        int matchedLine;
        int originalStart = hunk.getDirectedOriginalStart();
        boolean alreadyApplied = false;
        if (originalStart == 0 && fuzz > 0) {
            matchedLine = 0;
        } else if (originalStart == 0 && !isPropHunk) {
            if (this.getKindOnDisk() == SVNNodeKind.FILE) {
                SVNFileType kind = SVNFileType.getType(this.getAbsPath());
                boolean special = kind == SVNFileType.SYMLINK;
                long fileLength = SVNFileUtil.getFileLength(this.getAbsPath());
                if (kind == SVNFileType.FILE && !special && fileLength == 0L) {
                    matchedLine = 1;
                } else if (this.getDbKind() == SVNNodeKind.FILE) {
                    boolean fileMatches = targetContent.matchExistingTarget(hunk);
                    if (fileMatches) {
                        matchedLine = 1;
                        alreadyApplied = true;
                    } else {
                        matchedLine = 0;
                    }
                } else {
                    matchedLine = 0;
                }
            } else {
                matchedLine = 1;
            }
        } else if (originalStart == 0 && isPropHunk) {
            if (targetContent.isExisted()) {
                boolean propMatches = targetContent.matchExistingTarget(hunk);
                if (propMatches) {
                    matchedLine = 1;
                    alreadyApplied = true;
                } else {
                    matchedLine = 0;
                }
            } else {
                matchedLine = 1;
            }
        } else if (originalStart > 0 && targetContent.isExisted()) {
            int savedLine = targetContent.getCurrentLine();
            targetContent.seekToLine(originalStart);
            matchedLine = targetContent.getCurrentLine() != originalStart ? 0 : targetContent.scanForMatch(hunk, true, originalStart + 1, fuzz, ignoreWhitespace, false, null);
            if (matchedLine != originalStart) {
                if (fuzz == 0) {
                    int modifiedStart = hunk.getDirectedModifiedStart();
                    if (modifiedStart == 0) {
                        alreadyApplied = this.isLocallyDeleted();
                    } else {
                        targetContent.seekToLine(modifiedStart);
                        matchedLine = targetContent.scanForMatch(hunk, true, modifiedStart + 1, fuzz, ignoreWhitespace, true, null);
                        alreadyApplied = matchedLine == modifiedStart;
                    }
                } else {
                    alreadyApplied = false;
                }
                if (!alreadyApplied) {
                    targetContent.seekToLine(1);
                    matchedLine = targetContent.scanForMatch(hunk, false, originalStart, fuzz, ignoreWhitespace, false, null);
                    if (matchedLine == 0) {
                        matchedLine = targetContent.scanForMatch(hunk, true, 0, fuzz, ignoreWhitespace, false, null);
                    }
                }
            }
            targetContent.seekToLine(savedLine);
        } else {
            matchedLine = 0;
        }
        return new SvnHunkInfo(hunk, matchedLine, matchedLine == 0, alreadyApplied, fuzz);
    }

    private static void copyLinesToTarget(SvnTargetContent target, int line) throws SVNException {
        while (!(target.getCurrentLine() >= line && line != 0 || target.isEof())) {
            Object targetLine = target.readLine();
            if (!target.isEof() && target.getEolStr() != null) {
                targetLine = (String)targetLine + target.getEolStr();
            }
            target.getWriteCallback().write(target.getWriteBaton(), (String)targetLine);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SvnPatchTarget initPatchTarget(SvnPatch patch, File workingCopyDirectory, int stripCount, boolean removeTempFiles, List<SVNPatchTargetInfo> targetsInfo, ISvnPatchContext patchContext) throws SVNException, IOException {
        SvnDiffHunk hunk;
        SvnDiffHunk hunk2;
        boolean hasTextChanges = false;
        hasTextChanges = patch.getHunks() != null && patch.getHunks().size() > 0 || patch.getBinaryPatch() != null;
        SvnPatchTarget target = new SvnPatchTarget();
        target.setCurrentLine(1);
        target.setEolStyle(SVNWCContext.SVNEolStyle.None);
        target.setDbKind(SVNNodeKind.NONE);
        target.setKindOnDisk(SVNNodeKind.NONE);
        target.setOperation(patch.getOperation());
        boolean followMoves = patch.getOperation() == SvnDiffCallback.OperationKind.Added || patch.getOperation() == SvnDiffCallback.OperationKind.Moved ? false : (patch.getOperation() == SvnDiffCallback.OperationKind.Unchanged && patch.getHunks() != null && patch.getHunks().size() == 1 ? (hunk2 = patch.getHunks().get(0)).getDirectedOriginalStart() != 0 : true);
        target.resolveTargetPath(SvnPatchTarget.chooseTargetFilename(patch), workingCopyDirectory, stripCount, hasTextChanges, followMoves, targetsInfo, patchContext);
        if (!target.isSkipped()) {
            File uniqueFile;
            block53: {
                if (patch.getOldSymlinkBit() == Boolean.TRUE || patch.getNewSymlinkBit() == Boolean.TRUE) {
                    target.setGitSymlinkFormat(true);
                }
                if (patch.getOperation() == SvnDiffCallback.OperationKind.Added) {
                    target.setAdded(true);
                } else if (patch.getOperation() == SvnDiffCallback.OperationKind.Deleted) {
                    target.setDeleted(true);
                } else if (patch.getOperation() == SvnDiffCallback.OperationKind.Moved) {
                    File moveTargetRelPath;
                    File moveTargetPath = patch.getNewFileName();
                    if (stripCount > 0) {
                        moveTargetPath = SVNPatchTarget.stripPath(moveTargetPath, stripCount);
                    }
                    if (SVNFileUtil.isAbsolute(moveTargetPath)) {
                        moveTargetRelPath = SVNFileUtil.createFilePath(SVNPathUtil.getPathAsChild(SVNFileUtil.getFilePath(workingCopyDirectory), SVNFileUtil.getFilePath(moveTargetPath)));
                        if (moveTargetRelPath == null) {
                            target.setSkipped(true);
                            target.setAbsPath(null);
                            return target;
                        }
                    } else {
                        moveTargetRelPath = moveTargetPath;
                    }
                    boolean bl = SvnPatchTarget.isUnderRoot(workingCopyDirectory, moveTargetRelPath);
                    target.setMoveTargetAbsPath(SVNFileUtil.createFilePath(workingCopyDirectory, moveTargetRelPath));
                    if (!bl) {
                        target.setSkipped(true);
                        target.setAbsPath(null);
                        return target;
                    }
                    SVNFileType typeOnDisk = patchContext.getKindOnDisk(target.getMoveTargetAbsPath());
                    SVNNodeKind kindOnDisk = SVNFileType.getNodeKind(typeOnDisk);
                    SVNNodeKind wcKind = patchContext.readKind(target.getMoveTargetAbsPath(), true, false);
                    if (wcKind == SVNNodeKind.FILE || wcKind == SVNNodeKind.DIR) {
                        File movedFromAbsPath;
                        try {
                            movedFromAbsPath = patchContext.wasNodeMovedHere(target.getMoveTargetAbsPath());
                        }
                        catch (SVNException e) {
                            if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                                throw e;
                            }
                            movedFromAbsPath = null;
                        }
                        if (movedFromAbsPath != null && movedFromAbsPath.equals(target.getAbsPath())) {
                            target.setAbsPath(target.getMoveTargetAbsPath());
                            target.setMoveTargetAbsPath(null);
                            target.setOperation(SvnDiffCallback.OperationKind.Modified);
                            target.setLocallyDeleted(false);
                            target.setDbKind(wcKind);
                            target.setKindOnDisk(kindOnDisk);
                            target.setSpecial(typeOnDisk == SVNFileType.SYMLINK);
                            target.setHadAlreadyApplied(true);
                            break block53;
                        } else {
                            target.setSkipped(true);
                            target.setMoveTargetAbsPath(null);
                            return target;
                        }
                    }
                    if (kindOnDisk == SVNNodeKind.NONE || SvnPatchTarget.targetIsAdded(targetsInfo, target.getMoveTargetAbsPath())) {
                        target.setSkipped(true);
                        target.setMoveTargetAbsPath(null);
                        return target;
                    }
                }
            }
            if (target.isSymlink()) {
                target.setExisted(true);
                target.setReadBaton(new SymlinkReadBaton(target.getAbsPath()));
                SymlinkCallbacks symlinkCallbacks = new SymlinkCallbacks(workingCopyDirectory, patchContext);
                target.setReadLineCallback(symlinkCallbacks);
                target.setTellCallback(symlinkCallbacks);
                target.setSeekCallback(symlinkCallbacks);
            } else if (target.getKindOnDisk() == SVNNodeKind.FILE) {
                target.setHasLocalModifications(patchContext.isTextModified(target.getAbsPath(), false));
                target.setExecutable(patchContext.isExecutable(target.getAbsPath()));
                HashMap<String, byte[]> keywords = new HashMap<String, byte[]>();
                SVNWCContext.SVNEolStyle[] eolStyle = new SVNWCContext.SVNEolStyle[1];
                String[] stringArray = new String[1];
                if (target.getKeywords() != null) {
                    keywords.putAll(target.getKeywords());
                }
                eolStyle[0] = target.getEolStyle();
                stringArray[0] = target.getEolStr();
                SvnPatchTarget.obtainEolAndKeywordsForFile(keywords, eolStyle, stringArray, patchContext, target.getAbsPath());
                target.setKeywords(keywords);
                target.setEolStyle((SVNWCContext.SVNEolStyle)((Object)eolStyle[0]));
                target.setEolStr(stringArray[0]);
                RegularCallbacks regularCallbacks = new RegularCallbacks();
                target.setExisted(true);
                target.setReadLineCallback(regularCallbacks);
                target.setSeekCallback(regularCallbacks);
                target.setTellCallback(regularCallbacks);
                target.setStream(SVNPatchFileStream.openReadOnly(target.getAbsPath()));
                target.setReadBaton(target.getStream());
            }
            if (target.isSymlink()) {
                uniqueFile = patchContext.createTempFile(workingCopyDirectory);
                target.setPatchedAbsPath(uniqueFile);
                target.setWriteBaton(uniqueFile);
                target.setWriteCallback(new SymlinkCallbacks(workingCopyDirectory, patchContext));
                target.setOriginalContentFile(null);
            } else if (target.getKindOnDisk() == SVNNodeKind.FILE) {
                uniqueFile = patchContext.createTempFile(workingCopyDirectory);
                target.setPatchedAbsPath(uniqueFile);
                target.setPatchedStream(SVNPatchFileStream.openForWrite(uniqueFile));
                target.setWriteBaton(target.getPatchedStream());
                target.setWriteCallback(new RegularWriteCallback());
                target.setOriginalContentFile(target.getAbsPath());
                target.setExecutable(SVNFileUtil.isExecutable(target.getAbsPath()));
            } else {
                uniqueFile = patchContext.createTempFile(workingCopyDirectory);
                target.setPatchedAbsPath(uniqueFile);
                target.setPatchedStream(SVNPatchFileStream.openForWrite(uniqueFile));
                target.setWriteBaton(target.getPatchedStream());
                target.setWriteCallback(new RegularWriteCallback());
            }
            target.setRejectAbsPath(patchContext.createTempFile(workingCopyDirectory));
            target.setRejectStream(SVNPatchFileStream.openForWrite(target.getRejectAbsPath()));
            if (!target.isSkipped()) {
                SVNErrorMessage errorMessage;
                SvnDiffCallback.OperationKind operation;
                Map<String, SvnPropertiesPatch> propPatches = patch.getPropPatches();
                for (Map.Entry entry : propPatches.entrySet()) {
                    String propName = (String)entry.getKey();
                    SvnPropertiesPatch propPatch = (SvnPropertiesPatch)entry.getValue();
                    SvnPropertiesPatchTarget propTarget = SvnPropertiesPatchTarget.initPropTarget(propName, propPatch.getOperation(), patchContext, target.getAbsPath());
                    target.putPropTarget(propName, propTarget);
                }
                if (patch.getNewExecutableBit() != null && patch.getNewExecutableBit() != patch.getOldExecutableBit()) {
                    operation = patch.getNewExecutableBit() == Boolean.TRUE ? SvnDiffCallback.OperationKind.Added : (patch.getNewExecutableBit() == Boolean.FALSE ? (patch.getOldExecutableBit() == Boolean.TRUE ? SvnDiffCallback.OperationKind.Deleted : SvnDiffCallback.OperationKind.Unchanged) : SvnDiffCallback.OperationKind.Unchanged);
                    if (operation != SvnDiffCallback.OperationKind.Unchanged) {
                        SvnPropertiesPatchTarget svnPropertiesPatchTarget = target.getPropTargets().get("svn:executable");
                        if (svnPropertiesPatchTarget != null && operation != svnPropertiesPatchTarget.getOperation()) {
                            errorMessage = SVNErrorMessage.create(SVNErrorCode.INVALID_INPUT, "Invalid patch: specifies contradicting mode changes and {0} changes (for ''{1}'')", "svn:executable", target.getAbsPath());
                            SVNErrorManager.error(errorMessage, SVNLogType.WC);
                        } else if (svnPropertiesPatchTarget == null) {
                            SvnPropertiesPatchTarget svnPropertiesPatchTarget2 = SvnPropertiesPatchTarget.initPropTarget("svn:executable", operation, patchContext, target.getAbsPath());
                            target.putPropTarget("svn:executable", svnPropertiesPatchTarget2);
                        }
                    }
                }
                if (patch.getNewSymlinkBit() != null && patch.getNewSymlinkBit() != patch.getOldSymlinkBit()) {
                    operation = patch.getNewSymlinkBit() == Boolean.TRUE ? SvnDiffCallback.OperationKind.Added : (patch.getNewSymlinkBit() == Boolean.FALSE ? (patch.getOldSymlinkBit() == Boolean.TRUE ? SvnDiffCallback.OperationKind.Deleted : SvnDiffCallback.OperationKind.Unchanged) : SvnDiffCallback.OperationKind.Unchanged);
                    if (operation != SvnDiffCallback.OperationKind.Unchanged) {
                        SvnPropertiesPatchTarget svnPropertiesPatchTarget = target.getPropTargets().get("svn:executable");
                        if (svnPropertiesPatchTarget != null && operation != svnPropertiesPatchTarget.getOperation()) {
                            errorMessage = SVNErrorMessage.create(SVNErrorCode.INVALID_INPUT, "Invalid patch: specifies contradicting mode changes and {0} changes (for ''{1}'')", "svn:special", target.getAbsPath());
                            SVNErrorManager.error(errorMessage, SVNLogType.WC);
                        } else if (svnPropertiesPatchTarget == null) {
                            SvnPropertiesPatchTarget svnPropertiesPatchTarget3 = SvnPropertiesPatchTarget.initPropTarget("svn:special", operation, patchContext, target.getAbsPath());
                            target.putPropTarget("svn:special", svnPropertiesPatchTarget3);
                        }
                    }
                }
            }
        }
        if ((target.isLocallyDeleted() || target.getDbKind() == SVNNodeKind.NONE) && !target.isAdded() && target.getOperation() == SvnDiffCallback.OperationKind.Unchanged) {
            boolean maybeAdd = false;
            if (patch.getHunks() != null && patch.getHunks().size() == 1) {
                hunk = patch.getHunks().get(0);
                if (hunk.getDirectedOriginalStart() == 0) {
                    maybeAdd = true;
                }
            } else if (patch.getPropPatches() != null && patch.getPropPatches().size() > 0) {
                boolean allAdd = true;
                Map<String, SvnPropertiesPatch> map = patch.getPropPatches();
                for (Map.Entry<String, SvnPropertiesPatch> entry : map.entrySet()) {
                    SvnPropertiesPatch propPatch = entry.getValue();
                    if (propPatch.getOperation() == SvnDiffCallback.OperationKind.Added) continue;
                    allAdd = false;
                    break;
                }
                maybeAdd = allAdd;
            }
            if (maybeAdd) {
                target.setAdded(true);
            }
        } else if (!target.isDeleted() && !target.isAdded() && target.getOperation() == SvnDiffCallback.OperationKind.Unchanged) {
            boolean maybeDelete = false;
            if (patch.getHunks() != null && patch.getHunks().size() == 1 && (hunk = patch.getHunks().get(0)).getDirectedModifiedStart() == 0) {
                maybeDelete = true;
            }
            if (maybeDelete) {
                target.setDeleted(true);
            }
        }
        if (target.getRejectStream() != null) {
            File leftSrc = target.getCanonPathFromPatchfile();
            File rightSrc = target.getCanonPathFromPatchfile();
            if (target.isAdded()) {
                leftSrc = SVNFileUtil.createFilePath("/dev/null");
            }
            if (target.isDeleted()) {
                rightSrc = SVNFileUtil.createFilePath("/dev/null");
            }
            target.getRejectStream().write("--- " + leftSrc + "\n+++ " + rightSrc + "\n");
        }
        return target;
    }

    protected static boolean targetIsAdded(List<SVNPatchTargetInfo> targetsInfo, File localAbsPath) {
        for (int i = targetsInfo.size() - 1; i >= 0; --i) {
            SVNPatchTargetInfo targetInfo = targetsInfo.get(i);
            String info = SVNPathUtil.getPathAsChild(SVNFileUtil.getFilePath(targetInfo.getLocalAbsPath()), SVNFileUtil.getFilePath(localAbsPath));
            if (info != null && info.length() == 0) {
                return targetInfo.isAdded();
            }
            if (info == null) continue;
            return false;
        }
        return false;
    }

    protected static boolean targetIsDeleted(List<SVNPatchTargetInfo> targetsInfo, File localAbsPath) {
        for (int i = targetsInfo.size() - 1; i >= 0; --i) {
            SVNPatchTargetInfo targetInfo = targetsInfo.get(i);
            String info = SVNPathUtil.getPathAsChild(SVNFileUtil.getFilePath(targetInfo.getLocalAbsPath()), SVNFileUtil.getFilePath(localAbsPath));
            if (info == null) continue;
            return targetInfo.isDeleted();
        }
        return false;
    }

    private static void obtainEolAndKeywordsForFile(Map<String, byte[]> keywords, SVNWCContext.SVNEolStyle[] eolStyle, String[] eolStr, ISvnPatchContext patchContext, File localAbsPath) throws SVNException {
        SVNPropertyValue eolStyleVal;
        SVNProperties actualProps = patchContext.getActualProps(localAbsPath);
        SVNPropertyValue keywordsVal = actualProps.getSVNPropertyValue("svn:keywords");
        if (keywordsVal != null && keywords != null) {
            keywords.putAll(patchContext.computeKeywords(localAbsPath, keywordsVal));
        }
        if ((eolStyleVal = actualProps.getSVNPropertyValue("svn:eol-style")) != null) {
            String eolStyleValString = SVNPropertyValue.getPropertyAsString(eolStyleVal);
            SVNWCContext.SVNEolStyleInfo eolStyleInfo = SVNWCContext.SVNEolStyleInfo.fromValue(eolStyleValString);
            if (eolStr != null) {
                eolStr[0] = new String(eolStyleInfo.eolStr);
            }
            if (eolStyle != null) {
                eolStyle[0] = eolStyleInfo.eolStyle;
            }
        }
    }

    private void resolveTargetPath(File pathFromPatchFile, File workingCopyDirectory, int stripCount, boolean hasTextChanges, boolean followMoves, List<SVNPatchTargetInfo> targetsInfo, ISvnPatchContext patchContext) throws SVNException, IOException {
        boolean isUnderRoot;
        File canonPathFromPatchfile = pathFromPatchFile;
        this.setCanonPathFromPatchfile(canonPathFromPatchfile);
        if (hasTextChanges && SVNFileUtil.getFilePath(canonPathFromPatchfile).length() == 0) {
            this.setSkipped(true);
            this.setAbsPath(null);
            this.setRelPath(SVNFileUtil.createFilePath(""));
            return;
        }
        File strippedPath = stripCount > 0 ? SVNPatchTarget.stripPath(canonPathFromPatchfile, stripCount) : canonPathFromPatchfile;
        if (SVNFileUtil.isAbsolute(strippedPath)) {
            this.setRelPath(SVNFileUtil.createFilePath(SVNPathUtil.getPathAsChild(SVNFileUtil.getFilePath(workingCopyDirectory), SVNFileUtil.getFilePath(strippedPath))));
            if (this.getRelPath() == null) {
                this.setSkipped(true);
                this.setAbsPath(null);
                this.setRelPath(strippedPath);
                return;
            }
        } else {
            this.setRelPath(strippedPath);
        }
        if (!(isUnderRoot = SvnPatchTarget.isUnderRoot(workingCopyDirectory, this.getRelPath()))) {
            this.setSkipped(true);
            this.setAbsPath(null);
            return;
        }
        this.setAbsPath(SVNFileUtil.createFilePath(workingCopyDirectory, this.getRelPath()));
        if (SvnPatchTarget.targetIsDeleted(targetsInfo, this.getAbsPath())) {
            this.setLocallyDeleted(true);
            this.setDbKind(SVNNodeKind.NONE);
            return;
        }
        patchContext.resolvePatchTargetStatus(this, workingCopyDirectory, followMoves, targetsInfo);
    }

    private static boolean isUnderRoot(File workingCopyDirectory, File relPath) throws SVNException {
        File fullPath = SVNFileUtil.createFilePath(workingCopyDirectory, relPath);
        try {
            String workingCopyDirectoryPath = SVNFileUtil.getFilePath(workingCopyDirectory.getCanonicalFile());
            String canonicalFullPath = SVNFileUtil.getFilePath(fullPath.getCanonicalFile());
            return canonicalFullPath.equals(workingCopyDirectoryPath) || SVNPathUtil.isAncestor(workingCopyDirectoryPath, canonicalFullPath);
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
            return false;
        }
    }

    private static File chooseTargetFilename(SvnPatch patch) {
        int newCount;
        if (patch.getOldFileName() == SvnPatch.DEV_NULL) {
            return patch.getNewFileName();
        }
        if (patch.getNewFileName() == SvnPatch.DEV_NULL) {
            return patch.getOldFileName();
        }
        if (patch.getOperation() == SvnDiffCallback.OperationKind.Moved) {
            return patch.getOldFileName();
        }
        int oldCount = SVNPathUtil.getSegmentsCount(SVNFileUtil.getFilePath(patch.getOldFileName()));
        if (oldCount == (newCount = SVNPathUtil.getSegmentsCount(SVNFileUtil.getFilePath(patch.getNewFileName()))) && (oldCount = SVNPathUtil.tail(SVNFileUtil.getFilePath(patch.getOldFileName())).length()) == (newCount = SVNPathUtil.tail(SVNFileUtil.getFilePath(patch.getNewFileName())).length())) {
            oldCount = SVNFileUtil.getFilePath(patch.getOldFileName()).length();
            newCount = SVNFileUtil.getFilePath(patch.getNewFileName()).length();
        }
        return oldCount < newCount ? patch.getOldFileName() : patch.getNewFileName();
    }

    private void putPropTarget(String propName, SvnPropertiesPatchTarget propTarget) {
        this.propTargets.put(propName, propTarget);
    }

    @Deprecated
    public void installPatchedTarget(File workingCopyDirectory, boolean dryRun, SVNWCContext context) throws SVNException {
        SvnWcPatchContext patchContext = new SvnWcPatchContext(context);
        ArrayList<SVNPatchTargetInfo> targetInfos = new ArrayList<SVNPatchTargetInfo>();
        this.installPatchedTarget(workingCopyDirectory, dryRun, patchContext, targetInfos);
    }

    public void installPatchedTarget(File workingCopyDirectory, boolean dryRun, ISvnPatchContext patchContext, List<SVNPatchTargetInfo> targetInfos) throws SVNException {
        if (this.isDeleted()) {
            if (!dryRun) {
                patchContext.delete(this.getAbsPath());
            }
        } else {
            if (this.isAdded()) {
                File parentAbsPath = SVNFileUtil.getParentFile(this.getAbsPath());
                SVNNodeKind parentDbKind = patchContext.readKind(parentAbsPath, false, false);
                if (parentDbKind == SVNNodeKind.DIR || parentDbKind == SVNNodeKind.FILE) {
                    if (parentDbKind != SVNNodeKind.DIR) {
                        this.setSkipped(true);
                    } else if (patchContext.getKindOnDisk(parentAbsPath) != SVNFileType.DIRECTORY) {
                        this.setSkipped(true);
                    }
                } else {
                    this.createMissingParents(workingCopyDirectory, patchContext, dryRun, targetInfos);
                }
            } else {
                SVNNodeKind wcKind = patchContext.readKind(this.getAbsPath(), false, false);
                if (this.getKindOnDisk() == SVNNodeKind.NONE || wcKind != this.getKindOnDisk()) {
                    this.setSkipped(true);
                    if (wcKind != this.getKindOnDisk()) {
                        this.setObstructed(true);
                    }
                }
            }
            if (!dryRun && !this.isSkipped()) {
                if (this.isSpecial()) {
                    if (patchContext.getKindOnDisk(this.getPatchedAbsPath()) == SVNFileType.FILE) {
                        String symlinkTarget = SVNFileUtil.readFile(this.getPatchedAbsPath());
                        assert (symlinkTarget != null);
                        if (!this.gitSymlinkFormat) {
                            assert (symlinkTarget.startsWith("link "));
                            symlinkTarget = symlinkTarget.substring("link ".length());
                        }
                        patchContext.writeSymlinkContent(this.getAbsPath(), symlinkTarget);
                    } else {
                        assert (patchContext.getKindOnDisk(this.getPatchedAbsPath()) == SVNFileType.SYMLINK);
                        patchContext.copySymlink(this.getPatchedAbsPath(), this.getAbsPath());
                    }
                } else {
                    File dst;
                    File file = dst = this.getMoveTargetAbsPath() != null ? this.getMoveTargetAbsPath() : this.getAbsPath();
                    if (SVNFileType.getType(this.getPatchedAbsPath()) == SVNFileType.SYMLINK) {
                        SVNFileUtil.deleteFile(dst);
                        patchContext.copySymlink(this.getPatchedAbsPath(), dst);
                    } else {
                        boolean repairEol = this.getEolStyle() == SVNWCContext.SVNEolStyle.Fixed || this.getEolStyle() == SVNWCContext.SVNEolStyle.Native;
                        patchContext.translate(this.getPatchedAbsPath(), dst, null, this.getEolStr() == null ? null : this.getEolStr().getBytes(), this.getKeywords(), false, true);
                    }
                }
                if (this.isAdded()) {
                    patchContext.add(this.getAbsPath());
                }
                patchContext.setExecutable(this.getMoveTargetAbsPath() != null ? this.getMoveTargetAbsPath() : this.getAbsPath(), this.isExecutable());
                if (this.getMoveTargetAbsPath() != null) {
                    patchContext.move(this.getAbsPath(), this.getMoveTargetAbsPath());
                    patchContext.delete(this.getAbsPath());
                }
            }
        }
    }

    private void createMissingParents(File workingCopyDirectory, ISvnPatchContext patchContext, boolean dryRun, List<SVNPatchTargetInfo> targetInfos) throws SVNException {
        File localAbsPath = workingCopyDirectory;
        File relPath = this.getRelPath();
        String relPathString = SVNFileUtil.getFilePath(relPath);
        String[] components = relPathString.split("/");
        int presentComponents = 0;
        for (String component : components) {
            localAbsPath = SVNFileUtil.createFilePath(localAbsPath, component);
            SVNNodeKind wcKind = patchContext.readKind(localAbsPath, false, true);
            SVNNodeKind diskKind = SVNFileType.getNodeKind(SVNFileType.getType(localAbsPath));
            if (diskKind == SVNNodeKind.FILE || wcKind == SVNNodeKind.FILE) {
                this.setSkipped(true);
                break;
            }
            if (diskKind == SVNNodeKind.DIR) {
                if (wcKind == SVNNodeKind.DIR) {
                    ++presentComponents;
                    continue;
                }
                this.setSkipped(true);
                break;
            }
            if (wcKind == SVNNodeKind.NONE) break;
            this.setSkipped(true);
            break;
        }
        if (!this.isSkipped()) {
            int i;
            localAbsPath = workingCopyDirectory;
            for (i = 0; i < presentComponents; ++i) {
                String component = components[i];
                localAbsPath = SVNFileUtil.createFilePath(localAbsPath, component);
            }
            if (!dryRun && presentComponents < components.length - 1) {
                SVNFileUtil.ensureDirectoryExists(SVNFileUtil.createFilePath(workingCopyDirectory, SVNFileUtil.getFileDir(this.getRelPath())));
            }
            for (i = presentComponents; i < components.length - 1; ++i) {
                String component = components[i];
                if (SvnPatchTarget.targetIsAdded(targetInfos, localAbsPath = SVNFileUtil.createFilePath(localAbsPath, component))) continue;
                SVNPatchTargetInfo targetInfo = new SVNPatchTargetInfo(localAbsPath, true, false);
                targetInfos.add(targetInfo);
                if (dryRun) {
                    ISVNEventHandler eventHandler = patchContext.getEventHandler();
                    if (eventHandler == null) continue;
                    SVNEvent event = SVNEventFactory.createSVNEvent(localAbsPath, SVNNodeKind.DIR, null, -1L, SVNEventAction.ADD, SVNEventAction.ADD, null, null);
                    eventHandler.handleEvent(event, -1.0);
                    continue;
                }
                ISVNEventHandler canceller = patchContext.getEventHandler();
                if (canceller != null) {
                    canceller.checkCancelled();
                }
                patchContext.add(localAbsPath);
            }
        }
    }

    @Deprecated
    public void installPatchedPropTarget(boolean dryRun, SVNWCContext context) throws SVNException {
        SvnWcPatchContext patchContext = new SvnWcPatchContext(context);
        this.installPatchedPropTarget(dryRun, patchContext);
    }

    public void installPatchedPropTarget(boolean dryRun, ISvnPatchContext patchContext) throws SVNException {
        Map<String, SvnPropertiesPatchTarget> propTargets = this.getPropTargets();
        for (Map.Entry<String, SvnPropertiesPatchTarget> entry : propTargets.entrySet()) {
            SvnPropertiesPatchTarget propTarget = entry.getValue();
            ISVNEventHandler canceller = patchContext.getEventHandler();
            if (canceller != null) {
                canceller.checkCancelled();
            }
            if (propTarget.isSkipped()) continue;
            if (propTarget.getOperation() == SvnDiffCallback.OperationKind.Deleted) {
                if (dryRun) continue;
                patchContext.setProperty(this.getAbsPath(), propTarget.getName(), null);
                continue;
            }
            if (!this.hasTextChanges() && this.getKindOnDisk() == SVNNodeKind.NONE && !this.isAdded()) {
                if (!dryRun) {
                    SVNFileUtil.createEmptyFile(this.absPath);
                    patchContext.add(this.getAbsPath());
                }
                this.setAdded(true);
            }
            SVNPropertyValue propVal = propTarget.getValue() != null && SVNPropertyValue.getPropertyAsBytes(propTarget.getValue()).length != 0 && propTarget.getPatchedValue() != null && SVNPropertyValue.getPropertyAsBytes(propTarget.getPatchedValue()).length == 0 ? null : propTarget.getPatchedValue();
            try {
                if (dryRun) {
                    SVNPropertyValue sVNPropertyValue = SVNPropertiesManager.validatePropertyValue(this.getAbsPath(), this.getDbKind(), propTarget.getName(), propVal, true, null, null);
                    continue;
                }
                patchContext.setProperty(this.getAbsPath(), propTarget.getName(), propVal);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.ILLEGAL_TARGET || e.getErrorMessage().getErrorCode() == SVNErrorCode.NODE_UNEXPECTED_KIND || e.getErrorMessage().getErrorCode() == SVNErrorCode.IO_UNKNOWN_EOL || e.getErrorMessage().getErrorCode() == SVNErrorCode.BAD_MIME_TYPE || e.getErrorMessage().getErrorCode() == SVNErrorCode.CLIENT_INVALID_EXTERNALS_DESCRIPTION) {
                    for (SvnHunkInfo hunkInfo : propTarget.getHunkInfos()) {
                        hunkInfo.setRejected(true);
                        SvnPatchTarget.rejectHunk(this, hunkInfo.getHunk(), propTarget.getName());
                    }
                    continue;
                }
                throw e;
            }
        }
    }

    public void writeOutRejectedHunks(boolean dryRun) throws SVNException {
        try {
            this.getRejectStream().close();
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        if (!dryRun && (this.hadRejects() || this.hadPropRejects())) {
            SVNFileUtil.copyFile(this.getRejectAbsPath(), SVNFileUtil.createFilePath(SVNFileUtil.getFilePath(this.getAbsPath()) + ".svnpatch.rej"), false);
        }
    }

    @Deprecated
    public void sendPatchNotification(SVNWCContext context) throws SVNException {
        this.sendPatchNotification(new SvnWcPatchContext(context));
    }

    public void sendPatchNotification(ISvnPatchContext patchContext) throws SVNException {
        ISVNEventHandler eventHandler = patchContext.getEventHandler();
        if (eventHandler == null) {
            return;
        }
        SVNEventAction action = this.isSkipped() ? SVNEventAction.SKIP : (this.isDeleted() ? SVNEventAction.DELETE : (this.isAdded() || this.isReplaced() || this.getMoveTargetAbsPath() != null ? SVNEventAction.ADD : SVNEventAction.PATCH));
        File eventPath = this.getMoveTargetAbsPath() != null ? this.getMoveTargetAbsPath() : (this.getAbsPath() != null ? this.getAbsPath() : this.getRelPath());
        SVNStatusType contentState = SVNStatusType.UNKNOWN;
        SVNStatusType propState = SVNStatusType.UNKNOWN;
        if (action == SVNEventAction.SKIP) {
            contentState = this.isObstructed() ? SVNStatusType.OBSTRUCTED : (this.getDbKind() == SVNNodeKind.NONE || this.getDbKind() == SVNNodeKind.UNKNOWN ? SVNStatusType.MISSING : SVNStatusType.UNKNOWN);
        } else {
            if (this.hadRejects()) {
                contentState = SVNStatusType.CONFLICTED;
            } else if (this.hasLocalModifications()) {
                contentState = SVNStatusType.MERGED;
            } else if (this.hasTextChanges()) {
                contentState = SVNStatusType.CHANGED;
            } else if (this.hadAlreadyApplied()) {
                contentState = SVNStatusType.MERGED;
            }
            if (this.hadPropRejects()) {
                propState = SVNStatusType.CONFLICTED;
            } else if (this.hasPropChanges()) {
                propState = SVNStatusType.CHANGED;
            }
        }
        SVNEvent event = SVNEventFactory.createSVNEvent(eventPath, SVNNodeKind.FILE, null, -1L, contentState, propState, null, action, action, null, null);
        eventHandler.handleEvent(event, -1.0);
        if (action == SVNEventAction.PATCH) {
            for (SvnHunkInfo hunkInfo : this.getHunkInfos()) {
                this.sendHunkNotification(hunkInfo, null, patchContext);
            }
            Map<String, SvnPropertiesPatchTarget> propTargets = this.getPropTargets();
            for (Map.Entry<String, SvnPropertiesPatchTarget> entry : propTargets.entrySet()) {
                SvnPropertiesPatchTarget propTarget = entry.getValue();
                List<SvnHunkInfo> hunks = propTarget.getHunkInfos();
                for (SvnHunkInfo hunkInfo : hunks) {
                    if (propTarget.getOperation() == SvnDiffCallback.OperationKind.Added || propTarget.getOperation() == SvnDiffCallback.OperationKind.Deleted) continue;
                    this.sendHunkNotification(hunkInfo, propTarget.getName(), patchContext);
                }
            }
        }
        if (this.getMoveTargetAbsPath() != null) {
            event = SVNEventFactory.createSVNEvent(this.getAbsPath(), SVNNodeKind.FILE, null, -1L, SVNEventAction.DELETE, SVNEventAction.DELETE, null, null);
            eventHandler.handleEvent(event, -1.0);
        }
    }

    private void sendHunkNotification(SvnHunkInfo hunkInfo, String propName, ISvnPatchContext patchContext) throws SVNException {
        SVNEventAction action = hunkInfo.isAlreadyApplied() ? SVNEventAction.PATCH_HUNK_ALREADY_APPLIED : (hunkInfo.isRejected() ? SVNEventAction.PATCH_REJECTED_HUNK : SVNEventAction.PATCH_APPLIED_HUNK);
        SVNEvent event = SVNEventFactory.createSVNEvent(this.getAbsPath() != null ? this.getAbsPath() : this.getRelPath(), SVNNodeKind.UNKNOWN, null, -1L, action, action, null, null);
        event.setInfo(hunkInfo);
        event.setPropertyName(propName);
        ISVNEventHandler eventHandler = patchContext.getEventHandler();
        if (eventHandler != null) {
            eventHandler.handleEvent(event, -1.0);
        }
    }

    private boolean hasLocalModifications() {
        return this.hasLocalModifications;
    }

    public boolean hadRejects() {
        return this.hadRejects;
    }

    public void setHadRejects(boolean hadRejects) {
        this.hadRejects = hadRejects;
    }

    public boolean hadAlreadyApplied() {
        return this.hadAlreadyApplied;
    }

    public void setHadAlreadyApplied(boolean hadAlreadyApplied) {
        this.hadAlreadyApplied = hadAlreadyApplied;
    }

    public boolean hadPropRejects() {
        return this.hadPropRejects;
    }

    public void setHadPropRejects(boolean hadPropRejects) {
        this.hadPropRejects = hadPropRejects;
    }

    public void setSkipped(boolean skipped) {
        this.skipped = skipped;
    }

    public boolean isSymlink() {
        return this.symlink;
    }

    public void setAdded(boolean added) {
        this.added = added;
    }

    public void setReplaced(boolean replaced) {
        this.replaced = replaced;
    }

    public boolean isLocallyDeleted() {
        return this.locallyDeleted;
    }

    public boolean isObstructed() {
        return this.obstructed;
    }

    public void setObstructed(boolean obstructed) {
        this.obstructed = obstructed;
    }

    public SVNNodeKind getKindOnDisk() {
        return this.kindOnDisk;
    }

    public SVNNodeKind getDbKind() {
        return this.dbKind;
    }

    public SvnDiffCallback.OperationKind getOperation() {
        return this.operation;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public void setDbKind(SVNNodeKind dbKind) {
        this.dbKind = dbKind;
    }

    public void setOperation(SvnDiffCallback.OperationKind operation) {
        this.operation = operation;
    }

    public void setKindOnDisk(SVNNodeKind kindOnDisk) {
        this.kindOnDisk = kindOnDisk;
    }

    @Override
    public void setExisted(boolean existed) {
        this.existed = existed;
    }

    @Override
    public void setCurrentLine(int currentLine) {
        this.currentLine = currentLine;
    }

    public void setHasLocalModifications(boolean hasLocalModifications) {
        this.hasLocalModifications = hasLocalModifications;
    }

    public void setExecutable(boolean executable) {
        this.executable = executable;
    }

    public void setAbsPath(File absPath) {
        this.absPath = absPath;
    }

    public void setRelPath(File relPath) {
        this.relPath = relPath;
    }

    public File getCanonPathFromPatchfile() {
        return this.canonPathFromPatchfile;
    }

    public void setCanonPathFromPatchfile(File canonPathFromPatchfile) {
        this.canonPathFromPatchfile = canonPathFromPatchfile;
    }

    public File getRelPath() {
        return this.relPath;
    }

    public void setLocallyDeleted(boolean locallyDeleted) {
        this.locallyDeleted = locallyDeleted;
    }

    public void setSymlink(boolean symlink) {
        this.symlink = symlink;
    }

    @Override
    public boolean isExisted() {
        return this.existed;
    }

    @Override
    public int getCurrentLine() {
        return this.currentLine;
    }

    @Override
    public void setEolStr(String eolStr) {
        this.eolStr = eolStr;
    }

    public boolean isReplaced() {
        return this.replaced;
    }

    public boolean isSpecial() {
        return this.special;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public File getPatchedAbsPath() {
        return this.patchedAbsPath;
    }

    public void setPatchedAbsPath(File patchedAbsPath) {
        this.patchedAbsPath = patchedAbsPath;
    }

    public void setHasPropChanges(boolean hasPropChanges) {
        this.hasPropChanges = hasPropChanges;
    }

    public void setHasTextChanges(boolean hasTextChanges) {
        this.hasTextChanges = hasTextChanges;
    }

    public void setStream(SVNPatchFileStream stream) {
        this.stream = stream;
    }

    public void setGitSymlinkFormat(boolean gitSymlinkFormat) {
        this.gitSymlinkFormat = gitSymlinkFormat;
    }

    public void setMoveTargetAbsPath(File moveTargetAbsPath) {
        this.moveTargetAbsPath = moveTargetAbsPath;
    }

    public void setOriginalContentFile(File originalContentFile) {
        this.originalContentFile = originalContentFile;
    }

    public File getOriginalContentFile() {
        return this.originalContentFile;
    }

    public static SvnDiffHunk createAddsSingleLine(SvnPatch patch, String line, ISvnPatchContext patchContext, File workingCopyDirectory) throws IOException, SVNException {
        return SvnPatchTarget.addOrDeleteSingleLine(patch, line, !patch.isReverse(), patchContext, workingCopyDirectory);
    }

    public static SvnDiffHunk createDeletesSingleLine(SvnPatch patch, String line, ISvnPatchContext patchContext, File workingCopyDirectory) throws IOException, SVNException {
        return SvnPatchTarget.addOrDeleteSingleLine(patch, line, patch.isReverse(), patchContext, workingCopyDirectory);
    }

    private static SvnDiffHunk addOrDeleteSingleLine(SvnPatch patch, String line, boolean add, ISvnPatchContext patchContext, File workingCopyDirectory) throws SVNException, IOException {
        String[] hunkHeader = new String[]{"@@ -1 +0,0 @@\n", "@@ -0,0 +1 @@\n"};
        int headerLength = hunkHeader[add ? 1 : 0].length();
        int len = line.length();
        int end = headerLength + (1 + len);
        StringBuilder stringBuilder = new StringBuilder(end + 1);
        SvnDiffHunk hunk = new SvnDiffHunk();
        hunk.setPatch(patch);
        if (add) {
            hunk.setOriginalTextRange(new SvnDiffHunk.Range(0L, 0L, 0L));
            hunk.setOriginalNoFinalEol(false);
            hunk.setModifiedTextRange(new SvnDiffHunk.Range(headerLength, end, headerLength));
            hunk.setModifiedNoFinalEol(true);
            hunk.setOriginalStart(0);
            hunk.setOriginalLength(0);
            hunk.setModifiedStart(1);
            hunk.setModifiedLength(1);
        } else {
            hunk.setOriginalTextRange(new SvnDiffHunk.Range(headerLength, end, headerLength));
            hunk.setOriginalNoFinalEol(true);
            hunk.setModifiedTextRange(new SvnDiffHunk.Range(0L, 0L, 0L));
            hunk.setModifiedNoFinalEol(false);
            hunk.setOriginalStart(1);
            hunk.setOriginalLength(1);
            hunk.setModifiedStart(0);
            hunk.setModifiedLength(0);
        }
        hunk.setLeadingContext(0);
        hunk.setTrailingContext(0);
        stringBuilder.append(hunkHeader[add ? 1 : 0]);
        stringBuilder.append(add ? (char)'+' : '-');
        stringBuilder.append(line);
        stringBuilder.append('\n');
        stringBuilder.append("\\ No newline at end of hunk\n");
        String buf = stringBuilder.toString();
        hunk.setDiffTextRange(new SvnDiffHunk.Range(headerLength, buf.length(), headerLength));
        File uniqueFile = patchContext.createTempFile(workingCopyDirectory);
        SVNPatchFileStream patchFileStream = SVNPatchFileStream.openForWrite(uniqueFile);
        hunk.setPatchFileStream(patchFileStream);
        patchFileStream.write(buf);
        return hunk;
    }

    private static class SymlinkReadBaton {
        private final File absPath;
        private boolean atEof;

        public SymlinkReadBaton(File absPath) {
            this.absPath = absPath;
        }

        private File getAbsPath() {
            return this.absPath;
        }

        private boolean isAtEof() {
            return this.atEof;
        }
    }

    private static class SymlinkCallbacks
    implements SvnTargetContent.IWriteCallback,
    SvnTargetContent.IRealLineCallback,
    SvnTargetContent.ISeekCallback,
    SvnTargetContent.ITellCallback {
        private File workingCopyDirectory;
        private ISvnPatchContext patchContext;

        public SymlinkCallbacks(File workingCopyDirectory, ISvnPatchContext patchContext) {
            this.workingCopyDirectory = workingCopyDirectory;
            this.patchContext = patchContext;
        }

        @Override
        public void write(Object writeBaton, String s) throws SVNException {
            if (!s.startsWith("link ")) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_WRITE_ERROR, "Invalid link representation");
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
            File targetAbsPath = (File)writeBaton;
            this.patchContext.writeSymlinkContent(targetAbsPath, s.substring("link ".length()));
        }

        @Override
        public String readLine(Object baton, String[] eolStr, boolean[] eof) throws SVNException {
            SymlinkReadBaton symlinkReadBaton;
            if (eof != null) {
                eof[0] = true;
            }
            if (eolStr != null) {
                eolStr[0] = null;
            }
            if ((symlinkReadBaton = (SymlinkReadBaton)baton).isAtEof()) {
                return null;
            }
            return this.patchContext.readSymlinkContent(symlinkReadBaton.getAbsPath());
        }

        @Override
        public void seek(Object readBaton, long offset) {
            SymlinkReadBaton symlinkReadBaton = (SymlinkReadBaton)readBaton;
            symlinkReadBaton.atEof = offset != 0L;
        }

        @Override
        public long tell(Object readBaton) {
            SymlinkReadBaton symlinkReadBaton = (SymlinkReadBaton)readBaton;
            return symlinkReadBaton.isAtEof() ? 1L : 0L;
        }
    }

    private static class RegularCallbacks
    implements SvnTargetContent.IRealLineCallback,
    SvnTargetContent.ISeekCallback,
    SvnTargetContent.ITellCallback {
        private RegularCallbacks() {
        }

        @Override
        public String readLine(Object baton, String[] eolStr, boolean[] eof) throws SVNException {
            try {
                SVNPatchFileStream inputStream = (SVNPatchFileStream)baton;
                StringBuffer lineBuffer = new StringBuffer();
                StringBuffer eolStrBuffer = new StringBuffer();
                boolean isEof = inputStream.readLineWithEol(lineBuffer, eolStrBuffer);
                if (eof != null) {
                    eof[0] = isEof;
                }
                if (eolStr != null) {
                    eolStr[0] = eolStrBuffer.length() == 0 ? null : eolStrBuffer.toString();
                }
                return lineBuffer.toString();
            }
            catch (IOException e) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
                return null;
            }
        }

        @Override
        public void seek(Object baton, long offset) throws SVNException {
            SVNPatchFileStream inputStream = (SVNPatchFileStream)baton;
            try {
                inputStream.setSeekPosition(offset);
            }
            catch (IOException e) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
        }

        @Override
        public long tell(Object baton) throws SVNException {
            SVNPatchFileStream inputStream = (SVNPatchFileStream)baton;
            try {
                return inputStream.getSeekPosition();
            }
            catch (IOException e) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
                return -1L;
            }
        }
    }

    private static class RegularWriteCallback
    implements SvnTargetContent.IWriteCallback {
        private RegularWriteCallback() {
        }

        @Override
        public void write(Object writeBaton, String s) throws SVNException {
            SVNPatchFileStream outputStream = (SVNPatchFileStream)writeBaton;
            try {
                outputStream.write(s);
            }
            catch (IOException e) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
        }
    }
}

