/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbPristines;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback2;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnCopyAsChangedDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallbackResult;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallbackWrapper;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffSource;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgDiffUtil;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnReverseOrderDiffCallback;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnDiffEditor
implements ISVNEditor,
ISVNUpdateEditor {
    private SVNDepth depth;
    private SVNWCContext context;
    private ISVNWCDb db;
    private File anchorAbspath;
    private String target;
    private boolean showCopiesAsAdds;
    private ISvnDiffCallback2 callback;
    private Collection<String> changelists;
    private boolean ignoreAncestry;
    private boolean useGitDiffFormat;
    private ISVNCanceller canceller;
    private boolean reverseOrder;
    private boolean localBeforeRemote;
    private boolean diffPristine;
    private long revision;
    private boolean rootOpened;
    private Entry rootEntry;
    private Entry currentEntry;
    private Collection<File> tempFiles;
    private SVNWCDbRoot wcRoot;
    private final SVNDeltaProcessor deltaProcessor;
    private final SvnDiffCallbackResult result;

    public SvnDiffEditor(File anchorAbspath, String target, ISvnDiffCallback callback, SVNDepth depth, SVNWCContext context, boolean reverseOrder, boolean useTextBase, boolean showCopiesAsAdds, boolean ignoreAncestry, boolean recurseIntoDeletedDirectories, Collection<String> changelists, boolean useGitDiffFormat, ISVNCanceller canceller) {
        if (useGitDiffFormat) {
            showCopiesAsAdds = true;
        }
        this.depth = depth;
        this.context = context;
        this.db = context.getDb();
        this.anchorAbspath = anchorAbspath;
        this.target = target;
        this.diffPristine = useTextBase;
        this.showCopiesAsAdds = showCopiesAsAdds;
        this.callback = new SvnDiffCallbackWrapper(callback, recurseIntoDeletedDirectories, anchorAbspath);
        if (!showCopiesAsAdds) {
            this.callback = new SvnCopyAsChangedDiffCallback(this.callback);
        }
        if (reverseOrder) {
            this.callback = new SvnReverseOrderDiffCallback(this.callback, null);
        }
        this.changelists = changelists;
        if (showCopiesAsAdds) {
            ignoreAncestry = false;
        }
        this.ignoreAncestry = ignoreAncestry;
        this.useGitDiffFormat = useGitDiffFormat;
        this.canceller = canceller;
        this.reverseOrder = reverseOrder;
        this.deltaProcessor = new SVNDeltaProcessor();
        this.tempFiles = new ArrayList<File>();
        this.result = new SvnDiffCallbackResult();
    }

    public SvnDiffEditor() {
        this.deltaProcessor = new SVNDeltaProcessor();
        this.result = new SvnDiffCallbackResult();
    }

    @Override
    public void targetRevision(long revision) throws SVNException {
        this.revision = revision;
    }

    @Override
    public void openRoot(long revision) throws SVNException {
        this.rootOpened = true;
        this.currentEntry = this.rootEntry = new Entry(false, "", null, false, this.depth, this.anchorAbspath);
        if (this.target.length() == 0) {
            this.currentEntry.leftSource = new SvnDiffSource(this.revision);
            this.currentEntry.rightSource = new SvnDiffSource(-1L);
            this.callback.dirOpened(this.result, new File(""), this.currentEntry.leftSource, this.currentEntry.rightSource, null, null);
            this.currentEntry.skip = this.result.skip;
            this.currentEntry.skipChildren = this.result.skipChildren;
        } else {
            this.currentEntry.skip = true;
        }
    }

    @Override
    public void deleteEntry(String path, long revision) throws SVNException {
        File localAbspath = this.getLocalAbspath(path);
        String name = SVNPathUtil.tail(path);
        Entry pb = this.currentEntry;
        if (pb.deletes == null) {
            pb.deletes = new HashSet<String>();
        }
        pb.deletes.add(name);
    }

    @Override
    public void absentDir(String path) throws SVNException {
    }

    @Override
    public void absentFile(String path) throws SVNException {
    }

    @Override
    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        SVNDepth subdirDepth = this.depth == SVNDepth.IMMEDIATES ? SVNDepth.EMPTY : this.depth;
        Entry pb = this.currentEntry;
        this.currentEntry = new Entry(false, path, this.currentEntry, true, subdirDepth, this.getLocalAbspath(path));
        if (pb.reposOnly || !this.ignoreAncestry) {
            this.currentEntry.reposOnly = true;
        } else {
            pb.ensureLocalInfo();
            ISVNWCDb.SVNWCDbInfo info = pb.localInfo.get(this.currentEntry.name);
            if (info == null || info.kind != ISVNWCDb.SVNWCDbKind.Dir || info.status.isNotPresent()) {
                this.currentEntry.reposOnly = true;
            }
            if (!this.currentEntry.reposOnly && info.status != ISVNWCDb.SVNWCDbStatus.Added) {
                this.currentEntry.reposOnly = true;
            }
            if (!this.currentEntry.reposOnly) {
                this.currentEntry.rightSource = new SvnDiffSource(-1L);
                this.currentEntry.ignoringAncestry = true;
                if (pb.compared == null) {
                    pb.compared = new HashSet<String>();
                }
                pb.compared.add(this.currentEntry.name);
            }
        }
        this.currentEntry.leftSource = new SvnDiffSource(this.revision);
        if (this.localBeforeRemote && !this.currentEntry.reposOnly && !this.currentEntry.ignoringAncestry) {
            this.handleLocalOnly(pb, this.currentEntry.name);
        }
        this.result.reset();
        this.callback.dirOpened(this.result, new File(this.currentEntry.path), this.currentEntry.leftSource, this.currentEntry.rightSource, null, null);
        this.currentEntry.skip = this.result.skip;
        this.currentEntry.skipChildren = this.result.skipChildren;
    }

    @Override
    public void openDir(String path, long revision) throws SVNException {
        SVNDepth subdirDepth = this.depth == SVNDepth.IMMEDIATES ? SVNDepth.EMPTY : this.depth;
        Entry pb = this.currentEntry;
        this.currentEntry = new Entry(false, path, this.currentEntry, false, subdirDepth, this.getLocalAbspath(path));
        if (pb.reposOnly) {
            this.currentEntry.reposOnly = true;
        } else {
            pb.ensureLocalInfo();
            ISVNWCDb.SVNWCDbInfo info = pb.localInfo.get(this.currentEntry.name);
            if (info == null || info.kind != ISVNWCDb.SVNWCDbKind.Dir || info.status.isNotPresent()) {
                this.currentEntry.reposOnly = true;
            }
            if (!this.currentEntry.reposOnly) {
                switch (info.status) {
                    case Normal: {
                        break;
                    }
                    case Deleted: {
                        this.currentEntry.reposOnly = true;
                        if (info.haveMoreWork) break;
                        if (pb.compared == null) {
                            pb.compared = new HashSet<String>();
                        }
                        pb.compared.add(this.currentEntry.name);
                        break;
                    }
                    case Added: {
                        if (this.ignoreAncestry) {
                            this.currentEntry.ignoringAncestry = true;
                            break;
                        }
                        this.currentEntry.reposOnly = true;
                        break;
                    }
                    default: {
                        SVNErrorManager.assertionFailure(false, null, SVNLogType.WC);
                    }
                }
            }
            if (!this.currentEntry.reposOnly) {
                this.currentEntry.rightSource = new SvnDiffSource(-1L);
                if (pb.compared == null) {
                    pb.compared = new HashSet<String>();
                }
                pb.compared.add(this.currentEntry.name);
            }
        }
        this.currentEntry.leftSource = new SvnDiffSource(this.revision);
        if (this.localBeforeRemote && !this.currentEntry.reposOnly && !this.currentEntry.ignoringAncestry) {
            this.handleLocalOnly(pb, this.currentEntry.name);
        }
        this.callback.dirOpened(this.result, new File(this.currentEntry.path), this.currentEntry.leftSource, this.currentEntry.rightSource, null, null);
        this.currentEntry.skip = this.result.skip;
        this.currentEntry.skipChildren = this.result.skipChildren;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeDir() throws SVNException {
        try {
            boolean reportedClosed = false;
            Entry pb = this.currentEntry.parent;
            if (!this.currentEntry.skipChildren && this.currentEntry.deletes != null && this.currentEntry.deletes.size() > 0) {
                ArrayList<String> children = new ArrayList<String>(this.currentEntry.deletes);
                Collections.sort(children);
                for (String name : children) {
                    this.handleLocalOnly(this.currentEntry, name);
                    if (this.currentEntry.compared == null) {
                        this.currentEntry.compared = new HashSet<String>();
                    }
                    this.currentEntry.compared.add(name);
                }
            }
            if (!this.currentEntry.reposOnly && !this.currentEntry.skipChildren) {
                this.walkLocalNodesDiff(this.currentEntry.localAbspath, this.currentEntry.path, this.currentEntry.depth, this.currentEntry.compared);
            }
            if (!this.currentEntry.skip && (this.currentEntry.propChanges.size() > 0 || this.currentEntry.reposOnly || this.currentEntry.changePropertyCalled)) {
                SVNProperties reposProps = this.currentEntry.added ? new SVNProperties() : this.db.getBaseProps(this.currentEntry.localAbspath);
                if (this.currentEntry.propChanges.size() > 0 || this.currentEntry.changePropertyCalled) {
                    reposProps.putAll(this.currentEntry.propChanges);
                    reposProps.removeNullValues();
                }
                if (this.currentEntry.reposOnly) {
                    this.result.reset();
                    this.callback.dirDeleted(this.result, new File(this.currentEntry.path), this.currentEntry.leftSource, reposProps, null);
                    reportedClosed = true;
                } else {
                    SVNProperties localProps;
                    if (this.diffPristine) {
                        Structure<StructureFields.PristineInfo> pristineInfoStructure = this.db.readPristineInfo(this.currentEntry.localAbspath);
                        localProps = (SVNProperties)pristineInfoStructure.get(StructureFields.PristineInfo.props);
                    } else {
                        localProps = this.db.readProperties(this.currentEntry.localAbspath);
                    }
                    SVNProperties propChanges = reposProps.compareTo(localProps);
                    if (propChanges.size() > 0) {
                        this.result.reset();
                        this.callback.dirChanged(this.result, new File(this.currentEntry.path), this.currentEntry.leftSource, this.currentEntry.rightSource, reposProps, localProps, propChanges, null);
                        reportedClosed = true;
                    }
                }
            }
            if (!reportedClosed && !this.currentEntry.skip) {
                this.result.reset();
                this.callback.dirClosed(this.result, new File(this.currentEntry.path), this.currentEntry.leftSource, this.currentEntry.rightSource, null);
            }
            if (!(pb == null || this.localBeforeRemote || this.currentEntry.reposOnly || this.currentEntry.ignoringAncestry)) {
                this.handleLocalOnly(pb, this.currentEntry.name);
            }
        }
        finally {
            this.currentEntry = this.currentEntry.parent;
        }
    }

    @Override
    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        Entry pb = this.currentEntry;
        this.currentEntry = new Entry(true, path, this.currentEntry, true, SVNDepth.UNKNOWN, this.getLocalAbspath(path));
        if (pb.skipChildren) {
            this.currentEntry.skip = true;
            return;
        }
        if (pb.reposOnly || !this.ignoreAncestry) {
            this.currentEntry.reposOnly = true;
        } else {
            pb.ensureLocalInfo();
            ISVNWCDb.SVNWCDbInfo info = pb.localInfo.get(this.currentEntry.name);
            if (info == null || info.kind != ISVNWCDb.SVNWCDbKind.File || info.status.isNotPresent()) {
                this.currentEntry.reposOnly = true;
            }
            if (!this.currentEntry.reposOnly && info.status != ISVNWCDb.SVNWCDbStatus.Added) {
                this.currentEntry.reposOnly = true;
            }
            if (!this.currentEntry.reposOnly) {
                this.currentEntry.rightSource = new SvnDiffSource(-1L);
                this.currentEntry.ignoringAncestry = true;
                if (pb.compared == null) {
                    pb.compared = new HashSet<String>();
                }
                pb.compared.add(this.currentEntry.name);
            }
        }
        this.currentEntry.leftSource = new SvnDiffSource(this.revision);
        this.result.reset();
        this.callback.fileOpened(this.result, new File(this.currentEntry.path), this.currentEntry.leftSource, this.currentEntry.rightSource, null, false, null);
        this.currentEntry.skip = this.result.skip;
    }

    @Override
    public void openFile(String path, long revision) throws SVNException {
        Entry pb = this.currentEntry;
        this.currentEntry = new Entry(true, path, this.currentEntry, false, SVNDepth.UNKNOWN, this.getLocalAbspath(path));
        if (pb.skipChildren) {
            this.currentEntry.skip = true;
        } else if (pb.reposOnly) {
            this.currentEntry.reposOnly = true;
        } else {
            pb.ensureLocalInfo();
            ISVNWCDb.SVNWCDbInfo info = pb.localInfo.get(this.currentEntry.name);
            if (info == null || info.kind != ISVNWCDb.SVNWCDbKind.File || info.status.isNotPresent()) {
                this.currentEntry.reposOnly = true;
            }
            if (!this.currentEntry.reposOnly) {
                switch (info.status) {
                    case Normal: {
                        break;
                    }
                    case Deleted: {
                        this.currentEntry.reposOnly = true;
                        if (info.haveMoreWork) break;
                        if (pb.compared == null) {
                            pb.compared = new HashSet<String>();
                        }
                        pb.compared.add(this.currentEntry.name);
                        break;
                    }
                    case Added: {
                        if (this.ignoreAncestry) {
                            this.currentEntry.ignoringAncestry = true;
                            break;
                        }
                        this.currentEntry.reposOnly = true;
                        break;
                    }
                    default: {
                        SVNErrorManager.assertionFailure(false, null, SVNLogType.WC);
                    }
                }
            }
            if (!this.currentEntry.reposOnly) {
                this.currentEntry.rightSource = new SvnDiffSource(-1L);
                if (pb.compared == null) {
                    pb.compared = new HashSet<String>();
                }
                pb.compared.add(this.currentEntry.name);
            }
        }
        this.currentEntry.leftSource = new SvnDiffSource(this.revision);
        ISVNWCDb.WCDbBaseInfo baseInfo = this.db.getBaseInfo(this.currentEntry.localAbspath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.checksum, ISVNWCDb.WCDbBaseInfo.BaseInfoField.props);
        this.currentEntry.baseChecksum = baseInfo.checksum;
        this.currentEntry.baseProps = baseInfo.props;
        this.result.reset();
        this.callback.fileOpened(this.result, new File(this.currentEntry.path), this.currentEntry.leftSource, this.currentEntry.rightSource, null, false, null);
        this.currentEntry.skip = this.result.skip;
    }

    @Override
    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        InputStream sourceStream;
        if (this.currentEntry.skip) {
            return;
        }
        if (baseChecksum != null && this.currentEntry.baseChecksum != null) {
            SvnChecksum baseMd5 = this.db.getPristineMD5(this.anchorAbspath, this.currentEntry.baseChecksum);
            if (baseMd5 != null && !baseMd5.getDigest().equals(baseChecksum)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}''", (Object)this.currentEntry.localAbspath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            sourceStream = this.db.readPristine(this.currentEntry.localAbspath, this.currentEntry.baseChecksum);
        } else {
            sourceStream = this.currentEntry.baseChecksum != null ? this.db.readPristine(this.currentEntry.localAbspath, this.currentEntry.baseChecksum) : SVNFileUtil.DUMMY_IN;
        }
        this.currentEntry.tempFile = this.createTempFile(this.db.getWCRootTempDir(this.currentEntry.localAbspath));
        this.deltaProcessor.applyTextDelta(sourceStream, this.currentEntry.tempFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeFile(String path, String textChecksum) throws SVNException {
        try {
            Entry pb = this.currentEntry.parent;
            if (!this.currentEntry.skip && textChecksum != null) {
                SvnChecksum resultChecksum = this.currentEntry.tempFile != null ? this.currentEntry.resultChecksum : this.currentEntry.baseChecksum;
                if (resultChecksum.getKind() != SvnChecksum.Kind.md5) {
                    resultChecksum = this.db.getPristineMD5(this.currentEntry.localAbspath, resultChecksum);
                }
                if (!textChecksum.equals(resultChecksum.getDigest())) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}''", (Object)this.currentEntry.localAbspath);
                    SVNErrorManager.error(err, SVNLogType.DEFAULT);
                }
            }
            if (this.localBeforeRemote && !this.currentEntry.reposOnly && !this.currentEntry.ignoringAncestry) {
                this.handleLocalOnly(pb, this.currentEntry.name);
            }
            SVNProperties propBase = this.currentEntry.added ? new SVNProperties() : this.currentEntry.baseProps;
            SVNProperties reposProps = new SVNProperties(propBase);
            reposProps.putAll(this.currentEntry.propChanges);
            reposProps.removeNullValues();
            File reposFile = this.currentEntry.tempFile;
            if (reposFile == null && !this.currentEntry.skip) {
                assert (this.currentEntry.baseChecksum != null);
                reposFile = SvnWcDbPristines.getPristinePath(this.getWcRoot(), this.currentEntry.baseChecksum);
            }
            if (!this.currentEntry.skip) {
                if (this.currentEntry.reposOnly) {
                    this.result.reset();
                    this.callback.fileDeleted(this.result, new File(this.currentEntry.path), this.currentEntry.leftSource, this.currentEntry.tempFile, reposProps);
                } else {
                    File localFile;
                    SVNProperties localProps;
                    if (this.diffPristine) {
                        Structure<StructureFields.PristineInfo> pristineInfoStructure = this.db.readPristineInfo(this.currentEntry.localAbspath);
                        SvnChecksum checksum = (SvnChecksum)pristineInfoStructure.get(StructureFields.PristineInfo.checksum);
                        localProps = (SVNProperties)pristineInfoStructure.get(StructureFields.PristineInfo.props);
                        assert (checksum != null);
                        localFile = SvnWcDbPristines.getPristinePath(this.getWcRoot(), checksum);
                    } else {
                        localProps = this.db.readProperties(this.currentEntry.localAbspath);
                        localFile = this.context.getTranslatedFile(this.currentEntry.localAbspath, this.currentEntry.localAbspath, true, false, false, false, false);
                    }
                    SVNProperties propChanges = reposProps.compareTo(localProps);
                    this.result.reset();
                    this.callback.fileChanged(this.result, new File(this.currentEntry.path), this.currentEntry.leftSource, this.currentEntry.rightSource, reposFile, localFile, reposProps, localProps, true, propChanges);
                }
            }
            if (!(this.localBeforeRemote || this.currentEntry.reposOnly || this.currentEntry.ignoringAncestry)) {
                this.handleLocalOnly(pb, this.currentEntry.name);
            }
        }
        finally {
            this.currentEntry = this.currentEntry.parent;
        }
    }

    @Override
    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        if (SVNProperty.isWorkingCopyProperty(name)) {
            return;
        }
        if (SVNProperty.isRegularProperty(name)) {
            this.currentEntry.hasPropChange = true;
            if (this.currentEntry.propChanges == null) {
                this.currentEntry.propChanges = new SVNProperties();
            }
            this.currentEntry.propChanges.put(name, value);
        }
        this.currentEntry.changePropertyCalled = true;
    }

    @Override
    public void changeFileProperty(String path, String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        if (SVNProperty.isWorkingCopyProperty(propertyName)) {
            return;
        }
        if (SVNProperty.isRegularProperty(propertyName)) {
            this.currentEntry.hasPropChange = true;
            if (this.currentEntry.propChanges == null) {
                this.currentEntry.propChanges = new SVNProperties();
            }
            this.currentEntry.propChanges.put(propertyName, propertyValue);
        }
    }

    @Override
    public SVNCommitInfo closeEdit() throws SVNException {
        if (!this.rootOpened) {
            this.walkLocalNodesDiff(this.anchorAbspath, "", this.depth, null);
        }
        return null;
    }

    @Override
    public void abortEdit() throws SVNException {
    }

    @Override
    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        if (this.currentEntry.skip) {
            return null;
        }
        return this.deltaProcessor.textDeltaChunk(diffWindow);
    }

    @Override
    public void textDeltaEnd(String path) throws SVNException {
        if (this.currentEntry.skip) {
            return;
        }
        String checksum = this.deltaProcessor.textDeltaEnd();
        this.currentEntry.resultChecksum = new SvnChecksum(SvnChecksum.Kind.md5, checksum);
    }

    private File getLocalAbspath(String path) {
        return new File(this.anchorAbspath, path);
    }

    private void checkCancelled() throws SVNCancelException {
        this.canceller.checkCancelled();
    }

    private void walkLocalNodesDiff(File localAbspath, String path, SVNDepth depth, Set<String> compared) throws SVNException {
        if (this.diffPristine) {
            return;
        }
        boolean inAnchorNotTarget = path.length() == 0 && this.target.length() != 0;
        ISVNWCDb.WCDbInfo wcDbInfo = this.db.readInfo(localAbspath, ISVNWCDb.WCDbInfo.InfoField.revision, ISVNWCDb.WCDbInfo.InfoField.propsMod);
        long revision = wcDbInfo.revision;
        boolean propsMod = wcDbInfo.propsMod;
        SvnDiffSource leftSource = new SvnDiffSource(revision);
        SvnDiffSource rightSource = new SvnDiffSource(-1L);
        boolean skip = false;
        boolean skipChildren = false;
        if (compared != null) {
            skip = true;
        } else if (!inAnchorNotTarget) {
            this.result.reset();
            this.callback.dirOpened(this.result, new File(path), leftSource, rightSource, null, null);
            skip = this.result.skip;
            skipChildren = this.result.skipChildren;
        }
        if (!skipChildren && depth != SVNDepth.EMPTY) {
            SVNDepth depthBelowHere = depth;
            if (depthBelowHere == SVNDepth.IMMEDIATES) {
                depthBelowHere = SVNDepth.EMPTY;
            }
            boolean diffFiles = depth == SVNDepth.UNKNOWN || depth.compareTo(SVNDepth.FILES) >= 0;
            boolean diffDirectories = depth == SVNDepth.UNKNOWN || depth.compareTo(SVNDepth.IMMEDIATES) >= 0;
            HashMap<String, ISVNWCDb.SVNWCDbInfo> nodes = new HashMap<String, ISVNWCDb.SVNWCDbInfo>();
            this.db.readChildren(localAbspath, nodes, new HashSet<String>());
            ArrayList children = new ArrayList(nodes.keySet());
            Collections.sort(children);
            for (String name : children) {
                ISVNWCDb.WCDbBaseInfo baseInfo;
                ISVNWCDb.SVNWCDbInfo info = (ISVNWCDb.SVNWCDbInfo)nodes.get(name);
                if (inAnchorNotTarget && !this.target.equals(name) || compared != null && compared.contains(name) || info.status.isNotPresent()) continue;
                assert (info.status == ISVNWCDb.SVNWCDbStatus.Normal || info.status == ISVNWCDb.SVNWCDbStatus.Added || info.status == ISVNWCDb.SVNWCDbStatus.Deleted);
                File childAbsPath = SVNFileUtil.createFilePath(localAbspath, name);
                File childRelPath = SVNFileUtil.createFilePath(path, name);
                boolean reposOnly = false;
                boolean localOnly = false;
                ISVNWCDb.SVNWCDbKind baseKind = ISVNWCDb.SVNWCDbKind.Unknown;
                if (!info.haveBase) {
                    localOnly = true;
                    if (info.status == ISVNWCDb.SVNWCDbStatus.Deleted) {
                        continue;
                    }
                } else if (info.status == ISVNWCDb.SVNWCDbStatus.Normal) {
                    baseKind = info.kind;
                } else if (!(info.status != ISVNWCDb.SVNWCDbStatus.Deleted || this.diffPristine && info.haveMoreWork)) {
                    reposOnly = true;
                    baseInfo = this.db.getBaseInfo(childAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status, ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind);
                    baseKind = baseInfo.kind;
                    if (baseInfo.status.isNotPresent()) {
                        continue;
                    }
                } else {
                    baseInfo = this.db.getBaseInfo(childAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status, ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind);
                    baseKind = baseInfo.kind;
                    if (baseInfo.status.isNotPresent()) {
                        localOnly = true;
                    } else if (baseKind != info.kind || !this.ignoreAncestry) {
                        reposOnly = true;
                        localOnly = true;
                    }
                }
                if (this.localBeforeRemote && localOnly) {
                    if (info.kind == ISVNWCDb.SVNWCDbKind.File && diffFiles) {
                        SvnNgDiffUtil.diffLocalOnlyFile(childAbsPath, childRelPath, this.changelists, this.diffPristine, this.context, this.callback);
                    } else if (info.kind == ISVNWCDb.SVNWCDbKind.Dir && diffDirectories) {
                        SvnNgDiffUtil.diffLocalOnlyDirectory(childAbsPath, childRelPath, depthBelowHere, this.changelists, this.diffPristine, this.context, this.callback);
                    }
                }
                if (reposOnly) {
                    if (baseKind == ISVNWCDb.SVNWCDbKind.File && diffFiles) {
                        SvnNgDiffUtil.diffBaseOnlyFile(childAbsPath, childRelPath, this.revision, this.db, this.callback);
                    } else if (baseKind == ISVNWCDb.SVNWCDbKind.Dir && diffDirectories) {
                        SvnNgDiffUtil.diffBaseOnlyDirectory(childAbsPath, childRelPath, this.revision, depthBelowHere, this.db, this.callback);
                    }
                } else if (!localOnly) {
                    if (info.kind == ISVNWCDb.SVNWCDbKind.File && diffFiles) {
                        if (info.status != ISVNWCDb.SVNWCDbStatus.Normal || !this.diffPristine) {
                            SvnNgDiffUtil.diffBaseWorkingDiff(childAbsPath, childRelPath, this.revision, this.changelists, this.diffPristine, this.context, this.callback);
                        }
                    } else if (info.kind == ISVNWCDb.SVNWCDbKind.Dir && diffDirectories) {
                        this.walkLocalNodesDiff(childAbsPath, SVNFileUtil.getFilePath(childRelPath), depthBelowHere, null);
                    }
                }
                if (this.localBeforeRemote || !localOnly) continue;
                if (info.kind == ISVNWCDb.SVNWCDbKind.File && diffFiles) {
                    SvnNgDiffUtil.diffLocalOnlyFile(childAbsPath, childRelPath, this.changelists, this.diffPristine, this.context, this.callback);
                    continue;
                }
                if (info.kind != ISVNWCDb.SVNWCDbKind.Dir || !diffDirectories) continue;
                SvnNgDiffUtil.diffLocalOnlyDirectory(childAbsPath, childRelPath, depthBelowHere, this.changelists, this.diffPristine, this.context, this.callback);
            }
        }
        if (compared != null) {
            return;
        }
        if (!skip && this.changelists == null && !inAnchorNotTarget && propsMod) {
            SVNWCContext.PropDiffs propDiffs = this.context.getPropDiffs(localAbspath);
            SVNProperties propChanges = propDiffs.propChanges;
            SVNProperties leftProps = propDiffs.originalProps;
            SVNProperties rightProps = new SVNProperties(leftProps);
            rightProps.putAll(propChanges);
            rightProps.removeNullValues();
            this.result.reset();
            this.callback.dirChanged(this.result, new File(path), leftSource, rightSource, leftProps, rightProps, propChanges, null);
        } else if (!skip) {
            this.result.reset();
            this.callback.dirClosed(this.result, new File(path), leftSource, rightSource, null);
        }
    }

    private File createTempFile(File tempDir) throws SVNException {
        File tempFile = SVNFileUtil.createUniqueFile(tempDir, "diff.", ".tmp", true);
        this.tempFiles.add(tempFile);
        return tempFile;
    }

    private void addToCompared(Entry entry, String path) {
        if (entry.compared == null) {
            this.currentEntry.compared = new HashSet<String>();
        }
        this.currentEntry.compared.add(path);
    }

    public void cleanup() {
        for (File tempFile : this.tempFiles) {
            try {
                SVNFileUtil.deleteFile(tempFile);
            }
            catch (SVNException sVNException) {}
        }
    }

    @Override
    public long getTargetRevision() {
        return this.revision;
    }

    public static SVNProperties computePropDiff(SVNProperties props1, SVNProperties props2) {
        SVNProperties propsDiff = new SVNProperties();
        if (props2 != null) {
            for (String newPropName : props2.nameSet()) {
                if (props1.containsName(newPropName)) {
                    SVNPropertyValue oldValue = props2.getSVNPropertyValue(newPropName);
                    SVNPropertyValue value = props1.getSVNPropertyValue(newPropName);
                    if (oldValue != null && !oldValue.equals(value)) {
                        propsDiff.put(newPropName, oldValue);
                        continue;
                    }
                    if (oldValue != null || value == null) continue;
                    propsDiff.put(newPropName, oldValue);
                    continue;
                }
                propsDiff.put(newPropName, props2.getSVNPropertyValue(newPropName));
            }
        }
        if (props1 != null) {
            for (String oldPropName : props1.nameSet()) {
                if (props2.containsName(oldPropName)) continue;
                propsDiff.put(oldPropName, (String)null);
            }
        }
        return propsDiff;
    }

    private SVNWCDbRoot getWcRoot() throws SVNException {
        if (this.wcRoot == null) {
            SVNWCDb.DirParsedInfo parsed = ((SVNWCDb)this.db).parseDir(this.anchorAbspath, SVNSqlJetDb.Mode.ReadOnly);
            this.wcRoot = parsed.wcDbDir.getWCRoot();
        }
        return this.wcRoot;
    }

    private void handleLocalOnly(Entry pb, String name) throws SVNException {
        boolean reposDelete;
        boolean bl = reposDelete = pb.deletes != null && pb.deletes.contains(name);
        assert (!name.contains("/"));
        assert (!pb.added || this.ignoreAncestry);
        if (pb.skipChildren) {
            return;
        }
        pb.ensureLocalInfo();
        ISVNWCDb.SVNWCDbInfo info = pb.localInfo.get(name);
        if (info == null || info.status.isNotPresent()) {
            return;
        }
        switch (info.status) {
            case Incomplete: {
                return;
            }
            case Normal: {
                if (!reposDelete) {
                    return;
                }
                pb.deletes.remove(name);
                break;
            }
            case Deleted: {
                if (this.diffPristine && reposDelete) break;
                return;
            }
        }
        if (info.kind == ISVNWCDb.SVNWCDbKind.Dir) {
            this.depth = pb.depth == SVNDepth.INFINITY || pb.depth == SVNDepth.UNKNOWN ? pb.depth : SVNDepth.EMPTY;
            SvnNgDiffUtil.diffLocalOnlyDirectory(SVNFileUtil.createFilePath(pb.localAbspath, name), SVNFileUtil.createFilePath(pb.path, name), reposDelete ? SVNDepth.INFINITY : this.depth, this.changelists, this.diffPristine, this.context, this.callback);
        } else {
            SvnNgDiffUtil.diffLocalOnlyFile(SVNFileUtil.createFilePath(pb.localAbspath, name), SVNFileUtil.createFilePath(pb.path, name), this.changelists, this.diffPristine, this.context, this.callback);
        }
    }

    private class Entry {
        private boolean isFile;
        private Entry parent;
        private String path;
        private String name;
        private boolean added;
        private SVNDepth depth;
        private SVNProperties propChanges;
        private File localAbspath;
        private SvnChecksum baseChecksum;
        private SvnChecksum resultChecksum;
        private Set<String> compared;
        private SvnDiffSource leftSource;
        private SvnDiffSource rightSource;
        private boolean skip;
        private boolean skipChildren;
        private Set<String> deletes;
        private boolean reposOnly;
        private boolean ignoringAncestry;
        private File tempFile;
        private Map<String, ISVNWCDb.SVNWCDbInfo> localInfo;
        private SVNProperties baseProps;
        private boolean hasPropChange;
        private boolean changePropertyCalled;

        public Entry(boolean file, String path, Entry parent, boolean added, SVNDepth depth, File localAbspath) {
            this.isFile = file;
            this.path = path;
            this.name = SVNPathUtil.tail(path);
            this.parent = parent;
            this.added = added;
            this.depth = depth;
            this.localAbspath = localAbspath;
            this.propChanges = new SVNProperties();
            this.compared = new HashSet<String>();
        }

        public void ensureLocalInfo() throws SVNException {
            if (this.localInfo != null) {
                return;
            }
            this.localInfo = new HashMap<String, ISVNWCDb.SVNWCDbInfo>();
            SvnDiffEditor.this.db.readChildren(this.localAbspath, this.localInfo, new HashSet<String>());
        }
    }
}

