/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeInfo;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNMergeDriver;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.io.ISVNLocationSegmentHandler;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.SVNLocationSegment;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.ISvnOperationOptionsProvider;
import org.tmatesoft.svn.core.wc2.SvnCopySource;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class SvnRepositoryAccess {
    private SVNWCContext context;
    private ISvnOperationOptionsProvider operationOptionsProvider;

    protected SvnRepositoryAccess(ISvnOperationOptionsProvider operationOptionsProvider, SVNWCContext context) throws SVNException {
        this.operationOptionsProvider = operationOptionsProvider;
        this.context = context;
    }

    protected ISvnOperationOptionsProvider getOperationOptionsProvider() {
        return this.operationOptionsProvider;
    }

    protected SVNWCContext getWCContext() {
        return this.context;
    }

    public abstract SvnCopySource createRemoteCopySource(SVNWCContext var1, SvnCopySource var2) throws SVNException;

    public abstract Structure<RepositoryInfo> createRepositoryFor(SvnTarget var1, SVNRevision var2, SVNRevision var3, File var4) throws SVNException;

    public abstract Structure<RevisionsPair> getRevisionNumber(SVNRepository var1, SvnTarget var2, SVNRevision var3, Structure<RevisionsPair> var4) throws SVNException;

    public abstract Structure<UrlInfo> getURLFromPath(SvnTarget var1, SVNRevision var2, SVNRepository var3) throws SVNException;

    public SVNURL resolveUrl(SvnTarget target, SVNRepository repository, SVNRevision pegRevision, SVNRevision revision) throws SVNException {
        SVNRevision[] resolvedRevisions = this.resolveRevisions(pegRevision, revision, target.isURL(), true);
        SVNRevision pegRev = resolvedRevisions[0];
        SVNRevision startRev = resolvedRevisions[1];
        Structure<LocationsInfo> locationsInfo = this.getLocations(repository, target, pegRev, startRev, SVNRevision.UNDEFINED);
        SVNURL url = (SVNURL)locationsInfo.get(LocationsInfo.startUrl);
        locationsInfo.release();
        return url;
    }

    protected SVNRevision[] resolveRevisions(SVNRevision pegRevision, SVNRevision revision, boolean isURL, boolean noticeLocalModifications) {
        if (!pegRevision.isValid()) {
            pegRevision = isURL ? SVNRevision.HEAD : (noticeLocalModifications ? SVNRevision.WORKING : SVNRevision.BASE);
        }
        if (!revision.isValid()) {
            revision = pegRevision;
        }
        return new SVNRevision[]{pegRevision, revision};
    }

    public SVNRepository createRepository(SVNURL url, String expectedUuid, boolean mayReuse) throws SVNException {
        String reposUUID;
        SVNRepository repository = null;
        if (this.getOperationOptionsProvider().getRepositoryPool() == null) {
            repository = SVNRepositoryFactory.create(url, null);
            repository.setAuthenticationManager(this.getOperationOptionsProvider().getAuthenticationManager());
        } else {
            repository = this.getOperationOptionsProvider().getRepositoryPool().createRepository(url, mayReuse);
        }
        if (expectedUuid != null && !expectedUuid.equals(reposUUID = repository.getRepositoryUUID(true))) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_UUID_MISMATCH, "Repository UUID ''{0}'' doesn''t match expected UUID ''{1}''", reposUUID, expectedUuid);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        repository.setCanceller(this.getOperationOptionsProvider().getCanceller());
        repository.setEventHandler(this.getOperationOptionsProvider().getEventHandler());
        return repository;
    }

    public Structure<LocationsInfo> getLocations(SVNRepository repository, SvnTarget path, SVNRevision revision, SVNRevision start, SVNRevision end) throws SVNException {
        SVNErrorMessage err;
        Object source;
        long[] lArray;
        long endRevisionNumber;
        if (!revision.isValid() || !start.isValid()) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION), SVNLogType.DEFAULT);
        }
        long pegRevisionNumber = -1L;
        SVNURL url = null;
        if (path.isFile()) {
            if (revision == SVNRevision.WORKING && this.getWCContext() != null) {
                SVNURL sessionUrl;
                Structure<StructureFields.NodeOriginInfo> nodeOrigin = this.getWCContext().getNodeOrigin(path.getFile(), false, StructureFields.NodeOriginInfo.isCopy, StructureFields.NodeOriginInfo.revision, StructureFields.NodeOriginInfo.reposRelpath, StructureFields.NodeOriginInfo.reposRootUrl);
                boolean isCopy = nodeOrigin.is(StructureFields.NodeOriginInfo.isCopy);
                long pegRevNum = nodeOrigin.lng(StructureFields.NodeOriginInfo.revision);
                File reposRelPath = (File)nodeOrigin.get(StructureFields.NodeOriginInfo.reposRelpath);
                SVNURL reposRootUrl = (SVNURL)nodeOrigin.get(StructureFields.NodeOriginInfo.reposRootUrl);
                url = reposRelPath != null ? reposRootUrl.appendPath(SVNFileUtil.getFilePath(reposRelPath), false) : null;
                if (url != null && isCopy && repository != null && !(sessionUrl = repository.getLocation()).equals(url)) {
                    repository = null;
                }
            } else {
                url = null;
            }
            if (url == null) {
                Structure<UrlInfo> urlInfo = this.getURLFromPath(path, revision, repository);
                if (urlInfo.hasValue(UrlInfo.dropRepsitory) && urlInfo.is(UrlInfo.dropRepsitory)) {
                    repository = null;
                }
                url = (SVNURL)urlInfo.get(UrlInfo.url);
                if (urlInfo.hasValue(UrlInfo.pegRevision)) {
                    pegRevisionNumber = urlInfo.lng(UrlInfo.pegRevision);
                }
                urlInfo.release();
            }
            if (url == null) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)path.getFile());
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
        } else {
            url = path.getURL();
        }
        if (repository == null) {
            repository = this.createRepository(url, null, true);
        } else {
            repository.setLocation(url, false);
        }
        Structure<RevisionsPair> pair = null;
        if (pegRevisionNumber < 0L) {
            pair = this.getRevisionNumber(repository, path, revision, pair);
            pegRevisionNumber = pair.lng(RevisionsPair.revNumber);
        }
        pair = this.getRevisionNumber(repository, path, start, pair);
        long startRevisionNumber = pair.lng(RevisionsPair.revNumber);
        if (end == SVNRevision.UNDEFINED) {
            endRevisionNumber = startRevisionNumber;
        } else {
            pair = this.getRevisionNumber(repository, path, end, pair);
            endRevisionNumber = pair.lng(RevisionsPair.revNumber);
        }
        pair.release();
        Object result = Structure.obtain(LocationsInfo.class);
        ((Structure)result).set((LocationsInfo)LocationsInfo.startRevision, startRevisionNumber);
        if (end != SVNRevision.UNDEFINED) {
            ((Structure)result).set((LocationsInfo)LocationsInfo.startRevision, endRevisionNumber);
        }
        url = repository.getLocation();
        if (!(startRevisionNumber != pegRevisionNumber || endRevisionNumber != pegRevisionNumber && SVNRevision.isValidRevisionNumber(endRevisionNumber))) {
            ((Structure)result).set((LocationsInfo)LocationsInfo.startUrl, url);
            ((Structure)result).set((LocationsInfo)LocationsInfo.endUrl, url);
            return result;
        }
        SVNURL repositoryRootURL = repository.getRepositoryRoot(true);
        if (startRevisionNumber == endRevisionNumber) {
            long[] lArray2 = new long[1];
            lArray = lArray2;
            lArray2[0] = startRevisionNumber;
        } else {
            long[] lArray3 = new long[2];
            lArray3[0] = startRevisionNumber;
            lArray = lArray3;
            lArray3[1] = endRevisionNumber;
        }
        long[] revisionsRange = lArray;
        Map locations = repository.getLocations("", (Map)null, pegRevisionNumber, revisionsRange);
        SVNLocationEntry startPath = (SVNLocationEntry)locations.get(startRevisionNumber);
        SVNLocationEntry endPath = (SVNLocationEntry)locations.get(endRevisionNumber);
        if (startPath == null) {
            source = path != null ? path : url;
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "Unable to find repository location for ''{0}'' in revision ''{1}''", source, startRevisionNumber);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (endPath == null) {
            source = path != null ? path : url;
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "The location for ''{0}'' for revision {1} does not exist in the repository or refers to an unrelated object", source, endRevisionNumber);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        ((Structure)result).set((LocationsInfo)LocationsInfo.startUrl, repositoryRootURL.appendPath(startPath.getPath(), false));
        if (end.isValid()) {
            ((Structure)result).set((LocationsInfo)LocationsInfo.endUrl, repositoryRootURL.appendPath(endPath.getPath(), false));
        }
        return result;
    }

    public Map<String, SVNMergeRangeList> getReposMergeInfo(SVNRepository repository, String path, long revision, SVNMergeInfoInheritance inheritance, boolean squelchIncapable) throws SVNException {
        SVNMergeInfo mergeInfo;
        Map<String, SVNMergeInfo> reposMergeInfo;
        block3: {
            reposMergeInfo = null;
            try {
                reposMergeInfo = repository.getMergeInfo(new String[]{path}, revision, inheritance, false);
            }
            catch (SVNException svne) {
                if (squelchIncapable && svne.getErrorMessage().getErrorCode() == SVNErrorCode.UNSUPPORTED_FEATURE) break block3;
                throw svne;
            }
        }
        String rootRelativePath = this.getPathRelativeToRoot(repository.getLocation(), repository.getRepositoryRoot(false), repository);
        Map<String, SVNMergeRangeList> targetMergeInfo = null;
        if (reposMergeInfo != null && (mergeInfo = reposMergeInfo.get(rootRelativePath)) != null) {
            targetMergeInfo = mergeInfo.getMergeSourcesToMergeLists();
        }
        return targetMergeInfo;
    }

    protected String getPathRelativeToRoot(SVNURL url, SVNURL reposRootURL, SVNRepository repos) throws SVNException {
        if (reposRootURL == null) {
            reposRootURL = repos.getRepositoryRoot(true);
        }
        String reposRootPath = reposRootURL.getPath();
        Object absPath = url.getPath();
        if (!((String)absPath).startsWith(reposRootPath)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "URL ''{0}'' is not a child of repository root URL ''{1}''", url, reposRootURL);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (!((String)(absPath = ((String)absPath).substring(reposRootPath.length()))).startsWith("/")) {
            absPath = "/" + (String)absPath;
        }
        return absPath;
    }

    public String getPathRelativeToSession(SVNURL url, SVNURL sessionURL, SVNRepository repos) {
        if (sessionURL == null) {
            sessionURL = repos.getLocation();
        }
        String reposPath = sessionURL.getPath();
        String absPath = url.getPath();
        if (!absPath.startsWith(reposPath + "/") && !absPath.equals(reposPath)) {
            return null;
        }
        if ((absPath = absPath.substring(reposPath.length())).startsWith("/")) {
            absPath = absPath.substring(1);
        }
        return absPath;
    }

    public SVNLocationSegment getYoungestCommonAncestor(SVNURL url1, long rev1, SVNURL url2, long rev2) throws SVNException {
        boolean[] hasZero1 = new boolean[1];
        boolean[] hasZero2 = new boolean[1];
        Map<String, SVNMergeRangeList> history1 = this.getHistoryAsMergeInfo(url1, SVNRevision.create(rev1), -1L, -1L, hasZero1, null);
        Map<String, SVNMergeRangeList> history2 = this.getHistoryAsMergeInfo(url2, SVNRevision.create(rev2), -1L, -1L, hasZero2, null);
        long ycRevision = -1L;
        String ycPath = null;
        for (String path : history1.keySet()) {
            SVNMergeRangeList intersection;
            SVNMergeRangeList ranges1 = history1.get(path);
            SVNMergeRangeList ranges2 = history2.get(path);
            if (ranges2 == null || (intersection = ranges1.intersect(ranges2, true)) == null || intersection.isEmpty()) continue;
            SVNMergeRange ycRange = intersection.getRanges()[intersection.getSize() - 1];
            if (ycRevision >= 0L && ycRange.getEndRevision() <= ycRevision) continue;
            ycRevision = ycRange.getEndRevision();
            ycPath = path.substring(1);
        }
        if (ycPath == null && hasZero1[0] && hasZero2[0]) {
            ycPath = "/";
            ycRevision = 0L;
        }
        return new SVNLocationSegment(ycRevision, ycRevision, ycPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, SVNMergeRangeList> getHistoryAsMergeInfo(SVNURL url, SVNRevision pegRevision, long rangeYoungest, long rangeOldest, boolean[] hasZero, SVNRepository repos) throws SVNException {
        long[] pegRevNum = new long[1];
        Structure<RevisionsPair> pair = this.getRevisionNumber(repos, SvnTarget.fromURL(url), pegRevision, null);
        pegRevNum[0] = pair.lng(RevisionsPair.revNumber);
        pair.release();
        boolean closeSession = false;
        try {
            List<SVNLocationSegment> segments;
            if (repos == null) {
                repos = this.createRepository(url, null, false);
                closeSession = true;
            }
            if (!SVNRevision.isValidRevisionNumber(rangeYoungest)) {
                rangeYoungest = pegRevNum[0];
            }
            if (!SVNRevision.isValidRevisionNumber(rangeOldest)) {
                rangeOldest = 0L;
            }
            if (!(segments = repos.getLocationSegments("", pegRevNum[0], rangeYoungest, rangeOldest)).isEmpty() && hasZero != null && hasZero.length > 0) {
                SVNLocationSegment oldest = segments.get(0);
                hasZero[0] = oldest.getStartRevision() == 0L;
            }
            Map<String, SVNMergeRangeList> map = SvnRepositoryAccess.getMergeInfoFromSegments(segments);
            return map;
        }
        finally {
            if (closeSession) {
                repos.closeSession();
            }
        }
    }

    public static Map<String, SVNMergeRangeList> getMergeInfoFromSegments(Collection<SVNLocationSegment> segments) {
        LinkedList<SVNMergeRange> pathRanges;
        TreeMap mergeInfo = new TreeMap();
        for (SVNLocationSegment segment : segments) {
            if (segment.getPath() == null) continue;
            String sourcePath = segment.getPath();
            pathRanges = (LinkedList<SVNMergeRange>)mergeInfo.get(sourcePath);
            if (pathRanges == null) {
                pathRanges = new LinkedList<SVNMergeRange>();
                mergeInfo.put(sourcePath, pathRanges);
            }
            SVNMergeRange range = new SVNMergeRange(Math.max(segment.getStartRevision() - 1L, 0L), segment.getEndRevision(), true);
            pathRanges.add(range);
        }
        TreeMap<String, SVNMergeRangeList> result = new TreeMap<String, SVNMergeRangeList>();
        for (String path : mergeInfo.keySet()) {
            pathRanges = (Collection)mergeInfo.get(path);
            result.put(path, SVNMergeRangeList.fromCollection(pathRanges));
        }
        return result;
    }

    public SVNLocationEntry getCopySource(SvnTarget target, SVNRevision revision) throws SVNException {
        Structure<RepositoryInfo> repositoryInfo = this.createRepositoryFor(target, revision, revision, null);
        SVNRepository repository = (SVNRepository)repositoryInfo.get(RepositoryInfo.repository);
        long atRev = repositoryInfo.lng(RepositoryInfo.revision);
        repositoryInfo.release();
        final Object[] copyFrom = new Object[3];
        try {
            repository.getLocationSegments("", atRev, atRev, -1L, new ISVNLocationSegmentHandler(){

                @Override
                public void handleLocationSegment(SVNLocationSegment locationSegment) throws SVNException {
                    if (copyFrom[0] == null) {
                        copyFrom[0] = Boolean.TRUE;
                    } else {
                        if (copyFrom[1] != null) {
                            return;
                        }
                        if (locationSegment.getPath() != null) {
                            copyFrom[1] = locationSegment.getPath();
                            copyFrom[2] = locationSegment.getEndRevision();
                        }
                    }
                }
            });
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND || e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_DAV_REQUEST_FAILED) {
                return new SVNLocationEntry(-1L, null);
            }
            throw e;
        }
        if (copyFrom[1] != null) {
            return new SVNLocationEntry((Long)copyFrom[2], (String)copyFrom[1]);
        }
        return null;
    }

    public Map<String, SVNMergeRangeList> getHistoryAsMergeInfo(SVNRepository repos, SvnTarget target, long youngest, long oldest) throws SVNException {
        long pegRevnum = -1L;
        if (repos == null) {
            Structure<RepositoryInfo> reposInfo = this.createRepositoryFor(target, SVNRevision.UNDEFINED, target.getResolvedPegRevision(), null);
            pegRevnum = reposInfo.lng(RepositoryInfo.revision);
            repos = (SVNRepository)reposInfo.get(RepositoryInfo.repository);
            reposInfo.release();
        } else if (target.getPegRevision() == SVNRevision.HEAD || target.getPegRevision() == SVNRevision.UNDEFINED) {
            pegRevnum = repos.getLatestRevision();
        } else if (target.getPegRevision().getNumber() >= 0L) {
            pegRevnum = target.getPegRevision().getNumber();
        } else if (target.getPegRevision().getDate() != null) {
            pegRevnum = repos.getDatedRevision(target.getPegRevision().getDate());
        } else {
            if (target.isURL()) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_VERSIONED_PATH_REQUIRED);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            Structure<RevisionsPair> pair = this.getRevisionNumber(repos, target, target.getPegRevision(), null);
            pegRevnum = pair.lng(RevisionsPair.revNumber);
            pair.release();
        }
        if (youngest < 0L) {
            youngest = pegRevnum;
        }
        if (oldest < 0L) {
            oldest = 0L;
        }
        List<SVNLocationSegment> segments = repos.getLocationSegments("", pegRevnum, youngest, oldest);
        return SVNMergeDriver.getMergeInfoFromSegments(segments);
    }

    public static enum LocationsInfo {
        startUrl,
        startRevision,
        endUrl,
        endRevision;

    }

    public static enum UrlInfo {
        url,
        pegRevision,
        dropRepsitory;

    }

    public static enum RevisionsPair {
        revNumber,
        youngestRevision;

    }

    public static enum RepositoryInfo {
        repository,
        revision,
        url;

    }
}

