/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.svn.SVNConnection;
import org.tmatesoft.svn.core.internal.io.svn.SVNReader;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

class SVNCommitEditor
implements ISVNEditor {
    private SVNConnection myConnection;
    private SVNRepositoryImpl myRepository;
    private ISVNCommitCallback myCloseCallback;
    private Stack myDirsStack;
    private int myNextToken;
    private Map myFilesToTokens;
    private int myDiffWindowCount = 0;
    private boolean myIsAborted;

    public SVNCommitEditor(SVNRepositoryImpl location, SVNConnection connection, ISVNCommitCallback closeCallback) {
        this.myRepository = location;
        this.myConnection = connection;
        this.myCloseCallback = closeCallback;
        this.myDirsStack = new Stack();
        this.myNextToken = 0;
    }

    @Override
    public void targetRevision(long revision) throws SVNException {
    }

    @Override
    public void absentDir(String path) throws SVNException {
    }

    @Override
    public void absentFile(String path) throws SVNException {
    }

    @Override
    public void openRoot(long revision) throws SVNException {
        DirBaton rootBaton = new DirBaton(this.myNextToken++);
        this.myConnection.write("(w((n)s))", new Object[]{"open-root", SVNCommitEditor.getRevisionObject(revision), rootBaton.getToken()});
        this.myDirsStack.push(rootBaton);
    }

    @Override
    public void deleteEntry(String path, long revision) throws SVNException {
        DirBaton parentBaton = (DirBaton)this.myDirsStack.peek();
        this.myConnection.write("(w(s(n)s))", new Object[]{"delete-entry", path, SVNCommitEditor.getRevisionObject(revision), parentBaton.getToken()});
    }

    @Override
    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        DirBaton parentBaton = (DirBaton)this.myDirsStack.peek();
        DirBaton dirBaton = new DirBaton(this.myNextToken++);
        if (copyFromPath != null) {
            if (!SVNRevision.isValidRevisionNumber(copyFromRevision)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Got source path but no source revision for ''{0}''", (Object)path);
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            String rootURL = this.myRepository.getRepositoryRoot(false).toString();
            copyFromPath = SVNPathUtil.append(rootURL, SVNEncodingUtil.uriEncode(this.myRepository.getRepositoryPath(copyFromPath)));
            this.myConnection.write("(w(sss(sn)))", new Object[]{"add-dir", path, parentBaton.getToken(), dirBaton.getToken(), copyFromPath, SVNCommitEditor.getRevisionObject(copyFromRevision)});
        } else {
            this.myConnection.write("(w(sss()))", new Object[]{"add-dir", path, parentBaton.getToken(), dirBaton.getToken()});
        }
        this.myDirsStack.push(dirBaton);
    }

    @Override
    public void openDir(String path, long revision) throws SVNException {
        DirBaton parentBaton = (DirBaton)this.myDirsStack.peek();
        DirBaton dirBaton = new DirBaton(this.myNextToken++);
        this.myConnection.write("(w(sss(n)))", new Object[]{"open-dir", path, parentBaton.getToken(), dirBaton.getToken(), SVNCommitEditor.getRevisionObject(revision)});
        this.myDirsStack.push(dirBaton);
    }

    @Override
    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        DirBaton dirBaton = (DirBaton)this.myDirsStack.peek();
        byte[] bytes = SVNPropertyValue.getPropertyAsBytes(value);
        this.myConnection.write("(w(ss(b)))", new Object[]{"change-dir-prop", dirBaton.getToken(), name, bytes});
    }

    @Override
    public void closeDir() throws SVNException {
        DirBaton dirBaton = (DirBaton)this.myDirsStack.pop();
        this.myConnection.write("(w(s))", new Object[]{"close-dir", dirBaton.getToken()});
    }

    @Override
    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        DirBaton parentBaton = (DirBaton)this.myDirsStack.peek();
        String fileToken = "c" + this.myNextToken++;
        if (copyFromPath != null) {
            String host = this.myRepository.getRepositoryRoot(false).toString();
            copyFromPath = SVNPathUtil.append(host, SVNEncodingUtil.uriEncode(this.myRepository.getRepositoryPath(copyFromPath)));
            this.myConnection.write("(w(sss(sn)))", new Object[]{"add-file", path, parentBaton.getToken(), fileToken, copyFromPath, SVNCommitEditor.getRevisionObject(copyFromRevision)});
        } else {
            this.myConnection.write("(w(sss()))", new Object[]{"add-file", path, parentBaton.getToken(), fileToken});
        }
        if (this.myFilesToTokens == null) {
            this.myFilesToTokens = new SVNHashMap();
        }
        this.myFilesToTokens.put(path, fileToken);
    }

    @Override
    public void openFile(String path, long revision) throws SVNException {
        DirBaton parentBaton = (DirBaton)this.myDirsStack.peek();
        String fileToken = "c" + this.myNextToken++;
        this.myConnection.write("(w(sss(n)))", new Object[]{"open-file", path, parentBaton.getToken(), fileToken, SVNCommitEditor.getRevisionObject(revision)});
        if (this.myFilesToTokens == null) {
            this.myFilesToTokens = new SVNHashMap();
        }
        this.myFilesToTokens.put(path, fileToken);
    }

    @Override
    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        String fileToken = (String)this.myFilesToTokens.get(path);
        this.myDiffWindowCount = 0;
        this.myConnection.write("(w(s(s)))", new Object[]{"apply-textdelta", fileToken, baseChecksum});
    }

    @Override
    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        String fileToken = (String)this.myFilesToTokens.get(path);
        try {
            diffWindow.writeTo(this.myConnection.getDeltaStream(fileToken), this.myDiffWindowCount == 0, this.myConnection.getDeltaCompression());
            ++this.myDiffWindowCount;
            return SVNFileUtil.DUMMY_OUT;
        }
        catch (IOException e) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, e.getMessage()), e, SVNLogType.NETWORK);
            return null;
        }
    }

    @Override
    public void textDeltaEnd(String path) throws SVNException {
        String fileToken = (String)this.myFilesToTokens.get(path);
        this.myDiffWindowCount = 0;
        this.myConnection.write("(w(s))", new Object[]{"textdelta-end", fileToken});
    }

    @Override
    public void changeFileProperty(String path, String name, SVNPropertyValue value) throws SVNException {
        String fileToken = (String)this.myFilesToTokens.get(path);
        byte[] bytes = SVNPropertyValue.getPropertyAsBytes(value);
        this.myConnection.write("(w(ss(b)))", new Object[]{"change-file-prop", fileToken, name, bytes});
    }

    @Override
    public void closeFile(String path, String textChecksum) throws SVNException {
        String fileToken = (String)this.myFilesToTokens.remove(path);
        this.myDiffWindowCount = 0;
        this.myConnection.write("(w(s(s)))", new Object[]{"close-file", fileToken, textChecksum});
    }

    @Override
    public SVNCommitInfo closeEdit() throws SVNException {
        SVNException e = null;
        try {
            this.myConnection.write("(w())", new Object[]{"close-edit"});
            this.myConnection.read("", null, true);
            this.myRepository.authenticate();
            List items = this.myConnection.readTuple("r(?s)(?s)?(?s)", true);
            long revision = SVNReader.getLong(items, 0);
            Date date = SVNReader.getDate(items, 1);
            String author = SVNReader.getString(items, 2);
            String errorMessage = SVNReader.getString(items, 3);
            SVNErrorMessage err = errorMessage == null || errorMessage.length() == 0 ? null : SVNErrorMessage.create(SVNErrorCode.REPOS_POST_COMMIT_HOOK_FAILED, errorMessage, 1);
            SVNCommitInfo sVNCommitInfo = new SVNCommitInfo(revision, author, date, err);
            return sVNCommitInfo;
        }
        catch (SVNException exception) {
            e = exception;
            try {
                this.myConnection.write("(w())", new Object[]{"abort-edit"});
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
            throw exception;
        }
        finally {
            this.myCloseCallback.run(e);
            this.myCloseCallback = null;
        }
    }

    @Override
    public void abortEdit() throws SVNException {
        if (this.myIsAborted || this.myCloseCallback == null) {
            return;
        }
        this.myIsAborted = true;
        SVNException error = null;
        try {
            this.myConnection.write("(w())", new Object[]{"abort-edit"});
            this.myConnection.read("", null, true);
        }
        catch (SVNException e) {
            error = e;
            throw e;
        }
        finally {
            this.myCloseCallback.run(error);
            this.myCloseCallback = null;
        }
    }

    private static Long getRevisionObject(long rev) {
        return rev >= 0L ? Long.valueOf(rev) : null;
    }

    public static interface ISVNCommitCallback {
        public void run(SVNException var1);
    }

    private static final class DirBaton {
        private String myToken;

        public DirBaton(int token) {
            this.myToken = "d" + token;
        }

        public String getToken() {
            return this.myToken;
        }
    }
}

