/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.cli.svn.SVNXMLCommand;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.wc.ISVNInfoHandler;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNInfoCommand
extends SVNXMLCommand
implements ISVNInfoHandler {
    private boolean myIsMultipleTargets;
    private boolean myIsStartNewLine;
    private SVNInfoItemType myPrintWhat;
    private boolean myTargetIsPath;
    private static final int SIM_RANGE_MAX = 1000000;

    public SVNInfoCommand() {
        super("info", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.REVISION);
        options.add(SVNOption.RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.TARGETS);
        options.add(SVNOption.INCREMENTAL);
        options.add(SVNOption.XML);
        options.add(SVNOption.CHANGELIST);
        options.add(SVNOption.SHOW_ITEM);
        options.add(SVNOption.NO_NEWLINE);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNDepth depth;
        SVNErrorMessage errorMessage;
        List<Object> targets = new ArrayList();
        if (this.getSVNEnvironment().getTargets() != null) {
            targets.addAll(this.getSVNEnvironment().getTargets());
        }
        if ((targets = this.getSVNEnvironment().combineTargets(targets, true)).isEmpty()) {
            targets.add("");
        }
        if (this.getSVNEnvironment().isXML()) {
            if (this.getSVNEnvironment().getShowItem() != null) {
                errorMessage = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "--show-item is not valid in --xml mode");
                SVNErrorManager.error(errorMessage, SVNLogType.CLIENT);
            }
            if (this.getSVNEnvironment().isNoNewLine()) {
                errorMessage = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "--no-newline is not valid in --xml mode");
                SVNErrorManager.error(errorMessage, SVNLogType.CLIENT);
            }
            if (!this.getSVNEnvironment().isIncremental()) {
                this.printXMLHeader("info");
            }
        } else if (this.getSVNEnvironment().getShowItem() != null) {
            if (this.getSVNEnvironment().isIncremental()) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "'incremental' option only valid in XML mode"), SVNLogType.CLIENT);
            }
            boolean bl = this.myIsMultipleTargets = this.getSVNEnvironment().getDepth().compareTo(SVNDepth.EMPTY) > 0 || targets.size() > 1;
            if (this.myIsMultipleTargets && this.getSVNEnvironment().isNoNewLine()) {
                errorMessage = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "--no-newline is only available for single-target, non-recursive info operations");
                SVNErrorManager.error(errorMessage, SVNLogType.CLIENT);
            }
            this.findPrintWhat(this.getSVNEnvironment().getShowItem());
            this.myIsStartNewLine = false;
        } else {
            if (this.getSVNEnvironment().isIncremental()) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "'incremental' option only valid in XML mode"), SVNLogType.CLIENT);
            }
            if (this.getSVNEnvironment().isNoNewLine()) {
                errorMessage = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "--no-newline' is only valid with --show-item");
                SVNErrorManager.error(errorMessage, SVNLogType.CLIENT);
            }
        }
        if ((depth = this.getSVNEnvironment().getDepth()) == SVNDepth.UNKNOWN) {
            depth = SVNDepth.EMPTY;
        }
        SVNWCClient client = this.getSVNEnvironment().getClientManager().getWCClient();
        SVNNotifyPrinter printer = new SVNNotifyPrinter(this.getSVNEnvironment());
        client.setEventHandler(printer);
        boolean seenNonExistingTargets = false;
        for (int i = 0; i < targets.size(); ++i) {
            String targetName = (String)targets.get(i);
            SVNPath target = new SVNPath(targetName, true);
            SVNRevision pegRevision = target.getPegRevision();
            if (target.isURL()) {
                if (pegRevision == SVNRevision.UNDEFINED) {
                    pegRevision = SVNRevision.HEAD;
                }
                this.myTargetIsPath = false;
            } else {
                this.myTargetIsPath = true;
            }
            try {
                if (target.isFile()) {
                    client.doInfo(target.getFile(), pegRevision, this.getSVNEnvironment().getStartRevision(), depth, this.getSVNEnvironment().getChangelistsCollection(), this);
                    continue;
                }
                client.doInfo(target.getURL(), pegRevision, this.getSVNEnvironment().getStartRevision(), depth, (ISVNInfoHandler)this);
                continue;
            }
            catch (SVNException e) {
                SVNErrorMessage err = e.getErrorMessage();
                if (err.getErrorCode() == SVNErrorCode.UNVERSIONED_RESOURCE) {
                    this.getSVNEnvironment().getErr().print(SVNCommandUtil.getLocalPath(target.getTarget()) + ": (Not a versioned resource)\n\n");
                    continue;
                }
                this.getSVNEnvironment().handleWarning(err, new SVNErrorCode[]{SVNErrorCode.RA_ILLEGAL_URL, SVNErrorCode.WC_PATH_NOT_FOUND}, this.getSVNEnvironment().isQuiet());
                this.getSVNEnvironment().getErr().println();
                seenNonExistingTargets = true;
            }
        }
        if (this.getSVNEnvironment().isXML() && !this.getSVNEnvironment().isIncremental()) {
            this.printXMLFooter("info");
        } else if (this.getSVNEnvironment().getShowItem() != null && !this.getSVNEnvironment().isNoNewLine() && this.myIsStartNewLine) {
            this.getSVNEnvironment().getOut().print('\n');
        }
        if (seenNonExistingTargets) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Could not display info for all targets because some targets don't exist"), SVNLogType.CLIENT);
        }
    }

    @Override
    public void handleInfo(SVNInfo info) throws SVNException {
        if (this.getSVNEnvironment().isXML()) {
            this.printInfoXML(info);
        } else if (this.getSVNEnvironment().getShowItem() != null) {
            this.printInfoItem(info);
        } else {
            this.printInfo(info);
        }
    }

    protected void printInfo(SVNInfo info) {
        StringBuffer buffer = new StringBuffer();
        String path = null;
        if (info.getFile() != null) {
            path = this.getSVNEnvironment().getRelativePath(info.getFile());
            path = SVNCommandUtil.getLocalPath(path);
        } else {
            path = info.getPath();
            if ("".equals(path) && info.getURL() != null) {
                path = SVNPathUtil.tail(info.getURL().getPath());
            }
        }
        buffer.append("Path: " + path + "\n");
        if (info.getKind() != SVNNodeKind.DIR) {
            buffer.append("Name: " + SVNPathUtil.tail(path.replace(File.separatorChar, '/')) + "\n");
        }
        if (info.getWorkingCopyRoot() != null) {
            buffer.append("Working Copy Root Path: " + SVNPathUtil.validateFilePath(info.getWorkingCopyRoot().getAbsolutePath()) + "\n");
        }
        if (info.getURL() != null) {
            buffer.append("URL: " + info.getURL() + "\n");
        }
        if (info.getRepositoryRootURL() != null) {
            if (info.getURL() != null) {
                String relativeURL = SVNURLUtil.getRelativeURL(info.getRepositoryRootURL(), info.getURL(), true);
                buffer.append("Relative URL: ^/" + relativeURL + "\n");
            }
            buffer.append("Repository Root: " + info.getRepositoryRootURL() + "\n");
        }
        if (info.getRepositoryUUID() != null) {
            buffer.append("Repository UUID: " + info.getRepositoryUUID() + "\n");
        }
        if (info.getRevision() != null && info.getRevision().isValid()) {
            buffer.append("Revision: " + info.getRevision() + "\n");
        }
        String kind = info.getKind() == SVNNodeKind.DIR ? "directory" : (info.getKind() != null ? info.getKind().toString() : "none");
        buffer.append("Node Kind: " + kind + "\n");
        if (!info.isRemote()) {
            File relativePath;
            if (info.getSchedule() == null) {
                buffer.append("Schedule: normal\n");
            } else {
                buffer.append("Schedule: " + info.getSchedule() + "\n");
            }
            if (info.getDepth() != null && info.getDepth() != SVNDepth.UNKNOWN && info.getDepth() != SVNDepth.INFINITY) {
                buffer.append("Depth: " + info.getDepth() + "\n");
            }
            if (info.getCopyFromURL() != null) {
                buffer.append("Copied From URL: " + info.getCopyFromURL() + "\n");
            }
            if (info.getCopyFromRevision() != null && info.getCopyFromRevision().getNumber() >= 0L) {
                buffer.append("Copied From Rev: " + info.getCopyFromRevision() + "\n");
            }
            if (info.getMovedFromPath() != null) {
                relativePath = SVNWCUtils.skipAncestor(info.getWorkingCopyRoot(), info.getMovedFromPath());
                if (relativePath != null && !"".equals(relativePath.getPath())) {
                    buffer.append("Moved From: " + relativePath + "\n");
                } else {
                    buffer.append("Moved From: " + info.getMovedFromPath() + "\n");
                }
            }
            if (info.getMovedToPath() != null) {
                relativePath = SVNWCUtils.skipAncestor(info.getWorkingCopyRoot(), info.getMovedToPath());
                if (relativePath != null && !"".equals(relativePath.getPath())) {
                    buffer.append("Moved To: " + relativePath + "\n");
                } else {
                    buffer.append("Moved To: " + info.getMovedToPath() + "\n");
                }
            }
        }
        if (info.getAuthor() != null) {
            buffer.append("Last Changed Author: " + info.getAuthor() + "\n");
        }
        if (info.getCommittedRevision() != null && info.getCommittedRevision().getNumber() >= 0L) {
            buffer.append("Last Changed Rev: " + info.getCommittedRevision() + "\n");
        }
        if (info.getCommittedDate() != null) {
            buffer.append("Last Changed Date: " + SVNDate.formatHumanDate(info.getCommittedDate(), this.getSVNEnvironment().getClientManager().getOptions()) + "\n");
        }
        if (!info.isRemote()) {
            String cpath;
            if (info.getTextTime() != null) {
                buffer.append("Text Last Updated: " + SVNDate.formatHumanDate(info.getTextTime(), this.getSVNEnvironment().getClientManager().getOptions()) + "\n");
            }
            if (info.getPropTime() != null) {
                buffer.append("Properties Last Updated: " + SVNDate.formatHumanDate(info.getPropTime(), this.getSVNEnvironment().getClientManager().getOptions()) + "\n");
            }
            if (info.getChecksum() != null) {
                buffer.append("Checksum: " + info.getChecksum() + "\n");
            }
            if (info.getConflictOldFile() != null) {
                cpath = this.getSVNEnvironment().getRelativePath(info.getConflictOldFile());
                cpath = SVNCommandUtil.getLocalPath(cpath);
                buffer.append("Conflict Previous Base File: " + cpath + "\n");
            }
            if (info.getConflictWrkFile() != null) {
                cpath = this.getSVNEnvironment().getRelativePath(info.getConflictWrkFile());
                cpath = SVNCommandUtil.getLocalPath(cpath);
                buffer.append("Conflict Previous Working File: " + cpath + "\n");
            }
            if (info.getConflictNewFile() != null) {
                cpath = this.getSVNEnvironment().getRelativePath(info.getConflictNewFile());
                cpath = SVNCommandUtil.getLocalPath(cpath);
                buffer.append("Conflict Current Base File: " + cpath + "\n");
            }
            if (info.getPropConflictFile() != null) {
                cpath = this.getSVNEnvironment().getRelativePath(info.getPropConflictFile());
                cpath = SVNCommandUtil.getLocalPath(cpath);
                buffer.append("Conflict Properties File: " + cpath + "\n");
            }
        }
        if (info.getLock() != null) {
            SVNLock lock = info.getLock();
            if (lock.getID() != null) {
                buffer.append("Lock Token: " + lock.getID() + "\n");
            }
            if (lock.getOwner() != null) {
                buffer.append("Lock Owner: " + lock.getOwner() + "\n");
            }
            if (lock.getCreationDate() != null && lock.getCreationDate().getTime() != 0L) {
                buffer.append("Lock Created: " + SVNDate.formatHumanDate(lock.getCreationDate(), this.getSVNEnvironment().getClientManager().getOptions()) + "\n");
            }
            if (lock.getExpirationDate() != null && lock.getExpirationDate().getTime() != 0L) {
                buffer.append("Lock Expires: " + SVNDate.formatHumanDate(lock.getExpirationDate(), this.getSVNEnvironment().getClientManager().getOptions()) + "\n");
            }
            if (lock.getComment() != null) {
                buffer.append("Lock Comment ");
                int lineCount = SVNCommandUtil.getLinesCount(lock.getComment());
                buffer.append((String)(lineCount > 1 ? "(" + lineCount + " lines)" : "(1 line)"));
                buffer.append(":\n");
                buffer.append(lock.getComment());
                buffer.append("\n");
            }
        }
        if (info.getChangelistName() != null) {
            buffer.append("Changelist: " + info.getChangelistName() + "\n");
        }
        if (info.getTreeConflict() != null) {
            SVNTreeConflictDescription tc = info.getTreeConflict();
            String description = SVNTreeConflictUtil.getHumanReadableConflictDescription(tc);
            buffer.append("Tree conflict: " + description + "\n");
            SVNConflictVersion left = tc.getSourceLeftVersion();
            buffer.append("  Source  left: " + SVNTreeConflictUtil.getHumanReadableConflictVersion(left) + "\n");
            SVNConflictVersion right = tc.getSourceRightVersion();
            buffer.append("  Source right: " + SVNTreeConflictUtil.getHumanReadableConflictVersion(right) + "\n");
        }
        buffer.append("\n");
        this.getSVNEnvironment().getOut().print(buffer.toString());
    }

    private void printInfoItem(SVNInfo info) throws SVNException {
        String targetPath;
        String string = !this.myIsMultipleTargets ? null : (targetPath = !this.myTargetIsPath ? info.getURL().toString() : this.getSVNEnvironment().getRelativePath(info.getFile()));
        if (this.myIsStartNewLine) {
            this.getSVNEnvironment().getOut().print('\n');
        }
        switch (this.myPrintWhat) {
            case KIND: {
                this.printInfoItemString(info.getKind().toString(), targetPath);
                break;
            }
            case URL: {
                this.printInfoItemString(info.getURL().toString(), targetPath);
                break;
            }
            case RELATIVE_URL: {
                this.printInfoItemString(this.relativeUrl(info), targetPath);
                break;
            }
            case REPS_ROOT_URL: {
                this.printInfoItemString(info.getRepositoryRootURL().toString(), targetPath);
                break;
            }
            case REPOS_UUID: {
                this.printInfoItemString(info.getRepositoryUUID(), targetPath);
                break;
            }
            case REVISION: {
                this.printInfoItemRevision(info.getRevision(), targetPath);
                break;
            }
            case LAST_CHANGED_REV: {
                this.printInfoItemRevision(info.getCommittedRevision(), targetPath);
                break;
            }
            case LAST_CHANGED_DATE: {
                this.printInfoItemString(info.getCommittedDate() == null ? null : SVNDate.formatDate(info.getCommittedDate()), targetPath);
                break;
            }
            case LAST_CHANGED_AUTHOR: {
                this.printInfoItemString(info.getAuthor(), targetPath);
                break;
            }
            case WC_ROOT: {
                this.printInfoItemString(info.getWorkingCopyRoot() == null ? null : SVNFileUtil.getFilePath(info.getWorkingCopyRoot().getAbsoluteFile()), targetPath);
                break;
            }
            default: {
                SVNErrorManager.assertionFailure(false, null, SVNLogType.CLIENT);
            }
        }
        this.myIsStartNewLine = true;
    }

    private String relativeUrl(SVNInfo info) {
        String relativePath = SVNPathUtil.getRelativePath(info.getRepositoryRootURL().toString(), info.getURL().toString());
        return "^/" + relativePath;
    }

    private void printInfoItemString(String text, String targetPath) {
        if (text != null) {
            if (targetPath != null) {
                this.getSVNEnvironment().getOut().printf("%s %s", text, targetPath);
            } else {
                this.getSVNEnvironment().getOut().print(text);
            }
        } else if (targetPath != null) {
            this.getSVNEnvironment().getOut().printf("%s %s", "", targetPath);
        }
    }

    private void printInfoItemRevision(SVNRevision revision, String targetPath) {
        if (SVNRevision.isValidRevisionNumber(revision.getNumber())) {
            if (targetPath != null) {
                this.getSVNEnvironment().getOut().printf("%s %s", revision.getNumber(), targetPath);
            } else {
                this.getSVNEnvironment().getOut().printf("%s", revision.getNumber());
            }
        } else if (targetPath != null) {
            this.getSVNEnvironment().getOut().printf("%s %s", "", targetPath);
        }
    }

    protected void printInfoXML(SVNInfo info) {
        String rootURL;
        StringBuffer buffer = new StringBuffer();
        String path = null;
        if (info.getFile() != null) {
            path = this.getSVNEnvironment().getRelativePath(info.getFile());
            path = SVNCommandUtil.getLocalPath(path);
        } else {
            path = info.getPath();
        }
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("kind", info.getKind().toString());
        attrs.put("path", path);
        attrs.put("revision", info.getRevision() != SVNRevision.UNDEFINED ? info.getRevision().toString() : "Resource is not under version control.");
        buffer = this.openXMLTag("entry", 1, attrs, buffer);
        String url = info.getURL() != null ? info.getURL().toString() : null;
        buffer = this.openCDataTag("url", url, buffer);
        String string = rootURL = info.getRepositoryRootURL() != null ? info.getRepositoryRootURL().toString() : null;
        if (rootURL != null && url != null) {
            String relativeURL = SVNURLUtil.getRelativeURL(info.getRepositoryRootURL(), info.getURL(), true);
            buffer = this.openCDataTag("relative-url", "^/" + relativeURL, buffer);
        }
        String uuid = info.getRepositoryUUID();
        if (rootURL != null || uuid != null) {
            buffer = this.openXMLTag("repository", 1, null, buffer);
            buffer = this.openCDataTag("root", rootURL, buffer);
            buffer = this.openCDataTag("uuid", uuid, buffer);
            buffer = this.closeXMLTag("repository", buffer);
        }
        if (info.getFile() != null) {
            File relativePath;
            String schedule;
            buffer = this.openXMLTag("wc-info", 1, null, buffer);
            if (info.getWorkingCopyRoot() != null) {
                buffer = this.openCDataTag("wcroot-abspath", SVNPathUtil.validateFilePath(info.getWorkingCopyRoot().getAbsolutePath()), buffer);
            }
            if ((schedule = info.getSchedule()) == null || "".equals(schedule)) {
                schedule = "normal";
            }
            buffer = this.openCDataTag("schedule", schedule, buffer);
            if (info.getDepth() != null) {
                SVNDepth depth = info.getDepth();
                if (depth == SVNDepth.UNKNOWN && info.getKind() == SVNNodeKind.FILE) {
                    depth = SVNDepth.INFINITY;
                }
                buffer = this.openCDataTag("depth", depth.getName(), buffer);
            }
            if (info.getCopyFromURL() != null) {
                buffer = this.openCDataTag("copy-from-url", info.getCopyFromURL().toString(), buffer);
            }
            if (info.getCopyFromRevision() != null && info.getCopyFromRevision().isValid()) {
                buffer = this.openCDataTag("copy-from-rev", info.getCopyFromRevision().toString(), buffer);
            }
            if (info.getTextTime() != null) {
                buffer = this.openCDataTag("text-updated", ((SVNDate)info.getTextTime()).format(), buffer);
            }
            if (info.getPropTime() != null) {
                buffer = this.openCDataTag("prop-updated", ((SVNDate)info.getPropTime()).format(), buffer);
            }
            buffer = this.openCDataTag("checksum", info.getChecksum(), buffer);
            buffer = this.openCDataTag("changelist", info.getChangelistName(), buffer);
            if (info.getMovedFromPath() != null) {
                relativePath = SVNWCUtils.skipAncestor(info.getWorkingCopyRoot(), info.getMovedFromPath());
                buffer = relativePath != null && !"".equals(relativePath.getPath()) ? this.openCDataTag("moved-from", relativePath.getPath(), buffer) : this.openCDataTag("moved-from", info.getMovedFromPath().getPath(), buffer);
            }
            if (info.getMovedToPath() != null) {
                relativePath = SVNWCUtils.skipAncestor(info.getWorkingCopyRoot(), info.getMovedToPath());
                buffer = relativePath != null && !"".equals(relativePath.getPath()) ? this.openCDataTag("moved-to", relativePath.getPath(), buffer) : this.openCDataTag("moved-to", info.getMovedToPath().getPath(), buffer);
            }
            buffer = this.closeXMLTag("wc-info", buffer);
        }
        if (info.getAuthor() != null || info.getCommittedRevision().isValid() || info.getCommittedDate() != null) {
            this.openXMLTag("commit", 1, "revision", info.getCommittedRevision().toString(), buffer);
            buffer = this.openCDataTag("author", info.getAuthor(), buffer);
            if (info.getCommittedDate() != null) {
                buffer = this.openCDataTag("date", ((SVNDate)info.getCommittedDate()).format(), buffer);
            }
            buffer = this.closeXMLTag("commit", buffer);
        }
        if (info.getConflictNewFile() != null || info.getConflictOldFile() != null || info.getConflictWrkFile() != null || info.getPropConflictFile() != null) {
            buffer = this.openXMLTag("conflict", 1, null, buffer);
            if (info.getConflictOldFile() != null) {
                buffer = this.openCDataTag("prev-base-file", info.getConflictOldFile().getName(), buffer);
            }
            if (info.getConflictWrkFile() != null) {
                buffer = this.openCDataTag("prev-wc-file", info.getConflictWrkFile().getName(), buffer);
            }
            if (info.getConflictNewFile() != null) {
                buffer = this.openCDataTag("cur-base-file", info.getConflictNewFile().getName(), buffer);
            }
            if (info.getPropConflictFile() != null) {
                buffer = this.openCDataTag("prop-file", info.getPropConflictFile().getName(), buffer);
            }
            buffer = this.closeXMLTag("conflict", buffer);
        }
        if (info.getLock() != null) {
            SVNLock lock = info.getLock();
            buffer = this.openXMLTag("lock", 1, null, buffer);
            buffer = this.openCDataTag("token", lock.getID(), buffer);
            buffer = this.openCDataTag("owner", lock.getOwner(), buffer);
            buffer = this.openCDataTag("comment", lock.getComment(), buffer);
            if (lock.getCreationDate() != null) {
                buffer = this.openCDataTag("created", ((SVNDate)lock.getCreationDate()).format(), buffer);
            }
            if (lock.getExpirationDate() != null) {
                buffer = this.openCDataTag("expires", ((SVNDate)lock.getExpirationDate()).format(), buffer);
            }
            buffer = this.closeXMLTag("lock", buffer);
        }
        if (info.getTreeConflict() != null) {
            SVNConflictVersion right;
            SVNTreeConflictDescription tc = info.getTreeConflict();
            SVNHashMap attributes = new SVNHashMap();
            attributes.put("victim", tc.getPath().getName());
            attributes.put("kind", tc.getNodeKind().toString());
            attributes.put("operation", tc.getOperation().getName());
            if (tc.getConflictAction() == SVNConflictAction.EDIT) {
                attributes.put("action", "edit");
            } else if (tc.getConflictAction() == SVNConflictAction.ADD) {
                attributes.put("action", "add");
            } else if (tc.getConflictAction() == SVNConflictAction.DELETE) {
                attributes.put("action", "delete");
            }
            if (tc.getConflictReason() == SVNConflictReason.EDITED) {
                attributes.put("reason", "edit");
            } else if (tc.getConflictReason() == SVNConflictReason.OBSTRUCTED) {
                attributes.put("reason", "obstruction");
            } else if (tc.getConflictReason() == SVNConflictReason.DELETED) {
                attributes.put("reason", "delete");
            } else if (tc.getConflictReason() == SVNConflictReason.ADDED) {
                attributes.put("reason", "add");
            } else if (tc.getConflictReason() == SVNConflictReason.MISSING) {
                attributes.put("reason", "missing");
            } else if (tc.getConflictReason() == SVNConflictReason.UNVERSIONED) {
                attributes.put("reason", "unversioned");
            }
            buffer = this.openXMLTag("tree-conflict", 1, attributes, buffer);
            SVNConflictVersion left = tc.getSourceLeftVersion();
            if (left != null) {
                buffer = this.printConflictVersionXML(left, "source-left", buffer);
            }
            if ((right = tc.getSourceLeftVersion()) != null) {
                buffer = this.printConflictVersionXML(right, "source-right", buffer);
            }
            buffer = this.closeXMLTag("tree-conflict", buffer);
        }
        buffer = this.closeXMLTag("entry", buffer);
        this.getSVNEnvironment().getOut().print(buffer.toString());
    }

    private StringBuffer printConflictVersionXML(SVNConflictVersion version, String name, StringBuffer target) {
        SVNHashMap attributes = new SVNHashMap();
        attributes.put("side", name);
        if (version.getRepositoryRoot() != null) {
            attributes.put("repos-url", version.getRepositoryRoot().toString());
        }
        if (version.getPath() != null) {
            attributes.put("path-in-repos", version.getPath());
        }
        if (version.getPegRevision() >= 0L) {
            attributes.put("revision", Long.toString(version.getPegRevision()));
        }
        if (version.getKind() != SVNNodeKind.UNKNOWN) {
            attributes.put("kind", version.getKind().toString());
        }
        return this.openXMLTag("version", 4, attributes, target);
    }

    private void findPrintWhat(String keyword) throws SVNException {
        ArrayList<String> tokens = new ArrayList<String>();
        for (SVNInfoItemType itemType : SVNInfoItemType.values()) {
            tokens.add(itemType.getName());
        }
        int similarity = this.similarityCheck(keyword, tokens);
        switch (similarity) {
            case 0: {
                this.myPrintWhat = SVNInfoItemType.forName(keyword);
                break;
            }
            case 1: {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "''{0}'' is not a valid value for --show-item", (Object)keyword);
                SVNErrorManager.error(errorMessage, SVNLogType.CLIENT);
                break;
            }
            case 2: {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "''{0}'' is not a valid value for --show-item; did you mean ''{1}''?", keyword, tokens.get(0));
                SVNErrorManager.error(errorMessage, SVNLogType.CLIENT);
                break;
            }
            case 3: {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "''{0}'' is not a valid value for --show-item; did you mean ''{1}'' or ''{2}''?", keyword, tokens.get(0), tokens.get(1));
                SVNErrorManager.error(errorMessage, SVNLogType.CLIENT);
                break;
            }
            default: {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "''{0}'' is not a valid value for --show-item; did you mean ''{1}'', ''{2}'' or ''{3}''?", keyword, tokens.get(0), tokens.get(1), tokens.get(2));
                SVNErrorManager.error(errorMessage, SVNLogType.CLIENT);
            }
        }
    }

    private int similarityCheck(String key, List<String> tokens) {
        final int[] scores = new int[tokens.size()];
        for (int i = 0; i < tokens.size(); ++i) {
            scores[i] = this.stringDiff(key, tokens.get(i));
        }
        ArrayList<Integer> tokenIndices = new ArrayList<Integer>(tokens.size());
        for (int i = 0; i < tokens.size(); ++i) {
            tokenIndices.add(i);
        }
        Collections.sort(tokenIndices, new Comparator<Integer>(){

            @Override
            public int compare(Integer index1, Integer index2) {
                return -(scores[index1] - scores[index2]);
            }
        });
        int result = 1;
        for (Integer index : tokenIndices) {
            if (scores[index] < 666667) continue;
            ++result;
        }
        if (tokens.get((Integer)tokenIndices.get(0)).equals(key)) {
            return 0;
        }
        ArrayList<String> sortedTokens = new ArrayList<String>(tokens.size());
        for (Integer index : tokenIndices) {
            sortedTokens.add(tokens.get(index));
        }
        tokens.clear();
        tokens.addAll(sortedTokens);
        return result;
    }

    private int stringDiff(String s1, String s2) {
        int start1 = 0;
        int start2 = 0;
        int end1 = s1.length();
        int end2 = s2.length();
        int lcs = 0;
        int total = s1.length() + s2.length();
        while (start1 < end1 && start2 < end2 && s1.charAt(start1) == s2.charAt(start2)) {
            ++start1;
            ++start2;
            ++lcs;
        }
        while (start1 < end1 && start2 < end2 && s1.charAt(end1 - 1) == s2.charAt(end2 - 1)) {
            --end1;
            --end2;
            ++lcs;
        }
        if (start1 < end1 && start2 < end2) {
            int p;
            int rest1 = end1 - start1;
            int rest2 = end2 - start2;
            int slots = Math.min(rest1, rest2);
            if (rest1 < rest2) {
                p = start1;
                start1 = start2;
                start2 = p;
                p = end1;
                end1 = end2;
                end2 = p;
                String s = s1;
                s1 = s2;
                s2 = s;
            }
            int[] curr = new int[2 * (slots + 1)];
            int[] prev = new int[2 * (slots + 1)];
            for (p = start1; p < end1; ++p) {
                for (int i = 1; i < slots; ++i) {
                    curr[i] = s1.charAt(p) == s2.charAt(i - 1) ? prev[i - 1] : (curr[i - 1] > prev[i] ? curr[i - 1] : prev[i]);
                }
                int[] tmp = curr;
                curr = prev;
                prev = tmp;
                lcs += prev[slots];
            }
        }
        if (total != 0) {
            return (int)((2000000L * (long)lcs + (long)(total / 2)) / (long)total);
        }
        return 1000000;
    }

    private static enum SVNInfoItemType {
        KIND("kind"),
        URL("url"),
        RELATIVE_URL("relative-url"),
        REPS_ROOT_URL("repos-root-url"),
        REPOS_UUID("repos-uuid"),
        REVISION("revision"),
        LAST_CHANGED_REV("last-changed-revision"),
        LAST_CHANGED_DATE("last-changed-date"),
        LAST_CHANGED_AUTHOR("last-changed-author"),
        WC_ROOT("wc-root");

        private final String name;

        public static SVNInfoItemType forName(String name) {
            SVNInfoItemType[] values;
            for (SVNInfoItemType value : values = SVNInfoItemType.values()) {
                if (!value.getName().equals(name)) continue;
                return value;
            }
            return null;
        }

        private SVNInfoItemType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

