/*
 * Decompiled with CFR 0.152.
 */
package ballbreaker;

import ballbreaker.Game;
import ballbreaker.Pad;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Ball {
    private int dx = 1;
    private int dy = -1;
    private int x = 247;
    private int y = 427;
    private int width = 8;
    private int height = 8;
    private int movementType = 1;
    private boolean powerBall = false;

    public void move(Game game) {
        this.x += this.dx;
        this.y += this.dy;
        if (this.x < 0) {
            this.x = 0;
            if (this.movementType == 3) {
                this.movementType = 2;
                this.dx = -this.dx;
                this.y += 3;
            } else if (this.movementType == 4) {
                this.movementType = 1;
                this.dx = -this.dx;
                this.y -= 2;
            }
        }
        if (this.x > 500 - this.width) {
            this.x = 500 - this.width;
            if (this.movementType == 1) {
                this.movementType = 4;
                this.dx = -this.dx;
                this.y -= 3;
            } else if (this.movementType == 2) {
                this.movementType = 3;
                this.dx = -this.dx;
                this.y += 2;
            }
        }
        if (this.y < 0) {
            this.y = 0;
            if (this.movementType == 1) {
                this.movementType = 2;
                this.x += 2;
                this.dy = -this.dy;
            } else if (this.movementType == 4) {
                this.movementType = 3;
                this.dy = -this.dy;
                this.x -= 3;
            }
        }
        if (this.y >= 439) {
            int lives = game.getLivesLeft();
            if (--lives == 0) {
                Game.setWinStr("You lost the GAME");
                game.endGame();
            } else {
                game.setLivesLeft(lives);
                this.dx = 1;
                this.dy = -1;
                this.movementType = 1;
                game.resetPosition();
            }
        }
    }

    public void rotateBall(int px, int py, String collisionType, Pad pad) {
        if (collisionType.equals("onPad")) {
            if (this.x <= px + pad.getWidth() / 3) {
                if (this.movementType == 2 || this.movementType == 3) {
                    this.x -= 5;
                    this.dx = -1;
                    this.dy = -1;
                    this.movementType = 4;
                }
            } else if (this.x > px + pad.getWidth() / 3 && this.x <= px + pad.getWidth() * 2 / 3) {
                if (this.movementType == 2) {
                    this.dx = 1;
                    this.dy = -1;
                    this.movementType = 1;
                } else if (this.movementType == 3) {
                    this.dx = -1;
                    this.dy = -1;
                    this.movementType = 4;
                }
            } else if (this.x > px + pad.getWidth() * 2 / 3 && this.x <= px + pad.getWidth() && (this.movementType == 2 || this.movementType == 3)) {
                this.x += 5;
                this.dx = 1;
                this.dy = -1;
                this.movementType = 1;
            }
        } else if (collisionType.equals("onBrick")) {
            if (this.y < py) {
                if (this.movementType == 2) {
                    this.movementType = 1;
                    this.dy = -this.dy;
                } else if (this.movementType == 3) {
                    this.movementType = 4;
                    this.dy = -this.dy;
                }
            } else if (this.x <= px) {
                if (this.movementType == 2) {
                    this.movementType = 3;
                    this.dx = -this.dx;
                } else if (this.movementType == 1) {
                    this.movementType = 4;
                    this.dx = -this.dx;
                }
            } else if (this.y >= py + 7) {
                if (this.movementType == 1) {
                    this.movementType = 2;
                    this.dy = -this.dy;
                } else if (this.movementType == 4) {
                    this.movementType = 3;
                    this.dy = -this.dy;
                }
            } else if (this.x >= px + 42) {
                if (this.movementType == 4) {
                    this.movementType = 1;
                    this.dx = -this.dx;
                } else if (this.movementType == 3) {
                    this.movementType = 2;
                    this.dx = -this.dx;
                }
            }
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setX(int newX) {
        this.x = newX;
    }

    public void setY(int newY) {
        this.y = newY;
    }

    public int getHeight() {
        return this.height;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void changeBall(boolean newBall) {
        this.powerBall = newBall;
        if (newBall) {
            this.width = 10;
            this.height = 10;
        } else {
            this.width = 8;
            this.height = 8;
            this.x = 247;
            this.y = 427;
            this.dx = 1;
            this.dy = -1;
            this.movementType = 1;
            this.powerBall = false;
        }
    }

    public boolean isPowerBall() {
        return this.powerBall;
    }

    public void drawBall(Graphics g) {
        if (this.powerBall) {
            g.setColor(Color.red);
            g.fillArc(this.x, this.y, 10, 10, 0, 360);
            g.setColor(Color.black);
            g.drawArc(this.x, this.y, 10, 10, 0, 360);
        } else {
            g.fillArc(this.x, this.y, this.width, this.height, 0, 360);
        }
    }
}

