/*
 * Decompiled with CFR 0.152.
 */
package settings;

import application.RecordInputDevice;
import application.Shutter;
import application.SubtitlesEmbed;
import application.VideoPlayer;
import functions.VideoEncoders;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.text.DecimalFormat;
import javax.swing.JTextField;
import library.FFPROBE;
import settings.InputAndOutput;
import settings.Timecode;

public class Overlay
extends Shutter {
    public static String showTimecode(String filterComplex, String file, boolean videoPlayerCapture) {
        if (caseInAndOut.isSelected() && (VideoPlayer.caseAddTimecode.isSelected() || VideoPlayer.caseShowTimecode.isSelected() || VideoPlayer.caseAddText.isSelected() || VideoPlayer.caseShowFileName.isSelected())) {
            String tc1 = FFPROBE.timecode1;
            String tc2 = FFPROBE.timecode2;
            String tc3 = FFPROBE.timecode3;
            String tc4 = FFPROBE.timecode4;
            if (!(!VideoPlayer.caseAddTimecode.isSelected() || VideoPlayer.TC1.getText().isEmpty() || VideoPlayer.TC2.getText().isEmpty() || VideoPlayer.TC3.getText().isEmpty() || VideoPlayer.TC4.getText().isEmpty())) {
                tc1 = VideoPlayer.TC1.getText();
                tc2 = VideoPlayer.TC2.getText();
                tc3 = VideoPlayer.TC3.getText();
                tc4 = VideoPlayer.TC4.getText();
            } else if (VideoPlayer.caseShowTimecode.isSelected() && !FFPROBE.timecode1.equals("")) {
                float tcH = (float)(Integer.parseInt(tc1) * 3600) * FFPROBE.currentFPS;
                float tcM = (float)(Integer.parseInt(tc2) * 60) * FFPROBE.currentFPS;
                float tcS = (float)Integer.parseInt(tc3) * FFPROBE.currentFPS;
                float timeIn = (float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60 + Integer.parseInt(VideoPlayer.caseInS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(VideoPlayer.caseInF.getText());
                float offset = timeIn + tcH + tcM + tcS + (float)Integer.parseInt(tc4);
                if (offset < 0.0f) {
                    offset = 0.0f;
                }
                DecimalFormat formatter = new DecimalFormat("00");
                tc1 = formatter.format(Math.floor(offset / FFPROBE.currentFPS / 3600.0f));
                tc2 = formatter.format(Math.floor(offset / FFPROBE.currentFPS / 60.0f) % 60.0);
                tc3 = formatter.format(Math.floor(offset / FFPROBE.currentFPS) % 60.0);
                tc4 = formatter.format(Math.round(offset % FFPROBE.currentFPS));
            }
            if (videoPlayerCapture) {
                float currentTime;
                float offset;
                if (VideoPlayer.caseShowTimecode.isSelected()) {
                    tc1 = FFPROBE.timecode1;
                    tc2 = FFPROBE.timecode2;
                    tc3 = FFPROBE.timecode3;
                    tc4 = FFPROBE.timecode4;
                }
                DecimalFormat formatter = new DecimalFormat("00");
                float tcH = (float)(Integer.parseInt(tc1) * 3600) * FFPROBE.currentFPS;
                float tcM = (float)(Integer.parseInt(tc2) * 60) * FFPROBE.currentFPS;
                float tcS = (float)Integer.parseInt(tc3) * FFPROBE.currentFPS;
                float timeIn = (float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60 + Integer.parseInt(VideoPlayer.caseInS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(VideoPlayer.caseInF.getText());
                if (VideoPlayer.caseShowTimecode.isSelected()) {
                    timeIn = 0.0f;
                }
                if ((offset = (currentTime = Timecode.setNonDropFrameTC(VideoPlayer.playerCurrentFrame)) - timeIn + tcH + tcM + tcS + (float)Integer.parseInt(tc4)) < 0.0f) {
                    offset = 0.0f;
                }
                tc1 = formatter.format(Math.floor(offset / FFPROBE.currentFPS / 3600.0f));
                tc2 = formatter.format(Math.floor(offset / FFPROBE.currentFPS / 60.0f) % 60.0);
                tc3 = formatter.format(Math.floor(offset / FFPROBE.currentFPS) % 60.0);
                tc4 = formatter.format(Math.floor(offset % FFPROBE.currentFPS));
            }
            String rate = String.valueOf(FFPROBE.currentFPS);
            if (caseConform.isSelected()) {
                rate = comboFPS.getSelectedItem().toString().replace(",", ".");
            }
            String overlayFont = "";
            if (System.getProperty("os.name").contains("Mac")) {
                String[] fontName;
                File[] fontFolder = new File("/Library/Fonts").listFiles();
                int i = 0;
                while (i < fontFolder.length) {
                    File fontPath;
                    if (fontFolder[i].isFile() && (fontName = (fontPath = new File(fontFolder[i].toString())).getName().toLowerCase().replace(" ", "").replace("_", "").split("\\."))[0].equals(VideoPlayer.comboOverlayFont.getSelectedItem().toString().toLowerCase().replace(" ", "").replace("_", ""))) {
                        overlayFont = fontFolder[i].getAbsolutePath();
                        break;
                    }
                    ++i;
                }
                if (overlayFont == "") {
                    fontFolder = new File("/System/Library/Fonts").listFiles();
                    i = 0;
                    while (i < fontFolder.length) {
                        File fontPath;
                        if (fontFolder[i].isFile() && (fontName = (fontPath = new File(fontFolder[i].toString())).getName().toLowerCase().replace(" ", "").replace("_", "").split("\\."))[0].equals(VideoPlayer.comboOverlayFont.getSelectedItem().toString().toLowerCase().replace(" ", "").replace("_", ""))) {
                            overlayFont = fontFolder[i].getAbsolutePath();
                            break;
                        }
                        ++i;
                    }
                }
                if (overlayFont == "" && new File("/System/Library/Fonts/Supplemental").exists()) {
                    fontFolder = new File("/System/Library/Fonts/Supplemental").listFiles();
                    i = 0;
                    while (i < fontFolder.length) {
                        File fontPath;
                        if (fontFolder[i].isFile() && (fontName = (fontPath = new File(fontFolder[i].toString())).getName().toLowerCase().replace(" ", "").replace("_", "").split("\\."))[0].equals(VideoPlayer.comboOverlayFont.getSelectedItem().toString().toLowerCase().replace(" ", "").replace("_", ""))) {
                            overlayFont = fontFolder[i].getAbsolutePath();
                            break;
                        }
                        ++i;
                    }
                }
                if (overlayFont == "") {
                    fontFolder = new File(String.valueOf(System.getProperty("user.home")) + "/Library/Fonts").listFiles();
                    i = 0;
                    while (i < fontFolder.length) {
                        File fontPath;
                        if (fontFolder[i].isFile() && (fontName = (fontPath = new File(fontFolder[i].toString())).getName().toLowerCase().replace(" ", "").replace("_", "").split("\\."))[0].equals(VideoPlayer.comboOverlayFont.getSelectedItem().toString().toLowerCase().replace(" ", "").replace("_", ""))) {
                            overlayFont = fontFolder[i].getAbsolutePath();
                            break;
                        }
                        ++i;
                    }
                }
                if (overlayFont == "") {
                    fontFolder = new File("/Library/Fonts").listFiles();
                    i = 0;
                    while (i < fontFolder.length) {
                        File fontPath;
                        if (fontFolder[i].isFile() && (fontName = (fontPath = new File(fontFolder[i].toString())).getName().toLowerCase().replace(" ", "").replace("_", "").split("\\."))[0].contains(VideoPlayer.comboOverlayFont.getSelectedItem().toString().toLowerCase().replace(" ", "").replace("_", ""))) {
                            overlayFont = fontFolder[i].getAbsolutePath();
                            break;
                        }
                        ++i;
                    }
                }
                if (overlayFont == "") {
                    fontFolder = new File("/System/Library/Fonts").listFiles();
                    i = 0;
                    while (i < fontFolder.length) {
                        File fontPath;
                        if (fontFolder[i].isFile() && (fontName = (fontPath = new File(fontFolder[i].toString())).getName().toLowerCase().replace(" ", "").replace("_", "").split("\\."))[0].contains(VideoPlayer.comboOverlayFont.getSelectedItem().toString().toLowerCase().replace(" ", "").replace("_", ""))) {
                            overlayFont = fontFolder[i].getAbsolutePath();
                            break;
                        }
                        ++i;
                    }
                }
                if (overlayFont == "") {
                    fontFolder = new File(String.valueOf(System.getProperty("user.home")) + "/Library/Fonts").listFiles();
                    i = 0;
                    while (i < fontFolder.length) {
                        File fontPath;
                        if (fontFolder[i].isFile() && (fontName = (fontPath = new File(fontFolder[i].toString())).getName().toLowerCase().replace(" ", "").replace("_", "").split("\\."))[0].contains(VideoPlayer.comboOverlayFont.getSelectedItem().toString().toLowerCase().replace(" ", "").replace("_", ""))) {
                            overlayFont = fontFolder[i].getAbsolutePath();
                            break;
                        }
                        ++i;
                    }
                }
                if (overlayFont == "") {
                    overlayFont = "/Library/Fonts/Arial";
                }
            } else {
                overlayFont = "font=" + VideoPlayer.comboOverlayFont.getSelectedItem().toString();
            }
            float imageRatio = 1.0f;
            int ow = FFPROBE.imageWidth;
            if (!comboFonctions.getSelectedItem().toString().equals("DVD") && !comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
                if (comboResolution.getSelectedItem().toString().contains("%")) {
                    double value = (double)Integer.parseInt(comboResolution.getSelectedItem().toString().replace("%", "")) / 100.0;
                    ow = (int)Math.round((double)ow * value);
                } else if (comboResolution.getSelectedItem().toString().contains("x")) {
                    String[] s = comboResolution.getSelectedItem().toString().split("x");
                    ow = Integer.parseInt(s[0]);
                } else if (comboResolution.getSelectedItem().toString().contains(":")) {
                    String[] s = comboResolution.getSelectedItem().toString().split(":");
                    ow = s[0].equals("auto") ? Math.round(FFPROBE.imageHeight / Integer.parseInt(s[1])) : (s[1].equals("auto") ? Math.round(FFPROBE.imageWidth / Integer.parseInt(s[0])) : Integer.parseInt(s[0]));
                }
                if (VideoEncoders.setScalingFirst()) {
                    imageRatio = (float)FFPROBE.imageWidth / (float)ow;
                }
            }
            if (VideoPlayer.caseShowFileName.isSelected()) {
                if (filterComplex != "") {
                    filterComplex = String.valueOf(filterComplex) + ",";
                }
                filterComplex = String.valueOf(filterComplex) + "drawtext=" + overlayFont + ":text='" + file + "':r=" + rate + ":x=" + Math.round((float)Integer.parseInt(VideoPlayer.textNamePosX.getText()) / imageRatio) + ":y=" + Math.round((float)Integer.parseInt(VideoPlayer.textNamePosY.getText()) / imageRatio) + ":fontcolor=0x" + VideoPlayer.foregroundHex + VideoPlayer.foregroundNameAlpha + ":fontsize=" + Math.round((float)Integer.parseInt(VideoPlayer.textNameSize.getText()) / imageRatio) + ":box=1:boxcolor=0x" + VideoPlayer.backgroundHex + VideoPlayer.backgroundNameAlpha;
            }
            if (VideoPlayer.caseAddText.isSelected()) {
                if (filterComplex != "") {
                    filterComplex = String.valueOf(filterComplex) + ",";
                }
                filterComplex = String.valueOf(filterComplex) + "drawtext=" + overlayFont + ":text='" + VideoPlayer.text.getText() + "':r=" + rate + ":x=" + Math.round((float)Integer.parseInt(VideoPlayer.textNamePosX.getText()) / imageRatio) + ":y=" + Math.round((float)Integer.parseInt(VideoPlayer.textNamePosY.getText()) / imageRatio) + ":fontcolor=0x" + VideoPlayer.foregroundHex + VideoPlayer.foregroundNameAlpha + ":fontsize=" + Math.round((float)Integer.parseInt(VideoPlayer.textNameSize.getText()) / imageRatio) + ":box=1:boxcolor=0x" + VideoPlayer.backgroundHex + VideoPlayer.backgroundNameAlpha;
            }
            if (VideoPlayer.caseAddTimecode.isSelected() || VideoPlayer.caseShowTimecode.isSelected()) {
                String dropFrame = ":";
                if (!(FFPROBE.dropFrameTC.equals(":") || FFPROBE.currentFPS != 29.97f && FFPROBE.currentFPS != 59.94f)) {
                    dropFrame = ";";
                }
                if (Shutter.caseConform.isSelected()) {
                    dropFrame = Shutter.comboFPS.getSelectedItem().toString().equals("29,97") || Shutter.comboFPS.getSelectedItem().toString().equals("59,94") ? ";" : ":";
                }
                if (filterComplex != "") {
                    filterComplex = String.valueOf(filterComplex) + ",";
                }
                if (VideoPlayer.caseAddTimecode.isSelected() && VideoPlayer.lblTimecode.getText().equals(Shutter.language.getProperty("lblFrameNumber"))) {
                    String startNumber = String.format("%.0f", Float.valueOf((float)(Integer.parseInt(tc1) * 3600) * FFPROBE.currentFPS + (float)(Integer.parseInt(tc2) * 60) * FFPROBE.currentFPS + (float)Integer.parseInt(tc3) * FFPROBE.currentFPS + (float)Integer.parseInt(tc4)));
                    filterComplex = String.valueOf(filterComplex) + "drawtext=" + overlayFont + ":text='%{frame_num}': start_number=" + startNumber + ":x=" + Math.round((float)Integer.parseInt(VideoPlayer.textTcPosX.getText()) / imageRatio) + ":y=" + Math.round((float)Integer.parseInt(VideoPlayer.textTcPosY.getText()) / imageRatio) + ":fontcolor=0x" + VideoPlayer.foregroundHex + VideoPlayer.foregroundTcAlpha + ":fontsize=" + Math.round((float)Integer.parseInt(VideoPlayer.textTcSize.getText()) / imageRatio) + ":box=1:boxcolor=0x" + VideoPlayer.backgroundHex + VideoPlayer.backgroundTcAlpha;
                } else {
                    filterComplex = String.valueOf(filterComplex) + "drawtext=" + overlayFont + ":timecode='" + tc1 + "\\:" + tc2 + "\\:" + tc3 + "\\" + dropFrame + tc4 + "':r=" + rate + ":x=" + Math.round((float)Integer.parseInt(VideoPlayer.textTcPosX.getText()) / imageRatio) + ":y=" + Math.round((float)Integer.parseInt(VideoPlayer.textTcPosY.getText()) / imageRatio) + ":fontcolor=0x" + VideoPlayer.foregroundHex + VideoPlayer.foregroundTcAlpha + ":fontsize=" + Math.round((float)Integer.parseInt(VideoPlayer.textTcSize.getText()) / imageRatio) + ":box=1:boxcolor=0x" + VideoPlayer.backgroundHex + VideoPlayer.backgroundTcAlpha + ":tc24hmax=1";
                }
            }
        }
        return filterComplex;
    }

    public static String setSubtitles(boolean limitToFHD) {
        if (caseInAndOut.isSelected() && VideoPlayer.caseAddSubtitles.isSelected() && subtitlesBurn) {
            if (subtitlesFile.toString().substring(subtitlesFile.toString().lastIndexOf(".")).equals(".srt")) {
                String background = "";
                background = VideoPlayer.lblSubsBackground.getText().equals(Shutter.language.getProperty("lblBackgroundOn")) ? ",BorderStyle=4,BackColour=&H" + VideoPlayer.subsAlpha + VideoPlayer.subsHex2 + "&,Outline=0" : ",Outline=" + VideoPlayer.outline + ",OutlineColour=&H" + VideoPlayer.subsAlpha + VideoPlayer.subsHex2 + "&";
                if (VideoPlayer.btnG.getForeground() != Color.BLACK) {
                    background = String.valueOf(background) + ",Bold=1";
                }
                if (VideoPlayer.btnI.getForeground() != Color.BLACK) {
                    background = String.valueOf(background) + ",Italic=1";
                }
                String[] i = FFPROBE.imageResolution.split("x");
                float timeIn = (float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60 + Integer.parseInt(VideoPlayer.caseInS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(VideoPlayer.caseInF.getText());
                VideoPlayer.writeCurrentSubs(timeIn);
                if (limitToFHD || !comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
                    String[] s = "1920x1080".split("x");
                    if (comboResolution.getSelectedItem().toString().contains("%")) {
                        double value = (double)Integer.parseInt(comboResolution.getSelectedItem().toString().replace("%", "")) / 100.0;
                        s[0] = String.valueOf(Math.round((double)Integer.parseInt(s[0]) * value));
                        s[1] = String.valueOf(Math.round((double)Integer.parseInt(s[1]) * value));
                    } else if (comboResolution.getSelectedItem().toString().contains("x")) {
                        s = comboResolution.getSelectedItem().toString().split("x");
                    }
                    int iw = Integer.parseInt(i[0]);
                    int ih = Integer.parseInt(i[1]);
                    int ow = Integer.parseInt(s[0]);
                    int oh = Integer.parseInt(s[1]);
                    int width = Math.round((float)Integer.parseInt(VideoPlayer.textSubsWidth.getText()) / ((float)iw / (float)ow));
                    int height = Math.round((float)(ih + Integer.parseInt(VideoPlayer.textSubtitlesPosition.getText())) / ((float)ih / (float)oh));
                    return " -f lavfi -i \"color=black@0.0,format=rgba,scale=" + width + ":" + height + ",subtitles=" + "'" + subtitlesFile.toString() + "':alpha=1:force_style='FontName=" + VideoPlayer.comboSubsFont.getSelectedItem().toString() + ",FontSize=" + VideoPlayer.textSubsSize.getText() + ",PrimaryColour=&H" + VideoPlayer.subsHex + "&" + background + "'" + '\"';
                }
                int fontSize = Integer.parseInt(VideoPlayer.textSubsSize.getText());
                int height = Integer.parseInt(VideoPlayer.textSubtitlesPosition.getText());
                if (VideoPlayer.caseEnableCrop.isSelected()) {
                    int ih = Integer.parseInt(i[1]);
                    int oh = Integer.parseInt(VideoPlayer.textCropHeight.getText());
                    height -= Integer.parseInt(VideoPlayer.textCropPosY.getText());
                    fontSize = (int)((float)fontSize * ((float)ih / (float)oh));
                }
                return " -f lavfi -i \"color=black@0.0,format=rgba,scale=" + VideoPlayer.textSubsWidth.getText() + ":" + i[1] + "+" + height + ",subtitles=" + "'" + subtitlesFile.toString() + "':alpha=1:force_style='FontName=" + VideoPlayer.comboSubsFont.getSelectedItem().toString() + ",FontSize=" + fontSize + ",PrimaryColour=&H" + VideoPlayer.subsHex + "&" + background + "'" + '\"';
            }
            String[] i = FFPROBE.imageResolution.split("x");
            VideoPlayer.textSubsWidth.setText(i[0]);
            if (!comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
                String[] s = FFPROBE.imageResolution.split("x");
                if (comboResolution.getSelectedItem().toString().contains("%")) {
                    double value = (double)Integer.parseInt(comboResolution.getSelectedItem().toString().replace("%", "")) / 100.0;
                    s[0] = String.valueOf(Math.round((double)Integer.parseInt(s[0]) * value));
                    s[1] = String.valueOf(Math.round((double)Integer.parseInt(s[1]) * value));
                } else {
                    s = comboResolution.getSelectedItem().toString().split("x");
                }
                int iw = Integer.parseInt(i[0]);
                int ih = Integer.parseInt(i[1]);
                int ow = Integer.parseInt(s[0]);
                int oh = Integer.parseInt(s[1]);
                int width = Math.round((float)Integer.parseInt(VideoPlayer.textSubsWidth.getText()) / ((float)iw / (float)ow));
                int height = Math.round((float)(ih + Integer.parseInt(VideoPlayer.textSubtitlesPosition.getText())) / ((float)ih / (float)oh));
                return " -f lavfi" + InputAndOutput.inPoint + " -i " + '\"' + "color=black@0.0,format=rgba,scale=" + width + ":" + height + ",subtitles=" + "'" + subtitlesFile.toString() + "':alpha=1" + '\"';
            }
            return " -f lavfi" + InputAndOutput.inPoint + " -i " + '\"' + "color=black@0.0,format=rgba,scale=" + i[0] + ":" + i[1] + ",subtitles=" + "'" + subtitlesFile.toString() + "':alpha=1" + '\"';
        }
        if (caseInAndOut.isSelected() && VideoPlayer.caseAddSubtitles.isSelected() && !subtitlesBurn) {
            String subsFiles = "";
            Component[] componentArray = SubtitlesEmbed.frame.getContentPane().getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (c instanceof JTextField && !((JTextField)c).getText().equals(language.getProperty("aucun"))) {
                    subsFiles = String.valueOf(subsFiles) + InputAndOutput.inPoint + " -i " + '\"' + ((JTextField)c).getText() + '\"';
                }
                ++n2;
            }
            return subsFiles;
        }
        return "";
    }

    public static String setLogo() {
        if (caseInAndOut.isSelected() && VideoPlayer.caseAddWatermark.isSelected() && Shutter.overlayDeviceIsRunning) {
            return " " + RecordInputDevice.setOverlayDevice();
        }
        if (caseInAndOut.isSelected() && VideoPlayer.caseAddWatermark.isSelected()) {
            return " -i \"" + VideoPlayer.logoFile + '\"';
        }
        return "";
    }

    public static String setWatermark(String filterComplex) {
        if (caseInAndOut.isSelected() && VideoPlayer.caseAddWatermark.isSelected()) {
            float imageRatio = 1.0f;
            int ow = FFPROBE.imageWidth;
            if (!comboFonctions.getSelectedItem().toString().equals("DVD") && !comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
                if (comboResolution.getSelectedItem().toString().contains("%")) {
                    double value = (double)Integer.parseInt(comboResolution.getSelectedItem().toString().replace("%", "")) / 100.0;
                    ow = (int)Math.round((double)ow * value);
                } else if (comboResolution.getSelectedItem().toString().contains("x")) {
                    String[] s = comboResolution.getSelectedItem().toString().split("x");
                    ow = Integer.parseInt(s[0]);
                } else if (comboResolution.getSelectedItem().toString().contains(":")) {
                    String[] s = comboResolution.getSelectedItem().toString().split(":");
                    ow = s[0].equals("auto") ? Math.round(FFPROBE.imageHeight / Integer.parseInt(s[1])) : (s[1].equals("auto") ? Math.round(FFPROBE.imageWidth / Integer.parseInt(s[0])) : Integer.parseInt(s[0]));
                }
                if (VideoEncoders.setScalingFirst()) {
                    imageRatio = (float)FFPROBE.imageWidth / (float)ow;
                }
            }
            float size = (float)Integer.parseInt(VideoPlayer.textWatermarkSize.getText()) / 100.0f;
            filterComplex = filterComplex != "" ? "[0:v]" + filterComplex + "[v];[1:v]scale=iw*" + 1.0 / (double)imageRatio * (double)size + ":ih*" + 1.0 / (double)imageRatio * (double)size + ",lut=a=val*" + (float)Integer.parseInt(VideoPlayer.textWatermarkOpacity.getText()) / 100.0f + "[scaledwatermark];[v][scaledwatermark]overlay=" + Math.round((float)Integer.parseInt(VideoPlayer.textWatermarkPosX.getText()) / imageRatio) + ":" + Math.round((float)Integer.parseInt(VideoPlayer.textWatermarkPosY.getText()) / imageRatio) : "[1:v]scale=iw*" + 1.0 / (double)imageRatio * (double)size + ":ih*" + 1.0 / (double)imageRatio * (double)size + ",lut=a=val*" + (float)Integer.parseInt(VideoPlayer.textWatermarkOpacity.getText()) / 100.0f + "[scaledwatermark];[0:v][scaledwatermark]overlay=" + Math.round((float)Integer.parseInt(VideoPlayer.textWatermarkPosX.getText()) / imageRatio) + ":" + Math.round((float)Integer.parseInt(VideoPlayer.textWatermarkPosY.getText()) / imageRatio);
        }
        return filterComplex;
    }

    public static String setOverlay(String filterComplex, boolean limitToFHD) {
        if (caseInAndOut.isSelected() && VideoPlayer.caseAddSubtitles.isSelected() && subtitlesBurn) {
            String[] i = FFPROBE.imageResolution.split("x");
            int ImageWidth = Integer.parseInt(i[0]);
            int posX = Math.round(ImageWidth - Integer.parseInt(VideoPlayer.textSubsWidth.getText())) / 2;
            if (VideoPlayer.caseEnableCrop.isSelected()) {
                posX -= Integer.parseInt(VideoPlayer.textCropPosX.getText());
            }
            if (limitToFHD) {
                String[] s = "1920x1080".split("x");
                if (!comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
                    s = comboResolution.getSelectedItem().toString().split("x");
                }
                int iw = Integer.parseInt(i[0]);
                int ow = Integer.parseInt(s[0]);
                float imageRatio = (float)iw / (float)ow;
                posX = Math.round((float)posX / imageRatio);
            } else if (!comboFonctions.getSelectedItem().toString().equals("DVD") && !comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
                String[] s = FFPROBE.imageResolution.split("x");
                if (comboResolution.getSelectedItem().toString().contains("%")) {
                    double value = (double)Integer.parseInt(comboResolution.getSelectedItem().toString().replace("%", "")) / 100.0;
                    s[0] = String.valueOf(Math.round((double)Integer.parseInt(s[0]) * value));
                    s[1] = String.valueOf(Math.round((double)Integer.parseInt(s[1]) * value));
                } else {
                    s = comboResolution.getSelectedItem().toString().split("x");
                }
                int iw = Integer.parseInt(i[0]);
                int ow = Integer.parseInt(s[0]);
                float imageRatio = (float)iw / (float)ow;
                posX = Math.round((float)posX / imageRatio);
            }
            filterComplex = VideoPlayer.caseAddWatermark.isSelected() ? String.valueOf(filterComplex) + "[p];[p][2:v]overlay=shortest=1:x=" + posX : (filterComplex != "" ? String.valueOf(filterComplex) + "[p];[p][1:v]overlay=shortest=1:x=" + posX : "[0:v][1:v]overlay=shortest=1:x=" + posX);
        }
        return filterComplex;
    }
}

