/*
 * Decompiled with CFR 0.152.
 */
package settings;

import application.Settings;
import application.Shutter;
import application.VideoPlayer;
import functions.VideoEncoders;
import library.FFMPEG;
import library.FFPROBE;

public class Image
extends Shutter {
    public static String setCrop(String filterComplex) {
        if ((grpResolution.isVisible() || grpImageSequence.isVisible() || comboFonctions.getSelectedItem().toString().equals("Blu-ray")) && caseInAndOut.isSelected() && VideoPlayer.caseEnableCrop.isSelected()) {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + "[w];[w]";
            }
            float imageRatio = 1.0f;
            int ow = FFPROBE.imageWidth;
            if (!comboFonctions.getSelectedItem().toString().equals("DVD") && !comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
                if (comboResolution.getSelectedItem().toString().contains("%")) {
                    double value = (double)Integer.parseInt(comboResolution.getSelectedItem().toString().replace("%", "")) / 100.0;
                    ow = (int)Math.round((double)ow * value);
                } else if (comboResolution.getSelectedItem().toString().contains("x")) {
                    String[] s = comboResolution.getSelectedItem().toString().split("x");
                    ow = Integer.parseInt(s[0]);
                } else if (comboResolution.getSelectedItem().toString().contains(":")) {
                    String[] s = comboResolution.getSelectedItem().toString().split(":");
                    ow = s[0].equals("auto") ? Math.round(FFPROBE.imageHeight / Integer.parseInt(s[1])) : (s[1].equals("auto") ? Math.round(FFPROBE.imageWidth / Integer.parseInt(s[0])) : Integer.parseInt(s[0]));
                }
                if (VideoEncoders.setScalingFirst()) {
                    imageRatio = (float)FFPROBE.imageWidth / (float)ow;
                }
            }
            int cropWidth = Math.round((float)Integer.parseInt(VideoPlayer.textCropWidth.getText()) / imageRatio);
            int cropHeight = Math.round((float)Integer.parseInt(VideoPlayer.textCropHeight.getText()) / imageRatio);
            int cropX = Math.round((float)Integer.parseInt(VideoPlayer.textCropPosX.getText()) / imageRatio);
            int cropY = Math.round((float)Integer.parseInt(VideoPlayer.textCropPosY.getText()) / imageRatio);
            filterComplex = String.valueOf(filterComplex) + "crop=" + cropWidth + ":" + cropHeight + ":" + cropX + ":" + cropY;
        }
        return filterComplex;
    }

    public static String setRotate(String filterComplex) {
        block18: {
            String rotate;
            block21: {
                block19: {
                    if (!grpResolution.isVisible() && !grpImageSequence.isVisible()) break block18;
                    rotate = "";
                    if (!caseRotate.isSelected()) break block19;
                    String transpose = "";
                    switch (comboRotate.getSelectedItem().toString()) {
                        case "90": {
                            if (caseMiror.isSelected()) {
                                transpose = "transpose=3";
                                break;
                            }
                            transpose = "transpose=1";
                            break;
                        }
                        case "-90": {
                            if (caseMiror.isSelected()) {
                                transpose = "transpose=0";
                                break;
                            }
                            transpose = "transpose=2";
                            break;
                        }
                        case "180": {
                            transpose = caseMiror.isSelected() ? "transpose=1,transpose=1,hflip" : "transpose=1,transpose=1";
                        }
                    }
                    rotate = transpose;
                    break block21;
                }
                if (caseMiror.isSelected()) {
                    rotate = "hflip";
                }
            }
            if (rotate != "") {
                if (filterComplex != "") {
                    filterComplex = String.valueOf(filterComplex) + ",";
                }
                filterComplex = String.valueOf(filterComplex) + rotate;
            }
        }
        return filterComplex;
    }

    public static String limitToFHD() {
        if (!comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
            return " -s " + comboResolution.getSelectedItem().toString();
        }
        return " -s 1920x1080";
    }

    public static String setScale(String filterComplex, boolean limitToFHD) {
        int iw;
        String[] o;
        String[] i;
        if (!comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
            float ir;
            int oh;
            int ow;
            int ih;
            i = FFPROBE.imageResolution.split("x");
            o = FFPROBE.imageResolution.split("x");
            if (comboResolution.getSelectedItem().toString().contains("%")) {
                double value = (double)Integer.parseInt(comboResolution.getSelectedItem().toString().replace("%", "")) / 100.0;
                o[0] = String.valueOf(Math.round((double)Integer.parseInt(o[0]) * value));
                o[1] = String.valueOf(Math.round((double)Integer.parseInt(o[1]) * value));
            } else if (comboResolution.getSelectedItem().toString().contains("x")) {
                o = comboResolution.getSelectedItem().toString().split("x");
            } else if (comboResolution.getSelectedItem().toString().contains(":")) {
                o = comboResolution.getSelectedItem().toString().replace("auto", "1").split(":");
                int iw2 = Integer.parseInt(i[0]);
                ih = Integer.parseInt(i[1]);
                ow = Integer.parseInt(o[0]);
                oh = Integer.parseInt(o[1]);
                ir = (float)iw2 / (float)ih;
                if (o[0].toString().equals("1")) {
                    o[0] = String.valueOf(Math.round((float)oh * ir));
                } else {
                    o[1] = String.valueOf(Math.round((float)ow / ir));
                }
            }
            iw = Integer.parseInt(i[0]);
            ih = Integer.parseInt(i[1]);
            ow = Integer.parseInt(o[0]);
            oh = Integer.parseInt(o[1]);
            ir = (float)iw / (float)ih;
            float or = (float)ow / (float)oh;
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            if (lblPad.getText().equals(language.getProperty("lblCrop")) || comboFonctions.getSelectedItem().toString().equals("JPEG") || comboFonctions.getSelectedItem().toString().equals(language.getProperty("functionPicture"))) {
                if (comboResolution.getSelectedItem().toString().contains(":")) {
                    if (comboResolution.getSelectedItem().toString().contains("auto")) {
                        o = comboResolution.getSelectedItem().toString().split(":");
                        filterComplex = o[0].toString().equals("auto") ? String.valueOf(filterComplex) + "scale=-1:" + o[1] : String.valueOf(filterComplex) + "scale=" + o[0] + ":-1";
                    } else {
                        o = comboResolution.getSelectedItem().toString().split(":");
                        float number = 1.0f / (float)Integer.parseInt(o[0]);
                        filterComplex = String.valueOf(filterComplex) + "scale=iw*" + number + ":ih*" + number;
                    }
                } else {
                    filterComplex = iw > ow || ih > oh ? ((float)ow / ir >= (float)oh ? String.valueOf(filterComplex) + "scale=" + ow + ":-1" : String.valueOf(filterComplex) + "scale=-1:" + oh) : String.valueOf(filterComplex) + "scale=" + ow + ":" + oh;
                }
            } else {
                filterComplex = lblPad.getText().equals(language.getProperty("lblPad")) && ir != or ? String.valueOf(filterComplex) + "scale=" + o[0] + ":" + o[1] + ":force_original_aspect_ratio=decrease" : String.valueOf(filterComplex) + "scale=" + o[0] + ":" + o[1];
            }
        } else if (limitToFHD) {
            int oh;
            int ow;
            float or;
            int ih;
            float ir;
            i = FFPROBE.imageResolution.split("x");
            o = "1920x1080".split("x");
            if (!comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
                o = comboResolution.getSelectedItem().toString().split("x");
            }
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            filterComplex = (ir = (float)(iw = Integer.parseInt(i[0])) / (float)(ih = Integer.parseInt(i[1]))) != (or = (float)(ow = Integer.parseInt(o[0])) / (float)(oh = Integer.parseInt(o[1]))) ? String.valueOf(filterComplex) + "scale=" + o[0] + ":" + o[1] + ":force_original_aspect_ratio=decrease" : String.valueOf(filterComplex) + "scale=" + o[0] + ":" + o[1];
        } else if (comboFilter.getSelectedItem().toString().equals(".ico")) {
            filterComplex = String.valueOf(filterComplex) + "scale=256x256";
        }
        if (FFMPEG.isGPUCompatible && filterComplex.contains("scale=") && !comboResolution.getSelectedItem().toString().equals(language.getProperty("source")) && !FFPROBE.videoCodec.contains("vp9") && !FFPROBE.videoCodec.contains("vp8")) {
            String bitDepth = "nv12";
            if (FFPROBE.imageDepth == 10) {
                bitDepth = "p010";
            }
            boolean autoQSV = false;
            boolean autoCUDA = false;
            if (Settings.comboGPU.getSelectedItem().toString().equals("auto") && Settings.comboGPUFilter.getSelectedItem().toString().equals("auto")) {
                if (FFMPEG.cudaAvailable) {
                    autoCUDA = true;
                } else if (FFMPEG.qsvAvailable) {
                    autoQSV = true;
                }
            }
            if ((autoQSV || Settings.comboGPUFilter.getSelectedItem().toString().equals("qsv") && FFMPEG.isGPUCompatible) && !caseForcerDesentrelacement.isSelected() && !filterComplex.contains("yadif") && !filterComplex.contains("force_original_aspect_ratio")) {
                filterComplex = filterComplex.replace("scale=", "scale_qsv=");
                filterComplex = String.valueOf(filterComplex) + ",hwdownload,format=" + bitDepth;
            } else if ((autoCUDA || Settings.comboGPUFilter.getSelectedItem().toString().equals("cuda") && FFMPEG.isGPUCompatible) && (!caseForcerDesentrelacement.isSelected() || caseForcerDesentrelacement.isSelected() && filterComplex.contains("yadif"))) {
                filterComplex = filterComplex.replace("yadif=", "yadif_cuda=");
                filterComplex = filterComplex.replace("scale=", "scale_cuda=");
                filterComplex = String.valueOf(filterComplex) + ",hwdownload,format=" + bitDepth;
            }
        }
        return filterComplex;
    }

    public static String setPad(String filterComplex, boolean limitToFHD) {
        if (!comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
            float ir;
            int oh;
            int ow;
            int ih;
            String[] i = FFPROBE.imageResolution.split("x");
            String[] o = FFPROBE.imageResolution.split("x");
            if (comboResolution.getSelectedItem().toString().contains("%")) {
                double value = (double)Integer.parseInt(comboResolution.getSelectedItem().toString().replace("%", "")) / 100.0;
                o[0] = String.valueOf(Math.round((double)Integer.parseInt(o[0]) * value));
                o[1] = String.valueOf(Math.round((double)Integer.parseInt(o[1]) * value));
            } else if (comboResolution.getSelectedItem().toString().contains("x")) {
                o = comboResolution.getSelectedItem().toString().split("x");
            } else if (comboResolution.getSelectedItem().toString().contains(":")) {
                o = comboResolution.getSelectedItem().toString().replace("auto", "1").split(":");
                int iw = Integer.parseInt(i[0]);
                ih = Integer.parseInt(i[1]);
                ow = Integer.parseInt(o[0]);
                oh = Integer.parseInt(o[1]);
                ir = (float)iw / (float)ih;
                if (o[0].toString().equals("1")) {
                    o[0] = String.valueOf(Math.round((float)oh * ir));
                } else {
                    o[1] = String.valueOf(Math.round((float)ow / ir));
                }
            }
            int iw = Integer.parseInt(i[0]);
            ih = Integer.parseInt(i[1]);
            ow = Integer.parseInt(o[0]);
            oh = Integer.parseInt(o[1]);
            ir = (float)iw / (float)ih;
            float or = (float)ow / (float)oh;
            if (lblPad.getText().equals(language.getProperty("lblCrop")) || comboFonctions.getSelectedItem().toString().equals("JPEG") || comboFonctions.getSelectedItem().toString().equals(language.getProperty("functionPicture"))) {
                if (!(comboResolution.getSelectedItem().toString().contains(":") || iw <= ow && ih <= oh)) {
                    filterComplex = (float)ow / ir >= (float)oh ? String.valueOf(filterComplex) + ",crop='" + ow + ":" + oh + ":0:(ih-oh)*0.5" + "'" : String.valueOf(filterComplex) + ",crop='" + ow + ":" + oh + ":(iw-ow)*0.5:0" + "'";
                }
            } else if (lblPad.getText().equals(language.getProperty("lblPad")) && ir != or) {
                filterComplex = String.valueOf(filterComplex) + ",pad=" + o[0] + ":" + o[1] + ":(ow-iw)*0.5:(oh-ih)*0.5";
            }
        } else if (limitToFHD) {
            int oh;
            int ow;
            float or;
            int ih;
            int iw;
            float ir;
            String[] i = FFPROBE.imageResolution.split("x");
            String[] o = "1920x1080".split("x");
            if (!comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
                o = comboResolution.getSelectedItem().toString().split("x");
            }
            if ((ir = (float)(iw = Integer.parseInt(i[0])) / (float)(ih = Integer.parseInt(i[1]))) != (or = (float)(ow = Integer.parseInt(o[0])) / (float)(oh = Integer.parseInt(o[1])))) {
                filterComplex = String.valueOf(filterComplex) + ",pad=" + o[0] + ":" + o[1] + ":(ow-iw)*0.5:(oh-ih)*0.5";
            }
        }
        return filterComplex;
    }

    public static String setDAR(String filterComplex) {
        if ((grpResolution.isVisible() || grpImageSequence.isVisible()) && caseForcerDAR.isSelected()) {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            filterComplex = String.valueOf(filterComplex) + "setdar=" + comboDAR.getSelectedItem().toString().replace(":", "/");
        }
        return filterComplex;
    }
}

