/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.AuthenticationListener;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.WebKit;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.webkit.IWebDataSource;
import org.eclipse.swt.internal.webkit.IWebFrame;
import org.eclipse.swt.internal.webkit.IWebMutableURLRequest;
import org.eclipse.swt.internal.webkit.IWebURLAuthenticationChallenge;
import org.eclipse.swt.internal.webkit.IWebURLAuthenticationChallengeSender;
import org.eclipse.swt.internal.webkit.IWebURLCredential;
import org.eclipse.swt.internal.webkit.IWebURLProtectionSpace;
import org.eclipse.swt.internal.webkit.IWebURLRequest;
import org.eclipse.swt.internal.webkit.IWebView;
import org.eclipse.swt.internal.webkit.WebKit_win32;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class WebResourceLoadDelegate {
    COMObject iWebResourceLoadDelegate;
    int refCount = 0;
    Browser browser;
    String postData;

    WebResourceLoadDelegate(Browser browser) {
        this.createCOMInterfaces();
        this.browser = browser;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.iWebResourceLoadDelegate = new COMObject(new int[]{2, 0, 0, 4, 6, 4, 4, 4, 4, 3, 4, 3}){

            @Override
            public long method0(long[] args) {
                return WebResourceLoadDelegate.this.QueryInterface(args[0], args[1]);
            }

            @Override
            public long method1(long[] args) {
                return WebResourceLoadDelegate.this.AddRef();
            }

            @Override
            public long method2(long[] args) {
                return WebResourceLoadDelegate.this.Release();
            }

            @Override
            public long method3(long[] args) {
                return WebResourceLoadDelegate.this.identifierForInitialRequest(args[0], args[1], args[2], args[3]);
            }

            @Override
            public long method4(long[] args) {
                return WebResourceLoadDelegate.this.willSendRequest(args[0], args[1], args[2], args[3], args[4], args[5]);
            }

            @Override
            public long method5(long[] args) {
                return WebResourceLoadDelegate.this.didReceiveAuthenticationChallenge(args[0], args[1], args[2], args[3]);
            }

            @Override
            public long method6(long[] args) {
                return -2147467263L;
            }

            @Override
            public long method7(long[] args) {
                return 0L;
            }

            @Override
            public long method8(long[] args) {
                return 0L;
            }

            @Override
            public long method9(long[] args) {
                return 0L;
            }

            @Override
            public long method10(long[] args) {
                return 0L;
            }

            @Override
            public long method11(long[] args) {
                return -2147467263L;
            }
        };
    }

    int didReceiveAuthenticationChallenge(long webView, long identifier, long challenge, long dataSource) {
        IWebURLAuthenticationChallenge authenticationChallenge = new IWebURLAuthenticationChallenge(challenge);
        int[] count = new int[1];
        int hr = authenticationChallenge.previousFailureCount(count);
        long[] result = new long[1];
        if (hr == 0 && count[0] < 3) {
            AuthenticationListener[] authenticationListeners = this.browser.webBrowser.authenticationListeners;
            for (int i = 0; i < authenticationListeners.length; ++i) {
                AuthenticationEvent event = new AuthenticationEvent(this.browser);
                event.location = ((WebKit)this.browser.webBrowser).lastNavigateURL;
                authenticationListeners[i].authenticate(event);
                if (!event.doit) {
                    hr = authenticationChallenge.sender(result);
                    if (hr != 0 || result[0] == 0L) {
                        return 0;
                    }
                    IWebURLAuthenticationChallengeSender challengeSender = new IWebURLAuthenticationChallengeSender(result[0]);
                    challengeSender.cancelAuthenticationChallenge(challenge);
                    challengeSender.Release();
                    return 0;
                }
                if (event.user == null || event.password == null || (hr = authenticationChallenge.sender(result)) != 0 || result[0] == 0L) continue;
                IWebURLAuthenticationChallengeSender challengeSender = new IWebURLAuthenticationChallengeSender(result[0]);
                result[0] = 0L;
                hr = WebKit_win32.WebKitCreateInstance(WebKit_win32.CLSID_WebURLCredential, 0L, WebKit_win32.IID_IWebURLCredential, result);
                if (hr == 0 && result[0] != 0L) {
                    IWebURLCredential credential = new IWebURLCredential(result[0]);
                    long user = WebKit.createBSTR(event.user);
                    long password = WebKit.createBSTR(event.password);
                    credential.initWithUser(user, password, 1L);
                    challengeSender.useCredential(credential.getAddress(), challenge);
                    credential.Release();
                }
                challengeSender.Release();
                return 0;
            }
        }
        String[] userReturn = new String[1];
        String[] passwordReturn = new String[1];
        result[0] = 0L;
        hr = authenticationChallenge.proposedCredential(result);
        if (hr == 0 && result[0] != 0L) {
            IWebURLCredential proposedCredential = new IWebURLCredential(result[0]);
            result[0] = 0L;
            hr = proposedCredential.user(result);
            if (hr == 0 && result[0] != 0L) {
                userReturn[0] = WebKit.extractBSTR(result[0]);
                COM.SysFreeString(result[0]);
                int[] value = new int[1];
                hr = proposedCredential.hasPassword(value);
                if (hr == 0 && value[0] != 0) {
                    result[0] = 0L;
                    hr = proposedCredential.password(result);
                    if (hr == 0 && result[0] != 0L) {
                        passwordReturn[0] = WebKit.extractBSTR(result[0]);
                        COM.SysFreeString(result[0]);
                    }
                }
            }
            proposedCredential.Release();
        }
        result[0] = 0L;
        hr = authenticationChallenge.protectionSpace(result);
        if (hr != 0 || result[0] == 0L) {
            return 0;
        }
        IWebURLProtectionSpace space = new IWebURLProtectionSpace(result[0]);
        String host = null;
        String realm = null;
        result[0] = 0L;
        hr = space.host(result);
        if (hr == 0 && result[0] != 0L) {
            host = WebKit.extractBSTR(result[0]);
            COM.SysFreeString(result[0]);
            int[] port = new int[1];
            hr = space.port(port);
            if (hr == 0) {
                host = host + ":" + port[0];
                result[0] = 0L;
                hr = space.realm(result);
                if (hr == 0 && result[0] != 0L) {
                    realm = WebKit.extractBSTR(result[0]);
                    COM.SysFreeString(result[0]);
                }
            }
        }
        space.Release();
        boolean response = this.showAuthenticationDialog(userReturn, passwordReturn, host, realm);
        result[0] = 0L;
        hr = authenticationChallenge.sender(result);
        if (hr != 0 || result[0] == 0L) {
            return 0;
        }
        IWebURLAuthenticationChallengeSender challengeSender = new IWebURLAuthenticationChallengeSender(result[0]);
        if (!response) {
            challengeSender.cancelAuthenticationChallenge(challenge);
            challengeSender.Release();
            return 0;
        }
        result[0] = 0L;
        hr = WebKit_win32.WebKitCreateInstance(WebKit_win32.CLSID_WebURLCredential, 0L, WebKit_win32.IID_IWebURLCredential, result);
        if (hr == 0 && result[0] != 0L) {
            IWebURLCredential credential = new IWebURLCredential(result[0]);
            long user = WebKit.createBSTR(userReturn[0]);
            long password = WebKit.createBSTR(passwordReturn[0]);
            credential.initWithUser(user, password, 1L);
            challengeSender.useCredential(credential.getAddress(), challenge);
            credential.Release();
        }
        challengeSender.Release();
        return 0;
    }

    void disposeCOMInterfaces() {
        if (this.iWebResourceLoadDelegate != null) {
            this.iWebResourceLoadDelegate.dispose();
            this.iWebResourceLoadDelegate = null;
        }
    }

    long getAddress() {
        return this.iWebResourceLoadDelegate.getAddress();
    }

    int identifierForInitialRequest(long webView, long request, long dataSource, long identifier) {
        if (this.browser.isDisposed()) {
            return 0;
        }
        IWebDataSource source = new IWebDataSource(dataSource);
        long[] frame = new long[1];
        int hr = source.webFrame(frame);
        if (hr != 0 || frame[0] == 0L) {
            return 0;
        }
        new IWebFrame(frame[0]).Release();
        long[] mainFrame = new long[1];
        IWebView iWebView = new IWebView(webView);
        hr = iWebView.mainFrame(mainFrame);
        if (hr != 0 || mainFrame[0] == 0L) {
            return 0;
        }
        new IWebFrame(mainFrame[0]).Release();
        if (frame[0] == mainFrame[0]) {
            long ptr = C.malloc(8L);
            iWebView.estimatedProgress(ptr);
            double[] estimate = new double[1];
            OS.MoveMemory(estimate, ptr, 8);
            C.free(ptr);
            int progress = (int)(estimate[0] * 100.0);
            ProgressEvent progressEvent = new ProgressEvent(this.browser);
            progressEvent.display = this.browser.getDisplay();
            progressEvent.widget = this.browser;
            progressEvent.current = progress;
            progressEvent.total = Math.max(progress, 100);
            ProgressListener[] progressListeners = this.browser.webBrowser.progressListeners;
            for (int i = 0; i < progressListeners.length; ++i) {
                progressListeners[i].changed(progressEvent);
            }
        }
        return 0;
    }

    int QueryInterface(long riid, long ppvObject) {
        if (riid == 0L || ppvObject == 0L) {
            return -2147024809;
        }
        GUID guid = new GUID();
        COM.MoveMemory(guid, riid, GUID.sizeof);
        if (COM.IsEqualGUID(guid, COM.IIDIUnknown)) {
            OS.MoveMemory(ppvObject, new long[]{this.iWebResourceLoadDelegate.getAddress()}, C.PTR_SIZEOF);
            new IUnknown(this.iWebResourceLoadDelegate.getAddress()).AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(guid, WebKit_win32.IID_IWebResourceLoadDelegate)) {
            OS.MoveMemory(ppvObject, new long[]{this.iWebResourceLoadDelegate.getAddress()}, C.PTR_SIZEOF);
            new IUnknown(this.iWebResourceLoadDelegate.getAddress()).AddRef();
            return 0;
        }
        OS.MoveMemory(ppvObject, new long[]{0L}, C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    boolean showAuthenticationDialog(String[] user, String[] password, String host, String realm) {
        Shell parent = this.browser.getShell();
        Shell shell = new Shell(parent);
        shell.setLayout(new GridLayout());
        String title = SWT.getMessage("SWT_Authentication_Required");
        shell.setText(title);
        Label label = new Label(shell, 64);
        label.setText(Compatibility.getMessage("SWT_Enter_Username_and_Password", new String[]{realm, host}));
        GridData data = new GridData();
        Monitor monitor = this.browser.getMonitor();
        int maxWidth = monitor.getBounds().width * 2 / 3;
        int width = label.computeSize((int)-1, (int)-1).x;
        data.widthHint = Math.min(width, maxWidth);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        label.setLayoutData(data);
        Label userLabel = new Label(shell, 0);
        userLabel.setText(SWT.getMessage("SWT_Username"));
        Text userText = new Text(shell, 2048);
        if (user[0] != null) {
            userText.setText(user[0]);
        }
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        userText.setLayoutData(data);
        Label passwordLabel = new Label(shell, 0);
        passwordLabel.setText(SWT.getMessage("SWT_Password"));
        Text passwordText = new Text(shell, 0x400800);
        if (password[0] != null) {
            passwordText.setText(password[0]);
        }
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        passwordText.setLayoutData(data);
        boolean[] result = new boolean[1];
        Button[] buttons = new Button[2];
        Listener listener = event -> {
            user[0] = userText.getText();
            password[0] = passwordText.getText();
            result[0] = event.widget == buttons[1];
            shell.close();
        };
        Composite composite = new Composite(shell, 0);
        data = new GridData();
        data.horizontalAlignment = 3;
        composite.setLayoutData(data);
        composite.setLayout(new GridLayout(2, true));
        buttons[0] = new Button(composite, 8);
        buttons[0].setText(SWT.getMessage("SWT_Cancel"));
        buttons[0].setLayoutData(new GridData(768));
        buttons[0].addListener(13, listener);
        buttons[1] = new Button(composite, 8);
        buttons[1].setText(SWT.getMessage("SWT_OK"));
        buttons[1].setLayoutData(new GridData(768));
        buttons[1].addListener(13, listener);
        shell.setDefaultButton(buttons[1]);
        shell.pack();
        Rectangle parentSize = parent.getBounds();
        Rectangle shellSize = shell.getBounds();
        int x = parent.getLocation().x + (parentSize.width - shellSize.width) / 2;
        int y = parent.getLocation().y + (parentSize.height - shellSize.height) / 2;
        shell.setLocation(x, y);
        shell.open();
        Display display = this.browser.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return result[0];
    }

    int willSendRequest(long webView, long identifier, long request, long redirectResponse, long dataSource, long newRequest) {
        IWebURLRequest req = new IWebURLRequest(request);
        long[] result = new long[1];
        int hr = req.URL(result);
        if (hr == 0 && result[0] != 0L) {
            String url = WebKit.extractBSTR(result[0]);
            COM.SysFreeString(result[0]);
            if (url.startsWith("file://") && !url.startsWith("file:///")) {
                int length = "file://".length();
                url = "file:///" + url.substring(length);
                result[0] = 0L;
                hr = req.mutableCopy(result);
                if (hr == 0 && result[0] != 0L) {
                    IWebMutableURLRequest mReq = new IWebMutableURLRequest(result[0]);
                    long urlString = WebKit.createBSTR(url);
                    mReq.setURL(urlString);
                    OS.MoveMemory(newRequest, new long[]{mReq.getAddress()}, C.PTR_SIZEOF);
                    return 0;
                }
            }
        }
        req.AddRef();
        OS.MoveMemory(newRequest, new long[]{request}, C.PTR_SIZEOF);
        return 0;
    }
}

