/*
 * Decompiled with CFR 0.152.
 */
package library;

import application.Console;
import application.Functions;
import application.RecordInputDevice;
import application.RenderQueue;
import application.SceneDetection;
import application.Settings;
import application.Shutter;
import application.Utils;
import application.VideoPlayer;
import functions.VideoEncoders;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Taskbar;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import library.DCRAW;
import library.EXIFTOOL;
import library.FFPLAY;
import library.FFPROBE;
import library.XPDF;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import settings.BitratesAdjustement;
import settings.Colorimetry;
import settings.FunctionUtils;
import settings.InputAndOutput;

public class FFMPEG
extends Shutter {
    public static int dureeTotale = 0;
    public static boolean error = false;
    public static boolean isRunning = false;
    public static BufferedWriter writer;
    public static Thread runProcess;
    public static Process process;
    public static String analyseLufs;
    public static Float mseSensibility;
    public static float newVolume;
    public static StringBuilder shortTermValues;
    public static StringBuilder blackFrame;
    public static StringBuilder mediaOfflineFrame;
    public static String VMAFScore;
    public static String cropdetect;
    private static boolean firstInput;
    public static int firstScreenIndex;
    public static StringBuilder videoDevices;
    public static StringBuilder audioDevices;
    public static boolean isGPUCompatible;
    public static boolean cudaAvailable;
    public static boolean qsvAvailable;
    public static int differenceMax;
    private static int frame0;
    private static long time;
    public static long elapsedTime;
    public static int previousElapsedTime;
    private static int fps;
    private static StringBuilder getAll;
    public static StringBuilder errorLog;

    static {
        runProcess = new Thread();
        mseSensibility = Float.valueOf(800.0f);
        firstInput = true;
        firstScreenIndex = -1;
        isGPUCompatible = false;
        cudaAvailable = false;
        qsvAvailable = false;
        frame0 = 0;
        time = 0L;
        elapsedTime = 0L;
        previousElapsedTime = 0;
        fps = 0;
        errorLog = new StringBuilder();
    }

    public static void run(final String cmd) {
        time = 0L;
        fps = 0;
        elapsedTime = System.currentTimeMillis() - (long)previousElapsedTime;
        error = false;
        firstInput = true;
        Console.consoleFFMPEG.append(String.valueOf(System.lineSeparator()) + Shutter.language.getProperty("command") + " -threads " + Settings.txtThreads.getText() + cmd + System.lineSeparator());
        getAll = new StringBuilder();
        if (saveCode) {
            if (!cmd.contains("-pass 2")) {
                FFMPEG.saveToXML(cmd);
            }
        } else if (btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && RenderQueue.btnStartRender.isEnabled() && !cmd.contains("image2pipe") && !cmd.contains("waveform.png") && !cmd.contains("preview.bmp")) {
            if (lblCurrentEncoding.getText().equals(Shutter.language.getProperty("lblEncodageEnCours"))) {
                lblCurrentEncoding.setText(RenderQueue.tableRow.getValueAt(RenderQueue.tableRow.getRowCount() - 1, 0).toString());
            }
            if (!caseChangeFolder1.isSelected()) {
                lblDestination1.setText(Shutter.language.getProperty("sameAsSource"));
            }
            if (caseChangeFolder3.isSelected() && caseChangeFolder2.isSelected()) {
                RenderQueue.tableRow.addRow(new Object[]{lblCurrentEncoding.getText(), "ffmpeg" + FFMPEG.checkList(cmd), String.valueOf(lblDestination1.getText()) + " | " + lblDestination2.getText() + " | " + lblDestination3.getText()});
            } else if (caseChangeFolder2.isSelected()) {
                RenderQueue.tableRow.addRow(new Object[]{lblCurrentEncoding.getText(), "ffmpeg" + FFMPEG.checkList(cmd), String.valueOf(lblDestination1.getText()) + " | " + lblDestination2.getText()});
            } else {
                RenderQueue.tableRow.addRow(new Object[]{lblCurrentEncoding.getText(), "ffmpeg" + FFMPEG.checkList(cmd), lblDestination1.getText()});
            }
            lblCurrentEncoding.setText(Shutter.language.getProperty("lblEncodageEnCours"));
        } else {
            isRunning = true;
            if (!(Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) || cmd.contains("image2pipe") || cmd.contains("waveform.png") || cmd.contains("preview.bmp"))) {
                FFMPEG.disableAll();
            }
            runProcess = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            String line;
                            ProcessBuilder processFFMPEG;
                            String aspect;
                            String pipe;
                            String PathToFFMPEG;
                            if (System.getProperty("os.name").contains("Windows")) {
                                PathToFFMPEG = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                                PathToFFMPEG = PathToFFMPEG.substring(1, PathToFFMPEG.length() - 1);
                                PathToFFMPEG = String.valueOf(PathToFFMPEG.substring(0, PathToFFMPEG.lastIndexOf("/")).replace("%20", " ")) + "\\Library\\ffmpeg.exe";
                                pipe = "";
                                if ((cmd.contains("pipe:play") || caseStream.isSelected()) && !cmd.contains("image2pipe")) {
                                    PathToFFMPEG = "Library\\ffmpeg.exe";
                                    aspect = "";
                                    if (caseForcerDAR.isSelected()) {
                                        aspect = ",setdar=" + comboDAR.getSelectedItem().toString().replace(":", "/");
                                    }
                                    pipe = " | " + PathToFFMPEG.replace("ffmpeg", "ffplay") + " -loglevel quiet -x 320 -y 180 -alwaysontop -autoexit -an -vf setpts=FRAME_RATE" + aspect + " -i " + '\"' + "pipe:play" + '\"' + " -window_title " + '\"' + Shutter.language.getProperty("viewEncoding") + '\"';
                                    process = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", String.valueOf(PathToFFMPEG) + " -threads " + Settings.txtThreads.getText() + " " + cmd.replace("PathToFFMPEG", PathToFFMPEG) + pipe});
                                } else if (cmd.contains("pipe:stab") || cmd.contains("image2pipe") || cmd.contains("60000/1001") || cmd.contains("30000/1001") || cmd.contains("24000/1001") || comboFonctions.getSelectedItem().equals(language.getProperty("functionPicture")) || comboFonctions.getSelectedItem().toString().equals("JPEG") || (caseForcerDAR.isSelected() && grpAdvanced.isVisible() || VideoPlayer.caseAddTimecode.isSelected() || VideoPlayer.caseEnableColorimetry.isSelected() || caseLUTs.isSelected() && grpColorimetry.isVisible() || caseColormatrix.isSelected() && comboInColormatrix.getSelectedItem().toString().equals("HDR") && grpColorimetry.isVisible() || VideoPlayer.caseDeflicker.isSelected()) && !caseDisplay.isSelected()) {
                                    PathToFFMPEG = "Library\\ffmpeg.exe";
                                    process = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", String.valueOf(PathToFFMPEG) + " -threads " + Settings.txtThreads.getText() + " " + cmd.replace("PathToFFMPEG", PathToFFMPEG)});
                                } else {
                                    processFFMPEG = new ProcessBuilder(String.valueOf('\"') + PathToFFMPEG + '\"' + " -threads " + Settings.txtThreads.getText() + " " + cmd.replace("PathToFFMPEG", PathToFFMPEG));
                                    process = processFFMPEG.start();
                                }
                            } else {
                                PathToFFMPEG = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                                PathToFFMPEG = PathToFFMPEG.substring(0, PathToFFMPEG.length() - 1);
                                PathToFFMPEG = String.valueOf(PathToFFMPEG.substring(0, PathToFFMPEG.lastIndexOf("/")).replace("%20", "\\ ")) + "/Library/ffmpeg";
                                pipe = "";
                                if (cmd.contains("pipe:play")) {
                                    aspect = "";
                                    if (caseForcerDAR.isSelected()) {
                                        aspect = ",setdar=" + comboDAR.getSelectedItem().toString().replace(":", "/");
                                    }
                                    pipe = " | " + PathToFFMPEG.replace("ffmpeg", "ffplay") + " -loglevel quiet -x 320 -y 180 -alwaysontop -autoexit -an -vf setpts=FRAME_RATE" + aspect + " -i " + '\"' + "pipe:play" + '\"' + " -window_title " + '\"' + Shutter.language.getProperty("viewEncoding") + '\"';
                                }
                                processFFMPEG = new ProcessBuilder("/bin/bash", "-c", String.valueOf(PathToFFMPEG) + " -threads " + Settings.txtThreads.getText() + " " + cmd.replace("PathToFFMPEG", PathToFFMPEG) + pipe);
                                process = processFFMPEG.start();
                            }
                            BufferedReader input = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                            OutputStream stdin = process.getOutputStream();
                            writer = new BufferedWriter(new OutputStreamWriter(stdin));
                            Console.consoleFFMPEG.append(System.lineSeparator());
                            while ((line = input.readLine()) != null) {
                                getAll.append(line);
                                getAll.append(System.lineSeparator());
                                Console.consoleFFMPEG.append(String.valueOf(line) + System.lineSeparator());
                                FFMPEG.checkForErrors(line);
                                if (cancelled) break;
                                if (cmd.contains("-pass 2")) {
                                    FFMPEG.setProgress(line, true, cmd);
                                    continue;
                                }
                                FFMPEG.setProgress(line, false, cmd);
                            }
                            process.waitFor();
                            if (!cancelled) {
                                FFMPEG.postAnalyse();
                            }
                        }
                        catch (IOException PathToFFMPEG) {
                            isRunning = false;
                            caseRunInBackground.setEnabled(false);
                            caseDisplay.setEnabled(true);
                        }
                        catch (InterruptedException e) {
                            error = true;
                            isRunning = false;
                            caseRunInBackground.setEnabled(false);
                            caseDisplay.setEnabled(true);
                        }
                    }
                    finally {
                        isRunning = false;
                        caseRunInBackground.setEnabled(false);
                        caseDisplay.setEnabled(true);
                    }
                }
            });
            runProcess.start();
        }
    }

    public static void checkForErrors(String line) {
        if (line.contains("No such file or directory") || line.contains("Invalid data found when processing input") && !line.contains("unable to decode APP fields") || line.contains("No space left") || line.contains("does not contain any stream") || line.contains("Invalid argument") || line.contains("Error opening filters!") || line.contains("Error reinitializing filters!") || line.contains("matches no streams") || line.contains("Error while opening encoder") || line.contains("Decoder (codec none) not found") || line.contains("hwaccel initialisation returned error") || line.contains("Device setup failed for decoder") || line.contains("No device available for decoder") || line.contains("Error while decoding stream") || line.contains("Current pixel format is unsupported") || line.contains("Unknown encoder") || line.contains("Could not set video options") || line.contains("Could not find tag for codec") || line.contains("Input/output error") || line.contains("Operation not permitted") || line.contains("Permission denied")) {
            errorLog.append(String.valueOf(line) + System.lineSeparator());
            error = true;
        }
    }

    private static String checkList(String cmd) {
        if (cmd.contains("pass 2")) {
            return RenderQueue.tableRow.getValueAt(RenderQueue.tableRow.getRowCount() - 1, 1).toString().replace("ffmpeg", "").replace("pass 1", "pass 2");
        }
        String cmdFinale = cmd;
        String[] s = cmd.split("\"");
        String cmdFile = s[s.length - 1];
        int n = 0;
        int i = 0;
        while (i < RenderQueue.tableRow.getRowCount()) {
            String[] s2 = RenderQueue.tableRow.getValueAt(i, 1).toString().split("\"");
            String renduFile = s2[s2.length - 1];
            if (cmdFile.equals(renduFile)) {
                String[] s3 = cmd.split("\"");
                String ext = cmdFile.substring(cmdFile.lastIndexOf("."), cmdFile.lastIndexOf(".") + 4);
                String originalCmdFile = s3[s3.length - 1];
                cmdFile = originalCmdFile.replace(ext, "_" + ++n + ext);
            }
            ++i;
        }
        String[] s4 = cmd.split("\"");
        cmdFinale = cmd.replace(s4[s4.length - 1], cmdFile);
        return cmdFinale;
    }

    public static void toFFPLAY(final String cmd) {
        error = false;
        frame.setCursor(Cursor.getPredefinedCursor(3));
        isRunning = true;
        runProcess = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        String line;
                        ProcessBuilder processFFMPEG;
                        String PathToFFMPEG;
                        File file = fileList.getSelectedIndices().length == 0 ? new File((String)liste.firstElement()) : new File((String)fileList.getSelectedValue());
                        if (System.getProperty("os.name").contains("Windows")) {
                            PathToFFMPEG = "Library\\ffmpeg.exe";
                            processFFMPEG = new ProcessBuilder("cmd.exe", "/c", String.valueOf(PathToFFMPEG) + " -threads " + Settings.txtThreads.getText() + " " + cmd + " " + PathToFFMPEG.replace("ffmpeg", "ffplay") + " -i " + '\"' + "pipe:play" + '\"' + " -window_title " + '\"' + file.getName() + '\"');
                        } else {
                            PathToFFMPEG = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                            PathToFFMPEG = PathToFFMPEG.substring(0, PathToFFMPEG.length() - 1);
                            PathToFFMPEG = String.valueOf(PathToFFMPEG.substring(0, PathToFFMPEG.lastIndexOf("/")).replace("%20", "\\ ")) + "/Library/ffmpeg";
                            processFFMPEG = new ProcessBuilder("/bin/bash", "-c", String.valueOf(PathToFFMPEG) + " -threads " + Settings.txtThreads.getText() + " " + cmd + " " + PathToFFMPEG.replace("ffmpeg", "ffplay") + " -i " + '\"' + "pipe:play" + '\"' + " -window_title " + '\"' + file.getName() + '\"');
                        }
                        Console.consoleFFPLAY.append(String.valueOf(System.lineSeparator()) + Shutter.language.getProperty("command") + " " + PathToFFMPEG + " -threads " + Settings.txtThreads.getText() + " " + cmd + " " + PathToFFMPEG.replace("ffmpeg", "ffplay") + " -i " + '\"' + "pipe:play" + '\"' + " -window_title " + '\"' + file.getName() + '\"' + System.lineSeparator() + System.lineSeparator());
                        process = processFFMPEG.start();
                        BufferedReader input = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        while ((line = input.readLine()) != null) {
                            Console.consoleFFPLAY.append(String.valueOf(line) + System.lineSeparator());
                            FFMPEG.checkForErrors(line);
                            if (!line.contains("frame")) continue;
                            frame.setCursor(Cursor.getPredefinedCursor(0));
                        }
                        process.waitFor();
                    }
                    catch (IOException PathToFFMPEG) {
                        isRunning = false;
                    }
                    catch (InterruptedException e) {
                        error = true;
                        isRunning = false;
                    }
                }
                finally {
                    isRunning = false;
                }
            }
        });
        runProcess.start();
    }

    public static void toSDL(boolean isVideoPlayer) {
        if (fileList.getSelectedIndices().length > 1 && !isVideoPlayer) {
            String input = "";
            String filter = "";
            String hstack = "";
            int n = fileList.getSelectedIndices().length;
            int i = 0;
            for (String video : fileList.getSelectedValuesList()) {
                input = String.valueOf(input) + " -i \"" + video + '\"';
                filter = String.valueOf(filter) + "[" + i + ":v]scale=iw/" + n + ":ih/2[v" + i + "];";
                ++i;
            }
            int v = 0;
            while (v < i) {
                hstack = String.valueOf(hstack) + "[v" + v + "]";
                ++v;
            }
            hstack = String.valueOf(hstack) + "hstack=" + n + "[out]";
            FFMPEG.toFFPLAY(String.valueOf(input) + " -filter_complex " + '\"' + filter + hstack + '\"' + " -c:v rawvideo -map " + '\"' + "[out]" + '\"' + " -map a? -f nut pipe:play |");
        } else {
            int i;
            File inputFile = null;
            if (isVideoPlayer) {
                inputFile = new File(VideoPlayer.videoPath);
                InputAndOutput.getInputAndOutput();
            } else if (!inputDeviceIsRunning) {
                inputFile = new File((String)fileList.getSelectedValue());
                FFPROBE.Data((String)fileList.getSelectedValue());
            }
            do {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException filter) {
                    // empty catch block
                }
            } while (FFPROBE.isRunning);
            String channels = "";
            String videoOutput = "";
            String audioOutput = "";
            if (FFPROBE.audioOnly) {
                if (FFPROBE.channels > 1) {
                    i = 0;
                    while (i < FFPROBE.channels) {
                        channels = String.valueOf(channels) + "[0:a:" + i + "]showvolume=f=0.001:b=4:w=720:h=12[a" + i + "];";
                        audioOutput = String.valueOf(audioOutput) + "[a" + i + "]";
                        ++i;
                    }
                    audioOutput = String.valueOf(channels) + audioOutput + "vstack=" + i + "[volume]" + '\"' + " -map " + '\"' + "[volume]" + '\"';
                } else if (FFPROBE.channels <= 1) {
                    audioOutput = "[0:a:0]showvolume=f=0.001:b=4:w=720:h=12[volume]\" -map \"[volume]\"";
                }
            } else {
                if (FFPROBE.channels > 1) {
                    if (inputDeviceIsRunning) {
                        channels = String.valueOf(channels) + "[0:a]showvolume=f=0.001:b=4:w=1080:h=12[a0];";
                        channels = String.valueOf(channels) + "[2:a]showvolume=f=0.001:b=4:w=1080:h=12[a2];";
                        audioOutput = String.valueOf(audioOutput) + "[a0]";
                        audioOutput = String.valueOf(audioOutput) + "[a2]";
                        audioOutput = String.valueOf(audioOutput) + "vstack=3[volume]\" -map \"[volume]\"";
                    } else {
                        i = 0;
                        i = 0;
                        while (i < FFPROBE.channels) {
                            channels = String.valueOf(channels) + "[0:a:" + i + "]showvolume=f=0.001:b=4:w=1080:h=12[a" + i + "];";
                            audioOutput = String.valueOf(audioOutput) + "[a" + i + "]";
                            ++i;
                        }
                        audioOutput = String.valueOf(audioOutput) + "vstack=" + (i + 1) + "[volume]" + '\"' + " -map " + '\"' + "[volume]" + '\"';
                    }
                } else if (FFPROBE.channels == 1) {
                    if (inputDeviceIsRunning && RecordInputDevice.audioDeviceIndex > 0 && overlayDeviceIsRunning && RecordInputDevice.overlayAudioDeviceIndex > 0) {
                        channels = "[2:a]showvolume=f=0.001:b=4:w=1080:h=12[a0];";
                        audioOutput = "[a0]vstack[volume]\" -map \"[volume]\"";
                    } else if (inputDeviceIsRunning && overlayDeviceIsRunning && RecordInputDevice.overlayAudioDeviceIndex > 0) {
                        channels = "[1:a]showvolume=f=0.001:b=4:w=1080:h=12[a0];";
                        audioOutput = "[a0]vstack[volume]\" -map \"[volume]\"";
                    } else {
                        channels = "[0:a:0]showvolume=f=0.001:b=4:w=1080:h=12[a0];";
                        audioOutput = "[a0]vstack[volume]\" -map \"[volume]\"";
                    }
                }
                videoOutput = "[0:v]scale=1080:-1[v];" + channels + "[v]";
                if (FFPROBE.channels == 0 || ((String)liste.getElementAt(0)).equals("Capture.input.device")) {
                    videoOutput = "scale=1080:-1\"";
                    audioOutput = "";
                }
            }
            if (inputDeviceIsRunning && overlayDeviceIsRunning) {
                videoOutput = RecordInputDevice.audioDeviceIndex > 0 ? "[2:v]scale=iw*" + (float)Integer.parseInt(VideoPlayer.textWatermarkSize.getText()) / 100.0f + ":ih*" + (float)Integer.parseInt(VideoPlayer.textWatermarkSize.getText()) / 100.0f + ",lut=a=val*" + (float)Integer.parseInt(VideoPlayer.textWatermarkOpacity.getText()) / 100.0f + "[scaledwatermark];[1:v][scaledwatermark]overlay=" + VideoPlayer.textWatermarkPosX.getText() + ":" + VideoPlayer.textWatermarkPosY.getText() + ",scale=1080:-1[v]" : "[1:v]scale=iw*" + (float)Integer.parseInt(VideoPlayer.textWatermarkSize.getText()) / 100.0f + ":ih*" + (float)Integer.parseInt(VideoPlayer.textWatermarkSize.getText()) / 100.0f + ",lut=a=val*" + (float)Integer.parseInt(VideoPlayer.textWatermarkOpacity.getText()) / 100.0f + "[scaledwatermark];[0:v][scaledwatermark]overlay=" + VideoPlayer.textWatermarkPosX.getText() + ":" + VideoPlayer.textWatermarkPosY.getText() + ",scale=1080:-1[v]";
                videoOutput = audioOutput != "" ? String.valueOf(videoOutput) + ";" + channels + "[v]" : String.valueOf(videoOutput) + '\"';
            }
            String extension = "";
            String output = "";
            if (!inputDeviceIsRunning) {
                extension = inputFile.toString().substring(inputFile.toString().lastIndexOf("."));
                output = inputFile.getParent();
            }
            String concat = "";
            if (VideoPlayer.comboMode.getSelectedItem().toString().equals(Shutter.language.getProperty("removeMode"))) {
                concat = FunctionUtils.setConcat(inputFile, output);
                inputFile = new File(String.valueOf(output.replace("\\", "/")) + "/" + inputFile.getName().replace(extension, ".txt"));
            }
            String cmd = " -filter_complex \"" + videoOutput + audioOutput + " -c:v rawvideo -map a? -f nut pipe:play |";
            frame.setCursor(Cursor.getPredefinedCursor(3));
            if (isVideoPlayer) {
                FFMPEG.toFFPLAY(String.valueOf(InputAndOutput.inPoint) + concat + " -i " + '\"' + inputFile + '\"' + InputAndOutput.outPoint + cmd);
            } else if (inputDeviceIsRunning) {
                if (((String)liste.getElementAt(0)).equals("Capture.current.screen") && RecordInputDevice.audioDeviceIndex > 0 || System.getProperty("os.name").contains("Mac") && ((String)liste.getElementAt(0)).equals("Capture.input.device") && RecordInputDevice.audioDeviceIndex > 0) {
                    cmd = cmd.replace("0:v", "1:v");
                }
                if (overlayDeviceIsRunning && audioOutput == "") {
                    cmd = cmd.replace("-map a?", "-map \"[v]\"");
                }
                if (overlayDeviceIsRunning) {
                    FFMPEG.toFFPLAY(String.valueOf(RecordInputDevice.setInputDevices()) + " " + RecordInputDevice.setOverlayDevice() + cmd);
                } else {
                    FFMPEG.toFFPLAY(String.valueOf(RecordInputDevice.setInputDevices()) + cmd);
                }
            } else {
                FFMPEG.toFFPLAY(" -i \"" + inputFile + '\"' + cmd);
            }
            if (isRunning) {
                do {
                    if (error) {
                        JOptionPane.showConfirmDialog(frame, language.getProperty("cantReadFile"), language.getProperty("menuItemVisualiser"), -1, 0);
                        break;
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (isRunning && !error);
            }
            if (VideoPlayer.comboMode.getSelectedItem().toString().equals(Shutter.language.getProperty("removeMode"))) {
                File listeBAB = new File(String.valueOf(output.replace("\\", "/")) + "/" + inputFile.getName().replace(extension, ".txt"));
                listeBAB.delete();
            }
            if (isRunning) {
                process.destroy();
            }
            FFMPEG.enableAll();
            progressBar1.setValue(0);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void previewEncoding() {
        var0 = FFMPEG.comboFonctions.getSelectedItem().toString();
        tmp = -1;
        switch (var0.hashCode()) {
            case -2014515735: {
                if (var0.equals("MPEG-1")) {
                    tmp = 1;
                }
                break;
            }
            case -2014515734: {
                if (var0.equals("MPEG-2")) {
                    tmp = 1;
                }
                break;
            }
            case -1396343175: {
                if (var0.equals("Apple ProRes")) {
                    tmp = 1;
                }
                break;
            }
            case -1204006736: {
                if (var0.equals("AVC-Intra 100")) {
                    tmp = 1;
                }
                break;
            }
            case -589899684: {
                if (var0.equals("GoPro CineForm")) {
                    tmp = 1;
                }
                break;
            }
            case 65180: {
                if (var0.equals("AV1")) {
                    tmp = 1;
                }
                break;
            }
            case 71287: {
                if (var0.equals("HAP")) {
                    tmp = 1;
                }
                break;
            }
            case 78206: {
                if (var0.equals("OGV")) {
                    tmp = 1;
                }
                break;
            }
            case 85182: {
                if (var0.equals("VP8")) {
                    tmp = 1;
                }
                break;
            }
            case 85183: {
                if (var0.equals("VP9")) {
                    tmp = 1;
                }
                break;
            }
            case 86080: {
                if (var0.equals("WMV")) {
                    tmp = 1;
                }
                break;
            }
            case 2155355: {
                if (var0.equals("FFV1")) {
                    tmp = 1;
                }
                break;
            }
            case 2686806: {
                if (var0.equals("XAVC")) {
                    tmp = 1;
                }
                break;
            }
            case 2738361: {
                if (var0.equals("Xvid")) {
                    tmp = 1;
                }
                break;
            }
            case 65240746: {
                if (var0.equals("DNxHD")) {
                    tmp = 1;
                }
                break;
            }
            case 65240760: {
                if (var0.equals("DNxHR")) {
                    tmp = 1;
                }
                break;
            }
            case 67913674: {
                if (var0.equals("H.264")) {
                    tmp = 1;
                }
                break;
            }
            case 67913675: {
                if (var0.equals("H.265")) {
                    tmp = 1;
                }
                break;
            }
            case 73394741: {
                if (var0.equals("MJPEG")) {
                    tmp = 1;
                }
                break;
            }
            case 1680221659: {
                if (var0.equals("XDCAM HD422")) {
                    tmp = 1;
                }
                break;
            }
            case 1916493562: {
                if (var0.equals("Uncompressed")) {
                    tmp = 1;
                }
                break;
            }
        }
        switch (tmp) {
            case 1: {
                VideoEncoders.main(false);
                break;
            }
            default: {
                if (FFMPEG.liste.getSize() <= 0) break;
                file = "";
                if (FFMPEG.fileList.getSelectedIndices().length <= 0) ** GOTO lbl134
                if (!FFMPEG.scanIsRunning) ** GOTO lbl132
                dir = new File(Shutter.liste.firstElement());
                var6_3 = dir.listFiles();
                var5_4 = var6_3.length;
                var4_9 = 0;
                while (var4_9 < var5_4) {
                    f = var6_3[var4_9];
                    if (f.isHidden() || !f.isFile()) ** GOTO lbl129
                    file = f.toString();
                    ** GOTO lbl135
lbl129:
                    // 1 sources

                    ++var4_9;
                }
                ** GOTO lbl135
lbl132:
                // 1 sources

                file = ((String)FFMPEG.fileList.getSelectedValue()).toString();
                ** GOTO lbl135
lbl134:
                // 1 sources

                file = (String)FFMPEG.liste.firstElement();
lbl135:
                // 4 sources

                extension = file.substring(file.lastIndexOf("."));
                isRaw = false;
                var4_10 = extension.toLowerCase();
                tmp = -1;
                switch (var4_10.hashCode()) {
                    case 0x15B551: {
                        if (var4_10.equals(".3fr")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 1467256: {
                        if (var4_10.equals(".arw")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 1469109: {
                        if (var4_10.equals(".cr2")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 1469110: {
                        if (var4_10.equals(".cr3")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 1469178: {
                        if (var4_10.equals(".crw")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 1469999: {
                        if (var4_10.equals(".dng")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 1476412: {
                        if (var4_10.equals(".kdc")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 1478788: {
                        if (var4_10.equals(".mrw")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 1479329: {
                        if (var4_10.equals(".nef")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 1479749: {
                        if (var4_10.equals(".nrw")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 1480693: {
                        if (var4_10.equals(".orf")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 1481251: {
                        if (var4_10.equals(".pef")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 1481621: {
                        if (var4_10.equals(".r3d")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 1481734: {
                        if (var4_10.equals(".ptx")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 1483049: {
                        if (var4_10.equals(".raf")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 1483679: {
                        if (var4_10.equals(".rw2")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 1484554: {
                        if (var4_10.equals(".srw")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 1487389: {
                        if (var4_10.equals(".x3f")) {
                            tmp = 1;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 1: {
                        isRaw = true;
                    }
                }
                if (extension.toLowerCase().equals(".pdf")) {
                    XPDF.toFFPROBE(file.toString());
                    do {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException var5_5) {
                            // empty catch block
                        }
                    } while (XPDF.isRunning);
                } else if (isRaw) {
                    EXIFTOOL.run(file);
                    do {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException var5_6) {
                            // empty catch block
                        }
                    } while (EXIFTOOL.isRunning);
                } else {
                    if (!Utils.inputDeviceIsRunning) {
                        FFPROBE.Data(file.toString());
                    }
                    do {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException var5_7) {
                            // empty catch block
                        }
                    } while (FFPROBE.isRunning);
                }
                rotate = "";
                if (!FFMPEG.caseRotate.isSelected()) ** GOTO lbl301
                transpose = "";
                var7_13 = FFMPEG.comboRotate.getSelectedItem().toString();
                tmp = -1;
                switch (var7_13.hashCode()) {
                    case 1815: {
                        if (var7_13.equals("90")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 45060: {
                        if (var7_13.equals("-90")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 48873: {
                        if (var7_13.equals("180")) {
                            tmp = 3;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 1: {
                        if (FFMPEG.caseMiror.isSelected()) {
                            transpose = "transpose=3";
                            break;
                        }
                        transpose = "transpose=1";
                        break;
                    }
                    case 2: {
                        if (FFMPEG.caseMiror.isSelected()) {
                            transpose = "transpose=0";
                            break;
                        }
                        transpose = "transpose=2";
                        break;
                    }
                    case 3: {
                        transpose = FFMPEG.caseMiror.isSelected() != false ? "transpose=1,transpose=1,hflip" : "transpose=1,transpose=1";
                    }
                }
                rotate = transpose;
lbl301:
                // 2 sources

                miror = "";
                if (FFMPEG.caseMiror.isSelected() && !FFMPEG.caseRotate.isSelected()) {
                    miror = "hflip";
                }
                filter = "";
                frameSize = "";
                if (VideoPlayer.caseEnableCrop.isSelected()) {
                    imageRatio = 1.0f;
                    ow = FFPROBE.imageWidth;
                    if (!Shutter.comboFonctions.getSelectedItem().toString().equals("DVD") && !Shutter.comboResolution.getSelectedItem().toString().equals(Shutter.language.getProperty("source"))) {
                        s = Shutter.comboResolution.getSelectedItem().toString().split("x");
                        ow = Integer.parseInt(s[0]);
                        imageRatio = (float)FFPROBE.imageWidth / (float)ow;
                    }
                    cropWidth = Math.round((float)Integer.parseInt(VideoPlayer.textCropWidth.getText()) / imageRatio);
                    cropHeight = Math.round((float)Integer.parseInt(VideoPlayer.textCropHeight.getText()) / imageRatio);
                    cropX = Math.round((float)Integer.parseInt(VideoPlayer.textCropPosX.getText()) / imageRatio);
                    cropY = Math.round((float)Integer.parseInt(VideoPlayer.textCropPosY.getText()) / imageRatio);
                    filter = " -vf crop=" + cropWidth + ":" + cropHeight + ":" + cropX + ":" + cropY;
                }
                if (FFMPEG.comboResolution.getSelectedItem().toString().contains(":")) {
                    if (FFMPEG.comboResolution.getSelectedItem().toString().contains("auto")) {
                        s = FFMPEG.comboResolution.getSelectedItem().toString().split(":");
                        frameSize = s[0].toString().equals("auto") ? "scale=-1:" + s[1] : "scale=" + s[0] + ":-1";
                    } else {
                        s = FFMPEG.comboResolution.getSelectedItem().toString().split(":");
                        number = 1.0f / (float)Integer.parseInt(s[0]);
                        frameSize = "scale=iw*" + number + ":ih*" + number;
                    }
                } else {
                    i = FFPROBE.imageResolution.split("x");
                    o = FFPROBE.imageResolution.split("x");
                    if (FFMPEG.comboResolution.getSelectedItem().toString().contains("%")) {
                        value = (double)Integer.parseInt(FFMPEG.comboResolution.getSelectedItem().toString().replace("%", "")) / 100.0;
                        o[0] = String.valueOf((int)((double)Integer.parseInt(i[0]) * value));
                        o[1] = String.valueOf((int)((double)Integer.parseInt(i[1]) * value));
                    } else {
                        o = FFMPEG.comboResolution.getSelectedItem().toString().split("x");
                    }
                    iw = Integer.parseInt(i[0]);
                    ih = Integer.parseInt(i[1]);
                    ow = Integer.parseInt(o[0]);
                    oh = Integer.parseInt(o[1]);
                    ir = (float)iw / (float)ih;
                    frameSize = iw > ow && ih > oh ? ((float)ow / ir >= (float)oh ? "scale=" + ow + ":-1,crop=" + "'" + ow + ":" + oh + ":0:(ih-oh)*0.5" + "'" : "scale=-1:" + oh + ",crop=" + "'" + ow + ":" + oh + ":(iw-ow)*0.5:0" + "'") : "scale=" + ow + ":" + oh;
                }
                if (frameSize != "") {
                    filter = filter != "" ? String.valueOf(filter) + "," + frameSize : " -vf " + frameSize;
                }
                if (filter != "") {
                    if (rotate != "") {
                        filter = String.valueOf(filter) + "," + rotate;
                    }
                    if (miror != "") {
                        filter = String.valueOf(filter) + "," + miror;
                    }
                } else if (rotate != "" && miror != "") {
                    filter = String.valueOf(filter) + " -vf " + rotate + "," + miror;
                } else if (rotate != "") {
                    filter = String.valueOf(filter) + " -vf " + rotate;
                } else if (miror != "") {
                    filter = String.valueOf(filter) + " -vf " + miror;
                }
                EXRGamma = Colorimetry.setInputCodec(extension);
                compression = "";
                fileSize = 0;
                if (FFMPEG.comboFonctions.getSelectedItem().toString().equals("JPEG") && !extension.toLowerCase().equals(".pdf") && !isRaw) {
                    q = Math.round(31.0f - (float)Integer.valueOf(FFMPEG.comboFilter.getSelectedItem().toString().replace("%", "")).intValue() * 31.0f / 100.0f);
                    compression = " -q:v " + q;
                    fileOut = new File(String.valueOf(FFMPEG.dirTemp) + "fileSize.jpg");
                    if (fileOut.exists()) {
                        fileOut.delete();
                    }
                    InputAndOutput.getInputAndOutput();
                    FFMPEG.run(String.valueOf(InputAndOutput.inPoint) + EXRGamma + " -i " + '\"' + file.toString() + '\"' + InputAndOutput.outPoint + filter + compression + " -vframes 1 " + '\"' + fileOut + '\"');
                    do {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException var14_29) {
                            // empty catch block
                        }
                    } while (FFMPEG.runProcess.isAlive());
                    FFMPEG.enableAll();
                    if (fileOut.exists()) {
                        fileSize = (int)fileOut.length() / 1024;
                        fileOut.delete();
                    }
                    filter = filter != "" ? String.valueOf(filter) + ",drawtext=fontfile=" + FFMPEG.pathToFont + ":text='" + fileSize + "Ko" + "':" + '\"' + "x=(w-tw)*0.95:y=h-(2*lh)" + '\"' + ":fontcolor=white:fontsize=w*0.0422:box=1:boxcolor=0x00000099" : " -vf drawtext=fontfile=" + FFMPEG.pathToFont + ":text='" + fileSize + "Ko" + "':" + '\"' + "x=(w-tw)*0.95:y=h-(2*lh)" + '\"' + ":fontcolor=white:fontsize=w*0.0422:box=1:boxcolor=0x00000099";
                }
                if (extension.toLowerCase().equals(".pdf")) {
                    XPDF.toFFPLAY(filter);
                    break;
                }
                if (isRaw) {
                    DCRAW.toFFPLAY(filter);
                    break;
                }
                if (FFMPEG.comboFonctions.getSelectedItem().toString().equals("JPEG")) {
                    cmd = String.valueOf(filter) + " -an -c:v mjpeg" + compression + " -vframes 1 -f nut pipe:play |";
                    FFMPEG.toFFPLAY(String.valueOf(InputAndOutput.inPoint) + EXRGamma + " -i " + '\"' + file + '\"' + InputAndOutput.outPoint + cmd);
                    break;
                }
                FFPLAY.run(String.valueOf(EXRGamma) + " -i " + '\"' + file + '\"' + filter);
            }
        }
        thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    do {
                        Thread.sleep(10L);
                    } while (!isRunning);
                    FFMPEG.enableAll();
                    lblCurrentEncoding.setForeground(Color.LIGHT_GRAY);
                    lblCurrentEncoding.setText(language.getProperty("lblEncodageEnCours"));
                    do {
                        Thread.sleep(10L);
                    } while (isRunning);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (case2pass.isSelected()) {
                    File fichier = new File((String)liste.getElementAt(0));
                    File folder = new File(fichier.getParent());
                    String ext = fichier.toString().substring(fichier.toString().lastIndexOf("."));
                    if (caseChangeFolder1.isSelected()) {
                        folder = new File(lblDestination1.getText());
                    }
                    FunctionUtils.listFilesForFolder(fichier.getName().replace(ext, ""), folder);
                }
            }
        });
        thread.start();
    }

    public static void hwaccel(final String cmd) {
        error = false;
        Console.consoleFFMPEG.append(String.valueOf(System.lineSeparator()) + Shutter.language.getProperty("command") + " " + cmd + System.lineSeparator());
        runProcess = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ProcessBuilder processFFMPEG;
                    String PathToFFMPEG;
                    if (System.getProperty("os.name").contains("Windows")) {
                        PathToFFMPEG = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                        PathToFFMPEG = PathToFFMPEG.substring(1, PathToFFMPEG.length() - 1);
                        PathToFFMPEG = String.valueOf(PathToFFMPEG.substring(0, PathToFFMPEG.lastIndexOf("/")).replace("%20", " ")) + "\\Library\\ffmpeg.exe";
                        processFFMPEG = new ProcessBuilder(String.valueOf('\"') + PathToFFMPEG + '\"' + " " + cmd.replace("PathToFFMPEG", PathToFFMPEG));
                        process = processFFMPEG.start();
                    } else {
                        PathToFFMPEG = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                        PathToFFMPEG = PathToFFMPEG.substring(0, PathToFFMPEG.length() - 1);
                        PathToFFMPEG = String.valueOf(PathToFFMPEG.substring(0, PathToFFMPEG.lastIndexOf("/")).replace("%20", "\\ ")) + "/Library/ffmpeg";
                        processFFMPEG = new ProcessBuilder("/bin/bash", "-c", String.valueOf(PathToFFMPEG) + " " + cmd.replace("PathToFFMPEG", PathToFFMPEG));
                        process = processFFMPEG.start();
                    }
                    if (cmd.contains("-hwaccels")) {
                        String line;
                        StringBuilder hwaccels = new StringBuilder();
                        InputStreamReader isr = new InputStreamReader(process.getInputStream());
                        BufferedReader br = new BufferedReader(isr);
                        hwaccels.append("auto" + System.lineSeparator());
                        Console.consoleFFMPEG.append(System.lineSeparator());
                        while ((line = br.readLine()) != null) {
                            if (line.contains("Hardware acceleration methods") || line.equals("") || line == null) continue;
                            Console.consoleFFMPEG.append(String.valueOf(line) + System.lineSeparator());
                            hwaccels.append(String.valueOf(line) + System.lineSeparator());
                        }
                        hwaccels.append(language.getProperty("aucun"));
                        Settings.comboGPU = new JComboBox<String>(hwaccels.toString().split(System.lineSeparator()));
                    } else {
                        String line;
                        BufferedReader input = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        Console.consoleFFMPEG.append(System.lineSeparator());
                        while ((line = input.readLine()) != null) {
                            Console.consoleFFMPEG.append(String.valueOf(line) + System.lineSeparator());
                            FFMPEG.checkForErrors(line);
                        }
                    }
                    process.waitFor();
                }
                catch (IOException PathToFFMPEG) {
                }
                catch (InterruptedException e) {
                    error = true;
                }
            }
        });
        runProcess.start();
    }

    public static void checkGPUCapabilities(String file, boolean force) {
        frame.setCursor(Cursor.getPredefinedCursor(3));
        isGPUCompatible = false;
        cudaAvailable = false;
        qsvAvailable = false;
        if (System.getProperty("os.name").contains("Windows") && !Settings.comboGPU.getSelectedItem().toString().equals(Shutter.language.getProperty("aucun")) && !Settings.comboGPUFilter.getSelectedItem().toString().equals(Shutter.language.getProperty("aucun")) || System.getProperty("os.name").contains("Windows") && force) {
            String vcodec = "";
            if (FFPROBE.videoCodec != null && FFPROBE.totalLength > 40) {
                vcodec = FFPROBE.videoCodec.replace("video", "");
                String[] stringArray = Shutter.functionsList;
                int n = Shutter.functionsList.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (vcodec.toLowerCase().equals(s.replace(".", "").replace("-", "").toLowerCase()) || s.toLowerCase().contains(vcodec.toLowerCase())) {
                        vcodec = s;
                        break;
                    }
                    vcodec = vcodec.toUpperCase();
                    ++n2;
                }
            }
            if (vcodec.equals("H.264") || vcodec.equals("HEVC") || vcodec.equals("VP8") || vcodec.equals("VP9") || vcodec.equals("AV1") || vcodec.equals("MPEG-1") || vcodec.equals("MPEG-2")) {
                isGPUCompatible = true;
            }
            if (FFPROBE.imageDepth > 10) {
                isGPUCompatible = false;
            }
            if (isGPUCompatible) {
                try {
                    String bitDepth = "nv12";
                    if (FFPROBE.imageDepth == 10) {
                        bitDepth = "p010";
                    }
                    if (!comboResolution.getSelectedItem().toString().equals(language.getProperty("source")) || force) {
                        if (Settings.comboGPU.getSelectedItem().toString().equals("auto") || force) {
                            FFMPEG.gpuFilter(" -hwaccel cuda -hwaccel_output_format cuda -i \"" + file + '\"' + " -vf scale_cuda=640:360,hwdownload,format=" + bitDepth + " -an -t 1 -f null -" + '\"');
                            do {
                                Thread.sleep(100L);
                            } while (runProcess.isAlive());
                            if (!error) {
                                cudaAvailable = true;
                            }
                            FFMPEG.gpuFilter(" -hwaccel qsv -hwaccel_output_format qsv -i \"" + file + '\"' + " -vf scale_qsv=640:360,hwdownload,format=" + bitDepth + " -an -t 1 -f null -" + '\"');
                            do {
                                Thread.sleep(100L);
                            } while (runProcess.isAlive());
                            if (!error) {
                                qsvAvailable = true;
                            }
                            if (caseAccel.isSelected()) {
                                if (comboAccel.getSelectedItem().equals("Intel Quick Sync")) {
                                    cudaAvailable = false;
                                } else if (comboAccel.getSelectedItem().equals("Nvidia NVENC")) {
                                    qsvAvailable = false;
                                }
                            }
                            if (!cudaAvailable && !qsvAvailable) {
                                isGPUCompatible = false;
                            }
                        } else {
                            FFMPEG.gpuFilter(" -hwaccel " + Settings.comboGPU.getSelectedItem().toString() + " -hwaccel_output_format " + Settings.comboGPUFilter.getSelectedItem().toString() + " -i " + '\"' + file + '\"' + " -vf scale_" + Settings.comboGPUFilter.getSelectedItem().toString() + "=640:360,hwdownload,format=" + bitDepth + " -an -t 1 -f null -" + '\"');
                            do {
                                Thread.sleep(100L);
                            } while (runProcess.isAlive());
                            if (error) {
                                isGPUCompatible = false;
                            }
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                error = false;
                errorLog.setLength(0);
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public static void gpuFilter(final String cmd) {
        error = false;
        Console.consoleFFMPEG.append(String.valueOf(System.lineSeparator()) + Shutter.language.getProperty("command") + " -threads " + Settings.txtThreads.getText() + cmd + System.lineSeparator());
        runProcess = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String line;
                    ProcessBuilder processFFMPEG;
                    String PathToFFMPEG;
                    if (System.getProperty("os.name").contains("Windows")) {
                        PathToFFMPEG = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                        PathToFFMPEG = PathToFFMPEG.substring(1, PathToFFMPEG.length() - 1);
                        PathToFFMPEG = String.valueOf(PathToFFMPEG.substring(0, PathToFFMPEG.lastIndexOf("/")).replace("%20", " ")) + "\\Library\\ffmpeg.exe";
                        processFFMPEG = new ProcessBuilder(String.valueOf('\"') + PathToFFMPEG + '\"' + " " + cmd.replace("PathToFFMPEG", PathToFFMPEG));
                        process = processFFMPEG.start();
                    } else {
                        PathToFFMPEG = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                        PathToFFMPEG = PathToFFMPEG.substring(0, PathToFFMPEG.length() - 1);
                        PathToFFMPEG = String.valueOf(PathToFFMPEG.substring(0, PathToFFMPEG.lastIndexOf("/")).replace("%20", "\\ ")) + "/Library/ffmpeg";
                        processFFMPEG = new ProcessBuilder("/bin/bash", "-c", String.valueOf(PathToFFMPEG) + " " + cmd.replace("PathToFFMPEG", PathToFFMPEG));
                        process = processFFMPEG.start();
                    }
                    BufferedReader input = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    Console.consoleFFMPEG.append(System.lineSeparator());
                    while ((line = input.readLine()) != null) {
                        Console.consoleFFMPEG.append(String.valueOf(line) + System.lineSeparator());
                        FFMPEG.checkForErrors(line);
                    }
                    process.waitFor();
                }
                catch (IOException PathToFFMPEG) {
                }
                catch (InterruptedException e) {
                    error = true;
                }
            }
        });
        runProcess.start();
    }

    public static void devices(final String cmd) {
        error = false;
        isRunning = true;
        Console.consoleFFMPEG.append(String.valueOf(System.lineSeparator()) + Shutter.language.getProperty("command") + cmd + System.lineSeparator());
        runProcess = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        String line;
                        ProcessBuilder processFFMPEG;
                        String PathToFFMPEG;
                        if (System.getProperty("os.name").contains("Windows")) {
                            PathToFFMPEG = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                            PathToFFMPEG = PathToFFMPEG.substring(1, PathToFFMPEG.length() - 1);
                            PathToFFMPEG = String.valueOf(PathToFFMPEG.substring(0, PathToFFMPEG.lastIndexOf("/")).replace("%20", " ")) + "\\Library\\ffmpeg.exe";
                            processFFMPEG = new ProcessBuilder(String.valueOf('\"') + PathToFFMPEG + '\"' + " " + cmd.replace("PathToFFMPEG", PathToFFMPEG));
                            process = processFFMPEG.start();
                        } else {
                            PathToFFMPEG = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                            PathToFFMPEG = PathToFFMPEG.substring(0, PathToFFMPEG.length() - 1);
                            PathToFFMPEG = String.valueOf(PathToFFMPEG.substring(0, PathToFFMPEG.lastIndexOf("/")).replace("%20", "\\ ")) + "/Library/ffmpeg";
                            processFFMPEG = new ProcessBuilder("/bin/bash", "-c", String.valueOf(PathToFFMPEG) + " " + cmd.replace("PathToFFMPEG", PathToFFMPEG));
                            process = processFFMPEG.start();
                        }
                        BufferedReader input = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        boolean isVideoDevices = false;
                        boolean isAudioDevices = false;
                        if (!cmd.contains("openal")) {
                            videoDevices = new StringBuilder();
                            videoDevices.append(language.getProperty("noVideo"));
                        }
                        audioDevices = new StringBuilder();
                        audioDevices.append(language.getProperty("noAudio"));
                        Console.consoleFFMPEG.append(System.lineSeparator());
                        while ((line = input.readLine()) != null) {
                            String utf8EncodedString;
                            byte[] bytes;
                            String[] s;
                            Console.consoleFFMPEG.append(String.valueOf(line) + System.lineSeparator());
                            if (cmd.contains("avfoundation") && line.contains("]")) {
                                if (isAudioDevices) {
                                    s = line.split("\\]");
                                    bytes = s[2].substring(1, s[2].length()).getBytes(StandardCharsets.ISO_8859_1);
                                    utf8EncodedString = new String(bytes, StandardCharsets.UTF_8);
                                    audioDevices.append(":" + utf8EncodedString);
                                }
                                if (line.contains("AVFoundation audio devices")) {
                                    isAudioDevices = true;
                                }
                                if (isVideoDevices && !line.contains("Capture screen") && !isAudioDevices) {
                                    s = line.split("\\]");
                                    bytes = s[2].substring(1, s[2].length()).getBytes(StandardCharsets.ISO_8859_1);
                                    utf8EncodedString = new String(bytes, StandardCharsets.UTF_8);
                                    videoDevices.append(":" + utf8EncodedString);
                                }
                                if (line.contains("AVFoundation video devices")) {
                                    isVideoDevices = true;
                                }
                            }
                            if (cmd.contains("avfoundation") && line.contains("Capture screen") && firstScreenIndex == -1) {
                                s = line.split("\\[");
                                String[] s2 = s[2].split("\\]");
                                firstScreenIndex = Integer.parseInt(s2[0]);
                            }
                            if (cmd.contains("dshow")) {
                                if (line.contains("audio") && line.contains("\"") && !line.contains("Alternative name")) {
                                    s = line.split("\"");
                                    bytes = s[1].getBytes(StandardCharsets.ISO_8859_1);
                                    utf8EncodedString = new String(bytes, StandardCharsets.UTF_8);
                                    audioDevices.append(":" + utf8EncodedString);
                                }
                                if (line.contains("video") && line.contains("\"") && !line.contains("Alternative name") && !isAudioDevices) {
                                    s = line.split("\"");
                                    bytes = s[1].getBytes(StandardCharsets.ISO_8859_1);
                                    utf8EncodedString = new String(bytes, StandardCharsets.UTF_8);
                                    videoDevices.append(":" + utf8EncodedString);
                                }
                            }
                            FFMPEG.checkForErrors(line);
                        }
                        process.waitFor();
                    }
                    catch (IOException PathToFFMPEG) {
                        isRunning = false;
                    }
                    catch (InterruptedException e) {
                        error = true;
                        isRunning = false;
                    }
                }
                finally {
                    isRunning = false;
                }
            }
        });
        runProcess.start();
    }

    private static void saveToXML(String cmd) {
        FileDialog dialog = new FileDialog((Frame)frame, Shutter.language.getProperty("saveSettings"), 1);
        dialog.setDirectory(Functions.functionsFolder.toString());
        dialog.setLocation(FFMPEG.frame.getLocation().x - 50, FFMPEG.frame.getLocation().y + 50);
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
        if (dialog.getFile() != null) {
            try {
                DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                Element root = document.createElement("Shutter");
                document.appendChild(root);
                Element settings = document.createElement("settings");
                root.appendChild(settings);
                Attr attr = document.createAttribute("id");
                attr.setValue("10");
                settings.setAttributeNode(attr);
                String[] split = cmd.split("\"");
                String entree = split[1];
                int i = 0;
                while (++i < split.length) {
                }
                String sortie = split[i - 1];
                Element firstName = document.createElement("command");
                firstName.appendChild(document.createTextNode("ffmpeg" + cmd.replace(InputAndOutput.inPoint, "").replace(" -i ", "").replace(String.valueOf('\"') + entree + '\"', "").replace(String.valueOf('\"') + sortie + '\"', "").replace(" -y ", "").replace(" -n ", "")));
                settings.appendChild(firstName);
                Element lastname = document.createElement("pointIn");
                lastname.appendChild(document.createTextNode(InputAndOutput.inPoint));
                settings.appendChild(lastname);
                String ext = cmd.substring(cmd.lastIndexOf("."));
                Element email = document.createElement("extension");
                email.appendChild(document.createTextNode(ext.replace("\"", "")));
                settings.appendChild(email);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource domSource = new DOMSource(document);
                StreamResult streamResult = new StreamResult(new File(String.valueOf(dialog.getDirectory()) + dialog.getFile().toString().replace(".enc", "")) + ".enc");
                transformer.transform(domSource, streamResult);
            }
            catch (ParserConfigurationException | TransformerException exception) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isReadable(File file) {
        try {
            String line;
            ProcessBuilder processFFMPEG;
            String PathToFFMPEG;
            if (System.getProperty("os.name").contains("Windows")) {
                PathToFFMPEG = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                PathToFFMPEG = PathToFFMPEG.substring(1, PathToFFMPEG.length() - 1);
                PathToFFMPEG = String.valueOf(PathToFFMPEG.substring(0, PathToFFMPEG.lastIndexOf("/")).replace("%20", " ")) + "\\Library\\ffmpeg.exe";
                processFFMPEG = new ProcessBuilder(String.valueOf('\"') + PathToFFMPEG + '\"' + " -hide_banner -i " + '\"' + file + '\"' + " -t 5 -f null -" + '\"');
                process = processFFMPEG.start();
            } else {
                PathToFFMPEG = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                PathToFFMPEG = PathToFFMPEG.substring(0, PathToFFMPEG.length() - 1);
                PathToFFMPEG = String.valueOf(PathToFFMPEG.substring(0, PathToFFMPEG.lastIndexOf("/")).replace("%20", "\\ ")) + "/Library/ffmpeg";
                processFFMPEG = new ProcessBuilder("/bin/bash", "-c", String.valueOf(PathToFFMPEG) + " -hide_banner -i " + '\"' + file + '\"' + " -t 5 -f null -");
                process = processFFMPEG.start();
            }
            Console.consoleFFMPEG.append(String.valueOf(System.lineSeparator()) + Shutter.language.getProperty("command") + " -hide_banner -i " + '\"' + file + '\"' + " -t 5 -f null -" + System.lineSeparator());
            BufferedReader input = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            Console.consoleFFMPEG.append(System.lineSeparator());
            do {
                if ((line = input.readLine()) == null) {
                    return true;
                }
                Console.consoleFFMPEG.append(String.valueOf(line) + System.lineSeparator());
                if (line.contains("No such file or directory")) return false;
                if (line.contains("Invalid data found")) return false;
                if (line.contains("moov atom not found")) return false;
                if (line.contains("Operation not permitted")) return false;
                if (line.contains("File ended prematurely")) return false;
                if (line.contains("Warning MVs not available")) return false;
                if (line.contains("broken or empty index")) return false;
                if (line.contains("corrupt decoded frame")) return false;
                if (line.contains("invalid new backstep")) return false;
                if (line.contains("Packet corrupt")) return false;
                if (line.contains("ac-tex damaged")) return false;
            } while (!line.contains("Error"));
            return false;
        }
        catch (IOException PathToFFMPEG) {
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void suspendProcess() {
        try {
            if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                Runtime.getRuntime().exec("kill -SIGSTOP " + process.pid());
            } else {
                String pausep = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                pausep = pausep.substring(1, pausep.length() - 1);
                pausep = String.valueOf('\"') + pausep.substring(0, pausep.lastIndexOf("/")).replace("%20", " ") + "/Library/pausep.exe" + '\"';
                Runtime.getRuntime().exec(String.valueOf(pausep) + " " + process.pid());
            }
            if (System.getProperty("os.name").contains("Windows") && Taskbar.isTaskbarSupported()) {
                Taskbar.getTaskbar().setWindowProgressState(frame, Taskbar.State.PAUSED);
            }
        }
        catch (IOException | IllegalArgumentException | SecurityException exception) {
            // empty catch block
        }
    }

    public static void resumeProcess() {
        try {
            elapsedTime = System.currentTimeMillis() - (long)previousElapsedTime;
            if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                Runtime.getRuntime().exec("kill -SIGCONT " + process.pid());
            } else {
                String pausep = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                pausep = pausep.substring(1, pausep.length() - 1);
                pausep = String.valueOf('\"') + pausep.substring(0, pausep.lastIndexOf("/")).replace("%20", " ") + "/Library/pausep.exe" + '\"';
                Runtime.getRuntime().exec(String.valueOf(pausep) + " " + process.pid() + " /r");
            }
            if (System.getProperty("os.name").contains("Windows") && Taskbar.isTaskbarSupported()) {
                Taskbar.getTaskbar().setWindowProgressState(frame, Taskbar.State.NORMAL);
            }
        }
        catch (IOException | IllegalArgumentException | SecurityException exception) {
            // empty catch block
        }
    }

    private static void setProgress(String line, boolean pass2, String cmd) {
        String ffmpegTime;
        String[] split;
        String str;
        if (line.contains("Input #1")) {
            firstInput = false;
        }
        if (line.contains("Duration") && !line.contains("Duration: N/A") && !line.contains("<Duration>") && !line.contains("Segment-Durations-Ms") && firstInput) {
            float newFPS;
            str = line.substring(line.indexOf(":") + 2);
            split = str.split(",");
            ffmpegTime = split[0].replace(".", ":");
            dureeTotale = caseEnableSequence.isSelected() ? (int)((float)liste.getSize() / Float.parseFloat(caseSequenceFPS.getSelectedItem().toString().replace(",", "."))) : (caseInAndOut.isSelected() && (VideoPlayer.playerInMark > 0 || VideoPlayer.playerOutMark < VideoPlayer.waveformContainer.getWidth() - 2) ? VideoPlayer.durationH * 3600 + VideoPlayer.durationM * 60 + VideoPlayer.durationS : FFMPEG.getTimeToSeconds(ffmpegTime));
            if (caseConform.isSelected()) {
                newFPS = Float.parseFloat(comboFPS.getSelectedItem().toString().replace(",", "."));
                if (comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySpeed"))) {
                    dureeTotale = (int)((float)dureeTotale * (FFPROBE.currentFPS / newFPS));
                } else if (comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySlowMotion"))) {
                    dureeTotale = (int)((float)dureeTotale * (newFPS / FFPROBE.currentFPS));
                }
            }
            if (comboFonctions.getSelectedItem().toString().equals(language.getProperty("functionConform"))) {
                newFPS = Float.parseFloat(comboFilter.getSelectedItem().toString().replace(" " + Shutter.language.getProperty("fps"), "").replace(",", "."));
                dureeTotale = (int)((float)dureeTotale * (FFPROBE.currentFPS / newFPS));
            }
            if (comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionPicture")) && !comboFilter.getSelectedItem().toString().equals(".gif") && !Shutter.caseCreateSequence.isSelected()) {
                dureeTotale = 1;
            }
            if ((comboFonctions.getSelectedItem().toString().equals("H.264") || comboFonctions.getSelectedItem().toString().equals("H.265") || comboFonctions.getSelectedItem().toString().equals("WMV") || comboFonctions.getSelectedItem().toString().equals("MPEG-1") || comboFonctions.getSelectedItem().toString().equals("MPEG-2") || comboFonctions.getSelectedItem().toString().equals("WebM") || comboFonctions.getSelectedItem().toString().equals("AV1") || comboFonctions.getSelectedItem().toString().equals("OGV") || comboFonctions.getSelectedItem().toString().equals("MJPEG") || comboFonctions.getSelectedItem().toString().equals("Xvid") || comboFonctions.getSelectedItem().toString().equals("Blu-ray")) && case2pass.isSelected() || comboFonctions.getSelectedItem().toString().equals("DVD") && BitratesAdjustement.DVD2Pass) {
                dureeTotale *= 2;
            }
            if (cmd.contains("-loop")) {
                progressBar1.setMaximum(Integer.parseInt(Settings.txtImageDuration.getText()));
            } else if (!comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionInsert"))) {
                progressBar1.setMaximum(dureeTotale);
            }
        }
        if (line.contains("time=") && !lblCurrentEncoding.getText().equals(language.getProperty("lblEncodageEnCours")) && !lblCurrentEncoding.getText().equals(language.getProperty("processCancelled")) && !lblCurrentEncoding.getText().equals(language.getProperty("processEnded"))) {
            error = false;
            str = line.substring(line.indexOf(":") - 2);
            split = str.split("b");
            ffmpegTime = split[0].replace(".", ":").replace(" ", "");
            if (progressBar1.getString().equals("NaN") || inputDeviceIsRunning) {
                progressBar1.setStringPainted(false);
            } else {
                progressBar1.setStringPainted(true);
            }
            if (pass2) {
                progressBar1.setValue(dureeTotale / 2 + FFMPEG.getTimeToSeconds(ffmpegTime));
            } else {
                progressBar1.setValue(FFMPEG.getTimeToSeconds(ffmpegTime));
            }
        }
        previousElapsedTime = (int)(System.currentTimeMillis() - elapsedTime);
        int timeH = previousElapsedTime / 3600000 % 60;
        int timeMin = previousElapsedTime / 60000 % 60;
        int timeSec = previousElapsedTime / 1000 % 60;
        String heures = "";
        String minutes = "";
        String secondes = "";
        heures = timeH >= 1 ? String.valueOf(timeH) + "h " : "";
        minutes = timeMin >= 1 ? String.valueOf(timeMin) + "min " : "";
        secondes = timeSec > 0 ? String.valueOf(timeSec) + "sec" : "0sec";
        tempsEcoule.setText(String.valueOf(Shutter.language.getProperty("tempsEcoule")) + " " + heures + minutes + secondes);
        tempsEcoule.setSize(FFMPEG.tempsEcoule.getPreferredSize().width, 15);
        if ((line.contains("frame=") || line.contains("time=")) && !comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionPicture"))) {
            String[] split2 = line.split("=");
            int frames = 0;
            if (line.contains("frame=")) {
                frames = Integer.parseInt(split2[1].replace("fps", "").replace(" ", ""));
            } else if (line.contains("time=")) {
                String[] rawTime = split2[2].split(" ");
                String timecode = rawTime[0].replace(".", ":");
                String[] time = timecode.split(":");
                int h = Integer.parseInt(time[0]);
                int m = Integer.parseInt(time[1]);
                int s = Integer.parseInt(time[2]);
                int fps = Integer.parseInt(time[3]);
                frames = (int)((float)(h * 3600) * FFPROBE.currentFPS + (float)(m * 60) * FFPROBE.currentFPS + (float)s * FFPROBE.currentFPS + (float)fps);
            }
            if (time == 0L) {
                frame0 = frames;
                time = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - time >= 1000L && frames - frame0 > 0) {
                int total;
                if (fps == 0) {
                    fps = frames - frame0;
                } else if (frames - frame0 < fps - 100 || frames - frame0 > fps + 100) {
                    fps = frames - frame0;
                } else if (frames - frame0 > fps + 1) {
                    ++fps;
                } else if (frames - frame0 < fps - 1 && fps > 1) {
                    --fps;
                }
                time = 0L;
                if ((comboFonctions.getSelectedItem().toString().equals("H.264") || comboFonctions.getSelectedItem().toString().equals("H.265") || comboFonctions.getSelectedItem().toString().equals("WMV") || comboFonctions.getSelectedItem().toString().equals("MPEG-1") || comboFonctions.getSelectedItem().toString().equals("MPEG-2") || comboFonctions.getSelectedItem().toString().equals("WebM") || comboFonctions.getSelectedItem().toString().equals("AV1") || comboFonctions.getSelectedItem().toString().equals("OGV") || comboFonctions.getSelectedItem().toString().equals("MJPEG") || comboFonctions.getSelectedItem().toString().equals("Xvid") || comboFonctions.getSelectedItem().toString().equals("Blu-ray")) && case2pass.isSelected() || comboFonctions.getSelectedItem().toString().equals("DVD") && BitratesAdjustement.DVD2Pass) {
                    total = (int)((float)(dureeTotale / 2) * FFPROBE.currentFPS);
                } else if (caseConform.isSelected() && !comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySlowMotion")) && !caseForcerEntrelacement.isSelected()) {
                    float newFPS = Float.parseFloat(comboFPS.getSelectedItem().toString().replace(",", "."));
                    total = (int)((float)dureeTotale * FFPROBE.currentFPS * (newFPS / FFPROBE.currentFPS));
                } else {
                    total = (int)((float)dureeTotale * FFPROBE.currentFPS);
                }
                int restant = (total - frames) / fps;
                if (!(comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionPicture")) || comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSceneDetection")) || comboFonctions.getSelectedItem().equals("Synchronisation automatique"))) {
                    String pass = "";
                    if ((comboFonctions.getSelectedItem().toString().equals("H.264") || comboFonctions.getSelectedItem().toString().equals("H.265") || comboFonctions.getSelectedItem().toString().equals("WMV") || comboFonctions.getSelectedItem().toString().equals("MPEG-1") || comboFonctions.getSelectedItem().toString().equals("MPEG-2") || comboFonctions.getSelectedItem().toString().equals("WebM") || comboFonctions.getSelectedItem().toString().equals("AV1") || comboFonctions.getSelectedItem().toString().equals("OGV") || comboFonctions.getSelectedItem().toString().equals("MJPEG") || comboFonctions.getSelectedItem().toString().equals("Xvid") || comboFonctions.getSelectedItem().toString().equals("Blu-ray")) && case2pass.isSelected() || comboFonctions.getSelectedItem().toString().equals("DVD") && BitratesAdjustement.DVD2Pass) {
                        pass = !pass2 ? " - " + Shutter.language.getProperty("firstPass") : " - " + Shutter.language.getProperty("secondPass");
                    }
                    timeH = restant / 3600 % 60;
                    timeMin = restant / 60 % 60;
                    timeSec = restant % 60;
                    heures = timeH >= 1 ? String.valueOf(timeH) + "h " : "";
                    minutes = timeMin >= 1 ? String.valueOf(timeMin) + "min " : "";
                    secondes = timeSec > 0 ? String.valueOf(timeSec) + "sec" : "";
                    tempsRestant.setText(String.valueOf(Shutter.language.getProperty("tempsRestant")) + " " + heures + minutes + secondes + pass);
                    tempsRestant.setSize(FFMPEG.tempsRestant.getPreferredSize().width, 15);
                    if (tempsRestant.getX() + FFMPEG.tempsRestant.getSize().width > lblArrows.getX()) {
                        lblArrows.setVisible(false);
                    } else {
                        lblArrows.setVisible(true);
                    }
                    if (heures != "" || minutes != "" || secondes != "") {
                        tempsRestant.setVisible(true);
                    } else {
                        tempsRestant.setVisible(false);
                    }
                }
            }
        } else if (line.contains("frame=") && !caseDisplay.isSelected()) {
            tempsEcoule.setVisible(true);
        }
        if (comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSceneDetection")) && line.contains("pts")) {
            DecimalFormat formatter = new DecimalFormat("00");
            String[] rawline = line.split(":");
            String[] fullTime = rawline[3].split(" ");
            int rawTime = (int)(Float.valueOf(fullTime[0]).floatValue() * 1000.0f);
            long rawFrames = Math.round((float)rawTime / (1000.0f / FFPROBE.currentFPS));
            String h = formatter.format(Math.round(rawFrames / (long)Math.round(FFPROBE.currentFPS)) / 3600);
            String m = formatter.format(Math.round(rawFrames / (long)Math.round(FFPROBE.currentFPS) / 60L) % 60);
            String s = formatter.format(Math.round(rawFrames / (long)Math.round(FFPROBE.currentFPS) % 60L));
            String f = formatter.format(rawFrames % (long)Math.round(FFPROBE.currentFPS));
            File imageName = new File(SceneDetection.outputFolder + "/" + SceneDetection.tableRow.getRowCount() + ".png");
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!imageName.exists());
            ImageIcon imageIcon = new ImageIcon(imageName.toString());
            ImageIcon icon = new ImageIcon(imageIcon.getImage().getScaledInstance(142, 80, 1));
            SceneDetection.tableRow.addRow(new Object[]{SceneDetection.tableRow.getRowCount() + 1, icon, String.valueOf(h) + ":" + m + ":" + s + ":" + f});
            SceneDetection.scrollPane.getVerticalScrollBar().setValue(SceneDetection.scrollPane.getVerticalScrollBar().getMaximum());
            SceneDetection.table.repaint();
        }
        if (line.contains("Parsed_cropdetect")) {
            cropdetect = line.substring(line.indexOf("crop=") + 5);
        }
    }

    private static void postAnalyse() {
        Object shortTermTC;
        if (comboFonctions.getSelectedItem().toString().equals("Loudness & True Peak") || comboFonctions.getSelectedItem().toString().equals(language.getProperty("functionNormalization"))) {
            analyseLufs = null;
            analyseLufs = getAll.toString().substring(getAll.toString().lastIndexOf("Summary:") + 12);
            shortTermValues = new StringBuilder();
            float momentaryTerm = -1000.0f;
            String momentaryTermTC = "";
            float shortTerm = -1000.0f;
            shortTermTC = "";
            String[] stringArray = getAll.toString().split(System.lineSeparator());
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String allValues = stringArray[n2];
                if (allValues.contains("Parsed_ebur128") && !allValues.contains("Summary:")) {
                    String[] spliter = allValues.split(":");
                    DecimalFormat round = new DecimalFormat("0.##");
                    String[] splitTime = spliter[1].split(" ");
                    int temps = (int)(Float.parseFloat(round.format(Double.valueOf(splitTime[1].replace(",", ""))).replace(",", ".")) * 1000.0f);
                    DecimalFormat formatter = new DecimalFormat("00");
                    String h = formatter.format(temps / 3600000);
                    String m = formatter.format(temps / 60000 % 60);
                    String s = formatter.format(temps / 1000 % 60);
                    String f = formatter.format((int)((float)temps / (1000.0f / FFPROBE.currentFPS) % FFPROBE.currentFPS));
                    String timecode = String.valueOf(h) + ":" + m + ":" + s + ":" + f;
                    String values = allValues.substring(allValues.indexOf("M"));
                    String[] v = values.split(":");
                    try {
                        float S;
                        float M = Float.parseFloat(v[1].replace(" S", ""));
                        if (M > momentaryTerm) {
                            momentaryTerm = M;
                            momentaryTermTC = timecode;
                        }
                        if ((S = Float.parseFloat(v[2].replace("     I", ""))) > shortTerm) {
                            shortTerm = S;
                            shortTermTC = timecode;
                        }
                        if ((double)S > -16.0) {
                            shortTermValues.append(String.valueOf(timecode) + ": Short-term: " + S + " LUFS" + System.lineSeparator());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            analyseLufs = String.valueOf(analyseLufs) + System.lineSeparator() + "  Momentary max: " + momentaryTerm + " LUFS";
            analyseLufs = String.valueOf(analyseLufs) + System.lineSeparator() + "    Timecode:     " + momentaryTermTC;
            analyseLufs = String.valueOf(analyseLufs) + System.lineSeparator();
            analyseLufs = String.valueOf(analyseLufs) + System.lineSeparator() + "  Short-term max: " + shortTerm + " LUFS";
            analyseLufs = String.valueOf(analyseLufs) + System.lineSeparator() + "    Timecode:     " + (String)shortTermTC;
            if (shortTermValues.length() == 0) {
                shortTermValues.append(Shutter.language.getProperty("shortTerm"));
            }
            if (lblCurrentEncoding.getText().contains(Shutter.language.getProperty("analyzing"))) {
                String[] lufs = analyseLufs.split(":");
                String[] lufsFinal = lufs[2].split("L");
                String[] db = comboFilter.getSelectedItem().toString().split(" ");
                newVolume = Float.parseFloat(db[0]) - Float.parseFloat(lufsFinal[0].replace(" ", ""));
            }
        }
        if (comboFonctions.getSelectedItem().toString().equals(Shutter.language.getProperty("functionBlackDetection"))) {
            blackFrame = new StringBuilder();
            shortTermTC = getAll.toString().split(System.lineSeparator());
            int shortTerm = ((String[])shortTermTC).length;
            int momentaryTermTC = 0;
            while (momentaryTermTC < shortTerm) {
                String blackLine = shortTermTC[momentaryTermTC];
                if (blackLine.contains("blackdetect") && !blackLine.contains("black_start:0")) {
                    String blackdetect = blackLine.substring(blackLine.indexOf("black_start"));
                    String[] d = blackdetect.split(":");
                    String blackstart = d[1].replace(" black_end", "");
                    String[] bsDuree = blackstart.split("\\.");
                    int secondes = Integer.valueOf(bsDuree[0]);
                    int images = 0;
                    DecimalFormat formatter = new DecimalFormat("00");
                    String tcBlackFrame = String.valueOf(formatter.format(secondes / 3600)) + ":" + formatter.format(secondes / 60 % 60) + ":" + formatter.format(secondes % 60);
                    switch (bsDuree[1].length()) {
                        case 1: {
                            images = Integer.valueOf(bsDuree[1]) * 100;
                            break;
                        }
                        case 2: {
                            images = Integer.valueOf(bsDuree[1]) * 10;
                            break;
                        }
                        case 3: {
                            images = Integer.valueOf(bsDuree[1]);
                        }
                    }
                    tcBlackFrame = String.valueOf(tcBlackFrame) + ":" + formatter.format((int)((float)images / (1000.0f / FFPROBE.currentFPS)));
                    blackFrame.append(String.valueOf(tcBlackFrame) + System.lineSeparator());
                }
                ++momentaryTermTC;
            }
        }
        if (comboFonctions.getSelectedItem().toString().equals(Shutter.language.getProperty("functionOfflineDetection"))) {
            mediaOfflineFrame = new StringBuilder();
            File stats_file = System.getProperty("os.name").contains("Windows") ? new File("stats_file") : new File(String.valueOf(Shutter.dirTemp) + "stats_file");
            if (stats_file.exists()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(stats_file.toString()));
                    boolean offline = false;
                    Float mseValue = Float.valueOf(0.0f);
                    String line = reader.readLine();
                    while (line != null) {
                        if (line.contains("mse_avg")) {
                            String[] s = line.split(":");
                            String[] m = s[2].split(" ");
                            Float mse = Float.valueOf(Float.parseFloat(m[0]));
                            String[] f = s[1].split(" ");
                            String frame = f[0];
                            int frameNumber = Integer.parseInt(frame) - 2;
                            if (mse.floatValue() <= mseSensibility.floatValue() && !offline) {
                                if (mseValue.floatValue() == mse.floatValue()) {
                                    offline = true;
                                    DecimalFormat formatter = new DecimalFormat("00");
                                    String tcOfflineFrame = String.valueOf(formatter.format(Math.floor((float)frameNumber / FFPROBE.currentFPS) / 3600.0)) + ":" + formatter.format(Math.floor((float)frameNumber / FFPROBE.currentFPS / 60.0f) % 60.0) + ":" + formatter.format(Math.floor((float)frameNumber / FFPROBE.currentFPS) % 60.0) + ":" + formatter.format((float)frameNumber % FFPROBE.currentFPS);
                                    mediaOfflineFrame.append(String.valueOf(tcOfflineFrame) + System.lineSeparator());
                                }
                                mseValue = mse;
                            } else if (mse.floatValue() > mseSensibility.floatValue()) {
                                offline = false;
                                mseValue = Float.valueOf(0.0f);
                            }
                        }
                        line = reader.readLine();
                    }
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                stats_file.delete();
            }
        }
        if (comboFonctions.getSelectedItem().toString().equals("VMAF")) {
            VMAFScore = "";
            String[] stringArray = getAll.toString().split(System.lineSeparator());
            int n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String vmafLine = stringArray[n3];
                if (vmafLine.contains("VMAF score")) {
                    String[] s = vmafLine.split("\\]");
                    VMAFScore = s[1].substring(1);
                }
                ++n3;
            }
        }
    }

    public static int getTimeToSeconds(String time) {
        String[] t = time.split(":");
        int heures = Integer.parseInt(t[0]);
        int minutes = Integer.parseInt(t[1]);
        int secondes = Integer.parseInt(t[2]);
        int images = Integer.parseInt(t[3]);
        images /= 40;
        int totalSecondes = heures * 3600 + minutes * 60 + secondes;
        return totalSecondes;
    }
}

