/*
 * Decompiled with CFR 0.152.
 */
package functions;

import application.Ftp;
import application.Settings;
import application.Shutter;
import application.Utils;
import application.VideoPlayer;
import application.Wetransfer;
import java.io.File;
import javax.swing.JOptionPane;
import library.FFMPEG;
import library.FFPROBE;
import settings.FunctionUtils;
import settings.InputAndOutput;
import settings.Transitions;

public class AudioEncoders
extends Shutter {
    public static void main() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!scanIsRunning) {
                    FunctionUtils.completed = 0;
                }
                lblFilesEnded.setText(FunctionUtils.completedFiles(FunctionUtils.completed));
                int i = 0;
                while (i < liste.getSize()) {
                    block62: {
                        File file = FunctionUtils.setInputFile(new File((String)liste.getElementAt(i)));
                        if (file == null) break;
                        try {
                            String fileOutputName;
                            File fileOut;
                            String fileName = file.getName();
                            String extension = fileName.substring(fileName.lastIndexOf("."));
                            lblCurrentEncoding.setText(fileName);
                            if (!FunctionUtils.analyze(file, false)) break block62;
                            InputAndOutput.getInputAndOutput();
                            String labelOutput = FunctionUtils.setOutputDestination("", file);
                            String extensionName = "";
                            if (Settings.btnExtension.isSelected()) {
                                extensionName = Settings.txtExtension.getText();
                            } else if (caseMixAudio.isSelected()) {
                                extensionName = String.valueOf(extensionName) + "_MIX";
                            }
                            String DRC = "";
                            if (FFPROBE.audioCodec != null && FFPROBE.audioCodec.equals("ac3") && !caseDRC.isSelected()) {
                                DRC = " -drc_scale 0";
                            }
                            String audioCodec = "";
                            String container = "";
                            boolean stereoOutput = false;
                            switch (comboFonctions.getSelectedItem().toString()) {
                                case "AAC": {
                                    audioCodec = "aac -b:a " + comboFilter.getSelectedItem().toString() + "k";
                                    container = ".m4a";
                                    stereoOutput = false;
                                    break;
                                }
                                case "AC3": {
                                    audioCodec = "ac3 -b:a " + comboFilter.getSelectedItem().toString() + "k";
                                    container = ".ac3";
                                    stereoOutput = true;
                                    break;
                                }
                                case "AIFF": {
                                    audioCodec = comboFilter.getSelectedItem().toString().contains("Float") ? "pcm_f" + comboFilter.getSelectedItem().toString().replace(" Float", "") + "be" : "pcm_s" + comboFilter.getSelectedItem().toString().replace(" Bits", "") + "be";
                                    stereoOutput = true;
                                    container = ".aif";
                                    break;
                                }
                                case "FLAC": {
                                    audioCodec = "flac -compression_level " + comboFilter.getSelectedItem().toString();
                                    container = ".flac";
                                    stereoOutput = true;
                                    break;
                                }
                                case "ALAC": {
                                    audioCodec = "alac -sample_fmt s" + comboFilter.getSelectedItem().toString().replace(" Bits", "").replace("24", "32") + "p";
                                    container = ".m4a";
                                    stereoOutput = true;
                                    break;
                                }
                                case "OGG": {
                                    audioCodec = "libvorbis -b:a " + comboFilter.getSelectedItem().toString() + "k";
                                    container = ".ogg";
                                    stereoOutput = true;
                                    break;
                                }
                                case "Dolby Digital Plus": {
                                    audioCodec = "eac3 -b:a " + comboFilter.getSelectedItem().toString() + "k";
                                    container = ".eac3";
                                    stereoOutput = true;
                                    break;
                                }
                                case "Dolby TrueHD": {
                                    audioCodec = "truehd -strict -2";
                                    container = ".thd";
                                    stereoOutput = true;
                                    break;
                                }
                                case "OPUS": {
                                    audioCodec = "libopus -b:a " + comboFilter.getSelectedItem().toString() + "k";
                                    container = ".opus";
                                    stereoOutput = false;
                                    break;
                                }
                                case "MP3": {
                                    audioCodec = "libmp3lame -b:a " + comboFilter.getSelectedItem().toString() + "k";
                                    container = ".mp3";
                                    stereoOutput = true;
                                    break;
                                }
                                case "WAV": {
                                    audioCodec = comboFilter.getSelectedItem().toString().contains("Float") ? "pcm_f" + comboFilter.getSelectedItem().toString().replace(" Float", "") + "le" + " -write_bext 1" : "pcm_s" + comboFilter.getSelectedItem().toString().replace(" Bits", "") + "le" + " -write_bext 1";
                                    container = ".wav";
                                    stereoOutput = true;
                                }
                            }
                            if (VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("splitMode"))) {
                                container = "_%03d" + container;
                            }
                            if (!(fileOut = new File(fileOutputName = String.valueOf(labelOutput.replace("\\", "/")) + "/" + fileName.replace(extension, String.valueOf(extensionName) + container))).exists() || (fileOut = FunctionUtils.fileReplacement(labelOutput, fileName, extension, String.valueOf(extensionName) + "_", container)) != null) {
                                String cmd;
                                String concat = FunctionUtils.setConcat(file, labelOutput);
                                if (Settings.btnSetBab.isSelected() || VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("removeMode")) && caseInAndOut.isSelected()) {
                                    file = new File(String.valueOf(labelOutput.replace("\\", "/")) + "/" + fileName.replace(extension, ".txt"));
                                }
                                String audio = AudioEncoders.setAudio(audioCodec, stereoOutput);
                                if (caseSplitAudio.isSelected()) {
                                    if (FFPROBE.surround) {
                                        if (lblSplit.getText().equals(language.getProperty("mono"))) {
                                            cmd = " -filter_complex \"channelsplit=channel_layout=5.1[FL][FR][FC][LFE][BL][BR]\" -vn -y ";
                                            FFMPEG.run(String.valueOf(InputAndOutput.inPoint) + DRC + " -i " + '\"' + file.toString() + '\"' + InputAndOutput.outPoint + cmd + " -map " + '\"' + "[FL]" + '\"' + " " + '\"' + fileOut.toString().replace(container, "_FL" + container) + '\"' + " -map " + '\"' + "[FR]" + '\"' + " " + '\"' + fileOut.toString().replace(container, "_FR" + container) + '\"' + " -map " + '\"' + "[FC]" + '\"' + " " + '\"' + fileOut.toString().replace(container, "_FC" + container) + '\"' + " -map " + '\"' + "[LFE]" + '\"' + " " + '\"' + fileOut.toString().replace(container, "_LFE" + container) + '\"' + " -map " + '\"' + "[BL]" + '\"' + " " + '\"' + fileOut.toString().replace(container, "_BL" + container) + '\"' + " -map " + '\"' + "[BR]" + '\"' + " " + '\"' + fileOut.toString().replace(container, "_BR" + container) + '\"');
                                        } else if (lblSplit.getText().equals(language.getProperty("stereo"))) {
                                            cmd = " -af \"pan=stereo|c0=FL|c1=FR\" -vn -y ";
                                            FFMPEG.run(String.valueOf(InputAndOutput.inPoint) + DRC + " -i " + '\"' + file.toString() + '\"' + InputAndOutput.outPoint + cmd + '\"' + fileOut + '\"');
                                        }
                                    } else {
                                        AudioEncoders.splitAudio(audioCodec, fileName, extension, file, labelOutput, container, DRC);
                                    }
                                } else if (caseMixAudio.isSelected() && lblMix.getText().equals("2.1")) {
                                    cmd = " " + audio + "-vn -y ";
                                    FFMPEG.run(String.valueOf(InputAndOutput.inPoint) + concat + DRC + " -i " + '\"' + (String)liste.getElementAt(0) + '\"' + InputAndOutput.outPoint + DRC + " -i " + '\"' + (String)liste.getElementAt(1) + '\"' + InputAndOutput.outPoint + DRC + " -i " + '\"' + (String)liste.getElementAt(2) + '\"' + InputAndOutput.outPoint + cmd + '\"' + fileOut + '\"');
                                } else if (caseMixAudio.isSelected() && lblMix.getText().equals("5.1")) {
                                    cmd = " " + audio + "-vn -y ";
                                    FFMPEG.run(String.valueOf(InputAndOutput.inPoint) + concat + DRC + " -i " + '\"' + (String)liste.getElementAt(0) + '\"' + InputAndOutput.outPoint + DRC + " -i " + '\"' + (String)liste.getElementAt(1) + '\"' + InputAndOutput.outPoint + DRC + " -i " + '\"' + (String)liste.getElementAt(2) + '\"' + InputAndOutput.outPoint + DRC + " -i " + '\"' + (String)liste.getElementAt(3) + '\"' + InputAndOutput.outPoint + DRC + " -i " + '\"' + (String)liste.getElementAt(4) + '\"' + InputAndOutput.outPoint + DRC + " -i " + '\"' + (String)liste.getElementAt(5) + '\"' + InputAndOutput.outPoint + cmd + '\"' + fileOut + '\"');
                                } else {
                                    cmd = " " + audio + "-vn -y ";
                                    FFMPEG.run(String.valueOf(InputAndOutput.inPoint) + concat + DRC + " -i " + '\"' + file.toString() + '\"' + InputAndOutput.outPoint + cmd + '\"' + fileOut + '\"');
                                }
                                do {
                                    Thread.sleep(100L);
                                } while (FFMPEG.runProcess.isAlive());
                                if ((!FFMPEG.saveCode && !btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && !caseSplitAudio.isSelected() || !FFMPEG.saveCode && Settings.btnSetBab.isSelected() || !FFMPEG.saveCode && VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("removeMode")) && caseInAndOut.isSelected()) && AudioEncoders.lastActions(file, fileName, fileOut, labelOutput)) {
                                    break;
                                }
                            }
                        }
                        catch (InterruptedException e) {
                            FFMPEG.error = true;
                        }
                    }
                    ++i;
                }
                if (!btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender"))) {
                    AudioEncoders.enfOfFunction();
                }
            }
        });
        thread.start();
    }

    private static String setAudio(String codec, boolean stereoOutput) {
        String audio = "";
        String audioFilter = "";
        if (Transitions.setAudioFadeIn(false) != "") {
            audioFilter = String.valueOf(audioFilter) + "," + Transitions.setAudioFadeIn(false);
        }
        if (Transitions.setAudioFadeOut(false) != "") {
            audioFilter = String.valueOf(audioFilter) + "," + Transitions.setAudioFadeOut(false);
        }
        if (Transitions.setAudioSpeed() != "") {
            audioFilter = String.valueOf(audioFilter) + "," + Transitions.setAudioSpeed();
        }
        if (caseMixAudio.isSelected() && lblMix.getText().equals(language.getProperty("stereo")) && FFPROBE.surround) {
            audio = String.valueOf(audio) + "-af \"pan=stereo|FL=FC+0.30*FL+0.30*BL|FR=FC+0.30*FR+0.30*BR\" ";
        } else if (caseMixAudio.isSelected() && lblMix.getText().equals(language.getProperty("stereo"))) {
            int n = 1;
            while (n < liste.size()) {
                audio = String.valueOf(audio) + "-i \"" + (String)liste.elementAt(n) + '\"' + " ";
                ++n;
            }
            if (FFPROBE.stereo) {
                audio = String.valueOf(audio) + "-filter_complex amerge=inputs=" + liste.size() + audioFilter + " -ac 2 ";
            } else {
                audio = String.valueOf(audio) + "-filter_complex \"";
                String left = "";
                int cl = 0;
                String right = "";
                int cr = 0;
                int n2 = 0;
                while (n2 < liste.size()) {
                    if (n2 % 2 == 0) {
                        left = String.valueOf(left) + "[" + n2 + ":0]";
                        ++cl;
                    } else {
                        right = String.valueOf(right) + "[" + n2 + ":0]";
                        ++cr;
                    }
                    ++n2;
                }
                audio = String.valueOf(audio) + left + "amerge=inputs=" + cl + ",channelmap=map=FL[left];" + right + "amerge=inputs=" + cr + ",channelmap=map=FR[right];";
                audio = String.valueOf(audio) + "[left][right]amerge=inputs=2" + audioFilter + "[out]" + '\"' + " -map " + '\"' + "[out]" + '\"' + " -ac 2 ";
            }
        } else if (caseMixAudio.isSelected() && lblMix.getText().equals("2.1")) {
            audio = "-filter_complex \"[0:a][1:a][2:a]join=inputs=3:channel_layout=2.1" + audioFilter + "[a]" + '\"' + " -map " + '\"' + "[a]" + '\"' + " ";
        } else if (caseMixAudio.isSelected() && lblMix.getText().equals("5.1")) {
            audio = "-filter_complex \"[0:a][1:a][2:a][3:a][4:a][5:a]join=inputs=6:channel_layout=5.1" + audioFilter + "[a]" + '\"' + " -map " + '\"' + "[a]" + '\"' + " ";
        } else if (caseMixAudio.isSelected() && lblMix.getText().equals(language.getProperty("mono"))) {
            int n = 1;
            while (n < liste.size()) {
                audio = String.valueOf(audio) + "-i \"" + (String)liste.elementAt(n) + '\"' + " ";
                ++n;
            }
            audio = String.valueOf(audio) + "-filter_complex amerge=inputs=" + liste.size() + audioFilter + " -ac 1 ";
        } else if (FFPROBE.stereo) {
            audio = "-map a:0 ";
            if (audioFilter != "") {
                audio = String.valueOf(audio) + audioFilter.replaceFirst(",", " -filter_complex ") + " ";
            }
        } else if (FFPROBE.channels > 1) {
            audio = stereoOutput ? "-filter_complex \"[0:a:0][0:a:1]amerge=inputs=2" + audioFilter + "[a]" + '\"' + " -map " + '\"' + "[a]" + '\"' + " " : String.valueOf(audioFilter.replaceFirst(",", " -filter_complex ")) + " -map a? ";
        } else if (audioFilter != "") {
            audio = String.valueOf(audio) + audioFilter.replaceFirst(",", " -filter_complex ") + " ";
        }
        audio = String.valueOf(audio) + "-c:a " + codec + " ";
        if (caseSampleRate.isSelected()) {
            audio = String.valueOf(audio) + "-ar " + lbl48k.getText() + " ";
        }
        return audio;
    }

    private static void splitAudio(String codec, String fileName, String extension, File file, String output, String container, String DRC) throws InterruptedException {
        String audioFilter = "";
        if (Transitions.setAudioFadeIn(false) != "") {
            audioFilter = String.valueOf(audioFilter) + "," + Transitions.setAudioFadeIn(false);
        }
        if (Transitions.setAudioFadeOut(false) != "") {
            audioFilter = String.valueOf(audioFilter) + "," + Transitions.setAudioFadeOut(false);
        }
        if (Transitions.setAudioSpeed() != "") {
            audioFilter = String.valueOf(audioFilter) + "," + Transitions.setAudioSpeed();
        }
        if (FFPROBE.channels == 1 && lblSplit.getText().equals(language.getProperty("mono"))) {
            int i = 1;
            while (i < 3) {
                String yesno = " -y ";
                File fileOut = new File(String.valueOf(output) + "/" + fileName.replace(extension, "_Audio_" + i + container));
                if (fileOut.exists() && (fileOut = FunctionUtils.fileReplacement(output, fileName, extension, "_Audio_" + i + "_", container)) == null) {
                    yesno = " -n ";
                }
                String cmd = " -filter_complex \"[a:0]pan=1c|c0=c" + (i - 1) + audioFilter + "[a" + (i - 1) + "]" + '\"' + " -map " + '\"' + "[a" + (i - 1) + "]" + '\"' + " -c:a " + codec + " -vn" + yesno;
                FFMPEG.run(String.valueOf(InputAndOutput.inPoint) + DRC + " -i " + '\"' + file.toString() + '\"' + InputAndOutput.outPoint + cmd + '\"' + fileOut + '\"');
                do {
                    Thread.sleep(100L);
                } while (FFMPEG.runProcess.isAlive());
                if (FFMPEG.saveCode || btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) || !AudioEncoders.lastActions(file, fileName, fileOut, output)) {
                    ++i;
                    continue;
                }
                break;
            }
        } else if (FFPROBE.channels == 1 && lblSplit.getText().equals(Shutter.language.getProperty("stereo"))) {
            JOptionPane.showMessageDialog(Shutter.frame, String.valueOf(Shutter.language.getProperty("theFile")) + " " + fileName + " " + Shutter.language.getProperty("isAlreadyStereo"), Shutter.language.getProperty("cantSplitAudio"), 0);
        } else if (FFPROBE.channels > 1 && lblSplit.getText().equals(language.getProperty("mono"))) {
            int i = 1;
            while (i < FFPROBE.channels + 1) {
                String yesno = " -y ";
                File fileOut = new File(String.valueOf(output) + "/" + fileName.replace(extension, "_Audio_" + i + container));
                if (fileOut.exists() && (fileOut = FunctionUtils.fileReplacement(output, fileName, extension, "_Audio_" + i + "_", container)) == null) {
                    yesno = " -n ";
                }
                if (audioFilter != "") {
                    audioFilter = audioFilter.replaceFirst(",", " -filter_complex ");
                }
                String cmd = String.valueOf(audioFilter) + " -map a:" + (i - 1) + " -c:a " + codec + " -vn" + yesno;
                FFMPEG.run(String.valueOf(InputAndOutput.inPoint) + DRC + " -i " + '\"' + file.toString() + '\"' + InputAndOutput.outPoint + cmd + '\"' + fileOut + '\"');
                do {
                    Thread.sleep(100L);
                } while (FFMPEG.runProcess.isAlive());
                if (FFMPEG.saveCode || btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) || !AudioEncoders.lastActions(file, fileName, fileOut, output)) {
                    ++i;
                    continue;
                }
                break;
            }
        } else if (FFPROBE.channels > 1 && lblSplit.getText().equals(Shutter.language.getProperty("stereo"))) {
            int number = 1;
            int i = 1;
            while (i < FFPROBE.channels + 1) {
                String yesno = " -y ";
                File fileOut = new File(String.valueOf(output) + "/" + fileName.replace(extension, "_Audio_" + number + container));
                if (fileOut.exists() && (fileOut = FunctionUtils.fileReplacement(output, fileName, extension, "_Audio_" + number + "_", container)) == null) {
                    yesno = " -n ";
                }
                String cmd = " -filter_complex \"[0:a:" + (i - 1) + "][0:a:" + i + "]amerge=inputs=2" + audioFilter + "[a]" + '\"' + " -map " + '\"' + "[a]" + '\"' + " -c:a " + codec + " -vn" + yesno;
                FFMPEG.run(String.valueOf(InputAndOutput.inPoint) + DRC + " -i " + '\"' + file.toString() + '\"' + InputAndOutput.outPoint + cmd + '\"' + fileOut + '\"');
                do {
                    Thread.sleep(100L);
                } while (FFMPEG.runProcess.isAlive());
                if (FFMPEG.saveCode || btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) || !AudioEncoders.lastActions(file, fileName, fileOut, output)) {
                    ++number;
                    i += 2;
                    continue;
                }
                break;
            }
        } else {
            FFMPEG.errorList.append(fileName);
            FFMPEG.errorList.append(System.lineSeparator());
        }
    }

    private static boolean lastActions(File file, String fileName, File fileOut, String output) {
        if (FunctionUtils.cleanFunction(fileName, fileOut, output)) {
            return true;
        }
        FunctionUtils.addFileForMail(fileName);
        Wetransfer.addFile(fileOut);
        Ftp.sendToFtp(fileOut);
        Utils.copyFile(fileOut);
        if (Settings.btnSetBab.isSelected()) {
            return true;
        }
        if (caseMixAudio.isSelected() && !FFPROBE.surround) {
            return true;
        }
        if (Shutter.scanIsRunning) {
            FunctionUtils.moveScannedFiles(file);
            AudioEncoders.main();
            return true;
        }
        return false;
    }
}

