/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.BoardTableCellRenderer;
import application.Ftp;
import application.Settings;
import application.Shutter;
import application.Utils;
import application.VideoPlayer;
import application.Wetransfer;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import library.BMXTRANSWRAP;
import library.DCRAW;
import library.DVDAUTHOR;
import library.FFMPEG;
import library.MKVMERGE;
import library.TSMUXER;
import library.XPDF;
import settings.FunctionUtils;

public class RenderQueue {
    public static JFrame frame;
    private static int taskBarHeight;
    private static JPanel topPanel;
    private static JLabel title;
    ImageIcon header = new ImageIcon(this.getClass().getClassLoader().getResource("contents/header.png"));
    private JLabel quit;
    private JLabel fullscreen;
    private JLabel reduce;
    private JLabel topImage;
    private JLabel bottomImage;
    public static JButton btnStartRender;
    public static JTable table;
    public static DefaultTableModel tableRow;
    public static JScrollPane scrollPane;
    private static int complete;
    private boolean drag = false;
    private static int MousePositionX;
    private static int MousePositionY;

    static {
        title = new JLabel(Shutter.language.getProperty("frameFileDeRendus"));
    }

    public RenderQueue() {
        frame = new JFrame();
        frame.getContentPane().setBackground(new Color(45, 45, 45));
        frame.setDefaultCloseOperation(2);
        frame.setTitle(Shutter.language.getProperty("frameFileDeRendus"));
        frame.setForeground(Color.WHITE);
        frame.getContentPane().setLayout(null);
        frame.setSize(600, 332);
        frame.setResizable(true);
        if (!frame.isUndecorated()) {
            frame.setUndecorated(true);
            Area shape1 = new Area(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
            Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
            shape1.add(shape2);
            frame.setShape(shape1);
            frame.getRootPane().setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, new Color(100, 100, 100)));
            frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
            frame.setLocation(Shutter.frame.getLocation().x - RenderQueue.frame.getSize().width - 20, Shutter.frame.getLocation().y + (int)(Shutter.frame.getSize().getHeight() / 4.0));
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle winSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            taskBarHeight = (int)(dim.getHeight() - (double)winSize.height);
        }
        this.topPanel();
        this.table();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeiconified(WindowEvent we) {
                frame.toFront();
            }

            @Override
            public void windowClosed(WindowEvent arg0) {
                if (FFMPEG.isRunning || DCRAW.isRunning || XPDF.isRunning || MKVMERGE.isRunning || DVDAUTHOR.isRunning || TSMUXER.isRunning || BMXTRANSWRAP.isRunning) {
                    Shutter.btnCancel.doClick();
                }
                if (!Shutter.btnCancel.isEnabled()) {
                    if (!(Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionMerge")) || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionInsert")) || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) || Shutter.comboFonctions.getSelectedItem().equals("DVD Rip") || Shutter.comboFonctions.getSelectedItem().equals("Loudness & True Peak") || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionVideoLevels")) || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionNormalization")) || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSceneDetection")) || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionBlackDetection")) || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionOfflineDetection")) || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionWeb")) || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("itemMyFunctions")))) {
                        Shutter.iconList.setVisible(true);
                        if (Shutter.iconPresets.isVisible()) {
                            Shutter.iconPresets.setLocation(Shutter.iconList.getX() + Shutter.iconList.getWidth() + 2, 45);
                            Shutter.btnCancel.setBounds(207 + Shutter.iconList.getWidth(), 46, 101 - Shutter.iconList.getWidth() - 4, 21);
                        } else {
                            Shutter.iconPresets.setBounds(180, 45, 21, 21);
                            Shutter.btnCancel.setBounds(207, 46, 97, 21);
                        }
                    } else {
                        Shutter.iconList.setVisible(false);
                        if (Shutter.iconPresets.isVisible()) {
                            Shutter.iconPresets.setBounds(180, 45, 21, 21);
                            Shutter.btnCancel.setBounds(207, 46, 97, 21);
                        } else {
                            Shutter.btnCancel.setBounds(184, 46, 120, 21);
                        }
                    }
                    Utils.changeFrameVisibility(frame, true);
                    Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                }
            }
        });
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                Area shape1 = new Area(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
                Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
                shape1.add(shape2);
                frame.setShape(shape1);
            }
        });
        frame.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent arg0) {
                if (!RenderQueue.this.drag) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        frame.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (frame.getCursor() == Cursor.getPredefinedCursor(5) || frame.getCursor() == Cursor.getPredefinedCursor(11) || frame.getCursor() == Cursor.getPredefinedCursor(9)) {
                    RenderQueue.this.drag = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                RenderQueue.this.drag = false;
            }
        });
        frame.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (RenderQueue.this.drag) {
                    if (frame.getCursor() == Cursor.getPredefinedCursor(5)) {
                        frame.setSize(e.getX(), e.getY());
                    } else if (frame.getCursor() == Cursor.getPredefinedCursor(11)) {
                        frame.setSize(e.getX(), frame.getHeight());
                    } else if (frame.getCursor() == Cursor.getPredefinedCursor(9)) {
                        frame.setSize(frame.getWidth(), e.getY());
                    }
                    if (frame.getWidth() < 400) {
                        frame.setSize(400, frame.getHeight());
                    }
                    if (frame.getHeight() < 90) {
                        frame.setSize(frame.getWidth(), 90);
                    }
                    RenderQueue.this.resizeAll();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (e.getX() >= frame.getWidth() - 10 && e.getY() >= frame.getHeight() - 10) {
                    frame.setCursor(Cursor.getPredefinedCursor(5));
                } else if (e.getX() >= frame.getWidth() - 10) {
                    frame.setCursor(Cursor.getPredefinedCursor(11));
                } else if (e.getY() >= frame.getHeight() - 10) {
                    frame.setCursor(Cursor.getPredefinedCursor(9));
                } else if (!RenderQueue.this.drag) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        Utils.changeFrameVisibility(frame, false);
    }

    private void topPanel() {
        topPanel = new JPanel();
        topPanel.setLayout(null);
        topPanel.setBounds(0, 0, RenderQueue.frame.getSize().width, 28);
        this.quit = new JLabel(new FlatSVGIcon("contents/quit.svg", 15, 15));
        this.quit.setBounds(RenderQueue.frame.getSize().width - 20, 4, 15, 15);
        this.fullscreen = new JLabel(new FlatSVGIcon("contents/max.svg", 15, 15));
        this.fullscreen.setHorizontalAlignment(0);
        this.fullscreen.setBounds(this.quit.getLocation().x - 20, 4, 15, 15);
        this.fullscreen.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                RenderQueue.this.fullscreen.setIcon(new FlatSVGIcon("contents/max_pressed.svg", 15, 15));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    GraphicsConfiguration config = frame.getGraphicsConfiguration();
                    GraphicsDevice myScreen = config.getDevice();
                    GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    GraphicsDevice[] allScreens = env.getScreenDevices();
                    int screenIndex = -1;
                    int i = 0;
                    while (i < allScreens.length) {
                        if (allScreens[i].equals(myScreen)) {
                            screenIndex = i;
                            break;
                        }
                        ++i;
                    }
                    int screenHeight = allScreens[screenIndex].getDisplayMode().getHeight();
                    int screenWidth = allScreens[screenIndex].getDisplayMode().getWidth();
                    if (this.accept && frame.getHeight() < screenHeight - taskBarHeight) {
                        frame.setSize(screenWidth, screenHeight - taskBarHeight);
                        if (System.getProperty("os.name").contains("Windows")) {
                            frame.setLocation(allScreens[screenIndex].getDefaultConfiguration().getBounds().x + allScreens[screenIndex].getDefaultConfiguration().getBounds().width - RenderQueue.frame.getSize().width, allScreens[screenIndex].getDefaultConfiguration().getBounds().y);
                        } else {
                            frame.setLocation(allScreens[screenIndex].getDefaultConfiguration().getBounds().x + allScreens[screenIndex].getDisplayMode().getWidth() - RenderQueue.frame.getSize().width, allScreens[screenIndex].getDefaultConfiguration().getBounds().y);
                        }
                    } else if (this.accept) {
                        frame.setSize(600, 332);
                        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                        frame.setLocation(dim.width / 2 - RenderQueue.frame.getSize().width / 2, dim.height / 2 - RenderQueue.frame.getSize().height / 2);
                    }
                    RenderQueue.this.resizeAll();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                RenderQueue.this.fullscreen.setIcon(new FlatSVGIcon("contents/max_hover.svg", 15, 15));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RenderQueue.this.fullscreen.setIcon(new FlatSVGIcon("contents/max.svg", 15, 15));
                this.accept = false;
            }
        });
        ImageIcon image = new ImageIcon(this.getClass().getClassLoader().getResource("contents/header.png"));
        Image scaledImage = image.getImage().getScaledInstance(RenderQueue.topPanel.getSize().width * 10, RenderQueue.topPanel.getSize().height, 4);
        ImageIcon header = new ImageIcon(scaledImage);
        this.bottomImage = new JLabel(header);
        this.bottomImage.setBounds(0, 0, RenderQueue.frame.getSize().width * 10, 28);
        title.setHorizontalAlignment(0);
        title.setBounds(0, 0, frame.getWidth(), 28);
        title.setFont(new Font(Shutter.magnetoFont, 0, 17));
        topPanel.add(title);
        this.topImage = new JLabel();
        ImageIcon imageIcon = new ImageIcon(header.getImage().getScaledInstance(RenderQueue.topPanel.getSize().width, RenderQueue.topPanel.getSize().height, 1));
        this.topImage.setIcon(imageIcon);
        this.topImage.setBounds(title.getBounds());
        this.reduce = new JLabel(new FlatSVGIcon("contents/reduce.svg", 15, 15));
        this.reduce.setHorizontalAlignment(0);
        this.reduce.setBounds(this.fullscreen.getLocation().x - 20, 4, 15, 15);
        this.reduce.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                RenderQueue.this.reduce.setIcon(new FlatSVGIcon("contents/reduce_pressed.svg", 15, 15));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    frame.setState(1);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                RenderQueue.this.reduce.setIcon(new FlatSVGIcon("contents/reduce_hover.svg", 15, 15));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RenderQueue.this.reduce.setIcon(new FlatSVGIcon("contents/reduce.svg", 15, 15));
                this.accept = false;
            }
        });
        topPanel.add(this.quit);
        topPanel.add(this.fullscreen);
        topPanel.add(this.reduce);
        topPanel.add(this.topImage);
        topPanel.add(this.bottomImage);
        this.quit.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                RenderQueue.this.quit.setIcon(new FlatSVGIcon("contents/quit_pressed.svg", 15, 15));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    if (FFMPEG.isRunning || DCRAW.isRunning || XPDF.isRunning || MKVMERGE.isRunning || DVDAUTHOR.isRunning || TSMUXER.isRunning || BMXTRANSWRAP.isRunning) {
                        Shutter.btnCancel.doClick();
                    }
                    if (!Shutter.btnCancel.isEnabled()) {
                        if (!(Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionMerge")) || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionInsert")) || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) || Shutter.comboFonctions.getSelectedItem().equals("DVD Rip") || Shutter.comboFonctions.getSelectedItem().equals("Loudness & True Peak") || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionVideoLevels")) || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionNormalization")) || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSceneDetection")) || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionBlackDetection")) || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionOfflineDetection")) || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionWeb")) || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("itemMyFunctions")))) {
                            Shutter.iconList.setVisible(true);
                            if (Shutter.iconPresets.isVisible()) {
                                Shutter.iconPresets.setLocation(Shutter.iconList.getX() + Shutter.iconList.getWidth() + 2, 45);
                                Shutter.btnCancel.setBounds(207 + Shutter.iconList.getWidth(), 46, 101 - Shutter.iconList.getWidth() - 4, 21);
                            } else {
                                Shutter.iconPresets.setBounds(180, 45, 21, 21);
                                Shutter.btnCancel.setBounds(207, 46, 97, 21);
                            }
                        } else {
                            Shutter.iconList.setVisible(false);
                            if (Shutter.iconPresets.isVisible()) {
                                Shutter.iconPresets.setBounds(180, 45, 21, 21);
                                Shutter.btnCancel.setBounds(207, 46, 97, 21);
                            } else {
                                Shutter.btnCancel.setBounds(184, 46, 120, 21);
                            }
                        }
                        Utils.changeFrameVisibility(frame, true);
                        Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                RenderQueue.this.quit.setIcon(new FlatSVGIcon("contents/quit_hover.svg", 15, 15));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RenderQueue.this.quit.setIcon(new FlatSVGIcon("contents/quit.svg", 15, 15));
                this.accept = false;
            }
        });
        topPanel.setBounds(0, 0, RenderQueue.frame.getSize().width, 28);
        frame.getContentPane().add(topPanel);
        this.bottomImage.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent down) {
                if (down.getClickCount() == 2 && down.getButton() == 1) {
                    GraphicsConfiguration config = frame.getGraphicsConfiguration();
                    GraphicsDevice myScreen = config.getDevice();
                    GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    GraphicsDevice[] allScreens = env.getScreenDevices();
                    int screenIndex = -1;
                    int i = 0;
                    while (i < allScreens.length) {
                        if (allScreens[i].equals(myScreen)) {
                            screenIndex = i;
                            break;
                        }
                        ++i;
                    }
                    int screenHeight = allScreens[screenIndex].getDisplayMode().getHeight();
                    int screenWidth = allScreens[screenIndex].getDisplayMode().getWidth();
                    if (frame.getHeight() < screenHeight - taskBarHeight) {
                        frame.setSize(screenWidth, screenHeight - taskBarHeight);
                        if (System.getProperty("os.name").contains("Windows")) {
                            frame.setLocation(allScreens[screenIndex].getDefaultConfiguration().getBounds().x + allScreens[screenIndex].getDefaultConfiguration().getBounds().width - RenderQueue.frame.getSize().width, allScreens[screenIndex].getDefaultConfiguration().getBounds().y);
                        } else {
                            frame.setLocation(allScreens[screenIndex].getDefaultConfiguration().getBounds().x + allScreens[screenIndex].getDisplayMode().getWidth() - RenderQueue.frame.getSize().width, allScreens[screenIndex].getDefaultConfiguration().getBounds().y);
                        }
                    } else {
                        frame.setSize(600, 332);
                        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                        frame.setLocation(dim.width / 2 - RenderQueue.frame.getSize().width / 2, dim.height / 2 - RenderQueue.frame.getSize().height / 2);
                    }
                    RenderQueue.this.resizeAll();
                }
            }

            @Override
            public void mousePressed(MouseEvent down) {
                MousePositionX = down.getPoint().x;
                MousePositionY = down.getPoint().y;
                frame.toFront();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.bottomImage.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                frame.setLocation(MouseInfo.getPointerInfo().getLocation().x - MousePositionX, MouseInfo.getPointerInfo().getLocation().y - MousePositionY);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    private void table() {
        JLabel columnFile = new JLabel(Shutter.language.getProperty("columnFile"));
        columnFile.setFont(new Font("SansSerif", 0, 11));
        tableRow = new DefaultTableModel(new Object[0][], new String[]{Shutter.language.getProperty("columnFile"), Shutter.language.getProperty("columnCommand"), Shutter.language.getProperty("destination")});
        DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();
        dtcr.setHorizontalAlignment(0);
        table = new JTable(tableRow){

            public Class getColumnClass(int column) {
                return this.getValueAt(0, column).getClass();
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return true;
            }
        };
        table.setForeground(Color.BLACK);
        table.setDefaultRenderer(String.class, new BoardTableCellRenderer());
        table.setShowVerticalLines(false);
        table.setSelectionMode(2);
        table.setRowHeight(17);
        table.setOpaque(true);
        table.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if ((e.getKeyCode() == 127 || e.getKeyCode() == 8) && table.getSelectedRowCount() > 0) {
                    do {
                        tableRow.removeRow(table.getSelectedRow());
                    } while (table.getSelectedRows().length > 0);
                }
                if (table.getRowCount() == 0) {
                    btnStartRender.setEnabled(false);
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                Shutter.lblCurrentEncoding.setText(Shutter.language.getProperty("lblEncodageEnCours"));
                if (!Shutter.caseChangeFolder1.isSelected()) {
                    Shutter.lblDestination1.setText(Shutter.language.getProperty("sameAsSource"));
                }
            }
        });
        scrollPane = new JScrollPane();
        scrollPane.getViewport().add(table);
        scrollPane.setBackground(new Color(185, 185, 185));
        scrollPane.setOpaque(true);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.getVerticalScrollBar().setValue(scrollPane.getVerticalScrollBar().getMaximum());
        frame.getContentPane().add(scrollPane);
        btnStartRender = new JButton(Shutter.language.getProperty("btnStartRender"));
        btnStartRender.setFont(new Font(Shutter.montserratFont, 0, 12));
        btnStartRender.setEnabled(false);
        frame.getContentPane().add(btnStartRender);
        btnStartRender.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FFMPEG.tempsEcoule.setVisible(false);
                FFMPEG.elapsedTime = 0L;
                FFMPEG.previousElapsedTime = 0;
                btnStartRender.setEnabled(false);
                complete = 0;
                Thread render = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int i = 0;
                        while (i < tableRow.getRowCount()) {
                            String[] cli = tableRow.getValueAt(i, 1).toString().split(" ");
                            String cmd = tableRow.getValueAt(i, 1).toString();
                            String fichier = tableRow.getValueAt(i, 0).toString();
                            String c = cmd.substring(0, cmd.length() - 1);
                            File fileOut = new File(c.substring(c.lastIndexOf("\"") + 1));
                            if (fileOut.toString().contains("pipe")) {
                                String[] s = fileOut.toString().split("\\|");
                                fileOut = new File(s[0]);
                            }
                            if (cmd.contains("pipe:play")) {
                                Shutter.caseDisplay.setSelected(true);
                            } else {
                                Shutter.caseDisplay.setSelected(false);
                            }
                            switch (cli[0].toString()) {
                                case "ffmpeg": {
                                    FFMPEG.run(cmd.toString().replace("ffmpeg", ""));
                                    break;
                                }
                                case "bmxtranswrap": {
                                    BMXTRANSWRAP.run(cmd.toString().replace("bmxtranswrap", ""));
                                    break;
                                }
                                case "dvdauthor": {
                                    DVDAUTHOR.run(cmd.toString().replace("dvdauthor", ""));
                                    break;
                                }
                                case "tsMuxeR": {
                                    TSMUXER.run(cmd.toString().replace("tsMuxeR", ""));
                                    break;
                                }
                                case "dcraw": {
                                    DCRAW.run(cmd.toString().replace("dcraw", ""));
                                    break;
                                }
                                case "pdftoppm": {
                                    XPDF.run(cmd.toString().replace("pdftoppm", ""));
                                    break;
                                }
                                case "mkvmerge": {
                                    if (cmd.contains("--chromaticity-coordinates")) {
                                        File HDRmkv = fileOut;
                                        File tempHDR = new File(fileOut.toString().replace(fileOut.toString().substring(fileOut.toString().lastIndexOf(".")), "_HDR" + fileOut.toString().substring(fileOut.toString().lastIndexOf("."))));
                                        fileOut.renameTo(tempHDR);
                                        fileOut = HDRmkv;
                                    }
                                    MKVMERGE.run(cmd.toString().replace("mkvmerge", ""));
                                }
                            }
                            table.setRowSelectionInterval(i, i);
                            Shutter.disableAll();
                            Shutter.lblCurrentEncoding.setText(fichier);
                            try {
                                do {
                                    Thread.sleep(100L);
                                } while (FFMPEG.runProcess.isAlive() || BMXTRANSWRAP.isRunning || DCRAW.isRunning || XPDF.isRunning || MKVMERGE.isRunning || DVDAUTHOR.isRunning || TSMUXER.isRunning);
                                Thread.sleep(1000L);
                                do {
                                    Thread.sleep(100L);
                                } while (FFMPEG.runProcess.isAlive() || BMXTRANSWRAP.isRunning || DCRAW.isRunning || XPDF.isRunning || MKVMERGE.isRunning || DVDAUTHOR.isRunning || TSMUXER.isRunning);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            RenderQueue.lastActions(i, fichier, fileOut);
                            if (Shutter.cancelled) {
                                btnStartRender.setEnabled(true);
                                break;
                            }
                            ++i;
                        }
                        btnStartRender.setEnabled(true);
                        Shutter.enableAll();
                        Shutter.enfOfFunction();
                        Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                    }
                });
                render.start();
            }
        });
        this.resizeAll();
    }

    private void resizeAll() {
        title.setBounds(0, 0, frame.getWidth(), 28);
        btnStartRender.setBounds(11, frame.getHeight() - 29, frame.getWidth() - 23, 21);
        scrollPane.setBounds(10, 38, frame.getWidth() - 20, frame.getHeight() - 74);
        this.quit.setBounds(RenderQueue.frame.getSize().width - 20, 4, 15, 15);
        this.fullscreen.setBounds(this.quit.getLocation().x - 20, 4, 15, 15);
        this.reduce.setBounds(this.fullscreen.getLocation().x - 20, 4, 15, 15);
        topPanel.setBounds(0, 0, RenderQueue.frame.getSize().width, 28);
        this.topImage.setLocation(RenderQueue.frame.getSize().width / 2 - 200, 0);
    }

    private static void lastActions(int item, String file, File fileOut) {
        File tempMKV;
        String ext;
        File fileEntry;
        File fileToDelete;
        int n;
        String[] cli = tableRow.getValueAt(item, 1).toString().split(" ");
        if (cli[0].toString().equals("mkvmerge")) {
            if (!MKVMERGE.error) {
                File tempHDR = new File(fileOut.toString().replace(fileOut.toString().substring(fileOut.toString().lastIndexOf(".")), "_HDR" + fileOut.toString().substring(fileOut.toString().lastIndexOf("."))));
                tempHDR.delete();
            } else {
                FFMPEG.error = true;
            }
        }
        if (FFMPEG.error || fileOut.length() == 0L && !Shutter.caseCreateSequence.isSelected()) {
            FFMPEG.errorList.append(String.valueOf(Shutter.language.getProperty("file")) + " N\u00b0" + (item + 1) + " - " + file);
            FFMPEG.errorList.append(System.lineSeparator());
            try {
                fileOut.delete();
            }
            catch (Exception tempHDR) {
                // empty catch block
            }
        }
        if (Settings.btnSetBab.isSelected() || Shutter.grpImageSequence.isVisible() && Shutter.caseEnableSequence.isSelected() || VideoPlayer.comboMode.getSelectedItem().toString().equals(Shutter.language.getProperty("removeMode")) && Shutter.caseInAndOut.isSelected()) {
            String extension = file.substring(file.lastIndexOf("."));
            File concatList = new File(String.valueOf(fileOut.getParent().replace("\\", "/")) + "/" + file.replace(extension, ".txt"));
            concatList.delete();
        }
        if (Shutter.cancelled) {
            try {
                fileOut.delete();
            }
            catch (Exception extension) {
                // empty catch block
            }
        }
        if (!Shutter.cancelled && !FFMPEG.error) {
            Shutter.lblFilesEnded.setText(FunctionUtils.completedFiles(++complete));
        }
        if (item > 0 && cli[0].toString().equals("bmxtranswrap")) {
            String cmd = tableRow.getValueAt(item - 1, 1).toString();
            String c = cmd.substring(0, cmd.length() - 1);
            fileOut = new File(c.substring(c.lastIndexOf("\"") + 1));
            try {
                fileOut.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        File folder = new File(fileOut.getParent());
        if (cli[0].toString().equals("ffmpeg") && tableRow.getValueAt(item, 1).toString().contains("pass 2") && cli[0].toString().equals("ffmpeg")) {
            String extension = file.substring(file.lastIndexOf("."));
            File[] fileArray = folder.listFiles();
            int n2 = fileArray.length;
            n = 0;
            while (n < n2) {
                File fileEntry2 = fileArray[n];
                if (fileEntry2.isFile() && fileEntry2.getName().contains(file.replace(extension, "")) && fileEntry2.getName().contains("log")) {
                    fileToDelete = new File(fileEntry2.getAbsolutePath());
                    fileToDelete.delete();
                }
                ++n;
            }
        }
        if (cli[0].toString().equals("dvdauthor")) {
            File[] fileArray = folder.listFiles();
            n = fileArray.length;
            int n3 = 0;
            while (n3 < n) {
                fileEntry = fileArray[n3];
                if (fileEntry.isFile() && ((ext = fileEntry.toString().substring(fileEntry.toString().lastIndexOf("."))).equals(".log") || ext.equals(".xml") || ext.equals(".mpg"))) {
                    fileToDelete = new File(fileEntry.getAbsolutePath());
                    fileToDelete.delete();
                }
                ++n3;
            }
        }
        if (cli[0].toString().equals("tsMuxeR")) {
            File[] fileArray = folder.listFiles();
            n = fileArray.length;
            int n4 = 0;
            while (n4 < n) {
                fileEntry = fileArray[n4];
                if (fileEntry.isFile() && ((ext = fileEntry.toString().substring(fileEntry.toString().lastIndexOf("."))).equals(".meta") || ext.equals(".mkv"))) {
                    fileToDelete = new File(fileEntry.getAbsolutePath());
                    fileToDelete.delete();
                }
                ++n4;
            }
        }
        if (cli[0].toString().equals("ffmpeg") && (tempMKV = new File(String.valueOf(Shutter.dirTemp) + "fileToRewrap.mkv")).exists()) {
            tempMKV.delete();
        }
        FunctionUtils.addFileForMail(file);
        Wetransfer.addFile(fileOut);
        Ftp.sendToFtp(fileOut);
        if (tableRow.getValueAt(item, 2).toString().contains("|")) {
            String[] s = tableRow.getValueAt(item, 2).toString().split("\\|");
            if (s.length > 2) {
                Shutter.caseChangeFolder2.setSelected(true);
                Shutter.lblDestination2.setText(s[1].substring(1, s[1].length() - 1));
                Shutter.caseChangeFolder3.setSelected(true);
                Shutter.lblDestination3.setText(s[2].substring(1, s[2].length()));
            } else {
                Shutter.caseChangeFolder2.setSelected(true);
                Shutter.lblDestination2.setText(s[1].substring(1, s[1].length()));
                Shutter.caseChangeFolder3.setSelected(false);
                Shutter.lblDestination3.setText(Shutter.language.getProperty("aucune"));
            }
            if (s[0].substring(0, s[0].length() - 1).equals(Shutter.language.getProperty("sameAsSource"))) {
                Shutter.lblDestination1.setText(Shutter.language.getProperty("sameAsSource"));
                Shutter.caseChangeFolder1.setSelected(false);
            } else {
                Shutter.lblDestination1.setText(s[0].substring(0, s[0].length() - 1));
                Shutter.caseChangeFolder1.setSelected(true);
            }
        } else {
            if (tableRow.getValueAt(item, 2).toString().equals(Shutter.language.getProperty("sameAsSource"))) {
                Shutter.lblDestination1.setText(Shutter.language.getProperty("sameAsSource"));
                Shutter.caseChangeFolder1.setSelected(false);
            } else {
                Shutter.lblDestination1.setText(tableRow.getValueAt(item, 2).toString());
                Shutter.caseChangeFolder1.setSelected(true);
            }
            Shutter.caseChangeFolder2.setSelected(false);
            Shutter.lblDestination2.setText(Shutter.language.getProperty("aucune"));
            Shutter.caseChangeFolder3.setEnabled(false);
            Shutter.caseChangeFolder3.setSelected(false);
            Shutter.lblDestination3.setText(Shutter.language.getProperty("aucune"));
        }
        if (cli[0].toString().equals("ffmpeg") && !tableRow.getValueAt(item, 1).toString().contains("pass 1")) {
            Utils.copyFile(fileOut);
        }
    }
}

