/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.MiniWindowBackground;
import application.Shutter;
import application.Utils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ReducedWindow
extends JDialog {
    public static JDialog frame;
    private JPanel panel;
    private JLabel lblEnCours;
    private JLabel pourcentage;
    private JLabel iconImage;
    private JProgressBar progressBar;
    private JLabel lblTempsRestant;
    private boolean mouseFocusWindow = false;
    float opacity = 0.5f;
    private ImageIcon icon;
    private boolean drag = false;
    private static int MousePositionY;

    public ReducedWindow() {
        frame = new JDialog();
        frame.setContentPane(new MiniWindowBackground());
        frame.setDefaultCloseOperation(0);
        frame.setTitle("Shutter Encoder");
        frame.setForeground(Color.WHITE);
        frame.getContentPane().setLayout(null);
        frame.setSize(290, 94);
        frame.setResizable(false);
        if (!frame.isUndecorated()) {
            frame.setUndecorated(true);
            frame.setBackground(new Color(1.0f, 1.0f, 1.0f, 0.0f));
            frame.setAlwaysOnTop(true);
            frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
        }
        GraphicsConfiguration config = frame.getGraphicsConfiguration();
        GraphicsDevice myScreen = config.getDevice();
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] allScreens = env.getScreenDevices();
        int screenIndex = -1;
        int i = 0;
        while (i < allScreens.length) {
            if (allScreens[i].equals(myScreen)) {
                screenIndex = i;
                break;
            }
            ++i;
        }
        if (System.getProperty("os.name").contains("Windows")) {
            frame.setLocation(allScreens[screenIndex].getDefaultConfiguration().getBounds().x + allScreens[screenIndex].getDefaultConfiguration().getBounds().width - ReducedWindow.frame.getSize().width, Shutter.MiniWindowY);
        } else {
            frame.setLocation(allScreens[screenIndex].getDefaultConfiguration().getBounds().x + allScreens[screenIndex].getDisplayMode().getWidth() - ReducedWindow.frame.getSize().width, Shutter.MiniWindowY);
        }
        this.panel = new JPanel();
        this.panel.setLayout(null);
        this.panel.setBounds(6, 3, 88, 88);
        this.panel.setBackground(new Color(45, 45, 45));
        frame.getContentPane().add(this.panel);
        this.pourcentage = new JLabel("0%");
        this.pourcentage.setHorizontalAlignment(4);
        this.pourcentage.setBounds(29, 36, 33, 16);
        this.pourcentage.setVisible(false);
        this.pourcentage.setFont(new Font(Shutter.montserratFont, 0, 13));
        this.pourcentage.setBackground(new Color(0, 0, 0));
        this.panel.add(this.pourcentage);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png"));
        this.icon = new ImageIcon(imageIcon.getImage().getScaledInstance(this.panel.getSize().width - 5, this.panel.getSize().height - 5, 16));
        this.iconImage = new JLabel(this.icon);
        this.iconImage.setBounds(0, 0, 88, 88);
        this.panel.add(this.iconImage);
        this.lblEnCours = new JLabel(Shutter.language.getProperty("lblEnCours"));
        this.lblEnCours.setHorizontalAlignment(0);
        this.lblEnCours.setForeground(Color.LIGHT_GRAY);
        this.lblEnCours.setFont(new Font("SansSerif", 1, 13));
        this.lblEnCours.setBounds(100, 6, 178, 16);
        frame.getContentPane().add(this.lblEnCours);
        this.progressBar = new JProgressBar();
        this.progressBar.setBounds(100, 24, 178, 24);
        frame.getContentPane().add(this.progressBar);
        Shutter.caseRunInBackground.setBounds(100, 53, Shutter.caseRunInBackground.getPreferredSize().width, 16);
        frame.getContentPane().add(Shutter.caseRunInBackground);
        this.lblTempsRestant = new JLabel(String.valueOf(Shutter.language.getProperty("tempsRestant")) + " ");
        this.lblTempsRestant.setVisible(false);
        this.lblTempsRestant.setHorizontalAlignment(2);
        this.lblTempsRestant.setForeground(Utils.themeColor);
        this.lblTempsRestant.setFont(new Font(Shutter.montserratFont, 0, 12));
        this.lblTempsRestant.setBounds(100, 72, 178, 16);
        frame.getContentPane().add(this.lblTempsRestant);
        frame.setVisible(true);
        this.opacity = 1.0f;
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (!Shutter.lblCurrentEncoding.getText().equals(Shutter.language.getProperty("lblEncodageEnCours"))) {
                    ReducedWindow.this.lblEnCours.setText(Shutter.lblCurrentEncoding.getText());
                    if (!Shutter.progressBar1.isIndeterminate()) {
                        ReducedWindow.this.pourcentage.setVisible(true);
                    } else {
                        ReducedWindow.this.pourcentage.setVisible(false);
                    }
                } else {
                    ReducedWindow.this.pourcentage.setVisible(false);
                    ReducedWindow.this.lblEnCours.setText(Shutter.language.getProperty("lblEnCours"));
                }
                ReducedWindow.this.lblEnCours.setForeground(Shutter.lblCurrentEncoding.getForeground());
                if (Shutter.tempsRestant.isVisible()) {
                    ReducedWindow.this.lblTempsRestant.setVisible(true);
                } else {
                    ReducedWindow.this.lblTempsRestant.setVisible(false);
                }
                ReducedWindow.this.lblTempsRestant.setText(Shutter.tempsRestant.getText());
                if (Shutter.progressBar1.isIndeterminate()) {
                    ReducedWindow.this.progressBar.setIndeterminate(true);
                } else {
                    ReducedWindow.this.progressBar.setIndeterminate(false);
                }
                ReducedWindow.this.progressBar.setMaximum(Shutter.progressBar1.getMaximum());
                ReducedWindow.this.progressBar.setValue(Shutter.progressBar1.getValue());
                if (ReducedWindow.this.mouseFocusWindow && !ReducedWindow.this.drag && ReducedWindow.this.opacity < 0.99f) {
                    ReducedWindow.this.opacity += 0.01f;
                    try {
                        frame.setOpacity(ReducedWindow.this.opacity);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!Shutter.progressBar1.isIndeterminate() && ReducedWindow.this.progressBar.getValue() != 0) {
                    ReducedWindow.this.rotateIcon((long)ReducedWindow.this.progressBar.getValue() * 360L / (long)ReducedWindow.this.progressBar.getMaximum());
                }
                if (!Shutter.progressBar1.isIndeterminate() && ReducedWindow.this.progressBar.getValue() != 0) {
                    ReducedWindow.this.pourcentage.setText(String.valueOf(String.valueOf((long)ReducedWindow.this.progressBar.getValue() * 100L / (long)ReducedWindow.this.progressBar.getMaximum()) + "%"));
                }
            }
        };
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(task, 0L, 10L);
        frame.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                GraphicsConfiguration config = Shutter.frame.getGraphicsConfiguration();
                GraphicsDevice myScreen = config.getDevice();
                GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice[] allScreens = env.getScreenDevices();
                int screenIndex = -1;
                int i = 0;
                while (i < allScreens.length) {
                    if (allScreens[i].equals(myScreen)) {
                        screenIndex = i;
                        break;
                    }
                    ++i;
                }
                int screenHeight = allScreens[screenIndex].getDisplayMode().getHeight();
                if (MouseInfo.getPointerInfo().getLocation().y - MousePositionY < 0) {
                    int position = 0;
                    frame.setLocation(ReducedWindow.frame.getLocation().x, position);
                } else if (MouseInfo.getPointerInfo().getLocation().y - MousePositionY > screenHeight - ReducedWindow.frame.getSize().height) {
                    int position = screenHeight - ReducedWindow.frame.getSize().height;
                    frame.setLocation(ReducedWindow.frame.getLocation().x, position);
                } else if (ReducedWindow.this.drag) {
                    frame.setLocation(ReducedWindow.frame.getLocation().x, MouseInfo.getPointerInfo().getLocation().y - MousePositionY);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        frame.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!ReducedWindow.this.drag) {
                    frame.setVisible(false);
                    Shutter.frame.setState(0);
                    Shutter.caseRunInBackground.setBounds(6, 64, Shutter.caseRunInBackground.getPreferredSize().width, 23);
                    Shutter.grpProgression.add(Shutter.caseRunInBackground);
                }
            }

            @Override
            public void mousePressed(MouseEvent down) {
                ReducedWindow.this.drag = true;
                MousePositionY = down.getPoint().y;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ReducedWindow.this.drag = false;
                Shutter.MiniWindowY = ReducedWindow.frame.getLocation().y;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ReducedWindow.this.mouseFocusWindow = true;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ReducedWindow.this.mouseFocusWindow = false;
                if (!ReducedWindow.this.drag) {
                    do {
                        ReducedWindow.this.opacity -= 0.01f;
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        try {
                            frame.setOpacity(ReducedWindow.this.opacity);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    } while (ReducedWindow.this.opacity > 0.5f);
                }
            }
        });
    }

    private void rotateIcon(long l) {
        int w = this.icon.getIconWidth();
        int h = this.icon.getIconHeight();
        int type = 3;
        BufferedImage image = new BufferedImage(h, w, type);
        Graphics2D g2 = image.createGraphics();
        double x = (double)(h - w) / 2.0;
        double y = (double)(w - h) / 2.0;
        AffineTransform at = AffineTransform.getTranslateInstance(x, y);
        at.rotate(Math.toRadians(l), (double)w / 2.0, (double)h / 2.0);
        RenderingHints qualityHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        qualityHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHints(qualityHints);
        g2.drawImage(this.icon.getImage(), at, this.iconImage);
        g2.dispose();
        this.iconImage.setIcon(new ImageIcon(image));
    }
}

