/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplier;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplierProvider;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class OurClangTidyInspection
extends ClangTidyInspectionBase
implements OCInspectionBase.CLionClangTidyBasedMarker {
    private final Logger LOG = Logger.getInstance(((Object)((Object)this)).getClass());

    protected OurClangTidyInspection() {
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public abstract String getCheckName();

    @Override
    @NotNull
    public String getMessage(@NotNull String clangTidyMessage, boolean isBatchMode) {
        return clangTidyMessage;
    }

    @Override
    public boolean canBeDisabledByClangTidyCheckName(@NotNull VirtualFile file, @NotNull Project project) {
        return false;
    }

    @Override
    @NotNull
    public String getSuppressName(@NotNull String clangTidyCheckName) {
        return this.getShortName();
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder problemsHolder, final boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        return new PsiElementVisitor(){

            public void visitFile(@NotNull PsiFile file) {
                if (isOnTheFly && problemsHolder.isOnTheFly()) {
                    return;
                }
                if (!ClangdBridge.isSupported(file.getProject(), file.getVirtualFile())) {
                    return;
                }
                ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(file.getProject());
                VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
                try {
                    List allDiagnostics = service.computeWithOpenedAndParsed(virtualFile, response -> ClangUtils.waitForClangFuture(response.getOurTidyDiagnostics()));
                    if (allDiagnostics != null) {
                        List diagnostics = ContainerUtil.filter((Collection)allDiagnostics, diagnostic -> diagnostic.getDiagnosticName().equals(OurClangTidyInspection.this.getCheckName()));
                        ClangTidyAnnotationApplier applier = ClangTidyAnnotationApplierProvider.provide();
                        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
                        if (document != null) {
                            applier.annotateSuccess(file, (List<ClangTidyDiagnostic>)diagnostics, problemsHolder);
                        }
                    }
                }
                catch (Exception e) {
                    OurClangTidyInspection.this.LOG.warn(((Object)((Object)this)).getClass().getName() + " in batch mode failed.", (Throwable)e);
                }
            }
        };
    }
}

