/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInspection.ExternalAnnotatorInspectionVisitor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.ExternalAnnotatorBatchInspection;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBInsets;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangTidyFilesState;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClazyAnnotator;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClazyInspection
extends ClangTidyInspectionBase
implements ExternalAnnotatorBatchInspection,
OCInspectionBase.CLionClangTidyBasedMarker {
    @NotNull
    @NonNls
    private String myClazyChecks = "level0";

    @Override
    @NotNull
    public String getMessage(@NotNull String clangTidyMessage, boolean isBatchMode) {
        return isBatchMode ? clangTidyMessage : ClangdBundle.message("inspection.clazy.message", clangTidyMessage);
    }

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return ClangdBundle.message("inspection.static.analysis", new Object[0]);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return ClangdBundle.message("inspection.clazy.name", new Object[0]);
    }

    @Override
    public boolean canBeDisabledByClangTidyCheckName(@NotNull VirtualFile file, @NotNull Project project) {
        ClangTidyFilesState clangTidyFilesState = (ClangTidyFilesState)project.getService(ClangTidyFilesState.class);
        return !clangTidyFilesState.hasClangTidyFilesInPath(new File(file.getPath()));
    }

    @Override
    @NotNull
    public String getSuppressName(@NotNull String clangTidyCheckName) {
        return clangTidyCheckName;
    }

    @NotNull
    public static String getInspectionShortName() {
        return new ClazyInspection().getShortName();
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    public ProblemDescriptor @NotNull [] checkFile(@NotNull PsiFile file, @NotNull GlobalInspectionContext context, @NotNull InspectionManager manager) {
        ClazyAnnotator annotator = new ClazyAnnotator(this);
        return ExternalAnnotatorInspectionVisitor.checkFileWithExternalAnnotator((PsiFile)file, (InspectionManager)manager, (boolean)false, (ExternalAnnotator)annotator);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        FormBuilder builder = FormBuilder.createFormBuilder();
        JPanel childPanel = new JPanel(new GridBagLayout());
        ClazyInspection.addComponent(this.createChecksField(), childPanel, 0, 2, 0, 1, 0, (Insets)JBInsets.emptyInsets());
        ClazyInspection.addComponent((Component)ClazyInspection.createChecksExampleLink(), childPanel, 1, 1, 2, 0, 0, (Insets)JBInsets.emptyInsets());
        builder.addComponent((JComponent)childPanel);
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.add((Component)builder.getPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, (Insets)JBInsets.emptyInsets(), 0, 0));
        return panel2;
    }

    private static void addComponent(@NotNull Component component, @NotNull JPanel panel2, int gridX, int gridWidth, int gridY, int weightX, int weightY, @NotNull Insets insets) {
        panel2.add(component, new GridBagConstraints(gridX, gridY, gridWidth, 1, weightX, weightY, 18, 2, insets, 0, 0));
    }

    @NotNull
    private JComponent createChecksField() {
        final RawCommandLineEditor checksEditor = new RawCommandLineEditor(text -> StringUtil.split((String)text, (String)","), checks -> StringUtil.join((Collection)checks, (String)","));
        checksEditor.setText(this.myClazyChecks);
        checksEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                ClazyInspection.this.myClazyChecks = checksEditor.getText();
            }
        });
        return checksEditor;
    }

    @NotNull
    private static HyperlinkLabel createChecksExampleLink() {
        HyperlinkLabel hint = new HyperlinkLabel(ClangdBundle.message("configurable.clazy.checks.link", new Object[0]));
        hint.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(new URI("https://github.com/KDE/clazy#list-of-checks"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        return hint;
    }

    @NotNull
    @NonNls
    public String getClazyChecks() {
        return this.myClazyChecks;
    }

    public void setClazyChecks(@NotNull @NonNls String checks) {
        this.myClazyChecks = checks;
    }
}

