/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOption;
import com.jetbrains.cidr.lang.inspections.ClangdInspectionBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClangTidyInspectionBase
extends ClangdInspectionBase {
    @NotNull
    protected List<ClangTidyCheckOption> myClangTidyCheckOptions = new ArrayList<ClangTidyCheckOption>();

    @NotNull
    public abstract String getMessage(@NotNull String var1, boolean var2);

    @Nls
    @Nullable
    public String getQuickFixMessage() {
        return null;
    }

    public abstract boolean canBeDisabledByClangTidyCheckName(@NotNull VirtualFile var1, @NotNull Project var2);

    public boolean isPreferClangTidyFilesOverIDESettings() {
        return false;
    }

    @NotNull
    public abstract String getSuppressName(@NotNull String var1);

    public void disableGroups(@NotNull List<String> groups) {
        for (String group : groups) {
            this.disableAllChecksInGroup(group);
        }
    }

    public void enableGroups(@NotNull List<String> groups) {
        for (String group : groups) {
            this.enableAllChecksInGroup(group);
        }
    }

    public void disableAllChecksInGroup(@NotNull String group) {
    }

    public void enableAllChecksInGroup(@NotNull String group) {
    }

    public void enableCheck(@NotNull String check) {
    }

    public void disableCheck(@NotNull String check) {
    }

    public static boolean isMisraInspection(@NotNull String checkName) {
        return checkName.startsWith("clion-misra-");
    }

    @NotNull
    public List<ClangTidyCheckOption> getClangTidyCheckOptions() {
        return this.myClangTidyCheckOptions;
    }

    public void setClangTidyCheckOptions(@NotNull List<ClangTidyCheckOption> clangTidyCheckOptions) {
        this.myClangTidyCheckOptions = clangTidyCheckOptions;
    }

    @Nullable
    public ProblemHighlightType getForcedHighlightType() {
        return null;
    }

    public void addOrReplaceCheckOption(@NotNull String optionName, @NotNull String optionValue) {
        this.removeCheckOption(optionName);
        this.myClangTidyCheckOptions.add(new ClangTidyCheckOption(optionName, optionValue));
    }

    public void removeCheckOption(@NotNull String optionName) {
        Optional<ClangTidyCheckOption> foundOption = this.myClangTidyCheckOptions.stream().filter(option -> option.getOptionName().equals(optionName)).findFirst();
        foundOption.ifPresent(option -> this.myClangTidyCheckOptions.remove(option));
    }
}

