/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ByteToCharOffsetMapBuilder;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyReplacement;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyYamlDataKt;
import com.jetbrains.cidr.lang.daemon.clang.tidy.Note;
import com.jetbrains.cidr.lang.daemon.clang.tidy.OverlayMapping;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlReplacement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u000e\u001a\u00020\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00120\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0004H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J(\u0010\u001d\u001a\u00020\u001e2\u001e\u0010\u001f\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060 0 H\u0016R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/tidy/YamlDiagnosticV1;", "Lcom/jetbrains/cidr/lang/daemon/clang/tidy/YamlDiagnostic;", "()V", "DiagnosticName", "", "FileOffset", "", "FilePath", "Message", "Notes", "", "Lcom/jetbrains/cidr/lang/daemon/clang/tidy/Note;", "Replacements", "Lcom/jetbrains/cidr/lang/daemon/clang/tidy/YamlReplacement;", "addOffsets", "", "fileToByteOffset", "", "Ljava/util/SortedSet;", "appliedToSourceFile", "", "sourceFilePath", "fixWSLPaths", "wslMsId", "isSuppressed", "isValid", "mapOverlaysToSourceFiles", "overlayMapping", "Lcom/jetbrains/cidr/lang/daemon/clang/tidy/OverlayMapping;", "toClangTidyDiagnostic", "Lcom/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyDiagnostic;", "byteToCharOffsetMap", "", "intellij.c.clangd"})
public final class YamlDiagnosticV1
extends YamlDiagnostic {
    @JvmField
    @Nullable
    public String Message;
    @JvmField
    @Nullable
    public String DiagnosticName;
    @JvmField
    @Nullable
    public String FilePath;
    @JvmField
    public int FileOffset;
    @JvmField
    @Nullable
    public List<YamlReplacement> Replacements;
    @JvmField
    @Nullable
    public List<Note> Notes;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isValid() {
        YamlReplacement it;
        CharSequence charSequence = this.DiagnosticName;
        if (charSequence == null) return false;
        if (charSequence.length() == 0) {
            return false;
        }
        boolean bl = false;
        if (bl) return false;
        charSequence = this.FilePath;
        if (charSequence == null) return false;
        if (charSequence.length() == 0) {
            return false;
        }
        boolean bl2 = false;
        if (bl2) return false;
        charSequence = this.Message;
        if (charSequence == null) return false;
        if (charSequence.length() == 0) {
            return false;
        }
        boolean bl3 = false;
        if (bl3) return false;
        if (this.FileOffset < 0) return false;
        if (this.Replacements == null) return true;
        List<YamlReplacement> list = this.Replacements;
        Intrinsics.checkNotNull(list);
        Iterable $this$all$iv = list;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (YamlReplacement)element$iv;
            boolean bl4 = false;
        } while (it.isValid());
        return false;
    }

    @Override
    public boolean isSuppressed() {
        String string = this.DiagnosticName;
        Intrinsics.checkNotNull((Object)string);
        return StringsKt.startsWith$default((String)string, (String)"clang-diagnostic", (boolean)false, (int)2, null);
    }

    @Override
    public void fixWSLPaths(@NotNull String wslMsId) {
        String string = this.FilePath;
        Intrinsics.checkNotNull((Object)string);
        this.FilePath = ClangUrlConverter.fromWslPath(string, wslMsId);
        List<YamlReplacement> list = this.Replacements;
        Intrinsics.checkNotNull(list);
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            YamlReplacement it = (YamlReplacement)element$iv;
            boolean bl = false;
            it.fixWSLPaths(wslMsId);
        }
    }

    @Override
    public boolean appliedToSourceFile(@NotNull String sourceFilePath) {
        return FileUtil.pathsEqual((String)FileUtil.toCanonicalPath((String)this.FilePath), (String)sourceFilePath);
    }

    @Override
    public void mapOverlaysToSourceFiles(@NotNull OverlayMapping overlayMapping) {
        String string = this.FilePath;
        Intrinsics.checkNotNull((Object)string);
        File diagnosticFile = new File(string);
        if (overlayMapping.hasSourceFile(diagnosticFile)) {
            File file = overlayMapping.getSourceFile(diagnosticFile);
            Intrinsics.checkNotNull((Object)file);
            this.FilePath = file.getPath();
        }
        List<YamlReplacement> list = this.Replacements;
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                YamlReplacement it = (YamlReplacement)element$iv;
                boolean bl = false;
                String string2 = it.FilePath;
                Intrinsics.checkNotNull((Object)string2);
                File replacementFile = new File(string2);
                if (!overlayMapping.hasSourceFile(replacementFile)) continue;
                File file = overlayMapping.getSourceFile(replacementFile);
                Intrinsics.checkNotNull((Object)file);
                it.FilePath = file.getPath();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ClangTidyDiagnostic toClangTidyDiagnostic(@NotNull Map<String, ? extends Map<Integer, Integer>> byteToCharOffsetMap) {
        List list;
        List<YamlReplacement> list2 = this.Replacements;
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                YamlReplacement yamlReplacement = (YamlReplacement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ClangTidyReplacement clangTidyReplacement = it.toClangTidyReplacement(byteToCharOffsetMap);
                collection.add(clangTidyReplacement);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List clangTidyReplacements = list;
        String string = this.FilePath;
        Intrinsics.checkNotNull((Object)string);
        int offset = ClangTidyYamlDataKt.access$getCharOffset(string, this.FileOffset, byteToCharOffsetMap);
        String string2 = this.Message;
        Intrinsics.checkNotNull((Object)string2);
        String string3 = this.DiagnosticName;
        Intrinsics.checkNotNull((Object)string3);
        String string4 = this.FilePath;
        Intrinsics.checkNotNull((Object)string4);
        return new ClangTidyDiagnostic(string2, string3, string4, offset, CollectionsKt.emptyList(), clangTidyReplacements, null);
    }

    @Override
    public void addOffsets(@NotNull Map<String, SortedSet<Integer>> fileToByteOffset) {
        String string = this.FilePath;
        Intrinsics.checkNotNull((Object)string);
        ByteToCharOffsetMapBuilder.Companion.addOffset(string, this.FileOffset, fileToByteOffset);
        List<YamlReplacement> list = this.Replacements;
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                YamlReplacement it = (YamlReplacement)element$iv;
                boolean bl = false;
                String string2 = it.FilePath;
                Intrinsics.checkNotNull((Object)string2);
                ByteToCharOffsetMapBuilder.Companion.addOffset(string2, it.Offset, fileToByteOffset);
                String string3 = it.FilePath;
                Intrinsics.checkNotNull((Object)string3);
                ByteToCharOffsetMapBuilder.Companion.addOffset(string3, it.Offset + it.Length, fileToByteOffset);
            }
        }
    }
}

