/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.SuppressableProblemGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplierBase;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyReplacement;
import com.jetbrains.cidr.lang.daemon.clang.tidy.SimpleClangTidyIntentionAction;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.SimpleClangTidyProblemGroup;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleClangTidyAnnotationApplier
extends ClangTidyAnnotationApplierBase {
    @Override
    @NotNull
    protected SuppressableProblemGroup createProblemGroup(@NotNull PsiFile file, @NotNull TextRange highlightRange, @NotNull String checkName, @NotNull ClangTidyInspectionBase inspection) {
        boolean canDisable = inspection.canBeDisabledByClangTidyCheckName(file.getVirtualFile(), file.getProject());
        boolean canSuppress = ((Object)((Object)inspection)).getClass().equals(ClangTidyInspection.class);
        return new SimpleClangTidyProblemGroup(file, highlightRange, checkName, canDisable, canSuppress, inspection.getShortName());
    }

    @Override
    @Nullable
    protected TextRange getRangeToHighlight(@NotNull PsiFile file, @NotNull ClangTidyDiagnostic diagnostic, @NotNull ClangTidyInspectionBase sourceInspection) {
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return null;
        }
        CharSequence sequence = document.getCharsSequence();
        if (diagnostic.getFileOffset() < 0 || diagnostic.getFileOffset() >= sequence.length()) {
            return null;
        }
        int startOffset = diagnostic.getFileOffset();
        return SimpleClangTidyAnnotationApplier.getTextRange(sequence, startOffset);
    }

    @NotNull
    private static TextRange getTextRange(@NotNull CharSequence sequence, int startOffset) {
        char chatAtOffset = sequence.charAt(startOffset);
        if (chatAtOffset == '[') {
            return SimpleClangTidyAnnotationApplier.getTextRangeUntil(sequence, startOffset, ']', true);
        }
        if (chatAtOffset == '(') {
            return SimpleClangTidyAnnotationApplier.getTextRangeUntil(sequence, startOffset, ')', true);
        }
        if (chatAtOffset == '\"') {
            return SimpleClangTidyAnnotationApplier.getTextRangeUntil(sequence, startOffset, '\"', true);
        }
        if (chatAtOffset == '\'') {
            return SimpleClangTidyAnnotationApplier.getTextRangeUntil(sequence, startOffset, '\'', true);
        }
        if (SimpleClangTidyAnnotationApplier.isComment(sequence, startOffset)) {
            return SimpleClangTidyAnnotationApplier.getCommentTextRange(sequence, startOffset);
        }
        if (SimpleClangTidyAnnotationApplier.isOperatorSymbol(chatAtOffset)) {
            return SimpleClangTidyAnnotationApplier.getCompositeOperatorSymbolTextRange(sequence, startOffset);
        }
        if (StringUtil.isWhiteSpace((char)chatAtOffset)) {
            return SimpleClangTidyAnnotationApplier.getTextRangeAfterWhitespace(sequence, startOffset);
        }
        return SimpleClangTidyAnnotationApplier.getIdentifierTextRange(sequence, startOffset);
    }

    @NotNull
    private static TextRange getTextRangeAfterWhitespace(@NotNull CharSequence sequence, int startOffset) {
        int offset;
        for (offset = startOffset; offset < sequence.length() && StringUtil.isWhiteSpace((char)sequence.charAt(offset)); ++offset) {
        }
        return SimpleClangTidyAnnotationApplier.getTextRange(sequence, offset);
    }

    @NotNull
    private static TextRange getCommentTextRange(@NotNull CharSequence sequence, int startOffset) {
        int endOffset;
        if (StringUtil.startsWith((CharSequence)sequence, (int)startOffset, (CharSequence)"//")) {
            return SimpleClangTidyAnnotationApplier.getTextRangeUntil(sequence, startOffset, '\n', false);
        }
        for (endOffset = startOffset + 2; endOffset < sequence.length(); ++endOffset) {
            if (!StringUtil.startsWith((CharSequence)sequence, (int)endOffset, (CharSequence)"*/")) continue;
            endOffset += 2;
            break;
        }
        return new TextRange(startOffset, endOffset);
    }

    private static boolean isComment(@NotNull CharSequence sequence, int startOffset) {
        return StringUtil.startsWith((CharSequence)sequence, (int)startOffset, (CharSequence)"//") || StringUtil.startsWith((CharSequence)sequence, (int)startOffset, (CharSequence)"/*");
    }

    @NotNull
    private static TextRange getTextRangeUntil(@NotNull CharSequence sequence, int startOffset, char endSymbol, boolean includeEndSymbol) {
        int endOffset;
        for (endOffset = startOffset + 1; endOffset < sequence.length(); ++endOffset) {
            if (sequence.charAt(endOffset) != endSymbol) continue;
            if (!includeEndSymbol) break;
            ++endOffset;
            break;
        }
        return new TextRange(startOffset, endOffset);
    }

    private static boolean isOperatorSymbol(char ch) {
        return ch == '+' || ch == '-' || ch == '*' || ch == '/' || ch == '%' || ch == '&' || ch == '|' || ch == '^' || ch == '<' || ch == '>' || ch == '!' || ch == '=';
    }

    @NotNull
    private static TextRange getCompositeOperatorSymbolTextRange(@NotNull CharSequence sequence, int startOffset) {
        int endOffset;
        for (endOffset = startOffset; endOffset < sequence.length() && SimpleClangTidyAnnotationApplier.isOperatorSymbol(sequence.charAt(endOffset)); ++endOffset) {
        }
        return new TextRange(startOffset, endOffset);
    }

    @NotNull
    private static TextRange getIdentifierTextRange(@NotNull CharSequence sequence, int startOffset) {
        int endOffset;
        Predicate<Character> identifierPredicate = c -> Character.isLetterOrDigit(c.charValue()) || c.charValue() == '_' || c.charValue() == '#' || c.charValue() == '~' || c.charValue() == ':';
        if (identifierPredicate.test(Character.valueOf(sequence.charAt(startOffset)))) {
            for (endOffset = startOffset; endOffset < sequence.length() && identifierPredicate.test(Character.valueOf(sequence.charAt(endOffset))); ++endOffset) {
            }
        } else {
            endOffset = startOffset + 1;
        }
        return new TextRange(startOffset, endOffset);
    }

    @Override
    protected boolean isSuppressed(@NotNull PsiFile file, int offset, @NotNull String suppressName) {
        return false;
    }

    @Override
    @NotNull
    protected List<IntentionAction> createQuickFixes(@NotNull PsiFile file, @NotNull @NlsSafe String diagnosticMessage, @NotNull ClangTidyDiagnostic diagnostic, @NotNull ClangTidyInspectionBase sourceInspection) {
        List<ClangTidyReplacement> replacements = diagnostic.getReplacements();
        if (replacements.isEmpty()) {
            return Collections.singletonList(new EmptyIntentionAction(sourceInspection.getDisplayName()));
        }
        String diagnosticName = diagnostic.getDiagnosticName();
        String quickFixMessage = sourceInspection.getQuickFixMessage() != null ? sourceInspection.getQuickFixMessage() : diagnosticMessage;
        return Collections.singletonList(new SimpleClangTidyIntentionAction(quickFixMessage, diagnosticName, replacements));
    }

    @Override
    protected boolean shouldIgnoreForFile(@NotNull PsiFile file) {
        return false;
    }
}

