/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.google.common.html.HtmlEscapers;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.DumbAwareActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import java.awt.Desktop;
import java.awt.Dimension;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionChecksDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(InspectionChecksDialog.class);
    @NotNull
    private final List<String> myChecks;
    @NotNull
    private final String myAvailableChecks;
    private final boolean mySupportsHelpPage;
    @NotNull
    private final ClangTidyInspectionBase myInspection;
    @NotNull
    private final Set<String> myInitialEnabledChecks;
    private final @NotNull Map<String, @NlsSafe String> myCheckToDescriptionMap;
    @NotNull
    private final Set<CheckGroupTreeNode> myChangedGroupNodes = new HashSet<CheckGroupTreeNode>();
    @NotNull
    private final List<CheckGroupTreeNode> myAllGroupNodes = new ArrayList<CheckGroupTreeNode>();

    public InspectionChecksDialog(@NotNull Collection<String> checks, @NotNull String availableChecks, @NlsContexts.DialogTitle String title, @NotNull ClangTidyInspectionBase inspection, boolean supportsHelpPage, @NotNull Map<@NlsSafe String, @NlsSafe String> checkToDescriptionMap, @Nullable Project project) {
        super(project, false);
        this.myChecks = new ArrayList<String>(checks);
        this.myAvailableChecks = availableChecks;
        this.mySupportsHelpPage = supportsHelpPage;
        this.myChecks.sort(NaturalComparator.INSTANCE);
        this.myInspection = inspection;
        this.myInitialEnabledChecks = this.getEnabledChecks();
        this.myCheckToDescriptionMap = checkToDescriptionMap;
        this.init();
        this.setTitle(title);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        FormBuilder builder = new FormBuilder();
        CheckboxTreeBase checksTree = this.createChecksTree();
        JComponent decorator = this.createToolbarDecorator(checksTree);
        builder.addComponentFillVertically(decorator, 0);
        if (this.isClangTidyFilesCanOverrideDefaultSettings()) {
            builder.addComponent(InspectionChecksDialog.createClangTidyFilesOverrideHint());
        }
        builder.getPanel().setPreferredSize(InspectionChecksDialog.getPreferredDialogDimension());
        return builder.getPanel();
    }

    protected void doOKAction() {
        this.updateClangTidyConfiguration();
        super.doOKAction();
    }

    @NotNull
    private Set<String> getEnabledChecks() {
        List<String> options = CommonClangTidyUtil.getTrimmedOptions(this.myAvailableChecks);
        HashSet<String> enabledNewChecks = new HashSet<String>();
        for (String check : this.myChecks) {
            if (CommonClangTidyUtil.isDisabled(options, check)) continue;
            enabledNewChecks.add(check);
        }
        return enabledNewChecks;
    }

    private void updateClangTidyConfiguration() {
        List<String> disabledGroupNames = this.getDisabledGroupNames();
        if (disabledGroupNames.size() == this.myAllGroupNodes.size()) {
            this.myInspection.disableGroups(disabledGroupNames);
            return;
        }
        List<String> enabledGroupNames = this.getEnabledGroupNames();
        if (enabledGroupNames.size() == this.myAllGroupNodes.size()) {
            this.myInspection.enableGroups(enabledGroupNames);
            return;
        }
        List<CheckGroupTreeNode> groupNodesWithPartialState = this.getGroupNodesWithPartialState();
        if (disabledGroupNames.size() >= this.myAllGroupNodes.size() / 2) {
            this.myInspection.disableGroups(this.getAllGroupNames());
            this.myInspection.enableGroups(enabledGroupNames);
            this.updateParticularGroupNodes(groupNodesWithPartialState);
            return;
        }
        if (enabledGroupNames.size() >= this.myAllGroupNodes.size() / 2) {
            this.myInspection.enableGroups(this.getAllGroupNames());
            this.myInspection.disableGroups(disabledGroupNames);
            this.updateParticularGroupNodes(groupNodesWithPartialState);
            return;
        }
        this.updateParticularGroupNodes(this.myChangedGroupNodes);
    }

    private void updateParticularGroupNodes(@NotNull Collection<CheckGroupTreeNode> groupNodes) {
        for (CheckGroupTreeNode groupNode : groupNodes) {
            if (groupNode.allChecksDisabled()) {
                this.myInspection.disableAllChecksInGroup(groupNode.toString());
                continue;
            }
            if (groupNode.allChecksEnabled()) {
                this.myInspection.enableAllChecksInGroup(groupNode.toString());
                continue;
            }
            CommonClangTidyUtil.modifyAllChecksWithSingleGroup(groupNode.getAllChecks(), this.myInspection);
        }
    }

    @NotNull
    private List<String> getAllGroupNames() {
        return ContainerUtil.map(this.myAllGroupNodes, n -> n.toString());
    }

    @NotNull
    private List<String> getDisabledGroupNames() {
        return ContainerUtil.map((Collection)ContainerUtil.filter(this.myAllGroupNodes, n -> n.allChecksDisabled()), n -> n.toString());
    }

    @NotNull
    private List<String> getEnabledGroupNames() {
        return ContainerUtil.map((Collection)ContainerUtil.filter(this.myAllGroupNodes, n -> n.allChecksEnabled()), n -> n.toString());
    }

    @NotNull
    private List<CheckGroupTreeNode> getGroupNodesWithPartialState() {
        return ContainerUtil.filter(this.myAllGroupNodes, n -> n.isPartialState());
    }

    private CheckboxTreeBase createChecksTree() {
        CheckedTreeNode rootNode = new CheckedTreeNode();
        CheckboxTree tree = new CheckboxTree(this.createTreeCellRenderer(), rootNode, new CheckboxTreeBase.CheckPolicy(true, true, true, true));
        tree.addCheckboxTreeListener(new CheckboxTreeListener(){

            public void nodeStateChanged(@NotNull CheckedTreeNode node) {
                if (node instanceof CheckTreeNode && node.getParent() instanceof CheckGroupTreeNode) {
                    InspectionChecksDialog.this.myChangedGroupNodes.add((CheckGroupTreeNode)((Object)node.getParent()));
                } else if (node instanceof CheckGroupTreeNode) {
                    InspectionChecksDialog.this.myChangedGroupNodes.add((CheckGroupTreeNode)node);
                }
            }
        });
        tree.setRootVisible(false);
        this.fillTreeWithData(rootNode);
        ((DefaultTreeModel)tree.getModel()).reload();
        new TreeSpeedSearch((JTree)tree, path -> path.getLastPathComponent().toString(), true);
        TreeUtil.expandAll((JTree)tree);
        return tree;
    }

    private void fillTreeWithData(@NotNull CheckedTreeNode rootNode) {
        String group;
        TreeMap<String, ArrayList> myCheckGroups = new TreeMap<String, ArrayList>();
        for (String string : this.myChecks) {
            group = CommonClangTidyUtil.getGroupName(string);
            if (myCheckGroups.containsKey(group)) {
                ((List)myCheckGroups.get(group)).add(string);
                continue;
            }
            myCheckGroups.put(group, ContainerUtil.newArrayList((Object[])new String[]{string}));
        }
        for (Map.Entry entry : myCheckGroups.entrySet()) {
            group = (String)entry.getKey();
            Collection checks = (Collection)entry.getValue();
            CheckGroupTreeNode groupNode = new CheckGroupTreeNode(group);
            for (String check : checks) {
                groupNode.add((MutableTreeNode)((Object)new CheckTreeNode(this.myInitialEnabledChecks.contains(check), check)));
            }
            rootNode.add((MutableTreeNode)((Object)groupNode));
            this.myAllGroupNodes.add(groupNode);
        }
    }

    @NotNull
    private CheckboxTree.CheckboxTreeCellRenderer createTreeCellRenderer() {
        return new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Object userObject = ((CheckedTreeNode)value).getUserObject();
                if (userObject != null) {
                    String text = (String)userObject;
                    if (InspectionChecksDialog.this.myCheckToDescriptionMap.containsKey(text)) {
                        @NlsSafe String description = InspectionChecksDialog.this.myCheckToDescriptionMap.get(text);
                        description = HtmlEscapers.htmlEscaper().escape(description);
                        this.setToolTipText(description);
                    } else {
                        this.setToolTipText(null);
                    }
                    this.getTextRenderer().append(text);
                }
            }
        };
    }

    @NotNull
    private static Dimension getPreferredDialogDimension() {
        return new Dimension(450, 500);
    }

    private boolean isClangTidyFilesCanOverrideDefaultSettings() {
        return this.myInspection.isPreferClangTidyFilesOverIDESettings();
    }

    @NotNull
    private static JComponent createClangTidyFilesOverrideHint() {
        JBLabel hint = new JBLabel(AllIcons.General.Warning, 2);
        hint.setText(ClangdBundle.message("clang.tidy.update.settings.override", new Object[0]));
        return hint;
    }

    @NotNull
    private JComponent createToolbarDecorator(final @NotNull CheckboxTreeBase tree) {
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTree)tree).addExtraAction((AnActionButton)new DumbAwareActionButton(IdeBundle.message((String)"action.expand.all", (Object[])new Object[0]), AllIcons.Actions.Expandall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                TreeUtil.expandAll((JTree)tree);
            }
        }).addExtraAction((AnActionButton)new DumbAwareActionButton(IdeBundle.message((String)"action.collapse.all", (Object[])new Object[0]), AllIcons.Actions.Collapseall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                TreeUtil.collapseAll((JTree)tree, (boolean)true, (int)0);
            }
        }).addExtraAction((AnActionButton)new DumbAwareActionButton(IdeBundle.message((String)"command.select.all", (Object[])new Object[0]), AllIcons.Actions.Selectall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                InspectionChecksDialog.checkTree(tree, true);
            }
        }).addExtraAction((AnActionButton)new DumbAwareActionButton(IdeBundle.message((String)"command.unselect.all", (Object[])new Object[0]), AllIcons.Actions.Unselectall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                InspectionChecksDialog.checkTree(tree, false);
            }
        });
        if (this.mySupportsHelpPage) {
            toolbarDecorator = toolbarDecorator.addExtraAction((AnActionButton)new DumbAwareActionButton(ClangdBundle.message("clang.tidy.update.go.to.help.page", new Object[0]), AllIcons.General.Web){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    TreePath path = tree.getSelectionModel().getSelectionPath();
                    Object lastPathComponent = path.getLastPathComponent();
                    if (lastPathComponent instanceof CheckTreeNode) {
                        String checkName = lastPathComponent.toString();
                        InspectionChecksDialog.tryNavigateToHelpPage(checkName);
                    }
                }

                public boolean isEnabled() {
                    return tree.getSelectionPaths() != null && tree.getSelectionPaths().length == 1 && tree.getSelectionPaths()[0].getLastPathComponent() instanceof CheckTreeNode;
                }

                public boolean isVisible() {
                    return true;
                }
            });
        }
        return toolbarDecorator.setToolbarPosition(ActionToolbarPosition.RIGHT).createPanel();
    }

    private static void checkTree(CheckboxTreeBase tree, boolean checked) {
        CheckedTreeNode rootNode = (CheckedTreeNode)tree.getModel().getRoot();
        tree.setNodeState(rootNode, checked);
        tree.repaint();
    }

    private static void tryNavigateToHelpPage(@NotNull String checkName) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URI("https://clang.llvm.org/extra/clang-tidy/checks/" + checkName + ".html"));
            }
            catch (Exception e) {
                LOG.warn("Cannot navigate to clang-tidy help page", (Throwable)e);
            }
        }
    }

    private static class CheckTreeNode
    extends CheckedTreeNode {
        CheckTreeNode(boolean isChecked, @NotNull Object userObject) {
            super(userObject);
            this.setChecked(isChecked);
        }
    }

    private static class CheckGroupTreeNode
    extends CheckedTreeNode {
        CheckGroupTreeNode(@NotNull Object userObject) {
            super(userObject);
        }

        @NotNull
        Map<String, Boolean> getAllChecks() {
            HashMap<String, Boolean> checks = new HashMap<String, Boolean>();
            Enumeration children = this.children();
            while (children.hasMoreElements()) {
                TreeNode node = (TreeNode)children.nextElement();
                if (!(node instanceof CheckTreeNode)) continue;
                CheckTreeNode checkNode = (CheckTreeNode)((Object)node);
                checks.put(checkNode.toString(), checkNode.isChecked());
            }
            return checks;
        }

        boolean isPartialState() {
            Set childrenValues = Collections.list(this.children()).stream().filter(n -> n instanceof CheckTreeNode).map(n -> ((CheckTreeNode)((Object)((Object)n))).isChecked()).collect(Collectors.toSet());
            return childrenValues.size() == 2;
        }

        boolean allChecksEnabled() {
            Enumeration children = this.children();
            while (children.hasMoreElements()) {
                TreeNode node = (TreeNode)children.nextElement();
                if (!(node instanceof CheckTreeNode) || ((CheckTreeNode)((Object)node)).isChecked()) continue;
                return false;
            }
            return true;
        }

        boolean allChecksDisabled() {
            Enumeration children = this.children();
            while (children.hasMoreElements()) {
                TreeNode node = (TreeNode)children.nextElement();
                if (!(node instanceof CheckTreeNode) || !((CheckTreeNode)((Object)node)).isChecked()) continue;
                return false;
            }
            return true;
        }
    }
}

