/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import org.jetbrains.annotations.NotNull;

public class ClangTidyAnnotatorDebugInfoBuilder {
    @NotNull
    private String myCommandLine = "";
    @NotNull
    private String myOutput = "";
    @NotNull
    private String myCompilationDatabase = "";
    @NotNull
    private String myMacros = "";

    public void setMacros(@NotNull String macros) {
        this.myMacros = macros;
    }

    public void setCompilationDatabase(@NotNull String compilationDatabase) {
        this.myCompilationDatabase = compilationDatabase;
    }

    public void setCommandLine(@NotNull String commandLine) {
        this.myCommandLine = commandLine;
    }

    public void setOutput(@NotNull String output) {
        this.myOutput = output;
    }

    @NotNull
    public String build() {
        StringBuilder debugInfo = new StringBuilder();
        debugInfo.append(ClangTidyAnnotatorDebugInfoBuilder.getBlock("Command Line", this.myCommandLine));
        debugInfo.append(ClangTidyAnnotatorDebugInfoBuilder.getBlock("Output", this.myOutput));
        debugInfo.append(ClangTidyAnnotatorDebugInfoBuilder.getBlock("Compilation Database", ClangTidyAnnotatorDebugInfoBuilder.getPrettyJsonString(this.myCompilationDatabase)));
        debugInfo.append(ClangTidyAnnotatorDebugInfoBuilder.getBlock("Macros File", this.myMacros));
        return debugInfo.toString();
    }

    @NotNull
    private static String getPrettyJsonString(@NotNull String jsonStr) {
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JsonElement element = JsonParser.parseString((String)jsonStr);
            return gson.toJson(element);
        }
        catch (Exception e) {
            return jsonStr;
        }
    }

    @NotNull
    private static String getBlock(@NotNull String blockTitle, @NotNull String blockContent) {
        return "=== " + blockTitle + " ===\n" + blockContent + "\n\n";
    }
}

