/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.google.common.base.Charsets;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdCompilationCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Cpp20ModulesPaths;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.reparsing.OCLanguageServiceReparsingPassListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangTidyFilesState;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplier;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplierProvider;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationHolder;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotatorDebugInfoBuilder;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotatorInfo;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDocumentListener;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyResolveInfoProvider;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyYamlLoader;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.OverlayMapping;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.MisraInspection;
import com.jetbrains.cidr.lang.psi.OCFragmentVirtualFile;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.AppleClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.error.YAMLException;

public class ClangTidyAnnotator
extends ExternalAnnotator<ClangTidyAnnotatorInfo, ClangTidyAnnotationHolder> {
    public static final Key<Boolean> RUN_IN_UNIT_TEST_MODE = Key.create((String)"CLANG_TIDY_ANNOTATOR_RUN_IN_UNIT_TEST_MODE");
    public static final Key<Boolean> TAKE_CLION_CONFIG = Key.create((String)"CLANG_TIDY_ANNOTATOR_TAKE_CLION_CONFIG");
    public static final Key<Boolean> TAKE_TIDY_CONFIG = Key.create((String)"CLANG_TIDY_ANNOTATOR_TAKE_TIDY_CONFIG");
    public static final Key<Boolean> COLLECT_DEBUG_INFORMATION = Key.create((String)"CLANG_TIDY_COLLECT_DEBUG_INFORMATION");
    public static final Key<String> DEBUG_INFORMATION = Key.create((String)"CLANG_TIDY_DEBUG_INFORMATION");
    public static final Key<AtomicBoolean> HAS_DOCUMENT_LISTENER = Key.create((String)"CLANG_TIDY_HAS_DOCUMENT_LISTENER");
    public static final Key<MyMasterReparsingPassListener> REPARSING_PASS_LISTENER = Key.create((String)"CLANG_TIDY_REPARSING_PASS_LISTENER");
    private static final Logger LOG = Logger.getInstance(ClangTidyAnnotator.class);
    private static final ClangTidyDocumentListener DOCUMENT_LISTENER = new ClangTidyDocumentListener();
    private final ClangTidyInspectionBase myPairedInspection;
    private final ClangTidyResolveInfoProvider myResolveInfoProvider;

    public ClangTidyAnnotator() {
        this(null);
    }

    public ClangTidyAnnotator(@Nullable ClangTidyInspectionBase inspection) {
        this.myPairedInspection = inspection;
        this.myResolveInfoProvider = ClangTidyResolveInfoProvider.getInstance();
    }

    @Nullable
    public ClangTidyAnnotatorInfo collectInformation(@NotNull PsiFile file, @NotNull Editor editor, boolean hasErrors) {
        return this.collectInformationImpl(file, editor);
    }

    @Nullable
    public ClangTidyAnnotatorInfo collectInformation(@NotNull PsiFile file) {
        return this.collectInformationImpl(file, null);
    }

    @Nullable
    protected ClangTidyInspectionBase getInspection(PsiFile file, Project project) {
        return this.myPairedInspection != null ? this.myPairedInspection : CommonClangTidyUtil.getClangTidyInspection(file, project);
    }

    @NlsSafe
    @NotNull
    protected String getChecksConfig(@NotNull ClangTidyInspectionBase inspection) {
        if (inspection instanceof ClangTidyInspection) {
            ClangTidyInspection clangTidyInspection = (ClangTidyInspection)inspection;
            return CommonClangTidyUtil.getClangTidyConfig(CommonClangTidyUtil.concatClangTidyChecks(clangTidyInspection.getClangTidyChecks(), "-clion-*"), inspection.getClangTidyCheckOptions());
        }
        if (inspection instanceof MisraInspection) {
            MisraInspection misraInspection = (MisraInspection)inspection;
            String misraChecks = StringUtil.join((String[])new String[]{misraInspection.getAllMisraChecks(), ","});
            String onlyMisraChecks = CommonClangTidyUtil.concatClangTidyChecks("-*,-clion-*", misraChecks);
            return CommonClangTidyUtil.getClangTidyConfig(onlyMisraChecks, inspection.getClangTidyCheckOptions());
        }
        return CommonClangTidyUtil.getClangTidyConfig("", inspection.getClangTidyCheckOptions());
    }

    @Nullable
    private ClangTidyAnnotatorInfo collectInformationImpl(@NotNull PsiFile file, @Nullable Editor editor) {
        Project project = file.getProject();
        if (ApplicationManager.getApplication().isUnitTestMode() && project.getUserData(RUN_IN_UNIT_TEST_MODE) != Boolean.TRUE) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || virtualFile instanceof OCFragmentVirtualFile) {
            return null;
        }
        String inputFileName = PathUtil.getFileName((String)virtualFile.getPath());
        if (!this.myResolveInfoProvider.isInProjectSources(file)) {
            return null;
        }
        ClangUtils.ResolveInfo resolveInfo = this.myResolveInfoProvider.getResolveInfo(file, project);
        if (resolveInfo == null) {
            return null;
        }
        OCResolveConfiguration configuration = resolveInfo.configuration;
        VirtualFile rootVirtualFile = resolveInfo.root;
        OCLanguageKind languageKind = resolveInfo.languageKind;
        OCCompilerSettings compilerSettings = configuration.getCompilerSettings(languageKind, virtualFile);
        OCCompilerKind compiler = compilerSettings.getCompilerKind();
        File compilerExecutable = compilerSettings.getCompilerExecutable();
        File compilerWorkingDir = compilerSettings.getCompilerWorkingDir();
        CidrCompilerSwitches compilerSwitches = compilerSettings.getCompilerSwitches();
        if (compiler == null || compilerExecutable == null || compilerWorkingDir == null || compilerSwitches == null) {
            return null;
        }
        List headerPaths = configuration.getCompilerSettings(languageKind, rootVirtualFile).getHeadersSearchPaths();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            return null;
        }
        ClangTidyInspectionBase inspection = this.getInspection(file, project);
        if (inspection == null) {
            return null;
        }
        return new ClangTidyAnnotatorInfo(inputFileName, project, file, languageKind, configuration, compilerSettings, compiler, compilerExecutable, compilerWorkingDir, compilerSwitches, rootVirtualFile, headerPaths, document, inspection, editor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ClangTidyAnnotationHolder doAnnotate(@Nullable ClangTidyAnnotatorInfo info) {
        ClangTidyAnnotationHolder clangTidyAnnotationHolder;
        block6: {
            if (info == null) {
                return null;
            }
            ClangTidyAnnotator.tryRegisterDocumentListener(info);
            File workingDirectory = null;
            try {
                ClangTidyAnnotator.prepareClangTidyFiles(info);
                workingDirectory = FileUtil.createTempDirectory((String)"clion-clang-tidy", null, (boolean)true);
                clangTidyAnnotationHolder = this.executeClangTidy(info, workingDirectory);
                if (workingDirectory == null) break block6;
            }
            catch (com.intellij.execution.ExecutionException | IOException | YAMLException exc) {
                ClangTidyAnnotationHolder clangTidyAnnotationHolder2;
                block7: {
                    try {
                        LOG.warn(exc);
                        clangTidyAnnotationHolder2 = ClangTidyAnnotationHolder.error(exc.getMessage());
                        if (workingDirectory == null) break block7;
                    }
                    catch (Throwable throwable) {
                        if (workingDirectory != null) {
                            FileUtil.delete(workingDirectory);
                        }
                        throw throwable;
                    }
                    FileUtil.delete((File)workingDirectory);
                }
                return clangTidyAnnotationHolder2;
            }
            FileUtil.delete((File)workingDirectory);
        }
        return clangTidyAnnotationHolder;
    }

    public static boolean isAvailable() {
        return ClangTidyAnnotator.isAvailable(CommonClangTidyUtil.getBuiltinClangTidyPath());
    }

    private static void prepareClangTidyFiles(ClangTidyAnnotatorInfo info) {
        FileDocumentManager manager = FileDocumentManager.getInstance();
        Application application = ApplicationManager.getApplication();
        Document[] unsavedDocuments = (Document[])ReadAction.compute(() -> manager.getUnsavedDocuments());
        boolean forceReparseRequired = false;
        for (Document document : unsavedDocuments) {
            VirtualFile file = manager.getFile(document);
            if (file == null || !file.getName().equals(".clang-tidy")) continue;
            application.invokeAndWait(() -> application.runWriteAction(() -> manager.saveDocument(document)));
            forceReparseRequired = true;
        }
        if (forceReparseRequired) {
            ClangLanguageService languageService = ClangLanguageServiceProvider.getIfStarted(info.getProject());
            application.invokeAndWait(() -> languageService.notifyReparseRequired(info.getFile().getVirtualFile()));
        }
    }

    @Nullable
    private ClangTidyAnnotationHolder executeClangTidy(@NotNull ClangTidyAnnotatorInfo info, @NotNull File workingDirectory) throws IOException, com.intellij.execution.ExecutionException {
        return ClangTidyAnnotator.useLanguageService(info) ? ClangTidyAnnotator.executeClangTidyViaClangd(info) : this.executeStandaloneClangTidy(info, workingDirectory);
    }

    @Nullable
    private ClangTidyAnnotationHolder executeStandaloneClangTidy(@NotNull ClangTidyAnnotatorInfo info, @NotNull File workingDirectory) throws IOException, com.intellij.execution.ExecutionException {
        ProcessOutput processOutput;
        ClangUtils.traceClangd(LOG, "Clang-tidy is used for clang-tidy diagnostics");
        File clangTidyPath = ClangTidyAnnotator.getClangTidyPath();
        if (!ClangTidyAnnotator.isAvailable(clangTidyPath)) {
            return ClangTidyAnnotationHolder.error(ClangdBundle.message("inspection.clangTidy.not.found", new Object[0]));
        }
        boolean isBuiltinClangTidyUsed = FileUtil.filesEqual((File)clangTidyPath, (File)CommonClangTidyUtil.getBuiltinClangTidyPath());
        ClangTidyInspectionBase inspection = info.getInspection();
        String wslMsId = isBuiltinClangTidyUsed ? ClangUtils.getCurrentWslMsId(info.getProject()) : null;
        boolean executeInsideWSL = StringUtil.isNotEmpty((String)wslMsId);
        Document document = info.getDocument();
        long modificationStampOnStart = document.getModificationStamp();
        File inputFile = new File(info.getFile().getVirtualFile().getPath());
        OverlayMapping overlayMapping = ClangTidyAnnotator.generateVfsOverlays(workingDirectory);
        File vfsOverlay = ClangTidyAnnotator.generateVfsOverlay(overlayMapping, workingDirectory, executeInsideWSL);
        File outputFile = new File(workingDirectory, "output.yaml");
        ClangTidyAnnotatorDebugInfoBuilder debugInfoBuilder = new ClangTidyAnnotatorDebugInfoBuilder();
        File compilationDatabase = ClangTidyAnnotator.createCompilationDatabase(info, workingDirectory, inputFile, debugInfoBuilder, wslMsId);
        if (ClangTidyAnnotator.collectDebugInformation(info)) {
            debugInfoBuilder.setCompilationDatabase(FileUtil.loadFile((File)compilationDatabase));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        if (executeInsideWSL) {
            commandLine.setExePath(ClangUtils.getWslClangdDirPath() + "/clang-tidy");
        } else {
            commandLine.setExePath(clangTidyPath.getAbsolutePath());
        }
        ClangTidyFilesState clangTidyFilesState = (ClangTidyFilesState)info.getProject().getService(ClangTidyFilesState.class);
        if (!inspection.isPreferClangTidyFilesOverIDESettings() || !clangTidyFilesState.hasClangTidyFilesInPath(inputFile)) {
            String checksConfig = this.getChecksConfig(inspection);
            commandLine.addParameter("-config=" + checksConfig);
        } else {
            commandLine.addParameter("-checks=-clion-*");
        }
        commandLine.addParameter("-p=" + ClangTidyAnnotator.fixWslPathIfRequired(workingDirectory.getPath(), executeInsideWSL));
        commandLine.addParameter("-vfsoverlay=" + ClangTidyAnnotator.fixWslPathIfRequired(vfsOverlay.getPath(), executeInsideWSL));
        commandLine.addParameter("-export-fixes=" + ClangTidyAnnotator.fixWslPathIfRequired(outputFile.getPath(), executeInsideWSL));
        commandLine.addParameter(ClangTidyAnnotator.fixWslPathIfRequired(inputFile.getAbsolutePath(), executeInsideWSL));
        if (executeInsideWSL) {
            this.copyBuiltinClangToolsInsideWSL(wslMsId);
            WSLDistribution wslDistribution = WslDistributionManager.getInstance().getOrCreateDistributionByMsId(wslMsId);
            commandLine = wslDistribution.patchCommandLine(commandLine, info.getProject(), new WSLCommandLineOptions());
        }
        if (ClangTidyAnnotator.collectDebugInformation(info)) {
            debugInfoBuilder.setCommandLine(commandLine.toString());
        }
        CapturingProcessHandler processHandler = ClangTidyAnnotator.createCapturedProcessHandler(commandLine);
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (modificationStampOnStart != document.getModificationStamp()) {
            return null;
        }
        ProcessOutput processOutput2 = processOutput = progressIndicator != null ? processHandler.runProcessWithProgressIndicator(progressIndicator) : processHandler.runProcess();
        if (processOutput.getExitCode() != 0) {
            LOG.debug("Clang-Tidy finished with error: " + processOutput.getStderr());
        }
        if (ClangTidyAnnotator.collectDebugInformation(info)) {
            debugInfoBuilder.setOutput(outputFile.exists() ? FileUtil.loadFile((File)outputFile) : "");
            info.getFile().putUserData(DEBUG_INFORMATION, (Object)debugInfoBuilder.build());
        }
        List<ClangTidyDiagnostic> diagnostics = outputFile.exists() ? ClangTidyAnnotator.loadDiagnosticsFromYaml(outputFile, inputFile, overlayMapping, wslMsId) : Collections.emptyList();
        return ClangTidyAnnotationHolder.success(diagnostics);
    }

    protected void copyBuiltinClangToolsInsideWSL(@NotNull String wslMsId) {
        ClangUtils.prepareClangBinariesInsideWSL(new ClangUrlConverter(wslMsId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static ClangTidyAnnotationHolder executeClangTidyViaClangd(@NotNull ClangTidyAnnotatorInfo info) {
        ClangUtils.traceClangd(LOG, "Clangd is used for clang-tidy diagnostics");
        ProgressIndicator currentIndicator = ProgressManager.getInstance().getProgressIndicator();
        SensitiveProgressWrapper newIndicator = currentIndicator != null ? new SensitiveProgressWrapper(currentIndicator) : new ProgressIndicatorBase();
        Ref result = Ref.create();
        MyMasterReparsingPassListener masterListener = ClangTidyAnnotator.trySubscribeForClangReparsingPass(info.getProject());
        MySlaveReparsingPassListener slaveListener = new MySlaveReparsingPassListener((ProgressIndicator)newIndicator, info.getFile());
        try {
            masterListener.addListener(slaveListener);
            ProgressManager.getInstance().runProcess(() -> {
                Boolean isFileValid = (Boolean)ReadAction.compute(() -> info.getFile().isValid());
                if (!isFileValid.booleanValue()) {
                    return;
                }
                ClangLanguageService languageService = ClangLanguageServiceProvider.getIfStarted(info.getProject());
                result.set((Object)languageService.computeWithParsed(info.getFile().getVirtualFile(), response -> {
                    if (response == null) {
                        return null;
                    }
                    try {
                        ArrayList<ClangTidyDiagnostic> diagnostics = new ArrayList<ClangTidyDiagnostic>();
                        for (Future<Supplier<List<ClangTidyDiagnostic>>> future : ClangTidyAnnotator.getDiagnosticsFutures(response, info.getProject())) {
                            Supplier supplier = (Supplier)CidrConcurrentUtilsKt.waitCancelAware(future, (long)Long.MAX_VALUE, (String)"Clang-tidy diagnostics");
                            if (supplier != null) {
                                List diags = (List)supplier.get();
                                if (diags != null) {
                                    diagnostics.addAll(diags);
                                    continue;
                                }
                                return null;
                            }
                            return null;
                        }
                        return ClangTidyAnnotationHolder.success(diagnostics);
                    }
                    catch (ExecutionException | TimeoutException exception) {
                        return null;
                    }
                }));
            }, (ProgressIndicator)newIndicator);
        }
        finally {
            masterListener.removeListener(slaveListener);
        }
        return (ClangTidyAnnotationHolder)result.get();
    }

    @NotNull
    private static List<Future<Supplier<List<ClangTidyDiagnostic>>>> getDiagnosticsFutures(@NotNull ClangParseResponse response, @NotNull Project project) {
        ArrayList<Future<Supplier<List<ClangTidyDiagnostic>>>> futures = new ArrayList<Future<Supplier<List<ClangTidyDiagnostic>>>>();
        if (project.getUserData(TAKE_CLION_CONFIG) == Boolean.TRUE) {
            futures.add(response.getOurTidyDiagnostics());
        }
        if (project.getUserData(TAKE_TIDY_CONFIG) != Boolean.FALSE) {
            futures.add(response.getTidyDiagnostics());
        }
        return futures;
    }

    protected static OverlayMapping generateVfsOverlays(@NotNull File workingDirectory) throws IOException {
        OverlayMapping overlayMapping = new OverlayMapping();
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        for (Document unsavedDocument : documentManager.getUnsavedDocuments()) {
            VirtualFile virtualFile = documentManager.getFile(unsavedDocument);
            if (virtualFile == null) continue;
            File sourceFile = new File(virtualFile.getPath());
            File overlayFile = ClangTidyAnnotator.generateMappingFile(sourceFile.getName(), unsavedDocument, workingDirectory);
            overlayMapping.addOverlay(sourceFile, overlayFile);
        }
        return overlayMapping;
    }

    protected static File generateMappingFile(@NotNull String fileName, @NotNull Document document, @NotNull File workingDirectory) throws IOException {
        File mappingFile = new File(workingDirectory, fileName);
        FileUtil.writeToFile((File)mappingFile, (String)document.getText());
        return mappingFile;
    }

    protected static File generateVfsOverlay(@NotNull OverlayMapping overlayMapping, @NotNull File workingDirectory, boolean isWSL) throws IOException {
        File vfsOverlay = new File(workingDirectory, "overlay.yaml");
        FileUtil.writeToFile((File)vfsOverlay, (String)CommonClangTidyUtil.generateVfsOverlay(overlayMapping, isWSL));
        return vfsOverlay;
    }

    public void apply(@NotNull PsiFile file, @Nullable ClangTidyAnnotationHolder annotationHolder, @NotNull AnnotationHolder holder) {
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (annotationHolder == null || document == null) {
            return;
        }
        ClangTidyAnnotationApplier applier = ClangTidyAnnotationApplierProvider.provide();
        if (annotationHolder.isSuccess()) {
            applier.annotateSuccess(file, annotationHolder.getDiagnostics(), holder);
        } else {
            HighlightSeverity severity = annotationHolder.isError() ? HighlightSeverity.ERROR : HighlightSeverity.WARNING;
            applier.annotateFail(file, annotationHolder.getFailReason(), severity, holder);
        }
    }

    @NotNull
    protected static File createCompilationDatabase(@NotNull ClangTidyAnnotatorInfo info, @NotNull File workingDirectory, @NotNull File inputFile, @NotNull ClangTidyAnnotatorDebugInfoBuilder debugInfoBuilder, @Nullable String wslMsId) throws IOException {
        ClangUrlConverter converter = new ClangUrlConverter();
        boolean isWsl = StringUtil.isNotEmpty((String)wslMsId);
        if (isWsl) {
            converter.setWslMsId(wslMsId);
        }
        Application application = ApplicationManager.getApplication();
        ArrayList<String> commandLine = new ArrayList<String>();
        Ref compilerExecutableRef = Ref.create();
        Ref preprocessorDefinesRef = Ref.create();
        File macrosFile = new File(workingDirectory, "macros");
        application.runReadAction(() -> {
            @NotNull PsiFile ocFile = info.getFile();
            VirtualFile file = ocFile.getVirtualFile();
            Cpp20ModulesPaths cpp20Paths = new Cpp20ModulesPaths("", "");
            ClangUtils.ResolveInfo resolveInfo = new ClangUtils.ResolveInfo(info.getConfiguration(), info.getRootVirtualFile(), info.getLanguageKind(), info.isGuessed());
            @Nullable ClangdCompilationCommand command = ClangUtils.getCompilationCommand(converter, info.getProject(), file, macrosFile.getPath(), cpp20Paths, resolveInfo);
            if (command == null) {
                return null;
            }
            List<String> cmdLine = command.ccParams.getCommandLine();
            cmdLine.remove(cmdLine.size() - 1);
            compilerExecutableRef.set((Object)cmdLine.remove(0));
            @NotNull OCCompilerKind compilerKind = info.getCompilerKind();
            if (compilerKind != ClangClCompilerKind.INSTANCE && compilerKind != ClangCompilerKind.INSTANCE && compilerKind != AppleClangCompilerKind.INSTANCE) {
                String resourceDir = ClangUtils.getClangHeaderDir(isWsl);
                commandLine.add("-I" + resourceDir);
            }
            commandLine.addAll(cmdLine);
            preprocessorDefinesRef.set((Object)command.ppDefines);
            return null;
        });
        if (!preprocessorDefinesRef.isNull()) {
            FileUtil.writeToFile((File)macrosFile, (String)((String)preprocessorDefinesRef.get()));
            if (ClangTidyAnnotator.collectDebugInformation(info)) {
                debugInfoBuilder.setMacros((String)preprocessorDefinesRef.get());
            }
        }
        File compilationDatabase = new File(workingDirectory, "compile_commands.json");
        FileWriter writer = new FileWriter(compilationDatabase, Charsets.UTF_8);
        CommonClangTidyUtil.writeCompilationDatabase(writer, ClangTidyAnnotator.fixWslPathIfRequired((String)compilerExecutableRef.get(), isWsl), ClangTidyAnnotator.fixWslPathIfRequired(workingDirectory.getAbsolutePath(), isWsl), commandLine, ClangTidyAnnotator.fixWslPathIfRequired(inputFile.getAbsolutePath(), isWsl));
        return compilationDatabase;
    }

    @NotNull
    protected static String fixWslPathIfRequired(@NotNull String path, boolean isWsl) {
        return isWsl ? ClangUrlConverter.fixWslPathWhenRequired(StringUtil.replace((String)path, (String)"\\", (String)"/"), true) : path;
    }

    @NotNull
    private static File getClangTidyPath() {
        File clangTidyPath = CommonClangTidyUtil.getCustomClangTidyPath();
        if (clangTidyPath == null) {
            clangTidyPath = CommonClangTidyUtil.getBuiltinClangTidyPath();
        }
        return clangTidyPath;
    }

    protected static boolean isAvailable(@Nullable File clangTidyPath) {
        try {
            return clangTidyPath != null && clangTidyPath.exists() && clangTidyPath.canExecute();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    @NotNull
    protected static List<ClangTidyDiagnostic> loadDiagnosticsFromYaml(@NotNull File outputFile, @NotNull File sourceFile, @NotNull OverlayMapping overlayMapping, @Nullable String wslMsId) throws IOException {
        String yamlContent = FileUtil.loadFile((File)outputFile);
        ClangTidyYamlLoader yamlLoader = new ClangTidyYamlLoader();
        return yamlLoader.load(yamlContent, sourceFile.getPath(), overlayMapping, wslMsId);
    }

    protected static void tryRegisterDocumentListener(@NotNull ClangTidyAnnotatorInfo info) {
        Document document = info.getDocument();
        if (!(document instanceof UserDataHolderEx)) {
            return;
        }
        UserDataHolderEx dataHolder = (UserDataHolderEx)document;
        AtomicBoolean hasDocumentListener = (AtomicBoolean)dataHolder.getUserData(HAS_DOCUMENT_LISTENER);
        if (hasDocumentListener == null && dataHolder.putUserDataIfAbsent(HAS_DOCUMENT_LISTENER, (Object)(hasDocumentListener = new AtomicBoolean(false))) != hasDocumentListener) {
            return;
        }
        if (hasDocumentListener.compareAndSet(false, true)) {
            document.addDocumentListener((DocumentListener)DOCUMENT_LISTENER);
        }
    }

    @NotNull
    protected static MyMasterReparsingPassListener trySubscribeForClangReparsingPass(@NotNull Project project) {
        if (!(project instanceof UserDataHolderEx)) {
            LOG.warn("Unexpected project type: " + project.getClass().getSimpleName());
            return new MyMasterReparsingPassListener();
        }
        MyMasterReparsingPassListener existing = (MyMasterReparsingPassListener)project.getUserData(REPARSING_PASS_LISTENER);
        if (existing != null) {
            return existing;
        }
        UserDataHolderEx dataHolderEx = (UserDataHolderEx)project;
        MyMasterReparsingPassListener newMasterListener = new MyMasterReparsingPassListener();
        MyMasterReparsingPassListener existing2 = (MyMasterReparsingPassListener)dataHolderEx.putUserDataIfAbsent(REPARSING_PASS_LISTENER, (Object)newMasterListener);
        if (existing2 == newMasterListener) {
            project.getMessageBus().connect().subscribe(OCLanguageServiceReparsingPassListener.TOPIC, (Object)newMasterListener);
        }
        return existing2;
    }

    public String getPairedBatchInspectionShortName() {
        return ClangTidyInspection.getInspectionShortName();
    }

    @NotNull
    protected static CapturingProcessHandler createCapturedProcessHandler(@NotNull GeneralCommandLine commandLine) throws com.intellij.execution.ExecutionException {
        return new CapturingProcessHandler(commandLine){

            protected CapturingProcessAdapter createProcessAdapter(ProcessOutput processOutput) {
                return new CapturingProcessAdapter(processOutput){

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    }
                };
            }
        };
    }

    private static boolean useLanguageService(@NotNull ClangTidyAnnotatorInfo info) {
        Project project = info.getProject();
        if (ClangUtils.isClangdOn(project) && ClangUtils.isClangTidyViaClangdOn(project)) {
            if (info.getFile().getVirtualFile() == null) {
                return false;
            }
            if (ClangUtils.isClangTidyViaClangdForced(project)) {
                return true;
            }
            return CommonClangTidyUtil.getCustomClangTidyPath() == null && info.getEditor() != null;
        }
        return false;
    }

    protected static boolean collectDebugInformation(ClangTidyAnnotatorInfo info) {
        return info.getFile().getUserData(COLLECT_DEBUG_INFORMATION) == Boolean.TRUE;
    }

    protected static final class MySlaveReparsingPassListener {
        @NotNull
        private final ProgressIndicator myIndicator;
        @NotNull
        private final PsiFile myFile;

        public MySlaveReparsingPassListener(@NotNull ProgressIndicator indicator, @NotNull PsiFile file) {
            this.myIndicator = indicator;
            this.myFile = file;
        }

        public void onReparsing(@NotNull PsiFile file) {
            if (file == this.myFile) {
                this.myIndicator.cancel();
            }
        }
    }

    public static class MyMasterReparsingPassListener
    implements OCLanguageServiceReparsingPassListener {
        @NotNull
        private final Set<MySlaveReparsingPassListener> mySlaveListeners = Collections.newSetFromMap(new IdentityHashMap());

        @Override
        public synchronized void onReparsing(@NotNull PsiFile file) {
            for (MySlaveReparsingPassListener slave : this.mySlaveListeners) {
                slave.onReparsing(file);
            }
        }

        public synchronized void addListener(@NotNull MySlaveReparsingPassListener slave) {
            this.mySlaveListeners.add(slave);
        }

        public synchronized void removeListener(@NotNull MySlaveReparsingPassListener slave) {
            this.mySlaveListeners.remove(slave);
        }
    }
}

