/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressableProblemGroup;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplier;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.OpenClangTidySettingsAction;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClangTidyAnnotationApplierBase
implements ClangTidyAnnotationApplier {
    @Override
    public void annotateFail(@NotNull PsiFile file, @NotNull String reason, HighlightSeverity severity, @NotNull AnnotationHolder holder) {
        String message = ClangdBundle.message("inspection.clangTidy.failed", reason);
        holder.newAnnotation(severity, message).range((PsiElement)file).fileLevel().withFix((IntentionAction)new OpenClangTidySettingsAction()).create();
    }

    @Override
    public void annotateSuccess(@NotNull PsiFile file, @NotNull List<ClangTidyDiagnostic> diagnostics, final @NotNull AnnotationHolder holder) {
        this.applySuccess(file, diagnostics, holder.isBatchMode(), new DiagnosticProcessor(){

            @Override
            public boolean process(@NotNull @InspectionMessage String diagnosticMessage, @NotNull String diagnosticName, @NotNull TextRange rangeToHighlight, @NotNull HighlightSeverity highlightSeverity, @NotNull ClangTidyInspectionBase sourceInspection, @NotNull PsiFile ocFile, @NotNull IntentionAction fixToRegister) {
                AnnotationBuilder builder = holder.newAnnotation(highlightSeverity, diagnosticMessage).range(rangeToHighlight).withFix((IntentionAction)new IntentionWrapper(fixToRegister)).problemGroup((ProblemGroup)ClangTidyAnnotationApplierBase.this.createProblemGroup(ocFile, rangeToHighlight, sourceInspection.getSuppressName(diagnosticName), sourceInspection));
                if (sourceInspection.getForcedHighlightType() != null) {
                    builder = builder.highlightType(sourceInspection.getForcedHighlightType());
                }
                builder.create();
                return true;
            }
        });
    }

    @Override
    public void annotateSuccess(final @NotNull PsiFile file, @NotNull List<ClangTidyDiagnostic> diagnostics, final @NotNull ProblemsHolder holder) {
        this.applySuccess(file, diagnostics, !holder.isOnTheFly(), new DiagnosticProcessor(){

            @Override
            public boolean process(@NotNull @InspectionMessage String diagnosticMessage, @NotNull String diagnosticName, @NotNull TextRange rangeToHighlight, @NotNull HighlightSeverity highlightSeverity, @NotNull ClangTidyInspectionBase sourceInspection, @NotNull PsiFile psiFile, @NotNull IntentionAction fixToRegister) {
                IntentionWrapper localQuickFix = new IntentionWrapper(fixToRegister);
                ProblemHighlightType highlightType = sourceInspection.getForcedHighlightType() == null ? HighlightInfo.convertSeverityToProblemHighlight((HighlightSeverity)highlightSeverity) : sourceInspection.getForcedHighlightType();
                ProblemDescriptor problemDescriptor = InspectionManager.getInstance((Project)file.getProject()).createProblemDescriptor((PsiElement)psiFile, rangeToHighlight, diagnosticMessage, highlightType, holder.isOnTheFly(), new LocalQuickFix[]{localQuickFix});
                problemDescriptor.setProblemGroup((ProblemGroup)ClangTidyAnnotationApplierBase.this.createProblemGroup(psiFile, rangeToHighlight, sourceInspection.getSuppressName(diagnosticName), sourceInspection));
                holder.registerProblem(problemDescriptor);
                return true;
            }
        });
    }

    @Override
    public void annotateSuccess(final @NotNull PsiFile file, @NotNull List<ClangTidyDiagnostic> diagnostics, final @NotNull HighlightInfoHolder holder, boolean isBatch) {
        this.applySuccess(file, diagnostics, isBatch, new DiagnosticProcessor(){

            @Override
            public boolean process(@NotNull @NlsContexts.DetailedDescription String diagnosticMessage, @NotNull String diagnosticName, @NotNull TextRange rangeToHighlight, @NotNull HighlightSeverity highlightSeverity, @NotNull ClangTidyInspectionBase sourceInspection, @NotNull PsiFile ocFile, @NotNull IntentionAction fixToRegister) {
                ProblemHighlightType problemHighlightType = sourceInspection.getForcedHighlightType() == null ? HighlightInfo.convertSeverityToProblemHighlight((HighlightSeverity)highlightSeverity) : sourceInspection.getForcedHighlightType();
                HighlightInfoType highlightInfoType = ProblemDescriptorUtil.getHighlightInfoType((ProblemHighlightType)problemHighlightType, (HighlightSeverity)highlightSeverity, (SeverityRegistrar)SeverityRegistrar.getSeverityRegistrar((Project)file.getProject()));
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType).range(rangeToHighlight).descriptionAndTooltip(diagnosticMessage).severity(highlightSeverity).problemGroup((ProblemGroup)ClangTidyAnnotationApplierBase.this.createProblemGroup(ocFile, rangeToHighlight, sourceInspection.getSuppressName(diagnosticName), sourceInspection)).create();
                holder.add(info);
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)fixToRegister);
                return true;
            }
        });
    }

    @NotNull
    protected abstract SuppressableProblemGroup createProblemGroup(@NotNull PsiFile var1, @NotNull TextRange var2, @NotNull String var3, @NotNull ClangTidyInspectionBase var4);

    @Nullable
    protected abstract TextRange getRangeToHighlight(@NotNull PsiFile var1, @NotNull ClangTidyDiagnostic var2, @NotNull ClangTidyInspectionBase var3);

    protected abstract boolean isSuppressed(@NotNull PsiFile var1, int var2, @NotNull String var3);

    @NotNull
    protected abstract List<IntentionAction> createQuickFixes(@NotNull PsiFile var1, @NotNull @NlsSafe String var2, @NotNull ClangTidyDiagnostic var3, @NotNull ClangTidyInspectionBase var4);

    protected abstract boolean shouldIgnoreForFile(@NotNull PsiFile var1);

    private void applySuccess(@NotNull PsiFile file, @NotNull List<ClangTidyDiagnostic> diagnostics, boolean isBatchMode, @NotNull DiagnosticProcessor processor) {
        if (this.shouldIgnoreForFile(file)) {
            return;
        }
        for (ClangTidyDiagnostic diagnostic : diagnostics) {
            TextRange rangeToHighlight;
            ProgressManager.checkCanceled();
            ClangTidyInspectionBase inspection = CommonClangTidyUtil.findInspectionFromClangTidyDiagnostic(diagnostic, file, file.getProject());
            if (inspection == null || (rangeToHighlight = this.getRangeToHighlight(file, diagnostic, inspection)) == null) continue;
            String diagnosticMessage = inspection.getMessage(diagnostic.getMessage(), isBatchMode);
            String diagnosticName = diagnostic.getDiagnosticName();
            HighlightSeverity highlightSeverity = OCInspectionUtil.getHighlightSeverity(((Object)((Object)inspection)).getClass(), (PsiElement)file, (HighlightSeverity)HighlightSeverity.WARNING);
            if (highlightSeverity == null || this.isSuppressed(file, diagnostic.getFileOffset(), inspection.getSuppressName(diagnosticName))) continue;
            List<IntentionAction> fixes = this.createQuickFixes(file, diagnosticMessage, diagnostic, inspection);
            for (IntentionAction fix : fixes) {
                if (!processor.process(diagnosticMessage, diagnosticName, rangeToHighlight, highlightSeverity, inspection, file, fix)) break;
            }
        }
    }

    protected static interface DiagnosticProcessor {
        public boolean process(@NotNull String var1, @NotNull String var2, @NotNull TextRange var3, @NotNull HighlightSeverity var4, @NotNull ClangTidyInspectionBase var5, @NotNull PsiFile var6, @NotNull IntentionAction var7);
    }
}

